/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.OperationMessageWebSocketClient;
import com.netflix.graphql.dgs.client.ReactiveGraphQLClient;
import com.netflix.graphql.dgs.client.WebSocketGraphQLClient;
import com.netflix.graphql.types.subscription.OperationMessage;
import com.netflix.graphql.types.subscription.QueryPayload;
import graphql.GraphQLException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.web.reactive.socket.client.ReactorNettyWebSocketClient;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J*\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010 \u001a\u00020\u00032\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020#0\"H\u0016J4\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010 \u001a\u00020\u00032\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020#0\"2\b\u0010$\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0011\u001a&\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013 \u0014*\u0012\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/netflix/graphql/dgs/client/WebSocketGraphQLClient;", "Lcom/netflix/graphql/dgs/client/ReactiveGraphQLClient;", "url", "", "client", "Lorg/springframework/web/reactive/socket/client/WebSocketClient;", "acknowledgementTimeout", "Ljava/time/Duration;", "(Ljava/lang/String;Lorg/springframework/web/reactive/socket/client/WebSocketClient;Ljava/time/Duration;)V", "(Ljava/lang/String;Lorg/springframework/web/reactive/socket/client/WebSocketClient;)V", "(Ljava/lang/String;)V", "Lcom/netflix/graphql/dgs/client/OperationMessageWebSocketClient;", "(Lcom/netflix/graphql/dgs/client/OperationMessageWebSocketClient;)V", "(Lcom/netflix/graphql/dgs/client/OperationMessageWebSocketClient;Ljava/time/Duration;)V", "connection", "Ljava/util/concurrent/atomic/AtomicReference;", "Lreactor/core/Disposable;", "handshake", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "kotlin.jvm.PlatformType", "subscriptionCount", "Ljava/util/concurrent/atomic/AtomicLong;", "connectionIsStale", "", "doHandshake", "handleMessage", "Lreactor/core/publisher/Flux;", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "message", "Lcom/netflix/graphql/types/subscription/OperationMessage;", "reactiveExecuteQuery", "query", "variables", "", "", "operationName", "Companion", "graphql-dgs-client"})
public final class WebSocketGraphQLClient
implements ReactiveGraphQLClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OperationMessageWebSocketClient client;
    @NotNull
    private final Duration acknowledgementTimeout;
    @NotNull
    private final AtomicLong subscriptionCount;
    @NotNull
    private final AtomicReference<Disposable> connection;
    private final Mono<Void> handshake;
    private static final Duration DEFAULT_ACKNOWLEDGEMENT_TIMEOUT = Duration.ofSeconds(30L);
    @NotNull
    private static final OperationMessage CONNECTION_INIT_MESSAGE = new OperationMessage("connection_init", null, null);
    @NotNull
    private static final ObjectMapper MAPPER = ExtensionsKt.jacksonObjectMapper();

    public WebSocketGraphQLClient(@NotNull OperationMessageWebSocketClient client, @NotNull Duration acknowledgementTimeout) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)acknowledgementTimeout, (String)"acknowledgementTimeout");
        this.client = client;
        this.acknowledgementTimeout = acknowledgementTimeout;
        this.subscriptionCount = new AtomicLong(0L);
        this.connection = new AtomicReference<Object>(null);
        this.handshake = Mono.defer(() -> WebSocketGraphQLClient.handshake$lambda$0(this));
    }

    public /* synthetic */ WebSocketGraphQLClient(OperationMessageWebSocketClient operationMessageWebSocketClient, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Duration duration2 = DEFAULT_ACKNOWLEDGEMENT_TIMEOUT;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"DEFAULT_ACKNOWLEDGEMENT_TIMEOUT");
            duration = duration2;
        }
        this(operationMessageWebSocketClient, duration);
    }

    public WebSocketGraphQLClient(@NotNull String url, @NotNull WebSocketClient client, @NotNull Duration acknowledgementTimeout) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)acknowledgementTimeout, (String)"acknowledgementTimeout");
        this(new OperationMessageWebSocketClient(url, client), acknowledgementTimeout);
    }

    public WebSocketGraphQLClient(@NotNull String url, @NotNull WebSocketClient client) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        OperationMessageWebSocketClient operationMessageWebSocketClient = new OperationMessageWebSocketClient(url, client);
        Duration duration = DEFAULT_ACKNOWLEDGEMENT_TIMEOUT;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"DEFAULT_ACKNOWLEDGEMENT_TIMEOUT");
        this(operationMessageWebSocketClient, duration);
    }

    public WebSocketGraphQLClient(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        OperationMessageWebSocketClient operationMessageWebSocketClient = new OperationMessageWebSocketClient(url, (WebSocketClient)new ReactorNettyWebSocketClient());
        Duration duration = DEFAULT_ACKNOWLEDGEMENT_TIMEOUT;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"DEFAULT_ACKNOWLEDGEMENT_TIMEOUT");
        this(operationMessageWebSocketClient, duration);
    }

    public WebSocketGraphQLClient(@NotNull OperationMessageWebSocketClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Duration duration = DEFAULT_ACKNOWLEDGEMENT_TIMEOUT;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"DEFAULT_ACKNOWLEDGEMENT_TIMEOUT");
        this(client, duration);
    }

    @Override
    @NotNull
    public Flux<GraphQLResponse> reactiveExecuteQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return this.reactiveExecuteQuery(query, variables, null);
    }

    @Override
    @NotNull
    public Flux<GraphQLResponse> reactiveExecuteQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        String subscriptionId = String.valueOf(this.subscriptionCount.incrementAndGet());
        OperationMessage queryMessage = new OperationMessage("start", (Object)new QueryPayload(variables, MapsKt.emptyMap(), operationName, query, null, 16, null), subscriptionId);
        OperationMessage stopMessage = new OperationMessage("stop", null, subscriptionId);
        Flux flux = this.handshake.doOnSuccess(arg_0 -> WebSocketGraphQLClient.reactiveExecuteQuery$lambda$1((Function1)new Function1<Void, Unit>(this, queryMessage){
            final /* synthetic */ WebSocketGraphQLClient this$0;
            final /* synthetic */ OperationMessage $queryMessage;
            {
                this.this$0 = $receiver;
                this.$queryMessage = $queryMessage;
                super(1);
            }

            public final void invoke(Void it) {
                WebSocketGraphQLClient.access$getClient$p(this.this$0).send(this.$queryMessage);
            }
        }, arg_0)).thenMany((Publisher)this.client.receive().filter(arg_0 -> WebSocketGraphQLClient.reactiveExecuteQuery$lambda$2((Function1)new Function1<OperationMessage, Boolean>(subscriptionId){
            final /* synthetic */ String $subscriptionId;
            {
                this.$subscriptionId = $subscriptionId;
                super(1);
            }

            @NotNull
            public final Boolean invoke(OperationMessage it) {
                return Intrinsics.areEqual((Object)it.getId(), (Object)this.$subscriptionId);
            }
        }, arg_0)).takeUntil(arg_0 -> WebSocketGraphQLClient.reactiveExecuteQuery$lambda$3(reactiveExecuteQuery.3.INSTANCE, arg_0)).doOnCancel(() -> WebSocketGraphQLClient.reactiveExecuteQuery$lambda$4(this, stopMessage)).flatMap(arg_0 -> WebSocketGraphQLClient.reactiveExecuteQuery$lambda$5((Function1)new Function1<OperationMessage, Flux<GraphQLResponse>>((Object)this){

            @NotNull
            public final Flux<GraphQLResponse> invoke(@NotNull OperationMessage p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return WebSocketGraphQLClient.access$handleMessage((WebSocketGraphQLClient)this.receiver, p0);
            }
        }, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"override fun reactiveExe\u2026sage)\n            )\n    }");
        return flux;
    }

    private final boolean connectionIsStale() {
        Disposable disposable = this.connection.get();
        return !(disposable != null ? !disposable.isDisposed() : false);
    }

    private final Mono<Void> doHandshake() {
        Mono mono = Mono.defer(() -> WebSocketGraphQLClient.doHandshake$lambda$7(this));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"defer {\n            conn\u2026        .then()\n        }");
        return mono;
    }

    private final Flux<GraphQLResponse> handleMessage(OperationMessage message) {
        switch (message.getType()) {
            case "connection_ack": 
            case "ka": 
            case "complete": {
                Flux flux = Flux.empty();
                Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"empty()");
                return flux;
            }
            case "data": {
                Object payload = message.getPayload();
                String string = MAPPER.writeValueAsString(payload);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MAPPER.writeValueAsString(payload)");
                Flux flux = Flux.just((Object)new GraphQLResponse(string));
                Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"just(GraphQLResponse(MAP\u2026eValueAsString(payload)))");
                return flux;
            }
            case "connection_error": 
            case "error": {
                String errorMessage = String.valueOf(message.getPayload());
                throw new GraphQLException(errorMessage);
            }
        }
        throw new GraphQLException("Unable to handle message of type " + message.getType() + ". Full message: " + message);
    }

    private static final Mono handshake$lambda$0(WebSocketGraphQLClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.connectionIsStale() ? this$0.doHandshake() : Mono.empty();
    }

    private static final void reactiveExecuteQuery$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean reactiveExecuteQuery$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean reactiveExecuteQuery$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void reactiveExecuteQuery$lambda$4(WebSocketGraphQLClient this$0, OperationMessage $stopMessage) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$stopMessage, (String)"$stopMessage");
        this$0.client.send($stopMessage);
    }

    private static final Publisher reactiveExecuteQuery$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final OperationMessage doHandshake$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (OperationMessage)$tmp0.invoke(p0);
    }

    private static final Mono doHandshake$lambda$7(WebSocketGraphQLClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.connection.set(this$0.client.connect().subscribe());
        this$0.client.send(CONNECTION_INIT_MESSAGE);
        return this$0.client.receive().take(1L).map(arg_0 -> WebSocketGraphQLClient.doHandshake$lambda$7$lambda$6(doHandshake.1.1.INSTANCE, arg_0)).timeout(this$0.acknowledgementTimeout).then();
    }

    public static final /* synthetic */ OperationMessageWebSocketClient access$getClient$p(WebSocketGraphQLClient $this) {
        return $this.client;
    }

    public static final /* synthetic */ Flux access$handleMessage(WebSocketGraphQLClient $this, OperationMessage message) {
        return $this.handleMessage(message);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/netflix/graphql/dgs/client/WebSocketGraphQLClient$Companion;", "", "()V", "CONNECTION_INIT_MESSAGE", "Lcom/netflix/graphql/types/subscription/OperationMessage;", "DEFAULT_ACKNOWLEDGEMENT_TIMEOUT", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "MAPPER", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "graphql-dgs-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

