/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.netflix.graphql.dgs.client.GraphQLClient;
import com.netflix.graphql.dgs.client.GraphQLClientException;
import com.netflix.graphql.dgs.client.GraphQLClients;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.Request;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J0\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/netflix/graphql/dgs/client/RestClientGraphQLClient;", "Lcom/netflix/graphql/dgs/client/GraphQLClient;", "restClient", "Lorg/springframework/web/client/RestClient;", "(Lorg/springframework/web/client/RestClient;)V", "headersConsumer", "Ljava/util/function/Consumer;", "Lorg/springframework/http/HttpHeaders;", "(Lorg/springframework/web/client/RestClient;Ljava/util/function/Consumer;)V", "executeQuery", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "query", "", "variables", "", "", "operationName", "graphql-dgs-client"})
public final class RestClientGraphQLClient
implements GraphQLClient {
    @NotNull
    private final RestClient restClient;
    @NotNull
    private final Consumer<HttpHeaders> headersConsumer;

    public RestClientGraphQLClient(@NotNull RestClient restClient, @NotNull Consumer<HttpHeaders> headersConsumer) {
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        Intrinsics.checkNotNullParameter(headersConsumer, (String)"headersConsumer");
        this.restClient = restClient;
        this.headersConsumer = headersConsumer;
    }

    public RestClientGraphQLClient(@NotNull RestClient restClient) {
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        this(restClient, RestClientGraphQLClient::_init_$lambda$0);
    }

    @Override
    @NotNull
    public GraphQLResponse executeQuery(@Language(value="graphql") @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return this.executeQuery(query, (Map<String, ? extends Object>)MapsKt.emptyMap(), (String)null);
    }

    @Override
    @NotNull
    public GraphQLResponse executeQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return this.executeQuery(query, variables, (String)null);
    }

    @Override
    @NotNull
    public GraphQLResponse executeQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        String serializedRequest = GraphQLClients.INSTANCE.getObjectMapper$graphql_dgs_client().writeValueAsString((Object)new Request(query, variables, operationName));
        ResponseEntity responseEntity = ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().headers(RestClientGraphQLClient::executeQuery$lambda$1)).headers(this.headersConsumer)).body((Object)serializedRequest).retrieve().toEntity(String.class);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            int n = responseEntity.getStatusCode().value();
            String string = this.restClient.toString();
            String string2 = (String)responseEntity.getBody();
            if (string2 == null) {
                string2 = "";
            }
            Intrinsics.checkNotNull((Object)serializedRequest);
            throw new GraphQLClientException(n, string, string2, serializedRequest);
        }
        String string = (String)responseEntity.getBody();
        if (string == null) {
            string = "";
        }
        HttpHeaders httpHeaders = responseEntity.getHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"getHeaders(...)");
        return new GraphQLResponse(string, (Map)httpHeaders);
    }

    private static final void _init_$lambda$0(HttpHeaders it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void executeQuery$lambda$1(HttpHeaders headers) {
        headers.addAll((MultiValueMap)GraphQLClients.INSTANCE.getDefaultHeaders$graphql_dgs_client());
    }
}

