/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.netflix.graphql.dgs.client.GraphQLError;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.RequestDetails;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 42\u00020\u0001:\u00014B\u0011\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B+\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0006\u00a2\u0006\u0002\u0010\bB1\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\nH\u00c2\u0003J9\u0010\u001d\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u00062\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u001f\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!\u00a2\u0006\u0002\u0010\"J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0019\u0010&\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u0006\u0010'\u001a\u00020\u0003\u00a2\u0006\u0002\u0010(J'\u0010)\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u0006\u0010'\u001a\u00020\u00032\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H\u001f0+\u00a2\u0006\u0002\u0010,J'\u0010)\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u0006\u0010'\u001a\u00020\u00032\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!\u00a2\u0006\u0002\u0010-J\b\u0010.\u001a\u0004\u0018\u00010/J\u0006\u00100\u001a\u00020$J\t\u00101\u001a\u000202H\u00d6\u0001J\t\u00103\u001a\u00020\u0003H\u00d6\u0001R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00065"}, d2={"Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "", "json", "", "(Ljava/lang/String;)V", "headers", "", "", "(Ljava/lang/String;Ljava/util/Map;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Ljava/lang/String;Ljava/util/Map;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "data", "getData", "()Ljava/util/Map;", "errors", "Lcom/netflix/graphql/dgs/client/GraphQLError;", "getErrors", "()Ljava/util/List;", "getHeaders", "getJson", "()Ljava/lang/String;", "parsed", "Lcom/jayway/jsonpath/DocumentContext;", "getParsed", "()Lcom/jayway/jsonpath/DocumentContext;", "component1", "component2", "component3", "copy", "dataAsObject", "T", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "equals", "", "other", "extractValue", "path", "(Ljava/lang/String;)Ljava/lang/Object;", "extractValueAsObject", "typeRef", "Lcom/jayway/jsonpath/TypeRef;", "(Ljava/lang/String;Lcom/jayway/jsonpath/TypeRef;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "getRequestDetails", "Lcom/netflix/graphql/dgs/client/RequestDetails;", "hasErrors", "hashCode", "", "toString", "Companion", "graphql-dgs-client"})
@SourceDebugExtension(value={"SMAP\nGraphQLResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphQLResponse.kt\ncom/netflix/graphql/dgs/client/GraphQLResponse\n+ 2 GraphQLResponse.kt\ncom/netflix/graphql/dgs/client/GraphQLResponseKt\n*L\n1#1,162:1\n161#2:163\n*S KotlinDebug\n*F\n+ 1 GraphQLResponse.kt\ncom/netflix/graphql/dgs/client/GraphQLResponse\n*L\n64#1:163\n*E\n"})
public final class GraphQLResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String json;
    @NotNull
    private final Map<String, List<String>> headers;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final DocumentContext parsed;
    @NotNull
    private final Map<String, Object> data;
    @NotNull
    private final List<GraphQLError> errors;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final ObjectMapper DEFAULT_MAPPER;

    public GraphQLResponse(@Language(value="json") @NotNull String json, @NotNull Map<String, ? extends List<String>> headers, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.json = json;
        this.headers = headers;
        this.mapper = mapper;
        Option[] optionArray = new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL};
        DocumentContext documentContext = JsonPath.using((Configuration)Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonProvider(this.mapper)).mappingProvider((MappingProvider)new JacksonMappingProvider(this.mapper)).build().addOptions(optionArray)).parse(this.json);
        Intrinsics.checkNotNullExpressionValue((Object)documentContext, (String)"parse(...)");
        this.parsed = documentContext;
        Map map = (Map)this.parsed.read("data", new Predicate[0]);
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        this.data = map;
        boolean $i$f$jsonTypeRef = false;
        List list = (List)this.parsed.read("errors", (TypeRef)new TypeRef<List<? extends GraphQLError>>(){});
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        this.errors = list;
    }

    @NotNull
    public final String getJson() {
        return this.json;
    }

    @NotNull
    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final DocumentContext getParsed() {
        return this.parsed;
    }

    @NotNull
    public final Map<String, Object> getData() {
        return this.data;
    }

    @NotNull
    public final List<GraphQLError> getErrors() {
        return this.errors;
    }

    public GraphQLResponse(@Language(value="json") @NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this(json, MapsKt.emptyMap());
    }

    public GraphQLResponse(@Language(value="json") @NotNull String json, @NotNull Map<String, ? extends List<String>> headers) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this(json, headers, DEFAULT_MAPPER);
    }

    public final <T> T dataAsObject(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return (T)this.mapper.convertValue(this.data, clazz);
    }

    public final <T> T extractValue(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String dataPath = Companion.getDataPath(path);
        try {
            return (T)this.parsed.read(dataPath, new Predicate[0]);
        }
        catch (Exception ex) {
            logger.warn("Error extracting path '" + path + "' from data: '" + this.data + "'");
            throw ex;
        }
    }

    public final <T> T extractValueAsObject(@NotNull String path, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        String dataPath = Companion.getDataPath(path);
        try {
            return (T)this.parsed.read(dataPath, clazz, new Predicate[0]);
        }
        catch (Exception ex) {
            logger.warn("Error extracting path '" + path + "' from data: '" + this.data + "'");
            throw ex;
        }
    }

    public final <T> T extractValueAsObject(@NotNull String path, @NotNull TypeRef<T> typeRef) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(typeRef, (String)"typeRef");
        String dataPath = Companion.getDataPath(path);
        try {
            return (T)this.parsed.read(dataPath, typeRef);
        }
        catch (Exception ex) {
            logger.warn("Error extracting path '" + path + "' from data: '" + this.data + "'");
            throw ex;
        }
    }

    @Nullable
    public final RequestDetails getRequestDetails() {
        return this.extractValueAsObject("gatewayRequestDetails", RequestDetails.class);
    }

    public final boolean hasErrors() {
        return !((Collection)this.errors).isEmpty();
    }

    @NotNull
    public final String component1() {
        return this.json;
    }

    @NotNull
    public final Map<String, List<String>> component2() {
        return this.headers;
    }

    private final ObjectMapper component3() {
        return this.mapper;
    }

    @NotNull
    public final GraphQLResponse copy(@Language(value="json") @NotNull String json, @NotNull Map<String, ? extends List<String>> headers, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        return new GraphQLResponse(json, headers, mapper);
    }

    public static /* synthetic */ GraphQLResponse copy$default(GraphQLResponse graphQLResponse, String string, Map map, ObjectMapper objectMapper, int n, Object object) {
        if ((n & 1) != 0) {
            string = graphQLResponse.json;
        }
        if ((n & 2) != 0) {
            map = graphQLResponse.headers;
        }
        if ((n & 4) != 0) {
            objectMapper = graphQLResponse.mapper;
        }
        return graphQLResponse.copy(string, map, objectMapper);
    }

    @NotNull
    public String toString() {
        return "GraphQLResponse(json=" + this.json + ", headers=" + this.headers + ", mapper=" + this.mapper + ")";
    }

    public int hashCode() {
        int result = this.json.hashCode();
        result = result * 31 + ((Object)this.headers).hashCode();
        result = result * 31 + this.mapper.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GraphQLResponse)) {
            return false;
        }
        GraphQLResponse graphQLResponse = (GraphQLResponse)other;
        if (!Intrinsics.areEqual((Object)this.json, (Object)graphQLResponse.json)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.headers, graphQLResponse.headers)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.mapper, (Object)graphQLResponse.mapper);
    }

    static {
        Logger logger = LoggerFactory.getLogger(GraphQLResponse.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        GraphQLResponse.logger = logger;
        DEFAULT_MAPPER = (ObjectMapper)ExtensionsKt.jsonMapper((Function1)Companion.DEFAULT_MAPPER.1.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/netflix/graphql/dgs/client/GraphQLResponse$Companion;", "", "()V", "DEFAULT_MAPPER", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getDEFAULT_MAPPER$graphql_dgs_client", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "logger", "Lorg/slf4j/Logger;", "getDataPath", "", "path", "graphql-dgs-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectMapper getDEFAULT_MAPPER$graphql_dgs_client() {
            return DEFAULT_MAPPER;
        }

        @NotNull
        public final String getDataPath(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return Intrinsics.areEqual((Object)path, (Object)"data") || StringsKt.startsWith$default((String)path, (String)"data.", (boolean)false, (int)2, null) ? path : "data." + path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

