/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.client.OperationMessageWebSocketClient;
import com.netflix.graphql.types.subscription.OperationMessage;
import graphql.GraphQLException;
import java.net.URI;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.util.concurrent.Queues;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000b\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\f0\f \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\f0\f\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\r\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\f0\f \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\f0\f\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/netflix/graphql/dgs/client/OperationMessageWebSocketClient;", "", "url", "", "client", "Lorg/springframework/web/reactive/socket/client/WebSocketClient;", "(Ljava/lang/String;Lorg/springframework/web/reactive/socket/client/WebSocketClient;)V", "errorSink", "Lreactor/core/publisher/Sinks$Many;", "Lgraphql/GraphQLException;", "kotlin.jvm.PlatformType", "incomingSink", "Lcom/netflix/graphql/types/subscription/OperationMessage;", "outgoingSink", "connect", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "createMessage", "Lorg/springframework/web/reactive/socket/WebSocketMessage;", "session", "Lorg/springframework/web/reactive/socket/WebSocketSession;", "message", "decodeMessage", "exchange", "receive", "Lreactor/core/publisher/Flux;", "send", "", "Companion", "graphql-dgs-client"})
@SourceDebugExtension(value={"SMAP\nWebSocketGraphQLClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSocketGraphQLClient.kt\ncom/netflix/graphql/dgs/client/OperationMessageWebSocketClient\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,280:1\n51#2:281\n*S KotlinDebug\n*F\n+ 1 WebSocketGraphQLClient.kt\ncom/netflix/graphql/dgs/client/OperationMessageWebSocketClient\n*L\n275#1:281\n*E\n"})
public final class OperationMessageWebSocketClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private final WebSocketClient client;
    private final Sinks.Many<OperationMessage> incomingSink;
    private final Sinks.Many<OperationMessage> outgoingSink;
    private final Sinks.Many<GraphQLException> errorSink;
    @NotNull
    private static final ObjectMapper MAPPER = ExtensionsKt.jacksonObjectMapper();

    public OperationMessageWebSocketClient(@NotNull String url, @NotNull WebSocketClient client) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.url = url;
        this.client = client;
        this.incomingSink = Sinks.many().multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, false);
        this.outgoingSink = Sinks.many().multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, false);
        this.errorSink = Sinks.many().multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, false);
    }

    @NotNull
    public final Mono<Void> connect() {
        Mono mono = Mono.defer(() -> OperationMessageWebSocketClient.connect$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"defer(...)");
        return mono;
    }

    public final void send(@NotNull OperationMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.outgoingSink.tryEmitNext((Object)message).orThrow();
    }

    @NotNull
    public final Flux<OperationMessage> receive() {
        Function1 function1 = receive.1.INSTANCE;
        Flux flux = this.incomingSink.asFlux().mergeWith((Publisher)this.errorSink.asFlux().map(new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"mergeWith(...)");
        return flux;
    }

    private final Mono<Void> exchange(WebSocketSession session) {
        Flux incomingDeserialized2 = session.receive().map(arg_0 -> OperationMessageWebSocketClient.exchange$lambda$1((Function1)new Function1<WebSocketMessage, OperationMessage>((Object)this){

            @NotNull
            public final OperationMessage invoke(@NotNull WebSocketMessage p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return OperationMessageWebSocketClient.access$decodeMessage((OperationMessageWebSocketClient)this.receiver, p0);
            }
        }, arg_0)).doOnNext(arg_0 -> OperationMessageWebSocketClient.exchange$lambda$2((Function1)new Function1<OperationMessage, Unit>(this.incomingSink){

            public final void invoke(OperationMessage p0) {
                ((Sinks.Many)this.receiver).tryEmitNext((Object)p0);
            }
        }, arg_0));
        Mono outgoingSerialized2 = session.send((Publisher)this.outgoingSink.asFlux().map(arg_0 -> OperationMessageWebSocketClient.exchange$lambda$3((Function1)new Function1<OperationMessage, WebSocketMessage>(this, session){
            final /* synthetic */ OperationMessageWebSocketClient this$0;
            final /* synthetic */ WebSocketSession $session;
            {
                this.this$0 = $receiver;
                this.$session = $session;
                super(1);
            }

            public final WebSocketMessage invoke(OperationMessage it) {
                Intrinsics.checkNotNull((Object)it);
                return OperationMessageWebSocketClient.access$createMessage(this.this$0, this.$session, it);
            }
        }, arg_0)));
        Publisher[] publisherArray = new Publisher[]{incomingDeserialized2, outgoingSerialized2};
        Mono mono = Flux.merge((Publisher[])publisherArray).then().doOnError(arg_0 -> OperationMessageWebSocketClient.exchange$lambda$4((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ OperationMessageWebSocketClient this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Throwable it) {
                OperationMessageWebSocketClient.access$getErrorSink$p(this.this$0).tryEmitNext((Object)new GraphQLException(it)).orThrow();
            }
        }, arg_0)).doAfterTerminate(() -> OperationMessageWebSocketClient.exchange$lambda$5(this));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doAfterTerminate(...)");
        return mono;
    }

    private final WebSocketMessage createMessage(WebSocketSession session, OperationMessage message) {
        WebSocketMessage webSocketMessage = session.textMessage(MAPPER.writeValueAsString((Object)message));
        Intrinsics.checkNotNullExpressionValue((Object)webSocketMessage, (String)"textMessage(...)");
        return webSocketMessage;
    }

    private final OperationMessage decodeMessage(WebSocketMessage message) {
        String messageText = message.getPayloadAsText();
        boolean $i$f$jacksonTypeRef = false;
        TypeReference type = (TypeReference)new TypeReference<OperationMessage>(){};
        Object object = MAPPER.readValue(messageText, type);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return (OperationMessage)object;
    }

    private static final Mono connect$lambda$0(OperationMessageWebSocketClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.client.execute(new URI(this$0.url), new WebSocketHandler(this$0){
            final /* synthetic */ OperationMessageWebSocketClient this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Mono<Void> handle(@NotNull WebSocketSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                return OperationMessageWebSocketClient.access$exchange(this.this$0, session);
            }

            @NotNull
            public List<String> getSubProtocols() {
                return CollectionsKt.listOf((Object)"graphql-ws");
            }
        });
    }

    private static final OperationMessage exchange$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (OperationMessage)$tmp0.invoke(p0);
    }

    private static final void exchange$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final WebSocketMessage exchange$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (WebSocketMessage)$tmp0.invoke(p0);
    }

    private static final void exchange$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void exchange$lambda$5(OperationMessageWebSocketClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.errorSink.tryEmitNext((Object)new GraphQLException("Server closed the connection unexpectedly")).orThrow();
    }

    public static final /* synthetic */ OperationMessage access$decodeMessage(OperationMessageWebSocketClient $this, WebSocketMessage message) {
        return $this.decodeMessage(message);
    }

    public static final /* synthetic */ WebSocketMessage access$createMessage(OperationMessageWebSocketClient $this, WebSocketSession session, OperationMessage message) {
        return $this.createMessage(session, message);
    }

    public static final /* synthetic */ Sinks.Many access$getErrorSink$p(OperationMessageWebSocketClient $this) {
        return $this.errorSink;
    }

    public static final /* synthetic */ Mono access$exchange(OperationMessageWebSocketClient $this, WebSocketSession session) {
        return $this.exchange(session);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/client/OperationMessageWebSocketClient$Companion;", "", "()V", "MAPPER", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "graphql-dgs-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

