/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.graphiql.autoconfiguration;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.PathResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.ResourceTransformerChain;
import org.springframework.web.servlet.resource.TransformedResource;

@Configuration
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0002\f\rB\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/netflix/graphql/dgs/graphiql/autoconfiguration/GraphiQLConfigurer;", "Lorg/springframework/web/servlet/config/annotation/WebMvcConfigurer;", "graphiqlPath", "", "graphqlPath", "(Ljava/lang/String;Ljava/lang/String;)V", "addResourceHandlers", "", "registry", "Lorg/springframework/web/servlet/config/annotation/ResourceHandlerRegistry;", "addViewControllers", "Lorg/springframework/web/servlet/config/annotation/ViewControllerRegistry;", "Constants", "TokenReplacingTransformer", "graphql-dgs-graphiql-autoconfigure"})
public class GraphiQLConfigurer
implements WebMvcConfigurer {
    private final String graphiqlPath;
    private final String graphqlPath;

    public void addViewControllers(@NotNull ViewControllerRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        registry.addViewController(this.graphiqlPath).setViewName("forward:/graphiql/index.html");
        registry.addViewController(this.graphiqlPath + '/').setViewName("forward:/graphiql/index.html");
    }

    public void addResourceHandlers(@NotNull ResourceHandlerRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        registry.addResourceHandler(new String[]{"/graphiql/**"}).addResourceLocations(new String[]{"classpath:/static/graphiql/"}).setCachePeriod(Integer.valueOf(3600)).resourceChain(true).addResolver((ResourceResolver)new PathResourceResolver()).addTransformer((ResourceTransformer)new TokenReplacingTransformer("<DGS_GRAPHQL_PATH>", this.graphqlPath));
    }

    public GraphiQLConfigurer(@Value(value="${dgs.graphql.graphiql.path:/graphiql}") @NotNull String graphiqlPath, @Value(value="${dgs.graphql.path:/graphql}") @NotNull String graphqlPath) {
        Intrinsics.checkNotNullParameter((Object)graphiqlPath, (String)"graphiqlPath");
        Intrinsics.checkNotNullParameter((Object)graphqlPath, (String)"graphqlPath");
        this.graphiqlPath = graphiqlPath;
        this.graphqlPath = graphqlPath;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/graphiql/autoconfiguration/GraphiQLConfigurer$Constants;", "", "()V", "PATH_TO_GRAPHIQL_INDEX_HTML", "", "graphql-dgs-graphiql-autoconfigure"})
    public static final class Constants {
        @NotNull
        public static final String PATH_TO_GRAPHIQL_INDEX_HTML = "/graphiql/index.html";
        @NotNull
        public static final Constants INSTANCE;

        private Constants() {
        }

        static {
            Constants constants;
            INSTANCE = constants = new Constants();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/netflix/graphql/dgs/graphiql/autoconfiguration/GraphiQLConfigurer$TokenReplacingTransformer;", "Lorg/springframework/web/servlet/resource/ResourceTransformer;", "replaceToken", "", "replaceValue", "(Ljava/lang/String;Ljava/lang/String;)V", "transform", "Lorg/springframework/core/io/Resource;", "request", "Ljavax/servlet/http/HttpServletRequest;", "resource", "transformerChain", "Lorg/springframework/web/servlet/resource/ResourceTransformerChain;", "graphql-dgs-graphiql-autoconfigure"})
    public static final class TokenReplacingTransformer
    implements ResourceTransformer {
        private final String replaceToken;
        private final String replaceValue;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Resource transform(@Nullable HttpServletRequest request, @NotNull Resource resource, @Nullable ResourceTransformerChain transformerChain) throws IOException {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Object object = request;
            if (object != null && (object = object.getRequestURI()) != null) {
                if (StringsKt.endsWith$default((String)object, (String)"/graphiql/index.html", (boolean)false, (int)2, null)) {
                    InputStream inputStream = resource.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"resource.inputStream");
                    Object object2 = inputStream;
                    Charset charset = Charsets.UTF_8;
                    boolean bl = false;
                    Object object3 = object2;
                    int n = 0;
                    object3 = new InputStreamReader((InputStream)object3, charset);
                    n = 8192;
                    boolean bl2 = false;
                    object2 = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
                    boolean bl3 = false;
                    bl = false;
                    Throwable throwable = null;
                    try {
                        BufferedReader p1 = (BufferedReader)object2;
                        boolean bl4 = false;
                        object3 = TextStreamsKt.readText((Reader)p1);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                    }
                    Object content = object3;
                    object2 = StringsKt.replace$default((String)content, (String)this.replaceToken, (String)this.replaceValue, (boolean)false, (int)4, null);
                    Charset charset2 = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
                    Charset charset3 = charset2;
                    boolean bl5 = false;
                    Object object4 = object2;
                    if (object4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray = ((String)object4).getBytes(charset3);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    return (Resource)new TransformedResource(resource, byArray);
                }
            }
            return resource;
        }

        public TokenReplacingTransformer(@NotNull String replaceToken, @NotNull String replaceValue) {
            Intrinsics.checkNotNullParameter((Object)replaceToken, (String)"replaceToken");
            Intrinsics.checkNotNullParameter((Object)replaceValue, (String)"replaceValue");
            this.replaceToken = replaceToken;
            this.replaceValue = replaceValue;
        }
    }
}

