/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.mocking;

import com.netflix.graphql.mocking.MockGraphQLVisitor;
import com.netflix.graphql.mocking.MockProvider;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.SchemaTraverser;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0010\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\b\u0012\u0002\b\u00030\u0007J\u001c\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a8\u0006\r"}, d2={"Lcom/netflix/graphql/mocking/DgsSchemaTransformer;", "", "()V", "transformSchema", "Lgraphql/schema/GraphQLSchema;", "schema", "mockConfig", "", "", "transformSchemaWithMockProviders", "mockProviders", "", "Lcom/netflix/graphql/mocking/MockProvider;", "graphql-dgs-mocking"})
@SourceDebugExtension(value={"SMAP\nDgsSchemaTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsSchemaTransformer.kt\ncom/netflix/graphql/mocking/DgsSchemaTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,49:1\n1855#2,2:50\n215#3,2:52\n*S KotlinDebug\n*F\n+ 1 DgsSchemaTransformer.kt\ncom/netflix/graphql/mocking/DgsSchemaTransformer\n*L\n27#1:50,2\n43#1:52,2\n*E\n"})
public final class DgsSchemaTransformer {
    @NotNull
    public final GraphQLSchema transformSchemaWithMockProviders(@NotNull GraphQLSchema schema, @NotNull Set<? extends MockProvider> mockProviders) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(mockProviders, (String)"mockProviders");
        Map mockConfig = new LinkedHashMap();
        Iterable $this$forEach$iv = mockProviders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MockProvider p = (MockProvider)element$iv;
            boolean bl = false;
            mockConfig.putAll(p.provide());
        }
        return this.transformSchema(schema, mockConfig);
    }

    @NotNull
    public final GraphQLSchema transformSchema(@NotNull GraphQLSchema schema, @NotNull Map<String, ?> mockConfig) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(mockConfig, (String)"mockConfig");
        Map mockFetchers = new LinkedHashMap();
        MockGraphQLVisitor graphQLTypeVisitorStub = new MockGraphQLVisitor(mockConfig, mockFetchers);
        new SchemaTraverser().depthFirstFullSchema((GraphQLTypeVisitor)graphQLTypeVisitorStub, schema);
        GraphQLSchema graphQLSchema = schema.transform(arg_0 -> DgsSchemaTransformer.transformSchema$lambda$3(schema, mockFetchers, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)graphQLSchema, (String)"transform(...)");
        return graphQLSchema;
    }

    private static final void transformSchema$lambda$3$lambda$2(Map $mockFetchers, GraphQLCodeRegistry.Builder codeRegistryBuilder) {
        Intrinsics.checkNotNullParameter((Object)$mockFetchers, (String)"$mockFetchers");
        Map $this$forEach$iv = $mockFetchers;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            FieldCoordinates coordinates = (FieldCoordinates)entry.getKey();
            DataFetcher dataFetcher2 = (DataFetcher)entry.getValue();
            codeRegistryBuilder.dataFetcher(coordinates, dataFetcher2);
        }
    }

    private static final void transformSchema$lambda$3(GraphQLSchema $schema, Map $mockFetchers, GraphQLSchema.Builder schemaBuilder) {
        Intrinsics.checkNotNullParameter((Object)$schema, (String)"$schema");
        Intrinsics.checkNotNullParameter((Object)$mockFetchers, (String)"$mockFetchers");
        GraphQLCodeRegistry newCodeRegistry = $schema.getCodeRegistry().transform(arg_0 -> DgsSchemaTransformer.transformSchema$lambda$3$lambda$2($mockFetchers, arg_0));
        schemaBuilder.codeRegistry(newCodeRegistry);
    }
}

