/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.mocking;

import com.netflix.graphql.mocking.MockGraphQLVisitor;
import com.netflix.graphql.mocking.MockGraphQLVisitor$getPathForNode$;
import graphql.Scalars;
import graphql.introspection.Introspection;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.StaticDataFetcher;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.datafaker.Faker;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B3\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u0018\u001a\u00020\u00042\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\t2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004H\u0002J\u001e\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001b0#H\u0016R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/netflix/graphql/mocking/MockGraphQLVisitor;", "Lgraphql/schema/GraphQLTypeVisitorStub;", "mockConfig", "", "", "", "mockFetchers", "", "Lgraphql/schema/FieldCoordinates;", "Lgraphql/schema/DataFetcher;", "(Ljava/util/Map;Ljava/util/Map;)V", "additionalObjectTypes", "", "Lgraphql/schema/GraphQLObjectType;", "faker", "Lnet/datafaker/Faker;", "providedRoots", "", "dummyObject", "type", "Lgraphql/schema/GraphQLType;", "generateDataForScalar", "scalarType", "Lgraphql/schema/GraphQLScalarType;", "getPathForNode", "parents", "", "Lgraphql/schema/GraphQLSchemaElement;", "node", "Lgraphql/schema/GraphQLFieldDefinition;", "getProvidedMockData", "pathForNode", "visitGraphQLFieldDefinition", "Lgraphql/util/TraversalControl;", "context", "Lgraphql/util/TraverserContext;", "Companion", "graphql-dgs-mocking"})
@SourceDebugExtension(value={"SMAP\nMockGraphQLVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockGraphQLVisitor.kt\ncom/netflix/graphql/mocking/MockGraphQLVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,144:1\n1747#2,3:145\n1747#2,2:148\n1749#2:153\n1549#2:154\n1620#2,3:155\n1549#2:158\n1620#2,3:159\n1099#3,3:150\n473#4:162\n*S KotlinDebug\n*F\n+ 1 MockGraphQLVisitor.kt\ncom/netflix/graphql/mocking/MockGraphQLVisitor\n*L\n53#1:145,3\n54#1:148,2\n54#1:153\n92#1:154\n92#1:155,3\n98#1:158\n98#1:159,3\n54#1:150,3\n140#1:162\n*E\n"})
public final class MockGraphQLVisitor
extends GraphQLTypeVisitorStub {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Object> mockConfig;
    @NotNull
    private final Map<FieldCoordinates, DataFetcher<?>> mockFetchers;
    @NotNull
    private final Set<GraphQLObjectType> additionalObjectTypes;
    @NotNull
    private final List<String> providedRoots;
    @NotNull
    private final Faker faker;
    @NotNull
    private static final Logger logger;

    public MockGraphQLVisitor(@NotNull Map<String, ? extends Object> mockConfig, @NotNull Map<FieldCoordinates, DataFetcher<?>> mockFetchers) {
        Intrinsics.checkNotNullParameter(mockConfig, (String)"mockConfig");
        Intrinsics.checkNotNullParameter(mockFetchers, (String)"mockFetchers");
        this.mockConfig = mockConfig;
        this.mockFetchers = mockFetchers;
        this.additionalObjectTypes = new LinkedHashSet();
        this.providedRoots = new ArrayList();
        this.faker = new Faker();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public TraversalControl visitGraphQLFieldDefinition(@NotNull GraphQLFieldDefinition node, @NotNull TraverserContext<GraphQLSchemaElement> context) {
        block33: {
            DataFetcher dataFetcher2;
            int n;
            Object $this$count$iv;
            Object object;
            String pathForNode;
            GraphQLFieldsContainer parentNode;
            block32: {
                boolean bl;
                block31: {
                    boolean bl2;
                    String it;
                    Iterable $this$any$iv;
                    block34: {
                        boolean bl3;
                        boolean $i$f$any;
                        block30: {
                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                            Intrinsics.checkNotNullParameter(context, (String)"context");
                            Object object2 = context.getParentNode();
                            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type graphql.schema.GraphQLFieldsContainer");
                            parentNode = (GraphQLFieldsContainer)object2;
                            if (Introspection.isIntrospectionTypes((GraphQLNamedType)((GraphQLNamedType)parentNode))) {
                                return TraversalControl.CONTINUE;
                            }
                            List list = context.getParentNodes();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParentNodes(...)");
                            pathForNode = this.getPathForNode(list, node);
                            if (CollectionsKt.contains((Iterable)this.additionalObjectTypes, (Object)parentNode)) break block32;
                            $this$any$iv = this.mockConfig.keySet();
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl3 = false;
                            } else {
                                for (Object t : $this$any$iv) {
                                    it = (String)t;
                                    boolean bl4 = false;
                                    if (!StringsKt.startsWith$default((String)pathForNode, (String)it, (boolean)false, (int)2, null)) continue;
                                    bl3 = true;
                                    break block30;
                                }
                                bl3 = false;
                            }
                        }
                        if (!bl3) break block33;
                        $this$any$iv = this.providedRoots;
                        $i$f$any = false;
                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block34;
                        bl = false;
                        break block31;
                    }
                    object = $this$any$iv.iterator();
                    do {
                        block36: {
                            char c;
                            char element$iv;
                            int n2;
                            int count$iv;
                            boolean $i$f$count;
                            block37: {
                                block35: {
                                    if (!object.hasNext()) break block35;
                                    Object e = object.next();
                                    it = (String)e;
                                    boolean bl5 = false;
                                    if (!StringsKt.startsWith$default((String)pathForNode, (String)it, (boolean)false, (int)2, null)) break block36;
                                    $this$count$iv = pathForNode;
                                    $i$f$count = false;
                                    count$iv = 0;
                                    break block37;
                                }
                                bl = false;
                                break block31;
                            }
                            for (n2 = 0; n2 < $this$count$iv.length(); ++n2) {
                                c = element$iv = $this$count$iv.charAt(n2);
                                boolean bl6 = false;
                                if (!(c == '.')) continue;
                                ++count$iv;
                            }
                            $this$count$iv = it;
                            n = count$iv;
                            $i$f$count = false;
                            count$iv = 0;
                            for (n2 = 0; n2 < $this$count$iv.length(); ++n2) {
                                c = element$iv = $this$count$iv.charAt(n2);
                                boolean bl7 = false;
                                if (!(c == '.')) continue;
                                ++count$iv;
                            }
                            int n3 = count$iv;
                            if (n != n3) {
                                bl2 = true;
                                continue;
                            }
                        }
                        bl2 = false;
                    } while (!bl2);
                    bl = true;
                }
                if (bl) break block33;
            }
            if (parentNode instanceof GraphQLInterfaceType) {
                GraphQLSchema schema = (GraphQLSchema)context.getVarFromParents(GraphQLSchema.class);
                Iterator $i$f$any = schema.getImplementations((GraphQLInterfaceType)parentNode).iterator();
                while (true) {
                    if (!$i$f$any.hasNext()) {
                        return TraversalControl.CONTINUE;
                    }
                    GraphQLObjectType objType = (GraphQLObjectType)$i$f$any.next();
                    if (context.visitedNodes().contains(objType)) continue;
                    ((Collection)this.additionalObjectTypes).add(objType);
                }
            }
            GraphQLType type = GraphQLTypeUtil.unwrapNonNull((GraphQLType)((GraphQLType)node.getType()));
            if (this.mockConfig.get(pathForNode) != null) {
                logger.info("Returning provided mock data for {}", (Object)pathForNode);
                ((Collection)this.providedRoots).add(pathForNode);
                dataFetcher2 = this.getProvidedMockData(pathForNode);
            } else {
                StaticDataFetcher staticDataFetcher;
                logger.info("Generating mock data for {}", (Object)pathForNode);
                object = type;
                if (object instanceof GraphQLScalarType) {
                    Intrinsics.checkNotNull((Object)type);
                    staticDataFetcher = new StaticDataFetcher(this.generateDataForScalar((GraphQLScalarType)type));
                } else if (object instanceof GraphQLEnumType) {
                    List list = ((GraphQLEnumType)type).getValues();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValues(...)");
                    staticDataFetcher = new StaticDataFetcher(((GraphQLEnumValueDefinition)CollectionsKt.random((Collection)list, (Random)((Random)Random.Default))).getValue());
                } else if (object instanceof GraphQLList) {
                    Collection collection;
                    GraphQLType graphQLType = GraphQLTypeUtil.unwrapNonNull((GraphQLType)((GraphQLList)type).getWrappedType());
                    if (!(graphQLType instanceof GraphQLNamedType)) {
                        return TraversalControl.CONTINUE;
                    }
                    GraphQLNamedType graphQLNamedType = (GraphQLNamedType)graphQLType;
                    if (graphQLNamedType instanceof GraphQLScalarType) {
                        void $this$mapTo$iv$iv;
                        $this$count$iv = (Iterable)new IntRange(0, this.faker.number().numberBetween(0, 10));
                        $i$f$map = false;
                        Iterable count$iv = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        Iterator iterator = $this$mapTo$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            n = item$iv$iv = ((IntIterator)iterator).nextInt();
                            var20_33 = destination$iv$iv;
                            boolean bl = false;
                            var20_33.add(this.generateDataForScalar((GraphQLScalarType)graphQLType));
                        }
                        collection = (List)destination$iv$iv;
                    } else if (graphQLNamedType instanceof GraphQLEnumType) {
                        collection = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)new IntRange(0, this.faker.number().numberBetween(0, 3)))), (Function1)((Function1)new Function1<Integer, String>(graphQLType){
                            final /* synthetic */ GraphQLType $elementType;
                            {
                                this.$elementType = $elementType;
                                super(1);
                            }

                            @NotNull
                            public final String invoke(int it) {
                                List list = ((GraphQLEnumType)this.$elementType).getValues();
                                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValues(...)");
                                return ((GraphQLEnumValueDefinition)CollectionsKt.random((Collection)list, (Random)((Random)Random.Default))).getName();
                            }
                        })));
                    } else {
                        $this$map$iv = (Iterable)new IntRange(0, this.faker.number().numberBetween(0, 10));
                        $i$f$map = false;
                        Iterable $this$mapTo$iv$iv = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        Iterator iterator = $this$mapTo$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            int it = item$iv$iv = ((IntIterator)iterator).nextInt();
                            var20_33 = destination$iv$iv;
                            boolean bl = false;
                            var20_33.add(this.dummyObject(graphQLType));
                        }
                        collection = (List)destination$iv$iv;
                    }
                    Collection mockedValues2 = collection;
                    staticDataFetcher = new StaticDataFetcher((Object)mockedValues2);
                } else {
                    Intrinsics.checkNotNull((Object)type);
                    staticDataFetcher = new StaticDataFetcher(this.dummyObject(type));
                }
                dataFetcher2 = (DataFetcher)staticDataFetcher;
            }
            DataFetcher dataFetcher3 = dataFetcher2;
            object = this.mockFetchers;
            FieldCoordinates fieldCoordinates = FieldCoordinates.coordinates((GraphQLFieldsContainer)parentNode, (GraphQLFieldDefinition)node);
            Intrinsics.checkNotNullExpressionValue((Object)fieldCoordinates, (String)"coordinates(...)");
            object.put(fieldCoordinates, dataFetcher3);
        }
        return TraversalControl.CONTINUE;
    }

    private final Object dummyObject(GraphQLType type) {
        String displayName = GraphQLTypeUtil.simplePrint((GraphQLType)type);
        return new Object(displayName){
            final /* synthetic */ String $displayName;
            {
                this.$displayName = $displayName;
            }

            @NotNull
            public String toString() {
                return "DummyObject{type=" + this.$displayName + "}";
            }
        };
    }

    private final Object generateDataForScalar(GraphQLScalarType scalarType) {
        Object object;
        GraphQLScalarType graphQLScalarType = scalarType;
        if (Intrinsics.areEqual((Object)graphQLScalarType, (Object)Scalars.GraphQLString)) {
            object = this.faker.book().title();
        } else if (Intrinsics.areEqual((Object)graphQLScalarType, (Object)Scalars.GraphQLBoolean)) {
            object = this.faker.bool().bool();
        } else if (Intrinsics.areEqual((Object)graphQLScalarType, (Object)Scalars.GraphQLInt)) {
            object = this.faker.number().randomDigit();
        } else if (Intrinsics.areEqual((Object)graphQLScalarType, (Object)Scalars.GraphQLFloat)) {
            object = this.faker.number().randomDouble(2, 0, 100000);
        } else if (Intrinsics.areEqual((Object)graphQLScalarType, (Object)Scalars.GraphQLID)) {
            object = this.faker.number().digit();
        } else {
            return this.dummyObject((GraphQLType)scalarType);
        }
        String string = object;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private final DataFetcher<?> getProvidedMockData(String pathForNode) {
        Object provided = this.mockConfig.get(pathForNode);
        return provided instanceof DataFetcher ? (DataFetcher)provided : (DataFetcher)new StaticDataFetcher(provided);
    }

    private final String getPathForNode(List<? extends GraphQLSchemaElement> parents, GraphQLFieldDefinition node) {
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)CollectionsKt.asReversed(parents));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getPathForNode$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Object[] objectArray = new GraphQLFieldDefinition[]{node};
        return SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.plus((Sequence)sequence, (Sequence)SequencesKt.sequenceOf((Object[])objectArray)), (Function1)getPathForNode.1.INSTANCE), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    static {
        Logger logger = LoggerFactory.getLogger(MockGraphQLVisitor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        MockGraphQLVisitor.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/mocking/MockGraphQLVisitor$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs-mocking"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

