/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.pagination;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsTypeDefinitionRegistry;
import graphql.language.Description;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectiveLocation;
import graphql.language.FieldDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.SourceLocation;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@DgsComponent
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0004H\u0002J\u001a\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0007\u00a8\u0006\u0017"}, d2={"Lcom/netflix/graphql/dgs/pagination/DgsPaginationTypeDefinitionRegistry;", "", "()V", "createConnection", "Lgraphql/language/ObjectTypeDefinition;", "type", "", "createDescription", "Lgraphql/language/Description;", "content", "createEdge", "createFieldDefinition", "Lgraphql/language/FieldDefinition;", "name", "Lgraphql/language/Type;", "createPageInfo", "parseConnectionDirective", "", "Lgraphql/language/TypeDefinition;", "registry", "Lgraphql/schema/idl/TypeDefinitionRegistry;", "schemaRegistry", "Companion", "graphql-dgs-pagination"})
public final class DgsPaginationTypeDefinitionRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String CONNECTION_DIRECTIVE_NAME = "connection";
    @NotNull
    private static final String PAGE_INFO_TYPE_NAME = "PageInfo";

    @DgsTypeDefinitionRegistry
    @NotNull
    public final TypeDefinitionRegistry registry(@NotNull TypeDefinitionRegistry schemaRegistry) {
        Intrinsics.checkNotNullParameter((Object)schemaRegistry, (String)"schemaRegistry");
        List<TypeDefinition<?>> connectionTypes = this.parseConnectionDirective(schemaRegistry);
        TypeDefinitionRegistry typeDefinitionRegistry = new TypeDefinitionRegistry();
        typeDefinitionRegistry.addAll((Collection)connectionTypes);
        if (schemaRegistry.getDirectiveDefinition(CONNECTION_DIRECTIVE_NAME).isEmpty()) {
            DirectiveDefinition directive = DirectiveDefinition.newDirectiveDefinition().name(CONNECTION_DIRECTIVE_NAME).description(this.createDescription("Connection")).directiveLocation(DirectiveLocation.newDirectiveLocation().name("OBJECT").build()).directiveLocation(DirectiveLocation.newDirectiveLocation().name("INTERFACE").build()).directiveLocation(DirectiveLocation.newDirectiveLocation().name("UNION").build()).build();
            typeDefinitionRegistry.add((SDLDefinition)directive);
        }
        return typeDefinitionRegistry;
    }

    private final List<TypeDefinition<?>> parseConnectionDirective(TypeDefinitionRegistry registry) {
        List definitions = new ArrayList();
        Map map = registry.types();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"types(...)");
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            TypeDefinition typedef = (TypeDefinition)iterator.next().getValue();
            if (!typedef.hasDirective(CONNECTION_DIRECTIVE_NAME) || !(typedef instanceof ObjectTypeDefinition) && !(typedef instanceof InterfaceTypeDefinition) && !(typedef instanceof UnionTypeDefinition)) continue;
            Collection collection = definitions;
            String string = typedef.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            collection.add(this.createConnection(string));
            collection = definitions;
            String string2 = typedef.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            collection.add(this.createEdge(string2));
        }
        if (!((Collection)definitions).isEmpty() && !registry.getType(PAGE_INFO_TYPE_NAME).isPresent()) {
            ((Collection)definitions).add(this.createPageInfo());
        }
        return definitions;
    }

    private final ObjectTypeDefinition createConnection(String type) {
        ObjectTypeDefinition objectTypeDefinition = ObjectTypeDefinition.newObjectTypeDefinition().name(type + "Connection").description(this.createDescription(type + " Connection")).fieldDefinition(this.createFieldDefinition("edges", (Type)new ListType((Type)new TypeName(type + "Edge")))).fieldDefinition(this.createFieldDefinition("pageInfo", (Type)new NonNullType((Type)new TypeName(PAGE_INFO_TYPE_NAME)))).build();
        Intrinsics.checkNotNullExpressionValue((Object)objectTypeDefinition, (String)"build(...)");
        return objectTypeDefinition;
    }

    private final ObjectTypeDefinition createEdge(String type) {
        ObjectTypeDefinition objectTypeDefinition = ObjectTypeDefinition.newObjectTypeDefinition().name(type + "Edge").description(this.createDescription(type + " Edge")).fieldDefinition(this.createFieldDefinition("cursor", (Type)new TypeName("String"))).fieldDefinition(this.createFieldDefinition("node", (Type)new TypeName(type))).build();
        Intrinsics.checkNotNullExpressionValue((Object)objectTypeDefinition, (String)"build(...)");
        return objectTypeDefinition;
    }

    private final ObjectTypeDefinition createPageInfo() {
        ObjectTypeDefinition objectTypeDefinition = ObjectTypeDefinition.newObjectTypeDefinition().name(PAGE_INFO_TYPE_NAME).description(this.createDescription(PAGE_INFO_TYPE_NAME)).fieldDefinition(this.createFieldDefinition("hasPreviousPage", (Type)new NonNullType((Type)new TypeName("Boolean")))).fieldDefinition(this.createFieldDefinition("hasNextPage", (Type)new NonNullType((Type)new TypeName("Boolean")))).fieldDefinition(this.createFieldDefinition("startCursor", (Type)new TypeName("String"))).fieldDefinition(this.createFieldDefinition("endCursor", (Type)new TypeName("String"))).build();
        Intrinsics.checkNotNullExpressionValue((Object)objectTypeDefinition, (String)"build(...)");
        return objectTypeDefinition;
    }

    private final FieldDefinition createFieldDefinition(String name, Type<?> type) {
        FieldDefinition fieldDefinition = FieldDefinition.newFieldDefinition().name(name).type(type).description(this.createDescription("Field " + name)).build();
        Intrinsics.checkNotNullExpressionValue((Object)fieldDefinition, (String)"build(...)");
        return fieldDefinition;
    }

    private final Description createDescription(String content) {
        return new Description(content, SourceLocation.EMPTY, false);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/graphql/dgs/pagination/DgsPaginationTypeDefinitionRegistry$Companion;", "", "()V", "CONNECTION_DIRECTIVE_NAME", "", "PAGE_INFO_TYPE_NAME", "graphql-dgs-pagination"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

