/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.reactive.internal.method;

import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.internal.DgsRequestData;
import com.netflix.graphql.dgs.internal.method.ArgumentResolver;
import com.netflix.graphql.dgs.reactive.internal.DgsReactiveRequestData;
import graphql.schema.DataFetchingEnvironment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/netflix/graphql/dgs/reactive/internal/method/SyncHandlerMethodArgumentResolverAdapter;", "Lcom/netflix/graphql/dgs/internal/method/ArgumentResolver;", "delegate", "Lorg/springframework/web/reactive/result/method/SyncHandlerMethodArgumentResolver;", "bindingContext", "Lorg/springframework/web/reactive/BindingContext;", "(Lorg/springframework/web/reactive/result/method/SyncHandlerMethodArgumentResolver;Lorg/springframework/web/reactive/BindingContext;)V", "resolveArgument", "", "parameter", "Lorg/springframework/core/MethodParameter;", "dfe", "Lgraphql/schema/DataFetchingEnvironment;", "supportsParameter", "", "graphql-dgs-reactive"})
public final class SyncHandlerMethodArgumentResolverAdapter
implements ArgumentResolver {
    @NotNull
    private final SyncHandlerMethodArgumentResolver delegate;
    @NotNull
    private final BindingContext bindingContext;

    public SyncHandlerMethodArgumentResolverAdapter(@NotNull SyncHandlerMethodArgumentResolver delegate, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        this.delegate = delegate;
        this.bindingContext = bindingContext;
    }

    public boolean supportsParameter(@NotNull MethodParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return this.delegate.supportsParameter(parameter);
    }

    @Nullable
    public Object resolveArgument(@NotNull MethodParameter parameter, @NotNull DataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DgsRequestData dgsRequestData = DgsContext.Companion.getRequestData(dfe);
        DgsReactiveRequestData dgsReactiveRequestData = dgsRequestData instanceof DgsReactiveRequestData ? (DgsReactiveRequestData)dgsRequestData : null;
        if (dgsReactiveRequestData == null) {
            throw new IllegalStateException("DgsReactiveRequestData not found");
        }
        DgsReactiveRequestData requestData = dgsReactiveRequestData;
        ServerRequest serverRequest = requestData.getServerRequest();
        if (serverRequest == null) {
            throw new IllegalStateException("serverRequest is not set");
        }
        ServerRequest request = serverRequest;
        ServerWebExchange exchange = request.exchange();
        return this.delegate.resolveArgument(parameter, this.bindingContext, exchange).share().block();
    }
}

