/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.metrics.micrometer;

import com.netflix.graphql.dgs.metrics.micrometer.DgsGraphQLCollatedMetricsTagsProvider;
import com.netflix.graphql.dgs.metrics.micrometer.DgsGraphQLMetricsInstrumentation;
import com.netflix.graphql.dgs.metrics.micrometer.DgsGraphQLMetricsProperties;
import com.netflix.graphql.dgs.metrics.micrometer.DgsMeterRegistrySupplier;
import com.netflix.graphql.dgs.metrics.micrometer.dataloader.DgsDataLoaderInstrumentationProvider;
import com.netflix.graphql.dgs.metrics.micrometer.tagging.DgsContextualTagCustomizer;
import com.netflix.graphql.dgs.metrics.micrometer.tagging.DgsExecutionTagCustomizer;
import com.netflix.graphql.dgs.metrics.micrometer.tagging.DgsFieldFetchTagCustomizer;
import com.netflix.graphql.dgs.metrics.micrometer.tagging.DgsGraphQLMetricsTagsProvider;
import com.netflix.graphql.dgs.metrics.micrometer.tagging.SimpleGqlOutcomeTagCustomizer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.metrics.AutoTimer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfigureAfter(value={CompositeMeterRegistryAutoConfiguration.class})
@ConditionalOnClass(value={MetricsAutoConfiguration.class, MeterRegistry.class})
@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="management.metrics.dgs-graphql", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={DgsGraphQLMetricsProperties.class})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0017J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0017J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0017\u00a8\u0006\u001c"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMicrometerAutoConfiguration;", "", "()V", "collatedMetricsTagsProvider", "Lcom/netflix/graphql/dgs/metrics/micrometer/tagging/DgsGraphQLMetricsTagsProvider;", "contextualTagCustomizer", "", "Lcom/netflix/graphql/dgs/metrics/micrometer/tagging/DgsContextualTagCustomizer;", "executionTagCustomizer", "Lcom/netflix/graphql/dgs/metrics/micrometer/tagging/DgsExecutionTagCustomizer;", "fieldFetchTagCustomizer", "Lcom/netflix/graphql/dgs/metrics/micrometer/tagging/DgsFieldFetchTagCustomizer;", "dataLoaderInstrumentationProvider", "Lcom/netflix/graphql/dgs/metrics/micrometer/dataloader/DgsDataLoaderInstrumentationProvider;", "meterRegistrySupplier", "Lcom/netflix/graphql/dgs/metrics/micrometer/DgsMeterRegistrySupplier;", "meterRegistryProvider", "Lorg/springframework/beans/factory/ObjectProvider;", "Lio/micrometer/core/instrument/MeterRegistry;", "metricsInstrumentation", "Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsInstrumentation;", "tagsProvider", "properties", "Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsProperties;", "simpleGqlOutcomeTagCustomizer", "Lcom/netflix/graphql/dgs/metrics/micrometer/tagging/SimpleGqlOutcomeTagCustomizer;", "Companion", "DefaultMeterRegistrySupplier", "graphql-dgs-spring-boot-micrometer"})
public class DgsGraphQLMicrometerAutoConfiguration {
    @NotNull
    public static final String AUTO_CONF_PREFIX = "management.metrics.dgs-graphql";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Bean
    @ConditionalOnProperty(prefix="management.metrics.dgs-graphql.tag-customizers.outcome", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public SimpleGqlOutcomeTagCustomizer simpleGqlOutcomeTagCustomizer() {
        return new SimpleGqlOutcomeTagCustomizer();
    }

    @Bean
    @ConditionalOnProperty(prefix="management.metrics.dgs-graphql.instrumentation", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public DgsGraphQLMetricsInstrumentation metricsInstrumentation(@NotNull DgsMeterRegistrySupplier meterRegistrySupplier, @NotNull DgsGraphQLMetricsTagsProvider tagsProvider, @NotNull DgsGraphQLMetricsProperties properties) {
        Intrinsics.checkNotNullParameter((Object)meterRegistrySupplier, (String)"meterRegistrySupplier");
        Intrinsics.checkNotNullParameter((Object)tagsProvider, (String)"tagsProvider");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        return new DgsGraphQLMetricsInstrumentation(meterRegistrySupplier, tagsProvider, (AutoTimer)properties.getAutotime(), null, 8, null);
    }

    @Bean
    @ConditionalOnProperty(prefix="management.metrics.dgs-graphql.data-loader-instrumentation", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public DgsDataLoaderInstrumentationProvider dataLoaderInstrumentationProvider(@NotNull DgsMeterRegistrySupplier meterRegistrySupplier) {
        Intrinsics.checkNotNullParameter((Object)meterRegistrySupplier, (String)"meterRegistrySupplier");
        return new DgsDataLoaderInstrumentationProvider(meterRegistrySupplier);
    }

    @Bean
    @NotNull
    public DgsGraphQLMetricsTagsProvider collatedMetricsTagsProvider(@NotNull Collection<? extends DgsContextualTagCustomizer> contextualTagCustomizer, @NotNull Collection<? extends DgsExecutionTagCustomizer> executionTagCustomizer, @NotNull Collection<? extends DgsFieldFetchTagCustomizer> fieldFetchTagCustomizer) {
        Intrinsics.checkNotNullParameter(contextualTagCustomizer, (String)"contextualTagCustomizer");
        Intrinsics.checkNotNullParameter(executionTagCustomizer, (String)"executionTagCustomizer");
        Intrinsics.checkNotNullParameter(fieldFetchTagCustomizer, (String)"fieldFetchTagCustomizer");
        return new DgsGraphQLCollatedMetricsTagsProvider(contextualTagCustomizer, executionTagCustomizer, fieldFetchTagCustomizer);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DgsMeterRegistrySupplier meterRegistrySupplier(@NotNull ObjectProvider<MeterRegistry> meterRegistryProvider) {
        Intrinsics.checkNotNullParameter(meterRegistryProvider, (String)"meterRegistryProvider");
        return new DefaultMeterRegistrySupplier(meterRegistryProvider);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0004H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMicrometerAutoConfiguration$DefaultMeterRegistrySupplier;", "Lcom/netflix/graphql/dgs/metrics/micrometer/DgsMeterRegistrySupplier;", "meterRegistryProvider", "Lorg/springframework/beans/factory/ObjectProvider;", "Lio/micrometer/core/instrument/MeterRegistry;", "(Lorg/springframework/beans/factory/ObjectProvider;)V", "getMeterRegistryProvider", "()Lorg/springframework/beans/factory/ObjectProvider;", "get", "Companion", "graphql-dgs-spring-boot-micrometer"})
    public static final class DefaultMeterRegistrySupplier
    implements DgsMeterRegistrySupplier {
        @NotNull
        private final ObjectProvider<MeterRegistry> meterRegistryProvider;
        private static final SimpleMeterRegistry DEFAULT_METER_REGISTRY;
        @NotNull
        public static final Companion Companion;

        @Override
        @NotNull
        public MeterRegistry get() {
            MeterRegistry meterRegistry = (MeterRegistry)this.meterRegistryProvider.getIfAvailable();
            if (meterRegistry == null) {
                meterRegistry = (MeterRegistry)DEFAULT_METER_REGISTRY;
            }
            return meterRegistry;
        }

        @NotNull
        public final ObjectProvider<MeterRegistry> getMeterRegistryProvider() {
            return this.meterRegistryProvider;
        }

        public DefaultMeterRegistrySupplier(@NotNull ObjectProvider<MeterRegistry> meterRegistryProvider) {
            Intrinsics.checkNotNullParameter(meterRegistryProvider, (String)"meterRegistryProvider");
            this.meterRegistryProvider = meterRegistryProvider;
        }

        static {
            Companion = new Companion(null);
            DEFAULT_METER_REGISTRY = new SimpleMeterRegistry();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMicrometerAutoConfiguration$DefaultMeterRegistrySupplier$Companion;", "", "()V", "DEFAULT_METER_REGISTRY", "Lio/micrometer/core/instrument/simple/SimpleMeterRegistry;", "graphql-dgs-spring-boot-micrometer"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMicrometerAutoConfiguration$Companion;", "", "()V", "AUTO_CONF_PREFIX", "", "graphql-dgs-spring-boot-micrometer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

