/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.metrics.micrometer;

import graphql.ExecutionResult;
import graphql.GraphQLError;
import graphql.InvalidSyntaxError;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.MergedField;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.language.Field;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.validation.ValidationError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\b\u001a\u00020\u0004\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u0002H\tH\u0002\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\r\u001a\u00020\u0004\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u0002H\tH\u0002\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\u000e\u001a\u00020\u0004\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u0002H\tH\u0002\u00a2\u0006\u0002\u0010\fJ/\u0010\u000f\u001a\u00020\u0004\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u0002H\t2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsInstrumentationUtils;", "", "()V", "TAG_VALUE_NONE", "", "TAG_VALUE_UNKNOWN", "instrumentationIgnores", "", "errorDetailExtension", "T", "Lgraphql/GraphQLError;", "error", "(Lgraphql/GraphQLError;)Ljava/lang/String;", "errorType", "errorTypeExtension", "extension", "key", "default", "(Lgraphql/GraphQLError;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "resolveDataFetcherTagValue", "parameters", "Lgraphql/execution/instrumentation/parameters/InstrumentationFieldFetchParameters;", "sanitizeErrorPaths", "", "Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsInstrumentationUtils$ErrorTagValues;", "executionResult", "Lgraphql/ExecutionResult;", "shouldIgnoreTag", "", "tag", "ErrorTagValues", "graphql-dgs-spring-boot-micrometer"})
public final class DgsGraphQLMetricsInstrumentationUtils {
    private static final Set<String> instrumentationIgnores;
    private static final String TAG_VALUE_UNKNOWN = "unknown";
    private static final String TAG_VALUE_NONE = "none";
    @NotNull
    public static final DgsGraphQLMetricsInstrumentationUtils INSTANCE;

    @NotNull
    public final String resolveDataFetcherTagValue(@NotNull InstrumentationFieldFetchParameters parameters) {
        GraphQLObjectType graphQLObjectType;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        ExecutionStepInfo executionStepInfo = parameters.getExecutionStepInfo();
        Intrinsics.checkNotNullExpressionValue((Object)executionStepInfo, (String)"parameters.executionStepInfo");
        ExecutionStepInfo executionStepInfo2 = executionStepInfo.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)executionStepInfo2, (String)"parameters.executionStepInfo.parent");
        GraphQLOutputType type = executionStepInfo2.getType();
        if (type instanceof GraphQLNonNull) {
            GraphQLType graphQLType = ((GraphQLNonNull)type).getWrappedType();
            if (graphQLType == null) {
                throw new NullPointerException("null cannot be cast to non-null type graphql.schema.GraphQLObjectType");
            }
            graphQLObjectType = (GraphQLObjectType)graphQLType;
        } else {
            GraphQLOutputType graphQLOutputType = type;
            if (graphQLOutputType == null) {
                throw new NullPointerException("null cannot be cast to non-null type graphql.schema.GraphQLObjectType");
            }
            graphQLObjectType = (GraphQLObjectType)graphQLOutputType;
        }
        GraphQLObjectType parentType = graphQLObjectType;
        StringBuilder stringBuilder = new StringBuilder().append(parentType.getName()).append('.');
        ExecutionStepInfo executionStepInfo3 = parameters.getExecutionStepInfo();
        Intrinsics.checkNotNullExpressionValue((Object)executionStepInfo3, (String)"parameters.executionStepInfo");
        MergedField mergedField = executionStepInfo3.getField();
        Intrinsics.checkNotNullExpressionValue((Object)mergedField, (String)"parameters.executionStepInfo.field");
        Field field = mergedField.getSingleField();
        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"parameters.executionStepInfo.field.singleField");
        return stringBuilder.append(field.getName()).toString();
    }

    public final boolean shouldIgnoreTag(@NotNull String tag) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Iterable iterable = instrumentationIgnores;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                String it = (String)t;
                boolean bl3 = false;
                if (!StringsKt.contains$default((CharSequence)tag, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<ErrorTagValues> sanitizeErrorPaths(@NotNull ExecutionResult executionResult) {
        Intrinsics.checkNotNullParameter((Object)executionResult, (String)"executionResult");
        Map dedupeErrorPaths = MapsKt.emptyMap();
        List list = executionResult.getErrors();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"executionResult.errors");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            GraphQLError error = (GraphQLError)element$iv;
            boolean bl = false;
            List errorPath = null;
            String errorType = null;
            String errorDetail = INSTANCE.errorDetailExtension(error);
            GraphQLError graphQLError = error;
            if (graphQLError instanceof ValidationError) {
                List list2 = ((ValidationError)error).getQueryPath();
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                errorPath = list2;
                errorType = INSTANCE.errorType(error);
            } else if (graphQLError instanceof InvalidSyntaxError) {
                errorPath = CollectionsKt.emptyList();
                errorType = INSTANCE.errorType(error);
            } else {
                GraphQLError graphQLError2 = error;
                Intrinsics.checkNotNullExpressionValue((Object)graphQLError2, (String)"error");
                List list3 = graphQLError2.getPath();
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                errorPath = list3;
                errorType = INSTANCE.errorTypeExtension(error);
            }
            Iterable $this$map$iv = errorPath;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void iter;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string = StringsKt.toIntOrNull((String)iter.toString()) != null ? "number" : iter.toString();
                collection.add(string);
            }
            String sanitizedPath = ((List)destination$iv$iv).toString();
            Map map = dedupeErrorPaths;
            boolean bl3 = false;
            object = map;
            boolean bl4 = false;
            if (object.containsKey(sanitizedPath)) continue;
            dedupeErrorPaths = MapsKt.plus((Map)dedupeErrorPaths, (Pair)new Pair((Object)sanitizedPath, (Object)new ErrorTagValues(sanitizedPath, errorType, errorDetail)));
        }
        return dedupeErrorPaths.values();
    }

    private final <T extends GraphQLError> String errorType(T error) {
        Object object = error.getErrorType();
        if (object == null || (object = object.toString()) == null) {
            object = TAG_VALUE_UNKNOWN;
        }
        return object;
    }

    private final <T extends GraphQLError> String errorTypeExtension(T error) {
        return this.extension(error, "errorType", TAG_VALUE_UNKNOWN);
    }

    private final <T extends GraphQLError> String errorDetailExtension(T error) {
        return this.extension(error, "errorDetail", TAG_VALUE_NONE);
    }

    private final <T extends GraphQLError> String extension(T error, String key, String string) {
        Object object = error.getExtensions();
        if (object == null || (object = object.get(key)) == null || (object = object.toString()) == null) {
            object = string;
        }
        return object;
    }

    private DgsGraphQLMetricsInstrumentationUtils() {
    }

    static {
        DgsGraphQLMetricsInstrumentationUtils dgsGraphQLMetricsInstrumentationUtils;
        INSTANCE = dgsGraphQLMetricsInstrumentationUtils = new DgsGraphQLMetricsInstrumentationUtils();
        instrumentationIgnores = SetsKt.setOf((Object[])new String[]{"__typename", "__Schema", "__Type"});
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsInstrumentationUtils$ErrorTagValues;", "", "path", "", "type", "detail", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDetail", "()Ljava/lang/String;", "getPath", "getType", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-dgs-spring-boot-micrometer"})
    public static final class ErrorTagValues {
        @NotNull
        private final String path;
        @NotNull
        private final String type;
        @NotNull
        private final String detail;

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String getDetail() {
            return this.detail;
        }

        public ErrorTagValues(@NotNull String path, @NotNull String type, @NotNull String detail) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)detail, (String)"detail");
            this.path = path;
            this.type = type;
            this.detail = detail;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        @NotNull
        public final String component3() {
            return this.detail;
        }

        @NotNull
        public final ErrorTagValues copy(@NotNull String path, @NotNull String type, @NotNull String detail) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)detail, (String)"detail");
            return new ErrorTagValues(path, type, detail);
        }

        public static /* synthetic */ ErrorTagValues copy$default(ErrorTagValues errorTagValues, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = errorTagValues.path;
            }
            if ((n & 2) != 0) {
                string2 = errorTagValues.type;
            }
            if ((n & 4) != 0) {
                string3 = errorTagValues.detail;
            }
            return errorTagValues.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ErrorTagValues(path=" + this.path + ", type=" + this.type + ", detail=" + this.detail + ")";
        }

        public int hashCode() {
            String string = this.path;
            String string2 = this.type;
            String string3 = this.detail;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ErrorTagValues)) break block3;
                    ErrorTagValues errorTagValues = (ErrorTagValues)object;
                    if (!Intrinsics.areEqual((Object)this.path, (Object)errorTagValues.path) || !Intrinsics.areEqual((Object)this.type, (Object)errorTagValues.type) || !Intrinsics.areEqual((Object)this.detail, (Object)errorTagValues.detail)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

