/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.metrics.micrometer;

import com.netflix.graphql.dgs.metrics.micrometer.DgsGraphQLMetricsProperties;
import com.netflix.graphql.dgs.metrics.micrometer.LimitedTagMetricResolver;
import com.netflix.spectator.api.patterns.CardinalityLimiters;
import io.micrometer.core.instrument.Tag;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0016R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/SpectatorLimitedTagMetricResolver;", "Lcom/netflix/graphql/dgs/metrics/micrometer/LimitedTagMetricResolver;", "tagsProperties", "Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsProperties$TagsProperties;", "(Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsProperties$TagsProperties;)V", "dynamicTags", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/function/Function;", "resolveCardinalityLimiter", "properties", "Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsProperties$CardinalityLimiterProperties;", "tag", "Ljava/util/Optional;", "Lio/micrometer/core/instrument/Tag;", "key", "value", "toString", "graphql-dgs-spring-boot-micrometer"})
public final class SpectatorLimitedTagMetricResolver
implements LimitedTagMetricResolver {
    @NotNull
    private final DgsGraphQLMetricsProperties.TagsProperties tagsProperties;
    @NotNull
    private final ConcurrentHashMap<String, Function<String, String>> dynamicTags;

    public SpectatorLimitedTagMetricResolver(@NotNull DgsGraphQLMetricsProperties.TagsProperties tagsProperties) {
        Intrinsics.checkNotNullParameter((Object)tagsProperties, (String)"tagsProperties");
        this.tagsProperties = tagsProperties;
        this.dynamicTags = new ConcurrentHashMap();
    }

    @Override
    @NotNull
    public Optional<Tag> tag(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DgsGraphQLMetricsProperties.CardinalityLimiterProperties prop = this.tagsProperties.getLimiter();
        ConcurrentMap $this$getOrPut$iv = this.dynamicTags;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key);
        if (object == null) {
            boolean bl = false;
            Function<String, String> default$iv = this.resolveCardinalityLimiter(prop);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Function limiter = (Function)object;
        Optional<Tag> optional = Optional.of(Tag.of((String)key, (String)((String)limiter.apply(value))));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(Tag.of(key, limiter.apply(value)))");
        return optional;
    }

    private final Function<String, String> resolveCardinalityLimiter(DgsGraphQLMetricsProperties.CardinalityLimiterProperties properties) {
        Function function;
        switch (WhenMappings.$EnumSwitchMapping$0[properties.getKind().ordinal()]) {
            case 1: {
                Function function2 = CardinalityLimiters.first((int)properties.getLimit());
                function = function2;
                Intrinsics.checkNotNullExpressionValue((Object)function2, (String)"first(properties.limit)");
                break;
            }
            case 2: {
                Function function3 = CardinalityLimiters.mostFrequent((int)properties.getLimit());
                function = function3;
                Intrinsics.checkNotNullExpressionValue((Object)function3, (String)"mostFrequent(properties.limit)");
                break;
            }
            case 3: {
                Function function4 = CardinalityLimiters.rollup((int)properties.getLimit());
                function = function4;
                Intrinsics.checkNotNullExpressionValue((Object)function4, (String)"rollup(properties.limit)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return function;
    }

    @NotNull
    public String toString() {
        return "SpectatorLimitedTagMetricResolver(tagsProperties=" + this.tagsProperties + ", dynamicTags=" + this.dynamicTags + ")";
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DgsGraphQLMetricsProperties.CardinalityLimiterKind.values().length];
            try {
                nArray[DgsGraphQLMetricsProperties.CardinalityLimiterKind.FIRST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DgsGraphQLMetricsProperties.CardinalityLimiterKind.FREQUENCY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DgsGraphQLMetricsProperties.CardinalityLimiterKind.ROLLUP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

