/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.metrics.micrometer.utils;

import com.netflix.graphql.dgs.Internal;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.language.AstPrinter;
import graphql.language.AstSignature;
import graphql.language.Document;
import graphql.language.Node;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
@Internal
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00e7\u0080\u0001\u0018\u0000 \t2\u00020\u0001:\u0002\t\nJ\u001e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\u000b\u00c0\u0006\u0003"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/utils/QuerySignatureRepository;", "", "get", "Ljava/util/Optional;", "Lcom/netflix/graphql/dgs/metrics/micrometer/utils/QuerySignatureRepository$QuerySignature;", "document", "Lgraphql/language/Document;", "parameters", "Lgraphql/execution/instrumentation/parameters/InstrumentationExecutionParameters;", "Companion", "QuerySignature", "graphql-dgs-spring-boot-micrometer"})
public interface QuerySignatureRepository {
    @NotNull
    public static final Companion Companion = com.netflix.graphql.dgs.metrics.micrometer.utils.QuerySignatureRepository$Companion.$$INSTANCE;

    @NotNull
    public Optional<QuerySignature> get(@NotNull Document var1, @NotNull InstrumentationExecutionParameters var2);

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\b\tJ\u0015\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/utils/QuerySignatureRepository$Companion;", "", "()V", "computeSignature", "Lcom/netflix/graphql/dgs/metrics/micrometer/utils/QuerySignatureRepository$QuerySignature;", "document", "Lgraphql/language/Document;", "operationName", "", "computeSignature$graphql_dgs_spring_boot_micrometer", "queryHash", "query", "queryHash$graphql_dgs_spring_boot_micrometer", "graphql-dgs-spring-boot-micrometer"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final String queryHash$graphql_dgs_spring_boot_micrometer(@NotNull String query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            String string = DigestUtils.sha256Hex((String)query);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sha256Hex(query)");
            return string;
        }

        @NotNull
        public final QuerySignature computeSignature$graphql_dgs_spring_boot_micrometer(@NotNull Document document, @Nullable String operationName) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Document querySignatureDoc = new AstSignature().signatureQuery(document, operationName);
            String querySignature = AstPrinter.printAst((Node)((Node)querySignatureDoc));
            String querySigHash = DigestUtils.sha256Hex((String)querySignature);
            Intrinsics.checkNotNullExpressionValue((Object)querySignature, (String)"querySignature");
            Intrinsics.checkNotNullExpressionValue((Object)querySigHash, (String)"querySigHash");
            return new QuerySignature(querySignature, querySigHash);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/utils/QuerySignatureRepository$QuerySignature;", "", "value", "", "hash", "(Ljava/lang/String;Ljava/lang/String;)V", "getHash", "()Ljava/lang/String;", "getValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-dgs-spring-boot-micrometer"})
    public static final class QuerySignature {
        @NotNull
        private final String value;
        @NotNull
        private final String hash;

        public QuerySignature(@NotNull String value, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            this.value = value;
            this.hash = hash;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String getHash() {
            return this.hash;
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        @NotNull
        public final String component2() {
            return this.hash;
        }

        @NotNull
        public final QuerySignature copy(@NotNull String value, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            return new QuerySignature(value, hash);
        }

        public static /* synthetic */ QuerySignature copy$default(QuerySignature querySignature, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = querySignature.value;
            }
            if ((n & 2) != 0) {
                string2 = querySignature.hash;
            }
            return querySignature.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "QuerySignature(value=" + this.value + ", hash=" + this.hash + ")";
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = result * 31 + this.hash.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof QuerySignature)) {
                return false;
            }
            QuerySignature querySignature = (QuerySignature)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)querySignature.value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.hash, (Object)querySignature.hash);
        }
    }
}

