/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.metrics.micrometer;

import com.netflix.graphql.dgs.Internal;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import com.netflix.graphql.dgs.metrics.DgsMetrics;
import com.netflix.graphql.dgs.metrics.micrometer.DgsGraphQLMetricsInstrumentation;
import com.netflix.graphql.dgs.metrics.micrometer.DgsGraphQLMetricsProperties;
import com.netflix.graphql.dgs.metrics.micrometer.DgsMeterRegistrySupplier;
import com.netflix.graphql.dgs.metrics.micrometer.LimitedTagMetricResolver;
import com.netflix.graphql.dgs.metrics.micrometer.tagging.DgsGraphQLMetricsTagsProvider;
import com.netflix.graphql.dgs.metrics.micrometer.utils.QuerySignatureRepository;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import graphql.InvalidSyntaxError;
import graphql.analysis.QueryTraverser;
import graphql.analysis.QueryVisitor;
import graphql.analysis.QueryVisitorFieldEnvironment;
import graphql.analysis.QueryVisitorStub;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;
import graphql.language.Document;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.validation.ValidationError;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 22\u00020\u0001:\u0006234567B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J$\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00112\u0006\u0010\u0013\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u001eH\u0016J(\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010\u0013\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J&\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120$2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J@\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0015\u001a\u00020,2\u0006\u0010\u0013\u001a\u00020\"2\b\u0010-\u001a\u0004\u0018\u00010.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsInstrumentation;", "Lgraphql/execution/instrumentation/SimplePerformantInstrumentation;", "schemaProvider", "Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "registrySupplier", "Lcom/netflix/graphql/dgs/metrics/micrometer/DgsMeterRegistrySupplier;", "tagsProvider", "Lcom/netflix/graphql/dgs/metrics/micrometer/tagging/DgsGraphQLMetricsTagsProvider;", "properties", "Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsProperties;", "limitedTagMetricResolver", "Lcom/netflix/graphql/dgs/metrics/micrometer/LimitedTagMetricResolver;", "optQuerySignatureRepository", "Ljava/util/Optional;", "Lcom/netflix/graphql/dgs/metrics/micrometer/utils/QuerySignatureRepository;", "(Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;Lcom/netflix/graphql/dgs/metrics/micrometer/DgsMeterRegistrySupplier;Lcom/netflix/graphql/dgs/metrics/micrometer/tagging/DgsGraphQLMetricsTagsProvider;Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsProperties;Lcom/netflix/graphql/dgs/metrics/micrometer/LimitedTagMetricResolver;Ljava/util/Optional;)V", "beginExecuteOperation", "Lgraphql/execution/instrumentation/InstrumentationContext;", "Lgraphql/ExecutionResult;", "parameters", "Lgraphql/execution/instrumentation/parameters/InstrumentationExecuteOperationParameters;", "state", "Lgraphql/execution/instrumentation/InstrumentationState;", "beginExecution", "Lgraphql/execution/instrumentation/parameters/InstrumentationExecutionParameters;", "beginValidation", "", "Lgraphql/validation/ValidationError;", "Lgraphql/execution/instrumentation/parameters/InstrumentationValidationParameters;", "createState", "Lgraphql/execution/instrumentation/parameters/InstrumentationCreateStateParameters;", "instrumentDataFetcher", "Lgraphql/schema/DataFetcher;", "dataFetcher", "Lgraphql/execution/instrumentation/parameters/InstrumentationFieldFetchParameters;", "instrumentExecutionResult", "Ljava/util/concurrent/CompletableFuture;", "executionResult", "recordDataFetcherMetrics", "", "registry", "Lio/micrometer/core/instrument/MeterRegistry;", "timerSampler", "Lio/micrometer/core/instrument/Timer$Sample;", "Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsInstrumentation$MetricsInstrumentationState;", "error", "", "baseTags", "", "Lio/micrometer/core/instrument/Tag;", "Companion", "ComplexityUtils", "ErrorUtils", "MetricsInstrumentationState", "QueryUtils", "TagUtils", "graphql-dgs-spring-boot-micrometer"})
public final class DgsGraphQLMetricsInstrumentation
extends SimplePerformantInstrumentation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsSchemaProvider schemaProvider;
    @NotNull
    private final DgsMeterRegistrySupplier registrySupplier;
    @NotNull
    private final DgsGraphQLMetricsTagsProvider tagsProvider;
    @NotNull
    private final DgsGraphQLMetricsProperties properties;
    @NotNull
    private final LimitedTagMetricResolver limitedTagMetricResolver;
    @NotNull
    private final Optional<QuerySignatureRepository> optQuerySignatureRepository;
    @NotNull
    private static final Logger log;

    public DgsGraphQLMetricsInstrumentation(@NotNull DgsSchemaProvider schemaProvider, @NotNull DgsMeterRegistrySupplier registrySupplier, @NotNull DgsGraphQLMetricsTagsProvider tagsProvider, @NotNull DgsGraphQLMetricsProperties properties, @NotNull LimitedTagMetricResolver limitedTagMetricResolver, @NotNull Optional<QuerySignatureRepository> optQuerySignatureRepository) {
        Intrinsics.checkNotNullParameter((Object)schemaProvider, (String)"schemaProvider");
        Intrinsics.checkNotNullParameter((Object)registrySupplier, (String)"registrySupplier");
        Intrinsics.checkNotNullParameter((Object)tagsProvider, (String)"tagsProvider");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)limitedTagMetricResolver, (String)"limitedTagMetricResolver");
        Intrinsics.checkNotNullParameter(optQuerySignatureRepository, (String)"optQuerySignatureRepository");
        this.schemaProvider = schemaProvider;
        this.registrySupplier = registrySupplier;
        this.tagsProvider = tagsProvider;
        this.properties = properties;
        this.limitedTagMetricResolver = limitedTagMetricResolver;
        this.optQuerySignatureRepository = optQuerySignatureRepository;
    }

    public /* synthetic */ DgsGraphQLMetricsInstrumentation(DgsSchemaProvider dgsSchemaProvider, DgsMeterRegistrySupplier dgsMeterRegistrySupplier, DgsGraphQLMetricsTagsProvider dgsGraphQLMetricsTagsProvider, DgsGraphQLMetricsProperties dgsGraphQLMetricsProperties, LimitedTagMetricResolver limitedTagMetricResolver, Optional optional, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            Optional<QuerySignatureRepository> optional2 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty(...)");
            optional = optional2;
        }
        this(dgsSchemaProvider, dgsMeterRegistrySupplier, dgsGraphQLMetricsTagsProvider, dgsGraphQLMetricsProperties, limitedTagMetricResolver, optional);
    }

    @NotNull
    public InstrumentationState createState(@NotNull InstrumentationCreateStateParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        return new MetricsInstrumentationState(this.registrySupplier.get(), this.limitedTagMetricResolver);
    }

    @NotNull
    public InstrumentationContext<ExecutionResult> beginExecution(@NotNull InstrumentationExecutionParameters parameters, @NotNull InstrumentationState state) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!this.properties.getQuery().getEnabled()) {
            InstrumentationContext instrumentationContext = SimpleInstrumentationContext.noOp();
            Intrinsics.checkNotNullExpressionValue((Object)instrumentationContext, (String)"noOp(...)");
            return instrumentationContext;
        }
        if (!(state instanceof MetricsInstrumentationState)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ((MetricsInstrumentationState)state).startTimer();
        MetricsInstrumentationState metricsInstrumentationState = (MetricsInstrumentationState)state;
        Optional<String> optional = Optional.ofNullable(parameters.getOperation());
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        metricsInstrumentationState.setOperationName(optional);
        MetricsInstrumentationState metricsInstrumentationState2 = (MetricsInstrumentationState)state;
        ExecutionInput executionInput = parameters.getExecutionInput();
        Intrinsics.checkNotNullExpressionValue((Object)executionInput, (String)"getExecutionInput(...)");
        metricsInstrumentationState2.setIntrospectionQuery(QueryUtils.INSTANCE.isIntrospectionQuery(executionInput));
        SimpleInstrumentationContext simpleInstrumentationContext = SimpleInstrumentationContext.whenCompleted((arg_0, arg_1) -> DgsGraphQLMetricsInstrumentation.beginExecution$lambda$1(state, this, parameters, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)simpleInstrumentationContext, (String)"whenCompleted(...)");
        return (InstrumentationContext)simpleInstrumentationContext;
    }

    @NotNull
    public CompletableFuture<ExecutionResult> instrumentExecutionResult(@NotNull ExecutionResult executionResult, @NotNull InstrumentationExecutionParameters parameters, @NotNull InstrumentationState state) {
        Intrinsics.checkNotNullParameter((Object)executionResult, (String)"executionResult");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!(state instanceof MetricsInstrumentationState)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Collection<ErrorUtils.ErrorTagValues> errorTagValues = ErrorUtils.INSTANCE.sanitizeErrorPaths(executionResult);
        if (!errorTagValues.isEmpty()) {
            List list;
            List $this$instrumentExecutionResult_u24lambda_u242 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            CollectionsKt.addAll((Collection)$this$instrumentExecutionResult_u24lambda_u242, this.tagsProvider.getContextualTags());
            CollectionsKt.addAll((Collection)$this$instrumentExecutionResult_u24lambda_u242, this.tagsProvider.getExecutionTags((MetricsInstrumentationState)state, parameters, executionResult, null));
            CollectionsKt.addAll((Collection)$this$instrumentExecutionResult_u24lambda_u242, ((MetricsInstrumentationState)state).tags());
            List baseTags = CollectionsKt.build((List)list);
            MeterRegistry registry2 = this.registrySupplier.get();
            for (ErrorUtils.ErrorTagValues errorTagValue : errorTagValues) {
                List list2;
                List $this$instrumentExecutionResult_u24lambda_u243 = list2 = CollectionsKt.createListBuilder((int)(baseTags.size() + 3));
                boolean bl2 = false;
                $this$instrumentExecutionResult_u24lambda_u243.addAll(baseTags);
                $this$instrumentExecutionResult_u24lambda_u243.add(Tag.of((String)DgsMetrics.GqlTag.PATH.getKey(), (String)errorTagValue.getPath()));
                $this$instrumentExecutionResult_u24lambda_u243.add(Tag.of((String)DgsMetrics.GqlTag.ERROR_CODE.getKey(), (String)errorTagValue.getType()));
                $this$instrumentExecutionResult_u24lambda_u243.add(Tag.of((String)DgsMetrics.GqlTag.ERROR_DETAIL.getKey(), (String)errorTagValue.getDetail()));
                List errorTags = CollectionsKt.build((List)list2);
                registry2.counter(DgsMetrics.GqlMetric.ERROR.getKey(), (Iterable)errorTags);
            }
        }
        CompletableFuture<ExecutionResult> completableFuture = CompletableFuture.completedFuture(executionResult);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @NotNull
    public DataFetcher<?> instrumentDataFetcher(@NotNull DataFetcher<?> dataFetcher, @NotNull InstrumentationFieldFetchParameters parameters, @NotNull InstrumentationState state) {
        Intrinsics.checkNotNullParameter(dataFetcher, (String)"dataFetcher");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!(state instanceof MetricsInstrumentationState)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String gqlField = TagUtils.INSTANCE.resolveDataFetcherTagValue(parameters);
        if (parameters.isTrivialDataFetcher() || ((MetricsInstrumentationState)state).isIntrospectionQuery() || TagUtils.INSTANCE.shouldIgnoreTag(gqlField) || !this.schemaProvider.isFieldMetricsInstrumentationEnabled(gqlField) || !this.properties.getResolver().getEnabled()) {
            return dataFetcher;
        }
        return arg_0 -> DgsGraphQLMetricsInstrumentation.instrumentDataFetcher$lambda$6(this, dataFetcher, state, parameters, gqlField, arg_0);
    }

    @NotNull
    public InstrumentationContext<List<ValidationError>> beginValidation(@NotNull InstrumentationValidationParameters parameters, @NotNull InstrumentationState state) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!(state instanceof MetricsInstrumentationState)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Document document = parameters.getDocument();
        if (document == null) {
            InstrumentationContext instrumentationContext = SimpleInstrumentationContext.noOp();
            Intrinsics.checkNotNullExpressionValue((Object)instrumentationContext, (String)"noOp(...)");
            return instrumentationContext;
        }
        Document document2 = document;
        QuerySignatureRepository querySignatureRepository = this.optQuerySignatureRepository.orElse(null);
        if (querySignatureRepository == null) {
            InstrumentationContext instrumentationContext = SimpleInstrumentationContext.noOp();
            Intrinsics.checkNotNullExpressionValue((Object)instrumentationContext, (String)"noOp(...)");
            return instrumentationContext;
        }
        QuerySignatureRepository querySignatureRepository2 = querySignatureRepository;
        SimpleInstrumentationContext simpleInstrumentationContext = SimpleInstrumentationContext.whenCompleted((arg_0, arg_1) -> DgsGraphQLMetricsInstrumentation.beginValidation$lambda$7(state, querySignatureRepository2, document2, parameters, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)simpleInstrumentationContext, (String)"whenCompleted(...)");
        return (InstrumentationContext)simpleInstrumentationContext;
    }

    @Nullable
    public InstrumentationContext<ExecutionResult> beginExecuteOperation(@NotNull InstrumentationExecuteOperationParameters parameters, @NotNull InstrumentationState state) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!(state instanceof MetricsInstrumentationState)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (parameters.getExecutionContext().getRoot() == null) {
            MetricsInstrumentationState metricsInstrumentationState = (MetricsInstrumentationState)state;
            String string = parameters.getExecutionContext().getOperationDefinition().getOperation().name().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            Optional<String> optional = Optional.of(string);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
            metricsInstrumentationState.setOperation(optional);
            if (((MetricsInstrumentationState)state).getOperationName().isEmpty()) {
                MetricsInstrumentationState metricsInstrumentationState2 = (MetricsInstrumentationState)state;
                OperationDefinition operationDefinition = parameters.getExecutionContext().getOperationDefinition();
                Optional<String> optional2 = Optional.ofNullable(operationDefinition != null ? operationDefinition.getName() : null);
                Intrinsics.checkNotNullExpressionValue(optional2, (String)"ofNullable(...)");
                metricsInstrumentationState2.setOperationName(optional2);
            }
        }
        if (this.properties.getTags().getComplexity().getEnabled()) {
            ((MetricsInstrumentationState)state).setQueryComplexity(ComplexityUtils.INSTANCE.resolveComplexity(parameters));
        }
        return super.beginExecuteOperation(parameters, state);
    }

    private final void recordDataFetcherMetrics(MeterRegistry registry2, Timer.Sample timerSampler, MetricsInstrumentationState state, InstrumentationFieldFetchParameters parameters, Throwable error, Iterable<? extends Tag> baseTags) {
        List recordedTags = CollectionsKt.plus(baseTags, this.tagsProvider.getFieldFetchTags(state, parameters, error));
        timerSampler.stop(this.properties.getAutotime().builder(DgsMetrics.GqlMetric.RESOLVER.getKey()).tags((Iterable)recordedTags).register(registry2));
    }

    private static final void beginExecution$lambda$1(InstrumentationState $state, DgsGraphQLMetricsInstrumentation this$0, InstrumentationExecutionParameters $parameters, ExecutionResult result, Throwable exc) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$state, (String)"$state");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$parameters, (String)"$parameters");
        List $this$beginExecution_u24lambda_u241_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        CollectionsKt.addAll((Collection)$this$beginExecution_u24lambda_u241_u24lambda_u240, this$0.tagsProvider.getContextualTags());
        Collection collection = $this$beginExecution_u24lambda_u241_u24lambda_u240;
        DgsGraphQLMetricsTagsProvider dgsGraphQLMetricsTagsProvider = this$0.tagsProvider;
        MetricsInstrumentationState metricsInstrumentationState = (MetricsInstrumentationState)$state;
        Intrinsics.checkNotNull((Object)result);
        CollectionsKt.addAll((Collection)collection, dgsGraphQLMetricsTagsProvider.getExecutionTags(metricsInstrumentationState, $parameters, result, exc));
        CollectionsKt.addAll((Collection)$this$beginExecution_u24lambda_u241_u24lambda_u240, ((MetricsInstrumentationState)$state).tags());
        List tags2 = CollectionsKt.build((List)list);
        MetricsInstrumentationState metricsInstrumentationState2 = (MetricsInstrumentationState)$state;
        Timer.Builder builder = this$0.properties.getAutotime().builder(DgsMetrics.GqlMetric.QUERY.getKey()).tags((Iterable)tags2);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"tags(...)");
        metricsInstrumentationState2.stopTimer(builder);
    }

    private static final void instrumentDataFetcher$lambda$6$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final Object instrumentDataFetcher$lambda$6(DgsGraphQLMetricsInstrumentation this$0, DataFetcher $dataFetcher, InstrumentationState $state, InstrumentationFieldFetchParameters $parameters, String $gqlField, DataFetchingEnvironment environment) {
        Object object;
        List list;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dataFetcher, (String)"$dataFetcher");
        Intrinsics.checkNotNullParameter((Object)$state, (String)"$state");
        Intrinsics.checkNotNullParameter((Object)$parameters, (String)"$parameters");
        Intrinsics.checkNotNullParameter((Object)$gqlField, (String)"$gqlField");
        MeterRegistry registry2 = this$0.registrySupplier.get();
        List $this$instrumentDataFetcher_u24lambda_u246_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$instrumentDataFetcher_u24lambda_u246_u24lambda_u244.add(Tag.of((String)DgsMetrics.GqlTag.FIELD.getKey(), (String)$gqlField));
        CollectionsKt.addAll((Collection)$this$instrumentDataFetcher_u24lambda_u246_u24lambda_u244, this$0.tagsProvider.getContextualTags());
        CollectionsKt.addAll((Collection)$this$instrumentDataFetcher_u24lambda_u246_u24lambda_u244, ((MetricsInstrumentationState)$state).tags());
        List baseTags = CollectionsKt.build((List)list);
        Timer.Sample sampler = Timer.start((MeterRegistry)registry2);
        try {
            Object result = $dataFetcher.get(environment);
            if (result instanceof CompletionStage) {
                ((CompletionStage)result).whenComplete((arg_0, arg_1) -> DgsGraphQLMetricsInstrumentation.instrumentDataFetcher$lambda$6$lambda$5((Function2)new Function2<Object, Throwable, Unit>(this$0, registry2, sampler, $state, $parameters, (List<? extends Tag>)baseTags){
                    final /* synthetic */ DgsGraphQLMetricsInstrumentation this$0;
                    final /* synthetic */ MeterRegistry $registry;
                    final /* synthetic */ Timer.Sample $sampler;
                    final /* synthetic */ InstrumentationState $state;
                    final /* synthetic */ InstrumentationFieldFetchParameters $parameters;
                    final /* synthetic */ List<Tag> $baseTags;
                    {
                        this.this$0 = $receiver;
                        this.$registry = $registry;
                        this.$sampler = $sampler;
                        this.$state = $state;
                        this.$parameters = $parameters;
                        this.$baseTags = $baseTags;
                        super(2);
                    }

                    public final void invoke(Object object, Throwable error) {
                        Timer.Sample sample = this.$sampler;
                        Intrinsics.checkNotNullExpressionValue((Object)sample, (String)"$sampler");
                        DgsGraphQLMetricsInstrumentation.access$recordDataFetcherMetrics(this.this$0, this.$registry, sample, (MetricsInstrumentationState)this.$state, this.$parameters, error, this.$baseTags);
                    }
                }, arg_0, arg_1));
            } else {
                Intrinsics.checkNotNull((Object)sampler);
                this$0.recordDataFetcherMetrics(registry2, sampler, (MetricsInstrumentationState)$state, $parameters, null, baseTags);
            }
            object = result;
        }
        catch (Exception exc) {
            Intrinsics.checkNotNull((Object)sampler);
            this$0.recordDataFetcherMetrics(registry2, sampler, (MetricsInstrumentationState)$state, $parameters, exc, baseTags);
            throw exc;
        }
        return object;
    }

    private static final void beginValidation$lambda$7(InstrumentationState $state, QuerySignatureRepository $querySignatureRepository, Document $document, InstrumentationValidationParameters $parameters, List errors, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)$state, (String)"$state");
        Intrinsics.checkNotNullParameter((Object)$querySignatureRepository, (String)"$querySignatureRepository");
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        Intrinsics.checkNotNullParameter((Object)$parameters, (String)"$parameters");
        Collection collection = errors;
        if ((collection == null || collection.isEmpty()) && throwable == null) {
            ((MetricsInstrumentationState)$state).setQuerySignature($querySignatureRepository.get($document, (InstrumentationExecutionParameters)$parameters));
        }
    }

    public static final /* synthetic */ void access$recordDataFetcherMetrics(DgsGraphQLMetricsInstrumentation $this, MeterRegistry registry2, Timer.Sample timerSampler, MetricsInstrumentationState state, InstrumentationFieldFetchParameters parameters, Throwable error, Iterable baseTags) {
        $this.recordDataFetcherMetrics(registry2, timerSampler, state, parameters, error, baseTags);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DgsGraphQLMetricsInstrumentation.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsInstrumentation$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "graphql-dgs-spring-boot-micrometer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u000e\u001a\u00020\u000fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsInstrumentation$ComplexityUtils;", "", "()V", "queryComplexityBuckets", "", "", "calculateComplexity", "queryVisitorFieldEnvironment", "Lgraphql/analysis/QueryVisitorFieldEnvironment;", "childComplexity", "fieldComplexityCalculator", "Lkotlin/Function1;", "newQueryTraverser", "Lgraphql/analysis/QueryTraverser;", "parameters", "Lgraphql/execution/instrumentation/parameters/InstrumentationExecuteOperationParameters;", "resolveComplexity", "Ljava/util/Optional;", "graphql-dgs-spring-boot-micrometer"})
    public static final class ComplexityUtils {
        @NotNull
        public static final ComplexityUtils INSTANCE = new ComplexityUtils();
        @NotNull
        private static final List<Integer> queryComplexityBuckets;

        private ComplexityUtils() {
        }

        @NotNull
        public final Optional<Integer> resolveComplexity(@NotNull InstrumentationExecuteOperationParameters parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            try {
                QueryTraverser queryTraverser = this.newQueryTraverser(parameters);
                Map valuesByParent = new LinkedHashMap();
                queryTraverser.visitPostOrder((QueryVisitor)new QueryVisitorStub(valuesByParent){
                    final /* synthetic */ Map<QueryVisitorFieldEnvironment, Integer> $valuesByParent;
                    {
                        this.$valuesByParent = $valuesByParent;
                    }

                    public void visitField(@NotNull QueryVisitorFieldEnvironment env) {
                        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                        Integer n = this.$valuesByParent.get(env);
                        int childComplexity = n != null ? n : 0;
                        int value = ComplexityUtils.calculateComplexity$default(ComplexityUtils.INSTANCE, env, childComplexity, null, 4, null);
                        this.$valuesByParent.compute(env.getParentEnvironment(), (arg_0, arg_1) -> resolveComplexity.1.visitField$lambda$0((Function2)new Function2<QueryVisitorFieldEnvironment, Integer, Integer>(value){
                            final /* synthetic */ int $value;
                            {
                                this.$value = $value;
                                super(2);
                            }

                            @Nullable
                            public final Integer invoke(@Nullable QueryVisitorFieldEnvironment queryVisitorFieldEnvironment, @Nullable Integer oldValue) {
                                return ((Number)Optional.ofNullable(oldValue).orElse(0)).intValue() + this.$value;
                            }
                        }, arg_0, arg_1));
                    }

                    private static final Integer visitField$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        return (Integer)$tmp0.invoke(p0, p1);
                    }
                });
                Integer n = (Integer)valuesByParent.get(null);
                int totalComplexity = n != null ? n : 0;
                Optional<Comparable> optional = Optional.ofNullable(SequencesKt.minOrNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)queryComplexityBuckets), (Function1)((Function1)new Function1<Integer, Boolean>(totalComplexity){
                    final /* synthetic */ int $totalComplexity;
                    {
                        this.$totalComplexity = $totalComplexity;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(int it) {
                        return this.$totalComplexity < it;
                    }
                }))));
                Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
                return optional;
            }
            catch (Exception exc) {
                log.error("Unable to compute the query complexity!", (Throwable)exc);
                Optional<Integer> optional = Optional.empty();
                Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
                return optional;
            }
        }

        public final int calculateComplexity(@NotNull QueryVisitorFieldEnvironment queryVisitorFieldEnvironment, int childComplexity, @NotNull Function1<? super Integer, Integer> fieldComplexityCalculator) {
            Intrinsics.checkNotNullParameter((Object)queryVisitorFieldEnvironment, (String)"queryVisitorFieldEnvironment");
            Intrinsics.checkNotNullParameter(fieldComplexityCalculator, (String)"fieldComplexityCalculator");
            if (queryVisitorFieldEnvironment.isTypeNameIntrospectionField()) {
                return 0;
            }
            return ((Number)fieldComplexityCalculator.invoke((Object)childComplexity)).intValue();
        }

        public static /* synthetic */ int calculateComplexity$default(ComplexityUtils complexityUtils, QueryVisitorFieldEnvironment queryVisitorFieldEnvironment, int n, Function1 function1, int n2, Object object) {
            if ((n2 & 4) != 0) {
                function1 = calculateComplexity.1.INSTANCE;
            }
            return complexityUtils.calculateComplexity(queryVisitorFieldEnvironment, n, (Function1<? super Integer, Integer>)function1);
        }

        private final QueryTraverser newQueryTraverser(InstrumentationExecuteOperationParameters parameters) {
            QueryTraverser queryTraverser = QueryTraverser.newQueryTraverser().schema(parameters.getExecutionContext().getGraphQLSchema()).document(parameters.getExecutionContext().getDocument()).operationName(parameters.getExecutionContext().getOperationDefinition().getName()).coercedVariables(parameters.getExecutionContext().getCoercedVariables()).build();
            Intrinsics.checkNotNullExpressionValue((Object)queryTraverser, (String)"build(...)");
            return queryTraverser;
        }

        static {
            Object[] objectArray = new Integer[]{5, 10, 25, 50, 100, 200, 500, 1000, 2000, 5000, 10000};
            queryComplexityBuckets = CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u0002H\u0005H\u0002\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\t\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u0002H\u0005H\u0002\u00a2\u0006\u0002\u0010\bJ/\u0010\n\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u0002H\u00052\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0014"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsInstrumentation$ErrorUtils;", "", "()V", "errorDetailExtension", "", "T", "Lgraphql/GraphQLError;", "error", "(Lgraphql/GraphQLError;)Ljava/lang/String;", "errorTypeExtension", "extension", "key", "default", "(Lgraphql/GraphQLError;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "sanitizeErrorPaths", "", "Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsInstrumentation$ErrorUtils$ErrorTagValues;", "executionResult", "Lgraphql/ExecutionResult;", "ErrorTagValues", "graphql-dgs-spring-boot-micrometer"})
    @SourceDebugExtension(value={"SMAP\nDgsGraphQLMetricsInstrumentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsGraphQLMetricsInstrumentation.kt\ncom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsInstrumentation$ErrorUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,396:1\n1855#2,2:397\n*S KotlinDebug\n*F\n+ 1 DgsGraphQLMetricsInstrumentation.kt\ncom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsInstrumentation$ErrorUtils\n*L\n347#1:397,2\n*E\n"})
    public static final class ErrorUtils {
        @NotNull
        public static final ErrorUtils INSTANCE = new ErrorUtils();

        private ErrorUtils() {
        }

        @NotNull
        public final Collection<ErrorTagValues> sanitizeErrorPaths(@NotNull ExecutionResult executionResult) {
            Intrinsics.checkNotNullParameter((Object)executionResult, (String)"executionResult");
            Map dedupeErrorPaths = new LinkedHashMap();
            List list = executionResult.getErrors();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getErrors(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GraphQLError error = (GraphQLError)element$iv;
                boolean bl = false;
                List errorPath = null;
                String errorType = null;
                String errorDetail = INSTANCE.errorDetailExtension(error);
                GraphQLError graphQLError = error;
                if (graphQLError instanceof ValidationError) {
                    List list2 = ((ValidationError)error).getQueryPath();
                    if (list2 == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    errorPath = list2;
                    errorType = "BAD_REQUEST";
                } else if (graphQLError instanceof InvalidSyntaxError) {
                    errorPath = CollectionsKt.emptyList();
                    errorType = "BAD_REQUEST";
                } else {
                    List list3 = error.getPath();
                    if (list3 == null) {
                        list3 = CollectionsKt.emptyList();
                    }
                    errorPath = list3;
                    errorType = INSTANCE.errorTypeExtension(error);
                }
                String path2 = CollectionsKt.joinToString$default((Iterable)errorPath, null, (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)sanitizeErrorPaths.1.path.1.INSTANCE, (int)25, null);
                dedupeErrorPaths.computeIfAbsent(path2, arg_0 -> ErrorUtils.sanitizeErrorPaths$lambda$1$lambda$0((Function1)new Function1<String, ErrorTagValues>(path2, errorType, errorDetail){
                    final /* synthetic */ String $path;
                    final /* synthetic */ String $errorType;
                    final /* synthetic */ String $errorDetail;
                    {
                        this.$path = $path;
                        this.$errorType = $errorType;
                        this.$errorDetail = $errorDetail;
                        super(1);
                    }

                    @NotNull
                    public final ErrorTagValues invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return new ErrorTagValues(this.$path, this.$errorType, this.$errorDetail);
                    }
                }, arg_0));
            }
            return dedupeErrorPaths.values();
        }

        private final <T extends GraphQLError> String errorTypeExtension(T error) {
            return this.extension(error, "errorType", TagUtils.INSTANCE.getTAG_VALUE_UNKNOWN());
        }

        private final <T extends GraphQLError> String errorDetailExtension(T error) {
            return this.extension(error, "errorDetail", "none");
        }

        private final <T extends GraphQLError> String extension(T error, String key, String string) {
            Object object = error.getExtensions();
            if (object == null || (object = object.get(key)) == null || (object = object.toString()) == null) {
                object = string;
            }
            return object;
        }

        private static final ErrorTagValues sanitizeErrorPaths$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (ErrorTagValues)$tmp0.invoke(p0);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsInstrumentation$ErrorUtils$ErrorTagValues;", "", "path", "", "type", "detail", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDetail", "()Ljava/lang/String;", "getPath", "getType", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-dgs-spring-boot-micrometer"})
        public static final class ErrorTagValues {
            @NotNull
            private final String path;
            @NotNull
            private final String type;
            @NotNull
            private final String detail;

            public ErrorTagValues(@NotNull String path2, @NotNull String type, @NotNull String detail) {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Intrinsics.checkNotNullParameter((Object)detail, (String)"detail");
                this.path = path2;
                this.type = type;
                this.detail = detail;
            }

            @NotNull
            public final String getPath() {
                return this.path;
            }

            @NotNull
            public final String getType() {
                return this.type;
            }

            @NotNull
            public final String getDetail() {
                return this.detail;
            }

            @NotNull
            public final String component1() {
                return this.path;
            }

            @NotNull
            public final String component2() {
                return this.type;
            }

            @NotNull
            public final String component3() {
                return this.detail;
            }

            @NotNull
            public final ErrorTagValues copy(@NotNull String path2, @NotNull String type, @NotNull String detail) {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Intrinsics.checkNotNullParameter((Object)detail, (String)"detail");
                return new ErrorTagValues(path2, type, detail);
            }

            public static /* synthetic */ ErrorTagValues copy$default(ErrorTagValues errorTagValues, String string, String string2, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string = errorTagValues.path;
                }
                if ((n & 2) != 0) {
                    string2 = errorTagValues.type;
                }
                if ((n & 4) != 0) {
                    string3 = errorTagValues.detail;
                }
                return errorTagValues.copy(string, string2, string3);
            }

            @NotNull
            public String toString() {
                return "ErrorTagValues(path=" + this.path + ", type=" + this.type + ", detail=" + this.detail + ")";
            }

            public int hashCode() {
                int result = this.path.hashCode();
                result = result * 31 + this.type.hashCode();
                result = result * 31 + this.detail.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ErrorTagValues)) {
                    return false;
                }
                ErrorTagValues errorTagValues = (ErrorTagValues)other;
                if (!Intrinsics.areEqual((Object)this.path, (Object)errorTagValues.path)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.type, (Object)errorTagValues.type)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.detail, (Object)errorTagValues.detail);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0007R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0010\"\u0004\b\u0019\u0010\u0012R \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0010\"\u0004\b\u001d\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsInstrumentation$MetricsInstrumentationState;", "Lgraphql/execution/instrumentation/InstrumentationState;", "registry", "Lio/micrometer/core/instrument/MeterRegistry;", "limitedTagMetricResolver", "Lcom/netflix/graphql/dgs/metrics/micrometer/LimitedTagMetricResolver;", "(Lio/micrometer/core/instrument/MeterRegistry;Lcom/netflix/graphql/dgs/metrics/micrometer/LimitedTagMetricResolver;)V", "isIntrospectionQuery", "", "()Z", "setIntrospectionQuery", "(Z)V", "operation", "Ljava/util/Optional;", "", "getOperation", "()Ljava/util/Optional;", "setOperation", "(Ljava/util/Optional;)V", "operationName", "getOperationName", "setOperationName", "queryComplexity", "", "getQueryComplexity", "setQueryComplexity", "querySignature", "Lcom/netflix/graphql/dgs/metrics/micrometer/utils/QuerySignatureRepository$QuerySignature;", "getQuerySignature", "setQuerySignature", "timerSample", "Lio/micrometer/core/instrument/Timer$Sample;", "startTimer", "", "stopTimer", "timer", "Lio/micrometer/core/instrument/Timer$Builder;", "tags", "", "Lio/micrometer/core/instrument/Tag;", "graphql-dgs-spring-boot-micrometer"})
    public static final class MetricsInstrumentationState
    implements InstrumentationState {
        @NotNull
        private final MeterRegistry registry;
        @NotNull
        private final LimitedTagMetricResolver limitedTagMetricResolver;
        @NotNull
        private Optional<Timer.Sample> timerSample;
        private boolean isIntrospectionQuery;
        @NotNull
        private Optional<Integer> queryComplexity;
        @NotNull
        private Optional<String> operation;
        @NotNull
        private Optional<String> operationName;
        @NotNull
        private Optional<QuerySignatureRepository.QuerySignature> querySignature;

        public MetricsInstrumentationState(@NotNull MeterRegistry registry2, @NotNull LimitedTagMetricResolver limitedTagMetricResolver) {
            Intrinsics.checkNotNullParameter((Object)registry2, (String)"registry");
            Intrinsics.checkNotNullParameter((Object)limitedTagMetricResolver, (String)"limitedTagMetricResolver");
            this.registry = registry2;
            this.limitedTagMetricResolver = limitedTagMetricResolver;
            Optional optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            this.timerSample = optional;
            Optional optional2 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty(...)");
            this.queryComplexity = optional2;
            Optional optional3 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"empty(...)");
            this.operation = optional3;
            Optional optional4 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional4, (String)"empty(...)");
            this.operationName = optional4;
            Optional optional5 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional5, (String)"empty(...)");
            this.querySignature = optional5;
        }

        public final boolean isIntrospectionQuery() {
            return this.isIntrospectionQuery;
        }

        public final void setIntrospectionQuery(boolean bl) {
            this.isIntrospectionQuery = bl;
        }

        @NotNull
        public final Optional<Integer> getQueryComplexity() {
            return this.queryComplexity;
        }

        public final void setQueryComplexity(@NotNull Optional<Integer> optional) {
            Intrinsics.checkNotNullParameter(optional, (String)"<set-?>");
            this.queryComplexity = optional;
        }

        @NotNull
        public final Optional<String> getOperation() {
            return this.operation;
        }

        public final void setOperation(@NotNull Optional<String> optional) {
            Intrinsics.checkNotNullParameter(optional, (String)"<set-?>");
            this.operation = optional;
        }

        @NotNull
        public final Optional<String> getOperationName() {
            return this.operationName;
        }

        public final void setOperationName(@NotNull Optional<String> optional) {
            Intrinsics.checkNotNullParameter(optional, (String)"<set-?>");
            this.operationName = optional;
        }

        @NotNull
        public final Optional<QuerySignatureRepository.QuerySignature> getQuerySignature() {
            return this.querySignature;
        }

        public final void setQuerySignature(@NotNull Optional<QuerySignatureRepository.QuerySignature> optional) {
            Intrinsics.checkNotNullParameter(optional, (String)"<set-?>");
            this.querySignature = optional;
        }

        public final void startTimer() {
            Optional<Timer.Sample> optional = Optional.of(Timer.start((MeterRegistry)this.registry));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
            this.timerSample = optional;
        }

        public final void stopTimer(@NotNull Timer.Builder timer) {
            Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
            this.timerSample.ifPresent(arg_0 -> MetricsInstrumentationState.stopTimer$lambda$0((Function1)new Function1<Timer.Sample, Unit>(timer, this){
                final /* synthetic */ Timer.Builder $timer;
                final /* synthetic */ MetricsInstrumentationState this$0;
                {
                    this.$timer = $timer;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Timer.Sample it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.stop(this.$timer.register(MetricsInstrumentationState.access$getRegistry$p(this.this$0)));
                }
            }, arg_0));
        }

        @Internal
        @NotNull
        public final Iterable<Tag> tags() {
            List tags2 = new ArrayList();
            Collection collection = tags2;
            collection.add(Tag.of((String)DgsMetrics.GqlTag.QUERY_COMPLEXITY.getKey(), (String)this.queryComplexity.map(arg_0 -> MetricsInstrumentationState.tags$lambda$1(tags.1.INSTANCE, arg_0)).orElse("none")));
            collection = tags2;
            collection.add(Tag.of((String)DgsMetrics.GqlTag.OPERATION.getKey(), (String)this.operation.map(arg_0 -> MetricsInstrumentationState.tags$lambda$2(tags.2.INSTANCE, arg_0)).orElse("none")));
            collection = tags2;
            String string = DgsMetrics.GqlTag.OPERATION_NAME.getKey();
            String string2 = this.operationName.orElse("anonymous");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"orElse(...)");
            CollectionsKt.addAll((Collection)collection, this.limitedTagMetricResolver.tags(string, string2));
            collection = tags2;
            String string3 = DgsMetrics.GqlTag.QUERY_SIG_HASH.getKey();
            String string4 = this.querySignature.map(arg_0 -> MetricsInstrumentationState.tags$lambda$3(tags.3.INSTANCE, arg_0)).orElse("none");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"orElse(...)");
            CollectionsKt.addAll((Collection)collection, this.limitedTagMetricResolver.tags(string3, string4));
            return tags2;
        }

        private static final void stopTimer$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final String tags$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke(p0);
        }

        private static final String tags$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke(p0);
        }

        private static final String tags$lambda$3(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ MeterRegistry access$getRegistry$p(MetricsInstrumentationState $this) {
            return $this.registry;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsInstrumentation$QueryUtils;", "", "()V", "isIntrospectionQuery", "", "input", "Lgraphql/ExecutionInput;", "graphql-dgs-spring-boot-micrometer"})
    public static final class QueryUtils {
        @NotNull
        public static final QueryUtils INSTANCE = new QueryUtils();

        private QueryUtils() {
        }

        public final boolean isIntrospectionQuery(@NotNull ExecutionInput input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            String string = input.getQuery();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQuery(...)");
            return StringsKt.contains$default((CharSequence)string, (CharSequence)"query IntrospectionQuery", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)input.getOperationName(), (Object)"IntrospectionQuery");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsInstrumentation$TagUtils;", "", "()V", "TAG_VALUE_ANONYMOUS", "", "TAG_VALUE_NONE", "TAG_VALUE_UNKNOWN", "getTAG_VALUE_UNKNOWN", "()Ljava/lang/String;", "instrumentationIgnores", "", "resolveDataFetcherTagValue", "parameters", "Lgraphql/execution/instrumentation/parameters/InstrumentationFieldFetchParameters;", "shouldIgnoreTag", "", "tag", "graphql-dgs-spring-boot-micrometer"})
    @SourceDebugExtension(value={"SMAP\nDgsGraphQLMetricsInstrumentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsGraphQLMetricsInstrumentation.kt\ncom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsInstrumentation$TagUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,396:1\n1747#2,3:397\n*S KotlinDebug\n*F\n+ 1 DgsGraphQLMetricsInstrumentation.kt\ncom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsInstrumentation$TagUtils\n*L\n339#1:397,3\n*E\n"})
    public static final class TagUtils {
        @NotNull
        public static final TagUtils INSTANCE = new TagUtils();
        @NotNull
        private static final Set<String> instrumentationIgnores;
        @NotNull
        public static final String TAG_VALUE_ANONYMOUS = "anonymous";
        @NotNull
        public static final String TAG_VALUE_NONE = "none";
        @NotNull
        private static final String TAG_VALUE_UNKNOWN;

        private TagUtils() {
        }

        @NotNull
        public final String getTAG_VALUE_UNKNOWN() {
            return TAG_VALUE_UNKNOWN;
        }

        @NotNull
        public final String resolveDataFetcherTagValue(@NotNull InstrumentationFieldFetchParameters parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            GraphQLOutputType type = parameters.getExecutionStepInfo().getParent().getType();
            GraphQLNamedType parentType = (GraphQLNamedType)GraphQLTypeUtil.unwrapNonNullAs((GraphQLType)((GraphQLType)type));
            return parentType.getName() + "." + parameters.getExecutionStepInfo().getField().getSingleField().getName();
        }

        public final boolean shouldIgnoreTag(@NotNull String tag) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                Iterable $this$any$iv = instrumentationIgnores;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.contains$default((CharSequence)tag, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        static {
            Object[] objectArray = new String[]{"__typename", "__Schema", "__Type"};
            instrumentationIgnores = SetsKt.setOf((Object[])objectArray);
            TAG_VALUE_UNKNOWN = "UNKNOWN";
        }
    }
}

