/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.metrics.micrometer.dataloader;

import com.netflix.graphql.dgs.metrics.DgsMetrics;
import com.netflix.graphql.dgs.metrics.micrometer.dataloader.Forwarder;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.bytebuddy.implementation.bind.annotation.Pipe;
import org.dataloader.MappedBatchLoader;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB%\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ@\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b0\n2*\b\u0001\u0010\f\u001a$\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b0\n\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00030\rR\u0016\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/dataloader/MappedBatchLoaderInterceptor;", "", "batchLoader", "Lorg/dataloader/MappedBatchLoader;", "name", "", "registry", "Lio/micrometer/core/instrument/MeterRegistry;", "(Lorg/dataloader/MappedBatchLoader;Ljava/lang/String;Lio/micrometer/core/instrument/MeterRegistry;)V", "load", "Ljava/util/concurrent/CompletionStage;", "", "pipe", "Lcom/netflix/graphql/dgs/metrics/micrometer/dataloader/Forwarder;", "Companion", "graphql-dgs-spring-boot-micrometer"})
public final class MappedBatchLoaderInterceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MappedBatchLoader<?, ?> batchLoader;
    @NotNull
    private final String name;
    @NotNull
    private final MeterRegistry registry;
    @NotNull
    private static final String ID = DgsMetrics.GqlMetric.DATA_LOADER.getKey();
    private static final Logger logger = LoggerFactory.getLogger(MappedBatchLoaderInterceptor.class);

    public MappedBatchLoaderInterceptor(@NotNull MappedBatchLoader<?, ?> batchLoader, @NotNull String name, @NotNull MeterRegistry registry2) {
        Intrinsics.checkNotNullParameter(batchLoader, (String)"batchLoader");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)registry2, (String)"registry");
        this.batchLoader = batchLoader;
        this.name = name;
        this.registry = registry2;
    }

    @NotNull
    public final CompletionStage<Map<?, ?>> load(@Pipe @NotNull Forwarder<CompletionStage<Map<?, ?>>, MappedBatchLoader<?, ?>> pipe) {
        CompletionStage<Object> completionStage;
        Intrinsics.checkNotNullParameter(pipe, (String)"pipe");
        logger.debug("Starting metered timer[{}] for {}.", (Object)ID, (Object)this.getClass().getSimpleName());
        Timer.Sample timerSampler = Timer.start((MeterRegistry)this.registry);
        try {
            completionStage = pipe.to(this.batchLoader).whenComplete((arg_0, arg_1) -> MappedBatchLoaderInterceptor.load$lambda$0((Function2)new Function2<Map<?, ?>, Throwable, Unit>(this, timerSampler){
                final /* synthetic */ MappedBatchLoaderInterceptor this$0;
                final /* synthetic */ Timer.Sample $timerSampler;
                {
                    this.this$0 = $receiver;
                    this.$timerSampler = $timerSampler;
                    super(2);
                }

                public final void invoke(Map<?, ?> result, Throwable throwable) {
                    MappedBatchLoaderInterceptor.access$getLogger$cp().debug("Stopping timer[{}] for {}", (Object)MappedBatchLoaderInterceptor.access$getID$cp(), (Object)this.this$0.getClass().getSimpleName());
                    String[] stringArray = new String[]{DgsMetrics.GqlTag.LOADER_BATCH_SIZE.getKey(), String.valueOf(result.size()), DgsMetrics.GqlTag.LOADER_NAME.getKey(), MappedBatchLoaderInterceptor.access$getName$p(this.this$0)};
                    this.$timerSampler.stop(Timer.builder((String)MappedBatchLoaderInterceptor.access$getID$cp()).tags(stringArray).register(MappedBatchLoaderInterceptor.access$getRegistry$p(this.this$0)));
                }
            }, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{ID, this.getClass().getSimpleName(), exception.getMessage()};
            logger.warn("Error creating timer interceptor '{}' for {} with exception {}", objectArray);
            completionStage = pipe.to(this.batchLoader);
        }
        return completionStage;
    }

    private static final void load$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ String access$getID$cp() {
        return ID;
    }

    public static final /* synthetic */ String access$getName$p(MappedBatchLoaderInterceptor $this) {
        return $this.name;
    }

    public static final /* synthetic */ MeterRegistry access$getRegistry$p(MappedBatchLoaderInterceptor $this) {
        return $this.registry;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/dataloader/MappedBatchLoaderInterceptor$Companion;", "", "()V", "ID", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "graphql-dgs-spring-boot-micrometer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

