/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.metrics.micrometer.utils;

import com.netflix.graphql.dgs.Internal;
import com.netflix.graphql.dgs.metrics.DgsMetrics;
import com.netflix.graphql.dgs.metrics.micrometer.DgsGraphQLMetricsProperties;
import com.netflix.graphql.dgs.metrics.micrometer.DgsMeterRegistrySupplier;
import com.netflix.graphql.dgs.metrics.micrometer.utils.QuerySignatureRepository;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.language.Document;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

@Internal
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\b\u001a\u00020\tX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/utils/SimpleQuerySignatureRepository;", "Lcom/netflix/graphql/dgs/metrics/micrometer/utils/QuerySignatureRepository;", "Lorg/springframework/beans/factory/InitializingBean;", "properties", "Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsProperties;", "meterRegistrySupplier", "Lcom/netflix/graphql/dgs/metrics/micrometer/DgsMeterRegistrySupplier;", "(Lcom/netflix/graphql/dgs/metrics/micrometer/DgsGraphQLMetricsProperties;Lcom/netflix/graphql/dgs/metrics/micrometer/DgsMeterRegistrySupplier;)V", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "getMeterRegistry", "()Lio/micrometer/core/instrument/MeterRegistry;", "setMeterRegistry", "(Lio/micrometer/core/instrument/MeterRegistry;)V", "afterPropertiesSet", "", "computeQuerySignature", "Lcom/netflix/graphql/dgs/metrics/micrometer/utils/QuerySignatureRepository$QuerySignature;", "queryHash", "", "queryName", "document", "Lgraphql/language/Document;", "get", "Ljava/util/Optional;", "parameters", "Lgraphql/execution/instrumentation/parameters/InstrumentationExecutionParameters;", "Companion", "graphql-dgs-spring-boot-micrometer"})
public class SimpleQuerySignatureRepository
implements QuerySignatureRepository,
InitializingBean {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsGraphQLMetricsProperties properties;
    @NotNull
    private final DgsMeterRegistrySupplier meterRegistrySupplier;
    protected MeterRegistry meterRegistry;
    @NotNull
    private static final Logger log;

    public SimpleQuerySignatureRepository(@NotNull DgsGraphQLMetricsProperties properties, @NotNull DgsMeterRegistrySupplier meterRegistrySupplier) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)meterRegistrySupplier, (String)"meterRegistrySupplier");
        this.properties = properties;
        this.meterRegistrySupplier = meterRegistrySupplier;
    }

    @NotNull
    protected final MeterRegistry getMeterRegistry() {
        MeterRegistry meterRegistry = this.meterRegistry;
        if (meterRegistry != null) {
            return meterRegistry;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"meterRegistry");
        return null;
    }

    protected final void setMeterRegistry(@NotNull MeterRegistry meterRegistry) {
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"<set-?>");
        this.meterRegistry = meterRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Optional<QuerySignatureRepository.QuerySignature> get(@NotNull Document document, @NotNull InstrumentationExecutionParameters parameters) {
        Optional<QuerySignatureRepository.QuerySignature> optional;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Timer.Sample timerSample = Timer.start((MeterRegistry)this.getMeterRegistry());
        List tags2 = new ArrayList();
        String string = parameters.getQuery();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQuery(...)");
        String queryHash = QuerySignatureRepository.Companion.queryHash$graphql_dgs_spring_boot_micrometer(string);
        try {
            Optional<QuerySignatureRepository.QuerySignature> optional2 = Optional.ofNullable(this.computeQuerySignature(queryHash, parameters.getOperation(), document));
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"ofNullable(...)");
            Optional<QuerySignatureRepository.QuerySignature> result = optional2;
            ((Collection)tags2).add(DgsMetrics.CommonTags.SUCCESS.getTag());
            Optional<QuerySignatureRepository.QuerySignature> optional3 = result;
            return optional3;
        }
        catch (Throwable error) {
            CollectionsKt.addAll((Collection)tags2, DgsMetrics.CommonTags.FAILURE.tags(error));
            log.error("Failed to fetch query signature from cache, query [hash:{}, name:{}].", (Object)queryHash, (Object)parameters.getOperation());
            Optional<QuerySignatureRepository.QuerySignature> optional4 = Optional.empty();
            Intrinsics.checkNotNull(optional4);
            optional = optional4;
        }
        finally {
            CollectionsKt.addAll((Collection)tags2, DgsMetrics.CommonTags.JAVA_CLASS.tags(this));
            CollectionsKt.addAll((Collection)tags2, DgsMetrics.CommonTags.JAVA_CLASS_METHOD.tags("get"));
            timerSample.stop(this.properties.getAutotime().builder(DgsMetrics.InternalMetric.TIMED_METHOD.getKey()).tags((Iterable)tags2).register(this.getMeterRegistry()));
        }
        return optional;
    }

    @NotNull
    protected QuerySignatureRepository.QuerySignature computeQuerySignature(@NotNull String queryHash, @Nullable String queryName, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)queryHash, (String)"queryHash");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return QuerySignatureRepository.Companion.computeSignature$graphql_dgs_spring_boot_micrometer(document, queryName);
    }

    public void afterPropertiesSet() {
        this.setMeterRegistry(this.meterRegistrySupplier.get());
    }

    static {
        Logger logger = LoggerFactory.getLogger(SimpleQuerySignatureRepository.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/utils/SimpleQuerySignatureRepository$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "graphql-dgs-spring-boot-micrometer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

