/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.autoconfig;

import com.netflix.graphql.dgs.DgsFederationResolver;
import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.autoconfig.DgsConfigurationProperties;
import com.netflix.graphql.dgs.context.DgsCustomContextBuilder;
import com.netflix.graphql.dgs.context.DgsCustomContextBuilderWithRequest;
import com.netflix.graphql.dgs.exceptions.DefaultDataFetcherExceptionHandler;
import com.netflix.graphql.dgs.internal.DataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.DefaultDgsGraphQLContextBuilder;
import com.netflix.graphql.dgs.internal.DefaultDgsQueryExecutor;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import com.netflix.graphql.dgs.scalars.UploadScalar;
import com.netflix.graphql.mocking.MockProvider;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.AsyncSerialExecutionStrategy;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={DgsConfigurationProperties.class})
@ImportAutoConfiguration(classes={JacksonAutoConfiguration.class})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u001c\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012H\u0017J~\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u000e\b\u0001\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00122\u000e\b\u0001\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00122\u0006\u0010#\u001a\u00020\bH\u0017Jd\u0010$\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00122\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00122\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u00122\u0012\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0,0\u00122\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u0013H\u0017J,\u00100\u001a\u00020\u001c2\u0010\u00101\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003020\u00122\u0010\u00103\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003040\u0012H\u0017J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u001aH\u0017J\b\u00105\u001a\u000206H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/netflix/graphql/dgs/autoconfig/DgsAutoConfiguration;", "", "configProps", "Lcom/netflix/graphql/dgs/autoconfig/DgsConfigurationProperties;", "(Lcom/netflix/graphql/dgs/autoconfig/DgsConfigurationProperties;)V", "dataFetcherExceptionHandler", "Lgraphql/execution/DataFetcherExceptionHandler;", "defaultReloadSchemaIndicator", "Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor$ReloadSchemaIndicator;", "environment", "Lorg/springframework/core/env/Environment;", "dgsDataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "dgsInstrumentation", "Lgraphql/execution/instrumentation/ChainedInstrumentation;", "instrumentation", "Ljava/util/Optional;", "", "Lgraphql/execution/instrumentation/Instrumentation;", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "schema", "Lgraphql/schema/GraphQLSchema;", "schemaProvider", "Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "dgsContextBuilder", "Lcom/netflix/graphql/dgs/internal/DefaultDgsGraphQLContextBuilder;", "chainedInstrumentation", "providedQueryExecutionStrategy", "Lgraphql/execution/ExecutionStrategy;", "providedMutationExecutionStrategy", "idProvider", "Lgraphql/execution/ExecutionIdProvider;", "reloadSchemaIndicator", "dgsSchemaProvider", "federationResolver", "Lcom/netflix/graphql/dgs/DgsFederationResolver;", "existingTypeDefinitionFactory", "Lgraphql/schema/idl/TypeDefinitionRegistry;", "existingCodeRegistry", "Lgraphql/schema/GraphQLCodeRegistry;", "mockProviders", "", "Lcom/netflix/graphql/mocking/MockProvider;", "dataFetcherResultProcessors", "Lcom/netflix/graphql/dgs/internal/DataFetcherResultProcessor;", "graphQLContextBuilder", "dgsCustomContextBuilder", "Lcom/netflix/graphql/dgs/context/DgsCustomContextBuilder;", "dgsCustomContextBuilderWithRequest", "Lcom/netflix/graphql/dgs/context/DgsCustomContextBuilderWithRequest;", "uploadScalar", "Lcom/netflix/graphql/dgs/scalars/UploadScalar;", "graphql-dgs-spring-boot-oss-autoconfigure"})
public class DgsAutoConfiguration {
    private final DgsConfigurationProperties configProps;

    @Bean
    @NotNull
    public DgsQueryExecutor dgsQueryExecutor(@NotNull ApplicationContext applicationContext, @NotNull GraphQLSchema schema, @NotNull DgsSchemaProvider schemaProvider, @NotNull DgsDataLoaderProvider dgsDataLoaderProvider, @NotNull DefaultDgsGraphQLContextBuilder dgsContextBuilder, @NotNull DataFetcherExceptionHandler dataFetcherExceptionHandler, @NotNull ChainedInstrumentation chainedInstrumentation, @NotNull Environment environment, @Qualifier(value="query") @NotNull Optional<ExecutionStrategy> providedQueryExecutionStrategy, @Qualifier(value="mutation") @NotNull Optional<ExecutionStrategy> providedMutationExecutionStrategy, @NotNull Optional<ExecutionIdProvider> idProvider, @NotNull DefaultDgsQueryExecutor.ReloadSchemaIndicator reloadSchemaIndicator) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)schemaProvider, (String)"schemaProvider");
        Intrinsics.checkNotNullParameter((Object)dgsDataLoaderProvider, (String)"dgsDataLoaderProvider");
        Intrinsics.checkNotNullParameter((Object)dgsContextBuilder, (String)"dgsContextBuilder");
        Intrinsics.checkNotNullParameter((Object)dataFetcherExceptionHandler, (String)"dataFetcherExceptionHandler");
        Intrinsics.checkNotNullParameter((Object)chainedInstrumentation, (String)"chainedInstrumentation");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(providedQueryExecutionStrategy, (String)"providedQueryExecutionStrategy");
        Intrinsics.checkNotNullParameter(providedMutationExecutionStrategy, (String)"providedMutationExecutionStrategy");
        Intrinsics.checkNotNullParameter(idProvider, (String)"idProvider");
        Intrinsics.checkNotNullParameter((Object)reloadSchemaIndicator, (String)"reloadSchemaIndicator");
        ExecutionStrategy queryExecutionStrategy = providedQueryExecutionStrategy.orElse((ExecutionStrategy)new AsyncExecutionStrategy(dataFetcherExceptionHandler));
        ExecutionStrategy mutationExecutionStrategy = providedMutationExecutionStrategy.orElse((ExecutionStrategy)new AsyncSerialExecutionStrategy(dataFetcherExceptionHandler));
        ExecutionStrategy executionStrategy = queryExecutionStrategy;
        Intrinsics.checkNotNullExpressionValue((Object)executionStrategy, (String)"queryExecutionStrategy");
        ExecutionStrategy executionStrategy2 = mutationExecutionStrategy;
        Intrinsics.checkNotNullExpressionValue((Object)executionStrategy2, (String)"mutationExecutionStrategy");
        return (DgsQueryExecutor)new DefaultDgsQueryExecutor(schema, schemaProvider, dgsDataLoaderProvider, dgsContextBuilder, chainedInstrumentation, executionStrategy, executionStrategy2, idProvider, reloadSchemaIndicator);
    }

    @Bean
    @NotNull
    public DgsDataLoaderProvider dgsDataLoaderProvider(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        return new DgsDataLoaderProvider(applicationContext);
    }

    @Bean
    @NotNull
    public ChainedInstrumentation dgsInstrumentation(@NotNull Optional<List<Instrumentation>> instrumentation) {
        Intrinsics.checkNotNullParameter(instrumentation, (String)"instrumentation");
        List<Instrumentation> listOfInstrumentations = instrumentation.orElse(CollectionsKt.emptyList());
        return new ChainedInstrumentation(listOfInstrumentations);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DefaultDgsQueryExecutor.ReloadSchemaIndicator defaultReloadSchemaIndicator(@NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Object[] objectArray = environment.getActiveProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"environment.activeProfiles");
        boolean isLaptopProfile = ArraysKt.contains((Object[])objectArray, (Object)"laptop");
        Boolean hotReloadSetting = (Boolean)environment.getProperty("dgs.reload", Boolean.TYPE, (Object)isLaptopProfile);
        return new DefaultDgsQueryExecutor.ReloadSchemaIndicator(hotReloadSetting){
            final /* synthetic */ Boolean $hotReloadSetting;

            public final boolean reloadSchema() {
                Boolean bl = this.$hotReloadSetting;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"hotReloadSetting");
                return bl;
            }
            {
                this.$hotReloadSetting = bl;
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DgsSchemaProvider dgsSchemaProvider(@NotNull ApplicationContext applicationContext, @NotNull Optional<DgsFederationResolver> federationResolver, @NotNull DataFetcherExceptionHandler dataFetcherExceptionHandler, @NotNull Optional<TypeDefinitionRegistry> existingTypeDefinitionFactory, @NotNull Optional<GraphQLCodeRegistry> existingCodeRegistry, @NotNull Optional<Set<MockProvider>> mockProviders, @NotNull List<? extends DataFetcherResultProcessor> dataFetcherResultProcessors) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter(federationResolver, (String)"federationResolver");
        Intrinsics.checkNotNullParameter((Object)dataFetcherExceptionHandler, (String)"dataFetcherExceptionHandler");
        Intrinsics.checkNotNullParameter(existingTypeDefinitionFactory, (String)"existingTypeDefinitionFactory");
        Intrinsics.checkNotNullParameter(existingCodeRegistry, (String)"existingCodeRegistry");
        Intrinsics.checkNotNullParameter(mockProviders, (String)"mockProviders");
        Intrinsics.checkNotNullParameter(dataFetcherResultProcessors, (String)"dataFetcherResultProcessors");
        return new DgsSchemaProvider(applicationContext, federationResolver, existingTypeDefinitionFactory, mockProviders, this.configProps.getSchemaLocations(), dataFetcherResultProcessors);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DataFetcherExceptionHandler dataFetcherExceptionHandler() {
        return (DataFetcherExceptionHandler)new DefaultDataFetcherExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public GraphQLSchema schema(@NotNull DgsSchemaProvider dgsSchemaProvider) {
        Intrinsics.checkNotNullParameter((Object)dgsSchemaProvider, (String)"dgsSchemaProvider");
        return DgsSchemaProvider.schema$default((DgsSchemaProvider)dgsSchemaProvider, null, (int)1, null);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DefaultDgsGraphQLContextBuilder graphQLContextBuilder(@NotNull Optional<DgsCustomContextBuilder<?>> dgsCustomContextBuilder, @NotNull Optional<DgsCustomContextBuilderWithRequest<?>> dgsCustomContextBuilderWithRequest) {
        Intrinsics.checkNotNullParameter(dgsCustomContextBuilder, (String)"dgsCustomContextBuilder");
        Intrinsics.checkNotNullParameter(dgsCustomContextBuilderWithRequest, (String)"dgsCustomContextBuilderWithRequest");
        return new DefaultDgsGraphQLContextBuilder(dgsCustomContextBuilder, dgsCustomContextBuilderWithRequest);
    }

    @Bean
    @NotNull
    public UploadScalar uploadScalar() {
        return new UploadScalar();
    }

    public DgsAutoConfiguration(@NotNull DgsConfigurationProperties configProps) {
        Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
        this.configProps = configProps;
    }
}

