/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.autoconfig;

import com.netflix.graphql.dgs.DgsFederationResolver;
import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.autoconfig.DgsConfigurationProperties;
import com.netflix.graphql.dgs.autoconfig.DgsIntrospectionConfigurationProperties;
import com.netflix.graphql.dgs.context.DgsCustomContextBuilder;
import com.netflix.graphql.dgs.context.DgsCustomContextBuilderWithRequest;
import com.netflix.graphql.dgs.exceptions.DefaultDataFetcherExceptionHandler;
import com.netflix.graphql.dgs.internal.CookieValueResolver;
import com.netflix.graphql.dgs.internal.DataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.DefaultDgsGraphQLContextBuilder;
import com.netflix.graphql.dgs.internal.DefaultDgsQueryExecutor;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.DgsNoOpPreparsedDocumentProvider;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import com.netflix.graphql.dgs.scalars.UploadScalar;
import com.netflix.graphql.mocking.MockProvider;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.AsyncSerialExecutionStrategy;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.visibility.DefaultGraphqlFieldVisibility;
import graphql.schema.visibility.GraphqlFieldVisibility;
import graphql.schema.visibility.NoIntrospectionGraphqlFieldVisibility;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Configuration
@EnableConfigurationProperties(value={DgsConfigurationProperties.class, DgsIntrospectionConfigurationProperties.class})
@ImportAutoConfiguration(classes={JacksonAutoConfiguration.class})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 ?2\u00020\u0001:\u0001?B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001c\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0014H\u0017J\u0086\u0001\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u000e\b\u0001\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00142\u000e\b\u0001\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0\u00142\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00142\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020'H\u0017J|\u0010(\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u00142\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00142\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00142\u0012\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000201000\u00142\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u00152\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u000e\b\u0002\u00104\u001a\b\u0012\u0004\u0012\u0002050\u0014H\u0017J,\u00106\u001a\u00020\u001e2\u0010\u00107\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003080\u00142\u0010\u00109\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030:0\u0014H\u0017J\b\u0010;\u001a\u00020\bH\u0017J\b\u0010&\u001a\u00020'H\u0017J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020\bH\u0017J\b\u0010=\u001a\u00020>H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/netflix/graphql/dgs/autoconfig/DgsAutoConfiguration;", "", "configProps", "Lcom/netflix/graphql/dgs/autoconfig/DgsConfigurationProperties;", "(Lcom/netflix/graphql/dgs/autoconfig/DgsConfigurationProperties;)V", "dataFetcherExceptionHandler", "Lgraphql/execution/DataFetcherExceptionHandler;", "defaultFieldVisibility", "Lgraphql/schema/visibility/GraphqlFieldVisibility;", "defaultReloadSchemaIndicator", "Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor$ReloadSchemaIndicator;", "environment", "Lorg/springframework/core/env/Environment;", "dgsDataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "dgsInstrumentation", "Lgraphql/execution/instrumentation/ChainedInstrumentation;", "instrumentation", "Ljava/util/Optional;", "", "Lgraphql/execution/instrumentation/Instrumentation;", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "schema", "Lgraphql/schema/GraphQLSchema;", "schemaProvider", "Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "dgsContextBuilder", "Lcom/netflix/graphql/dgs/internal/DefaultDgsGraphQLContextBuilder;", "chainedInstrumentation", "providedQueryExecutionStrategy", "Lgraphql/execution/ExecutionStrategy;", "providedMutationExecutionStrategy", "idProvider", "Lgraphql/execution/ExecutionIdProvider;", "reloadSchemaIndicator", "preparsedDocumentProvider", "Lgraphql/execution/preparsed/PreparsedDocumentProvider;", "dgsSchemaProvider", "federationResolver", "Lcom/netflix/graphql/dgs/DgsFederationResolver;", "existingTypeDefinitionFactory", "Lgraphql/schema/idl/TypeDefinitionRegistry;", "existingCodeRegistry", "Lgraphql/schema/GraphQLCodeRegistry;", "mockProviders", "", "Lcom/netflix/graphql/mocking/MockProvider;", "dataFetcherResultProcessors", "Lcom/netflix/graphql/dgs/internal/DataFetcherResultProcessor;", "cookieValueResolver", "Lcom/netflix/graphql/dgs/internal/CookieValueResolver;", "graphQLContextBuilder", "dgsCustomContextBuilder", "Lcom/netflix/graphql/dgs/context/DgsCustomContextBuilder;", "dgsCustomContextBuilderWithRequest", "Lcom/netflix/graphql/dgs/context/DgsCustomContextBuilderWithRequest;", "noIntrospectionFieldVisibility", "fieldVisibility", "uploadScalar", "Lcom/netflix/graphql/dgs/scalars/UploadScalar;", "Companion", "graphql-dgs-spring-boot-oss-autoconfigure"})
public class DgsAutoConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsConfigurationProperties configProps;
    @NotNull
    public static final String AUTO_CONF_PREFIX = "dgs.graphql";

    public DgsAutoConfiguration(@NotNull DgsConfigurationProperties configProps) {
        Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
        this.configProps = configProps;
    }

    @Bean
    @NotNull
    public DgsQueryExecutor dgsQueryExecutor(@NotNull ApplicationContext applicationContext, @NotNull GraphQLSchema schema, @NotNull DgsSchemaProvider schemaProvider, @NotNull DgsDataLoaderProvider dgsDataLoaderProvider, @NotNull DefaultDgsGraphQLContextBuilder dgsContextBuilder, @NotNull DataFetcherExceptionHandler dataFetcherExceptionHandler, @NotNull ChainedInstrumentation chainedInstrumentation, @NotNull Environment environment, @Qualifier(value="query") @NotNull Optional<ExecutionStrategy> providedQueryExecutionStrategy, @Qualifier(value="mutation") @NotNull Optional<ExecutionStrategy> providedMutationExecutionStrategy, @NotNull Optional<ExecutionIdProvider> idProvider, @NotNull DefaultDgsQueryExecutor.ReloadSchemaIndicator reloadSchemaIndicator, @NotNull PreparsedDocumentProvider preparsedDocumentProvider) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)schemaProvider, (String)"schemaProvider");
        Intrinsics.checkNotNullParameter((Object)dgsDataLoaderProvider, (String)"dgsDataLoaderProvider");
        Intrinsics.checkNotNullParameter((Object)dgsContextBuilder, (String)"dgsContextBuilder");
        Intrinsics.checkNotNullParameter((Object)dataFetcherExceptionHandler, (String)"dataFetcherExceptionHandler");
        Intrinsics.checkNotNullParameter((Object)chainedInstrumentation, (String)"chainedInstrumentation");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(providedQueryExecutionStrategy, (String)"providedQueryExecutionStrategy");
        Intrinsics.checkNotNullParameter(providedMutationExecutionStrategy, (String)"providedMutationExecutionStrategy");
        Intrinsics.checkNotNullParameter(idProvider, (String)"idProvider");
        Intrinsics.checkNotNullParameter((Object)reloadSchemaIndicator, (String)"reloadSchemaIndicator");
        Intrinsics.checkNotNullParameter((Object)preparsedDocumentProvider, (String)"preparsedDocumentProvider");
        ExecutionStrategy queryExecutionStrategy = providedQueryExecutionStrategy.orElse((ExecutionStrategy)new AsyncExecutionStrategy(dataFetcherExceptionHandler));
        ExecutionStrategy mutationExecutionStrategy = providedMutationExecutionStrategy.orElse((ExecutionStrategy)new AsyncSerialExecutionStrategy(dataFetcherExceptionHandler));
        Intrinsics.checkNotNullExpressionValue((Object)queryExecutionStrategy, (String)"queryExecutionStrategy");
        Intrinsics.checkNotNullExpressionValue((Object)mutationExecutionStrategy, (String)"mutationExecutionStrategy");
        return (DgsQueryExecutor)new DefaultDgsQueryExecutor(schema, schemaProvider, dgsDataLoaderProvider, dgsContextBuilder, chainedInstrumentation, queryExecutionStrategy, mutationExecutionStrategy, idProvider, reloadSchemaIndicator, preparsedDocumentProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public PreparsedDocumentProvider preparsedDocumentProvider() {
        return (PreparsedDocumentProvider)DgsNoOpPreparsedDocumentProvider.INSTANCE;
    }

    @Bean
    @NotNull
    public DgsDataLoaderProvider dgsDataLoaderProvider(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        return new DgsDataLoaderProvider(applicationContext);
    }

    @Bean
    @NotNull
    public ChainedInstrumentation dgsInstrumentation(@NotNull Optional<List<Instrumentation>> instrumentation) {
        Intrinsics.checkNotNullParameter(instrumentation, (String)"instrumentation");
        List<Instrumentation> listOfInstrumentations = instrumentation.orElse(CollectionsKt.emptyList());
        return new ChainedInstrumentation(listOfInstrumentations);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DefaultDgsQueryExecutor.ReloadSchemaIndicator defaultReloadSchemaIndicator(@NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        String[] stringArray = environment.getActiveProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"environment.activeProfiles");
        boolean isLaptopProfile = ArraysKt.contains((Object[])stringArray, (Object)"laptop");
        Boolean hotReloadSetting = (Boolean)environment.getProperty("dgs.reload", Boolean.TYPE, (Object)isLaptopProfile);
        return () -> DgsAutoConfiguration.defaultReloadSchemaIndicator$lambda-0(hotReloadSetting);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DgsSchemaProvider dgsSchemaProvider(@NotNull ApplicationContext applicationContext, @NotNull Optional<DgsFederationResolver> federationResolver, @NotNull Optional<TypeDefinitionRegistry> existingTypeDefinitionFactory, @NotNull Optional<GraphQLCodeRegistry> existingCodeRegistry, @NotNull Optional<Set<MockProvider>> mockProviders, @NotNull List<? extends DataFetcherResultProcessor> dataFetcherResultProcessors, @NotNull Optional<DataFetcherExceptionHandler> dataFetcherExceptionHandler, @NotNull Optional<CookieValueResolver> cookieValueResolver) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter(federationResolver, (String)"federationResolver");
        Intrinsics.checkNotNullParameter(existingTypeDefinitionFactory, (String)"existingTypeDefinitionFactory");
        Intrinsics.checkNotNullParameter(existingCodeRegistry, (String)"existingCodeRegistry");
        Intrinsics.checkNotNullParameter(mockProviders, (String)"mockProviders");
        Intrinsics.checkNotNullParameter(dataFetcherResultProcessors, (String)"dataFetcherResultProcessors");
        Intrinsics.checkNotNullParameter(dataFetcherExceptionHandler, (String)"dataFetcherExceptionHandler");
        Intrinsics.checkNotNullParameter(cookieValueResolver, (String)"cookieValueResolver");
        return new DgsSchemaProvider(applicationContext, federationResolver, existingTypeDefinitionFactory, mockProviders, this.configProps.getSchemaLocations(), dataFetcherResultProcessors, dataFetcherExceptionHandler, cookieValueResolver);
    }

    public static /* synthetic */ DgsSchemaProvider dgsSchemaProvider$default(DgsAutoConfiguration dgsAutoConfiguration, ApplicationContext applicationContext, Optional optional, Optional optional2, Optional optional3, Optional optional4, List list, Optional optional5, Optional optional6, int n, Object object) {
        Optional<DataFetcherExceptionHandler> optional7;
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: dgsSchemaProvider");
        }
        if ((n & 0x40) != 0) {
            optional7 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional7, (String)"empty()");
            optional5 = optional7;
        }
        if ((n & 0x80) != 0) {
            optional7 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional7, (String)"empty()");
            optional6 = optional7;
        }
        return dgsAutoConfiguration.dgsSchemaProvider(applicationContext, optional, optional2, optional3, optional4, list, optional5, optional6);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DataFetcherExceptionHandler dataFetcherExceptionHandler() {
        return (DataFetcherExceptionHandler)new DefaultDataFetcherExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public GraphQLSchema schema(@NotNull DgsSchemaProvider dgsSchemaProvider, @NotNull GraphqlFieldVisibility fieldVisibility) {
        Intrinsics.checkNotNullParameter((Object)dgsSchemaProvider, (String)"dgsSchemaProvider");
        Intrinsics.checkNotNullParameter((Object)fieldVisibility, (String)"fieldVisibility");
        return dgsSchemaProvider.schema(null, fieldVisibility);
    }

    @Bean
    @ConditionalOnProperty(prefix="dgs.graphql.introspection", name={"enabled"}, havingValue="false", matchIfMissing=false)
    @NotNull
    public GraphqlFieldVisibility noIntrospectionFieldVisibility() {
        NoIntrospectionGraphqlFieldVisibility noIntrospectionGraphqlFieldVisibility = NoIntrospectionGraphqlFieldVisibility.NO_INTROSPECTION_FIELD_VISIBILITY;
        Intrinsics.checkNotNullExpressionValue((Object)noIntrospectionGraphqlFieldVisibility, (String)"NO_INTROSPECTION_FIELD_VISIBILITY");
        return (GraphqlFieldVisibility)noIntrospectionGraphqlFieldVisibility;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public GraphqlFieldVisibility defaultFieldVisibility() {
        DefaultGraphqlFieldVisibility defaultGraphqlFieldVisibility = DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY;
        Intrinsics.checkNotNullExpressionValue((Object)defaultGraphqlFieldVisibility, (String)"DEFAULT_FIELD_VISIBILITY");
        return (GraphqlFieldVisibility)defaultGraphqlFieldVisibility;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DefaultDgsGraphQLContextBuilder graphQLContextBuilder(@NotNull Optional<DgsCustomContextBuilder<?>> dgsCustomContextBuilder, @NotNull Optional<DgsCustomContextBuilderWithRequest<?>> dgsCustomContextBuilderWithRequest) {
        Intrinsics.checkNotNullParameter(dgsCustomContextBuilder, (String)"dgsCustomContextBuilder");
        Intrinsics.checkNotNullParameter(dgsCustomContextBuilderWithRequest, (String)"dgsCustomContextBuilderWithRequest");
        return new DefaultDgsGraphQLContextBuilder(dgsCustomContextBuilder, dgsCustomContextBuilderWithRequest);
    }

    @Bean
    @NotNull
    public UploadScalar uploadScalar() {
        return new UploadScalar();
    }

    private static final boolean defaultReloadSchemaIndicator$lambda-0(Boolean $hotReloadSetting) {
        Intrinsics.checkNotNullExpressionValue((Object)$hotReloadSetting, (String)"hotReloadSetting");
        return $hotReloadSetting;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/autoconfig/DgsAutoConfiguration$Companion;", "", "()V", "AUTO_CONF_PREFIX", "", "graphql-dgs-spring-boot-oss-autoconfigure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

