/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.autoconfig;

import com.netflix.graphql.dgs.DgsFederationResolver;
import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.autoconfig.DgsAutoConfiguration;
import com.netflix.graphql.dgs.autoconfig.DgsConfigurationProperties;
import com.netflix.graphql.dgs.autoconfig.DgsInputArgumentConfiguration;
import com.netflix.graphql.dgs.context.DgsCustomContextBuilder;
import com.netflix.graphql.dgs.context.DgsCustomContextBuilderWithRequest;
import com.netflix.graphql.dgs.context.GraphQLContextContributor;
import com.netflix.graphql.dgs.context.GraphQLContextContributorInstrumentation;
import com.netflix.graphql.dgs.exceptions.DefaultDataFetcherExceptionHandler;
import com.netflix.graphql.dgs.internal.DataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.DefaultDgsGraphQLContextBuilder;
import com.netflix.graphql.dgs.internal.DefaultDgsQueryExecutor;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.DgsQueryExecutorRequestCustomizer;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import com.netflix.graphql.dgs.internal.EntityFetcherRegistry;
import com.netflix.graphql.dgs.internal.FlowDataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.FluxDataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.MonoDataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.QueryValueCustomizer;
import com.netflix.graphql.dgs.internal.method.ArgumentResolver;
import com.netflix.graphql.dgs.internal.method.MethodDataFetcherFactory;
import com.netflix.graphql.dgs.scalars.UploadScalar;
import com.netflix.graphql.mocking.MockProvider;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.AsyncSerialExecutionStrategy;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.DataFetcherFactory;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.visibility.DefaultGraphqlFieldVisibility;
import graphql.schema.visibility.GraphqlFieldVisibility;
import graphql.schema.visibility.NoIntrospectionGraphqlFieldVisibility;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.reflect.KProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;

@AutoConfiguration
@EnableConfigurationProperties(value={DgsConfigurationProperties.class})
@ImportAutoConfiguration(classes={JacksonAutoConfiguration.class, DgsInputArgumentConfiguration.class})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00f0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 Q2\u00020\u0001:\u0001QB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u00a8\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\r\u001a\u00020\u000e2\u000e\b\u0001\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u000e\b\u0001\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001f2\u0006\u0010$\u001a\u00020\f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u001c2\u0006\u0010'\u001a\u00020\n2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u001cH\u0017J\u008a\u0001\u0010*\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u001f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u001f2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u001f2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u001c2\f\u00103\u001a\b\u0012\u0004\u0012\u000205042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u00106\u001a\u0002072\u0012\b\u0002\u00108\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003090\u001f2\u0006\u0010:\u001a\u00020;H\u0017J\b\u00106\u001a\u000207H\u0017J\b\u0010<\u001a\u00020=H\u0017J\b\u0010>\u001a\u00020?H\u0017J,\u0010@\u001a\u00020\u001a2\u0010\u0010A\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030B0\u001f2\u0010\u0010C\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030D0\u001fH\u0017J\u0016\u0010E\u001a\u00020\u001d2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020G0\u001cH\u0017J\u0016\u0010:\u001a\u00020;2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020I0\u001cH\u0017J\b\u0010J\u001a\u00020)H\u0017J\b\u0010K\u001a\u00020LH\u0017J\b\u0010M\u001a\u00020\bH\u0017J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u00182\u0006\u0010N\u001a\u00020\bH\u0017J\b\u0010O\u001a\u00020PH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/netflix/graphql/dgs/autoconfig/DgsAutoConfiguration;", "", "configProps", "Lcom/netflix/graphql/dgs/autoconfig/DgsConfigurationProperties;", "(Lcom/netflix/graphql/dgs/autoconfig/DgsConfigurationProperties;)V", "dataFetcherExceptionHandler", "Lgraphql/execution/DataFetcherExceptionHandler;", "defaultFieldVisibility", "Lgraphql/schema/visibility/GraphqlFieldVisibility;", "defaultQueryValueCustomizer", "Lcom/netflix/graphql/dgs/internal/QueryValueCustomizer;", "defaultReloadSchemaIndicator", "Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor$ReloadSchemaIndicator;", "environment", "Lorg/springframework/core/env/Environment;", "dgsDataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "schema", "Lgraphql/schema/GraphQLSchema;", "schemaProvider", "Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "dgsContextBuilder", "Lcom/netflix/graphql/dgs/internal/DefaultDgsGraphQLContextBuilder;", "instrumentations", "Lorg/springframework/beans/factory/ObjectProvider;", "Lgraphql/execution/instrumentation/Instrumentation;", "providedQueryExecutionStrategy", "Ljava/util/Optional;", "Lgraphql/execution/ExecutionStrategy;", "providedMutationExecutionStrategy", "idProvider", "Lgraphql/execution/ExecutionIdProvider;", "reloadSchemaIndicator", "preparsedDocumentProvider", "Lgraphql/execution/preparsed/PreparsedDocumentProvider;", "queryValueCustomizer", "requestCustomizer", "Lcom/netflix/graphql/dgs/internal/DgsQueryExecutorRequestCustomizer;", "dgsSchemaProvider", "federationResolver", "Lcom/netflix/graphql/dgs/DgsFederationResolver;", "existingTypeDefinitionFactory", "Lgraphql/schema/idl/TypeDefinitionRegistry;", "existingCodeRegistry", "Lgraphql/schema/GraphQLCodeRegistry;", "mockProviders", "Lcom/netflix/graphql/mocking/MockProvider;", "dataFetcherResultProcessors", "", "Lcom/netflix/graphql/dgs/internal/DataFetcherResultProcessor;", "entityFetcherRegistry", "Lcom/netflix/graphql/dgs/internal/EntityFetcherRegistry;", "defaultDataFetcherFactory", "Lgraphql/schema/DataFetcherFactory;", "methodDataFetcherFactory", "Lcom/netflix/graphql/dgs/internal/method/MethodDataFetcherFactory;", "flowReactiveDataFetcherResultProcessor", "Lcom/netflix/graphql/dgs/internal/FlowDataFetcherResultProcessor;", "fluxReactiveDataFetcherResultProcessor", "Lcom/netflix/graphql/dgs/internal/FluxDataFetcherResultProcessor;", "graphQLContextBuilder", "dgsCustomContextBuilder", "Lcom/netflix/graphql/dgs/context/DgsCustomContextBuilder;", "dgsCustomContextBuilderWithRequest", "Lcom/netflix/graphql/dgs/context/DgsCustomContextBuilderWithRequest;", "graphQLContextContributionInstrumentation", "graphQLContextContributors", "Lcom/netflix/graphql/dgs/context/GraphQLContextContributor;", "argumentResolvers", "Lcom/netflix/graphql/dgs/internal/method/ArgumentResolver;", "mockRequestHeaderCustomizer", "monoReactiveDataFetcherResultProcessor", "Lcom/netflix/graphql/dgs/internal/MonoDataFetcherResultProcessor;", "noIntrospectionFieldVisibility", "fieldVisibility", "uploadScalar", "Lcom/netflix/graphql/dgs/scalars/UploadScalar;", "Companion", "graphql-dgs-spring-boot-oss-autoconfigure"})
public class DgsAutoConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsConfigurationProperties configProps;
    @NotNull
    public static final String AUTO_CONF_PREFIX = "dgs.graphql";

    public DgsAutoConfiguration(@NotNull DgsConfigurationProperties configProps) {
        Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
        this.configProps = configProps;
    }

    @Bean
    @Order(value=-2147483648)
    @NotNull
    public Instrumentation graphQLContextContributionInstrumentation(@NotNull ObjectProvider<GraphQLContextContributor> graphQLContextContributors) {
        Intrinsics.checkNotNullParameter(graphQLContextContributors, (String)"graphQLContextContributors");
        List list = graphQLContextContributors.orderedStream().toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"graphQLContextContributo\u2026.orderedStream().toList()");
        return (Instrumentation)new GraphQLContextContributorInstrumentation(list);
    }

    @Bean
    @NotNull
    public DgsQueryExecutor dgsQueryExecutor(@NotNull ApplicationContext applicationContext, @NotNull GraphQLSchema schema, @NotNull DgsSchemaProvider schemaProvider, @NotNull DgsDataLoaderProvider dgsDataLoaderProvider, @NotNull DefaultDgsGraphQLContextBuilder dgsContextBuilder, @NotNull DataFetcherExceptionHandler dataFetcherExceptionHandler, @NotNull ObjectProvider<Instrumentation> instrumentations, @NotNull Environment environment, @Qualifier(value="query") @NotNull Optional<ExecutionStrategy> providedQueryExecutionStrategy, @Qualifier(value="mutation") @NotNull Optional<ExecutionStrategy> providedMutationExecutionStrategy, @NotNull Optional<ExecutionIdProvider> idProvider, @NotNull DefaultDgsQueryExecutor.ReloadSchemaIndicator reloadSchemaIndicator, @NotNull ObjectProvider<PreparsedDocumentProvider> preparsedDocumentProvider, @NotNull QueryValueCustomizer queryValueCustomizer, @NotNull ObjectProvider<DgsQueryExecutorRequestCustomizer> requestCustomizer) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)schemaProvider, (String)"schemaProvider");
        Intrinsics.checkNotNullParameter((Object)dgsDataLoaderProvider, (String)"dgsDataLoaderProvider");
        Intrinsics.checkNotNullParameter((Object)dgsContextBuilder, (String)"dgsContextBuilder");
        Intrinsics.checkNotNullParameter((Object)dataFetcherExceptionHandler, (String)"dataFetcherExceptionHandler");
        Intrinsics.checkNotNullParameter(instrumentations, (String)"instrumentations");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(providedQueryExecutionStrategy, (String)"providedQueryExecutionStrategy");
        Intrinsics.checkNotNullParameter(providedMutationExecutionStrategy, (String)"providedMutationExecutionStrategy");
        Intrinsics.checkNotNullParameter(idProvider, (String)"idProvider");
        Intrinsics.checkNotNullParameter((Object)reloadSchemaIndicator, (String)"reloadSchemaIndicator");
        Intrinsics.checkNotNullParameter(preparsedDocumentProvider, (String)"preparsedDocumentProvider");
        Intrinsics.checkNotNullParameter((Object)queryValueCustomizer, (String)"queryValueCustomizer");
        Intrinsics.checkNotNullParameter(requestCustomizer, (String)"requestCustomizer");
        ExecutionStrategy queryExecutionStrategy = providedQueryExecutionStrategy.orElse((ExecutionStrategy)new AsyncExecutionStrategy(dataFetcherExceptionHandler));
        ExecutionStrategy mutationExecutionStrategy = providedMutationExecutionStrategy.orElse((ExecutionStrategy)new AsyncSerialExecutionStrategy(dataFetcherExceptionHandler));
        List instrumentationImpls = instrumentations.orderedStream().toList();
        if (instrumentationImpls.size() == 1) {
            Intrinsics.checkNotNullExpressionValue(instrumentationImpls, (String)"instrumentationImpls");
            object = (Instrumentation)CollectionsKt.single(instrumentationImpls);
        } else {
            Intrinsics.checkNotNullExpressionValue(instrumentationImpls, (String)"instrumentationImpls");
            object = !((Collection)instrumentationImpls).isEmpty() ? (Instrumentation)new ChainedInstrumentation(instrumentationImpls) : null;
        }
        Instrumentation instrumentation = object;
        Intrinsics.checkNotNullExpressionValue((Object)queryExecutionStrategy, (String)"queryExecutionStrategy");
        Intrinsics.checkNotNullExpressionValue((Object)mutationExecutionStrategy, (String)"mutationExecutionStrategy");
        PreparsedDocumentProvider preparsedDocumentProvider2 = (PreparsedDocumentProvider)preparsedDocumentProvider.getIfAvailable();
        Object object2 = requestCustomizer.getIfAvailable(() -> DgsAutoConfiguration.dgsQueryExecutor$lambda$0((KProperty0)new PropertyReference0Impl(DgsQueryExecutorRequestCustomizer.Companion){

            @Nullable
            public Object get() {
                return ((DgsQueryExecutorRequestCustomizer.Companion)this.receiver).getDEFAULT_REQUEST_CUSTOMIZER();
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"requestCustomizer.getIfA\u2026FAULT_REQUEST_CUSTOMIZER)");
        return (DgsQueryExecutor)new DefaultDgsQueryExecutor(schema, schemaProvider, dgsDataLoaderProvider, dgsContextBuilder, instrumentation, queryExecutionStrategy, mutationExecutionStrategy, idProvider, reloadSchemaIndicator, preparsedDocumentProvider2, queryValueCustomizer, (DgsQueryExecutorRequestCustomizer)object2);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public QueryValueCustomizer defaultQueryValueCustomizer() {
        return DgsAutoConfiguration::defaultQueryValueCustomizer$lambda$1;
    }

    @Bean
    @NotNull
    public DgsDataLoaderProvider dgsDataLoaderProvider(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        return new DgsDataLoaderProvider(applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DefaultDgsQueryExecutor.ReloadSchemaIndicator defaultReloadSchemaIndicator(@NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        String[] stringArray = environment.getActiveProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"environment.activeProfiles");
        boolean isLaptopProfile = ArraysKt.contains((Object[])stringArray, (Object)"laptop");
        Boolean hotReloadSetting = (Boolean)environment.getProperty("dgs.reload", Boolean.TYPE, (Object)isLaptopProfile);
        return () -> DgsAutoConfiguration.defaultReloadSchemaIndicator$lambda$2(hotReloadSetting);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DgsSchemaProvider dgsSchemaProvider(@NotNull ApplicationContext applicationContext, @NotNull Optional<DgsFederationResolver> federationResolver, @NotNull Optional<TypeDefinitionRegistry> existingTypeDefinitionFactory, @NotNull Optional<GraphQLCodeRegistry> existingCodeRegistry, @NotNull ObjectProvider<MockProvider> mockProviders, @NotNull List<? extends DataFetcherResultProcessor> dataFetcherResultProcessors, @NotNull Optional<DataFetcherExceptionHandler> dataFetcherExceptionHandler, @NotNull EntityFetcherRegistry entityFetcherRegistry, @NotNull Optional<DataFetcherFactory<?>> defaultDataFetcherFactory, @NotNull MethodDataFetcherFactory methodDataFetcherFactory) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter(federationResolver, (String)"federationResolver");
        Intrinsics.checkNotNullParameter(existingTypeDefinitionFactory, (String)"existingTypeDefinitionFactory");
        Intrinsics.checkNotNullParameter(existingCodeRegistry, (String)"existingCodeRegistry");
        Intrinsics.checkNotNullParameter(mockProviders, (String)"mockProviders");
        Intrinsics.checkNotNullParameter(dataFetcherResultProcessors, (String)"dataFetcherResultProcessors");
        Intrinsics.checkNotNullParameter(dataFetcherExceptionHandler, (String)"dataFetcherExceptionHandler");
        Intrinsics.checkNotNullParameter((Object)entityFetcherRegistry, (String)"entityFetcherRegistry");
        Intrinsics.checkNotNullParameter(defaultDataFetcherFactory, (String)"defaultDataFetcherFactory");
        Intrinsics.checkNotNullParameter((Object)methodDataFetcherFactory, (String)"methodDataFetcherFactory");
        return new DgsSchemaProvider(applicationContext, federationResolver, existingTypeDefinitionFactory, CollectionsKt.toSet((Iterable)((Iterable)mockProviders)), this.configProps.getSchemaLocations(), dataFetcherResultProcessors, dataFetcherExceptionHandler, entityFetcherRegistry, defaultDataFetcherFactory, methodDataFetcherFactory, null, 1024, null);
    }

    public static /* synthetic */ DgsSchemaProvider dgsSchemaProvider$default(DgsAutoConfiguration dgsAutoConfiguration, ApplicationContext applicationContext, Optional optional, Optional optional2, Optional optional3, ObjectProvider objectProvider, List list, Optional optional4, EntityFetcherRegistry entityFetcherRegistry, Optional optional5, MethodDataFetcherFactory methodDataFetcherFactory, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: dgsSchemaProvider");
        }
        if ((n & 0x40) != 0) {
            Optional<DataFetcherExceptionHandler> optional6 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional6, (String)"empty()");
            optional4 = optional6;
        }
        if ((n & 0x100) != 0) {
            Optional<DataFetcherFactory<?>> optional7 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional7, (String)"empty()");
            optional5 = optional7;
        }
        return dgsAutoConfiguration.dgsSchemaProvider(applicationContext, optional, optional2, optional3, (ObjectProvider<MockProvider>)objectProvider, list, optional4, entityFetcherRegistry, optional5, methodDataFetcherFactory);
    }

    @Bean
    @NotNull
    public EntityFetcherRegistry entityFetcherRegistry() {
        return new EntityFetcherRegistry();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DataFetcherExceptionHandler dataFetcherExceptionHandler() {
        return (DataFetcherExceptionHandler)new DefaultDataFetcherExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public GraphQLSchema schema(@NotNull DgsSchemaProvider dgsSchemaProvider, @NotNull GraphqlFieldVisibility fieldVisibility) {
        Intrinsics.checkNotNullParameter((Object)dgsSchemaProvider, (String)"dgsSchemaProvider");
        Intrinsics.checkNotNullParameter((Object)fieldVisibility, (String)"fieldVisibility");
        return dgsSchemaProvider.schema(null, fieldVisibility);
    }

    @Bean
    @ConditionalOnProperty(prefix="dgs.graphql.introspection", name={"enabled"}, havingValue="false", matchIfMissing=false)
    @NotNull
    public GraphqlFieldVisibility noIntrospectionFieldVisibility() {
        NoIntrospectionGraphqlFieldVisibility noIntrospectionGraphqlFieldVisibility = NoIntrospectionGraphqlFieldVisibility.NO_INTROSPECTION_FIELD_VISIBILITY;
        Intrinsics.checkNotNullExpressionValue((Object)noIntrospectionGraphqlFieldVisibility, (String)"NO_INTROSPECTION_FIELD_VISIBILITY");
        return (GraphqlFieldVisibility)noIntrospectionGraphqlFieldVisibility;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public GraphqlFieldVisibility defaultFieldVisibility() {
        DefaultGraphqlFieldVisibility defaultGraphqlFieldVisibility = DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY;
        Intrinsics.checkNotNullExpressionValue((Object)defaultGraphqlFieldVisibility, (String)"DEFAULT_FIELD_VISIBILITY");
        return (GraphqlFieldVisibility)defaultGraphqlFieldVisibility;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DefaultDgsGraphQLContextBuilder graphQLContextBuilder(@NotNull Optional<DgsCustomContextBuilder<?>> dgsCustomContextBuilder, @NotNull Optional<DgsCustomContextBuilderWithRequest<?>> dgsCustomContextBuilderWithRequest) {
        Intrinsics.checkNotNullParameter(dgsCustomContextBuilder, (String)"dgsCustomContextBuilder");
        Intrinsics.checkNotNullParameter(dgsCustomContextBuilderWithRequest, (String)"dgsCustomContextBuilderWithRequest");
        return new DefaultDgsGraphQLContextBuilder(dgsCustomContextBuilder, dgsCustomContextBuilderWithRequest);
    }

    @Bean
    @NotNull
    public UploadScalar uploadScalar() {
        return new UploadScalar();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"reactor.core.publisher.Mono"})
    @NotNull
    public MonoDataFetcherResultProcessor monoReactiveDataFetcherResultProcessor() {
        return new MonoDataFetcherResultProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"kotlinx.coroutines.flow.Flow"})
    @NotNull
    public FlowDataFetcherResultProcessor flowReactiveDataFetcherResultProcessor() {
        return new FlowDataFetcherResultProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"reactor.core.publisher.Flux"})
    @NotNull
    public FluxDataFetcherResultProcessor fluxReactiveDataFetcherResultProcessor() {
        return new FluxDataFetcherResultProcessor();
    }

    @Bean
    @NotNull
    public MethodDataFetcherFactory methodDataFetcherFactory(@NotNull ObjectProvider<ArgumentResolver> argumentResolvers) {
        Intrinsics.checkNotNullParameter(argumentResolvers, (String)"argumentResolvers");
        List list = argumentResolvers.orderedStream().toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"argumentResolvers.orderedStream().toList()");
        return new MethodDataFetcherFactory(list, null, 2, null);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.mock.web.MockHttpServletRequest"})
    @NotNull
    public DgsQueryExecutorRequestCustomizer mockRequestHeaderCustomizer() {
        return new DgsQueryExecutorRequestCustomizer(){

            @Nullable
            public WebRequest apply(@Nullable WebRequest request, @Nullable HttpHeaders headers) {
                Map map = (Map)headers;
                if (map == null || map.isEmpty() || !(request instanceof NativeWebRequest)) {
                    return request;
                }
                Object object = ((NativeWebRequest)request).getNativeRequest();
                MockHttpServletRequest mockHttpServletRequest = object instanceof MockHttpServletRequest ? (MockHttpServletRequest)object : null;
                if (mockHttpServletRequest == null) {
                    return request;
                }
                MockHttpServletRequest mockRequest = mockHttpServletRequest;
                headers.forEach((arg_0, arg_1) -> mockRequestHeaderCustomizer.1.apply$lambda$0((Function2)new Function2<String, List<String>, Unit>(mockRequest){
                    final /* synthetic */ MockHttpServletRequest $mockRequest;
                    {
                        this.$mockRequest = $mockRequest;
                        super(2);
                    }

                    public final void invoke(String key, List<String> value) {
                        if (this.$mockRequest.getHeader(key) == null) {
                            this.$mockRequest.addHeader(key, value);
                        }
                    }
                }, arg_0, arg_1));
                return request;
            }

            @NotNull
            public String toString() {
                return "{MockRequestHeaderCustomizer}";
            }

            private static final void apply$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0, p1);
            }
        };
    }

    private static final DgsQueryExecutorRequestCustomizer dgsQueryExecutor$lambda$0(KProperty0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DgsQueryExecutorRequestCustomizer)((Function0)$tmp0).invoke();
    }

    private static final String defaultQueryValueCustomizer$lambda$1(String a) {
        return a;
    }

    private static final boolean defaultReloadSchemaIndicator$lambda$2(Boolean $hotReloadSetting) {
        Intrinsics.checkNotNullExpressionValue((Object)$hotReloadSetting, (String)"hotReloadSetting");
        return $hotReloadSetting;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/autoconfig/DgsAutoConfiguration$Companion;", "", "()V", "AUTO_CONF_PREFIX", "", "graphql-dgs-spring-boot-oss-autoconfigure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

