/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.apq;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.netflix.graphql.dgs.apq.AutomatedPersistedQueryCaffeineCache;
import com.netflix.graphql.dgs.apq.DgsAPQSupportProperties;
import com.netflix.graphql.dgs.internal.QueryValueCustomizer;
import graphql.execution.preparsed.PreparsedDocumentEntry;
import graphql.execution.preparsed.persisted.ApolloPersistedQuerySupport;
import graphql.execution.preparsed.persisted.PersistedQueryCache;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.cache.CaffeineCacheMetrics;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration
@ConditionalOnProperty(prefix="dgs.graphql.apq", name={"enabled"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={DgsAPQSupportProperties.class})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \f2\u00020\u0001:\u0004\t\n\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\r"}, d2={"Lcom/netflix/graphql/dgs/apq/DgsAPQSupportAutoConfiguration;", "", "()V", "apolloAPQQueryValueCustomizer", "Lcom/netflix/graphql/dgs/internal/QueryValueCustomizer;", "apolloPersistedQuerySupport", "Lgraphql/execution/preparsed/persisted/ApolloPersistedQuerySupport;", "persistedQueryCache", "Lgraphql/execution/preparsed/persisted/PersistedQueryCache;", "APQBasicCaffeineCacheConfiguration", "APQCaffeineCacheConfiguration", "APQMicrometerMeteredCaffeineCacheConfiguration", "Companion", "graphql-dgs-spring-boot-oss-autoconfigure"})
public class DgsAPQSupportAutoConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String BEAN_APQ_CAFFEINE_CACHE_NAME = "apqCaffeineCache";

    @Bean
    @ConditionalOnBean(value={PersistedQueryCache.class})
    @NotNull
    public ApolloPersistedQuerySupport apolloPersistedQuerySupport(@NotNull PersistedQueryCache persistedQueryCache) {
        Intrinsics.checkNotNullParameter((Object)persistedQueryCache, (String)"persistedQueryCache");
        return new ApolloPersistedQuerySupport(persistedQueryCache);
    }

    @Bean
    @ConditionalOnBean(value={ApolloPersistedQuerySupport.class})
    @NotNull
    public QueryValueCustomizer apolloAPQQueryValueCustomizer() {
        return DgsAPQSupportAutoConfiguration::apolloAPQQueryValueCustomizer$lambda$0;
    }

    private static final String apolloAPQQueryValueCustomizer$lambda$0(String query) {
        return StringUtils.isBlank((CharSequence)query) ? "PersistedQueryMarker" : query;
    }

    @Configuration
    @ConditionalOnClass(name={"com.github.benmanes.caffeine.cache.Cache"})
    @ConditionalOnProperty(prefix="dgs.graphql.apq.default-cache", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\t"}, d2={"Lcom/netflix/graphql/dgs/apq/DgsAPQSupportAutoConfiguration$APQCaffeineCacheConfiguration;", "", "()V", "apqCaffeineCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lgraphql/execution/preparsed/PreparsedDocumentEntry;", "properties", "Lcom/netflix/graphql/dgs/apq/DgsAPQSupportProperties;", "graphql-dgs-spring-boot-oss-autoconfigure"})
    public static class APQCaffeineCacheConfiguration {
        @Bean(name={"apqCaffeineCache"})
        @ConditionalOnMissingBean(name={"apqCaffeineCache"})
        @NotNull
        public Cache<String, PreparsedDocumentEntry> apqCaffeineCache(@NotNull DgsAPQSupportProperties properties) {
            Cache cache;
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            if (StringUtils.isNotBlank((CharSequence)properties.getDefaultCache().getCaffeineSpec())) {
                Cache cache2 = Caffeine.from((CaffeineSpec)CaffeineSpec.parse((String)properties.getDefaultCache().getCaffeineSpec())).build();
                cache = cache2;
                Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"{\n                Caffei\u2026c)).build()\n            }");
            } else {
                Cache cache3 = Caffeine.newBuilder().maximumSize(1000L).expireAfterAccess(Duration.ofHours(1L)).build();
                cache = cache3;
                Intrinsics.checkNotNullExpressionValue((Object)cache3, (String)"{\n                Caffei\u2026   .build()\n            }");
            }
            return cache;
        }
    }

    @Configuration
    @ConditionalOnClass(name={"io.micrometer.core.instrument.MeterRegistry", "com.github.benmanes.caffeine.cache.Cache"})
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0014\b\u0001\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\nH\u0017\u00a8\u0006\u000b"}, d2={"Lcom/netflix/graphql/dgs/apq/DgsAPQSupportAutoConfiguration$APQMicrometerMeteredCaffeineCacheConfiguration;", "", "()V", "meteredPersistedQueryCache", "Lgraphql/execution/preparsed/persisted/PersistedQueryCache;", "appCaffeine", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lgraphql/execution/preparsed/PreparsedDocumentEntry;", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "graphql-dgs-spring-boot-oss-autoconfigure"})
    public static class APQMicrometerMeteredCaffeineCacheConfiguration {
        @Bean
        @ConditionalOnBean(value={MeterRegistry.class})
        @ConditionalOnMissingBean(value={PersistedQueryCache.class})
        @NotNull
        public PersistedQueryCache meteredPersistedQueryCache(@Qualifier(value="apqCaffeineCache") @NotNull Cache<String, PreparsedDocumentEntry> appCaffeine, @NotNull MeterRegistry meterRegistry) {
            Intrinsics.checkNotNullParameter(appCaffeine, (String)"appCaffeine");
            Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
            Cache cache = CaffeineCacheMetrics.monitor((MeterRegistry)meterRegistry, appCaffeine, (String)DgsAPQSupportAutoConfiguration.BEAN_APQ_CAFFEINE_CACHE_NAME, (String[])new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"monitor(meterRegistry, a\u2026_APQ_CAFFEINE_CACHE_NAME)");
            Cache monitoredCache = cache;
            return new AutomatedPersistedQueryCaffeineCache((Cache<String, PreparsedDocumentEntry>)monitoredCache);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={APQMicrometerMeteredCaffeineCacheConfiguration.class})
    @ConditionalOnClass(name={"com.github.benmanes.caffeine.cache.Cache"})
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0014\b\u0001\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0017\u00a8\u0006\t"}, d2={"Lcom/netflix/graphql/dgs/apq/DgsAPQSupportAutoConfiguration$APQBasicCaffeineCacheConfiguration;", "", "()V", "meteredPersistedQueryCache", "Lgraphql/execution/preparsed/persisted/PersistedQueryCache;", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lgraphql/execution/preparsed/PreparsedDocumentEntry;", "graphql-dgs-spring-boot-oss-autoconfigure"})
    public static class APQBasicCaffeineCacheConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={PersistedQueryCache.class})
        @NotNull
        public PersistedQueryCache meteredPersistedQueryCache(@Qualifier(value="apqCaffeineCache") @NotNull Cache<String, PreparsedDocumentEntry> cache) {
            Intrinsics.checkNotNullParameter(cache, (String)"cache");
            return new AutomatedPersistedQueryCaffeineCache(cache);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/apq/DgsAPQSupportAutoConfiguration$Companion;", "", "()V", "BEAN_APQ_CAFFEINE_CACHE_NAME", "", "graphql-dgs-spring-boot-oss-autoconfigure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

