/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.autoconfig;

import com.netflix.graphql.dgs.DataLoaderInstrumentationExtensionProvider;
import com.netflix.graphql.dgs.DgsDataLoaderCustomizer;
import com.netflix.graphql.dgs.DgsDataLoaderInstrumentation;
import com.netflix.graphql.dgs.DgsDataLoaderOptionsProvider;
import com.netflix.graphql.dgs.DgsDefaultPreparsedDocumentProvider;
import com.netflix.graphql.dgs.DgsFederationResolver;
import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.autoconfig.DgsAutoConfiguration;
import com.netflix.graphql.dgs.autoconfig.DgsConfigurationProperties;
import com.netflix.graphql.dgs.autoconfig.DgsDataloaderConfigurationProperties;
import com.netflix.graphql.dgs.autoconfig.DgsInputArgumentConfiguration;
import com.netflix.graphql.dgs.context.DgsCustomContextBuilder;
import com.netflix.graphql.dgs.context.DgsCustomContextBuilderWithRequest;
import com.netflix.graphql.dgs.context.GraphQLContextContributor;
import com.netflix.graphql.dgs.context.GraphQLContextContributorInstrumentation;
import com.netflix.graphql.dgs.exceptions.DefaultDataFetcherExceptionHandler;
import com.netflix.graphql.dgs.internal.DataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.DefaultDataLoaderOptionsProvider;
import com.netflix.graphql.dgs.internal.DefaultDgsGraphQLContextBuilder;
import com.netflix.graphql.dgs.internal.DefaultDgsQueryExecutor;
import com.netflix.graphql.dgs.internal.DgsDataLoaderInstrumentationDataLoaderCustomizer;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.DgsQueryExecutorRequestCustomizer;
import com.netflix.graphql.dgs.internal.DgsRequestData;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import com.netflix.graphql.dgs.internal.DgsWrapWithContextDataLoaderCustomizer;
import com.netflix.graphql.dgs.internal.EntityFetcherRegistry;
import com.netflix.graphql.dgs.internal.FlowDataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.FluxDataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.GraphQLJavaErrorInstrumentation;
import com.netflix.graphql.dgs.internal.MonoDataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.QueryValueCustomizer;
import com.netflix.graphql.dgs.internal.SchemaProviderResult;
import com.netflix.graphql.dgs.internal.method.ArgumentResolver;
import com.netflix.graphql.dgs.internal.method.MethodDataFetcherFactory;
import com.netflix.graphql.dgs.scalars.UploadScalar;
import com.netflix.graphql.mocking.MockProvider;
import graphql.GraphQLContext;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.AsyncSerialExecutionStrategy;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.DataFetcherFactory;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.visibility.GraphqlFieldVisibility;
import io.micrometer.context.ContextRegistry;
import io.micrometer.context.ContextSnapshotFactory;
import io.micrometer.context.ThreadLocalAccessor;
import io.micrometer.context.integration.Slf4jThreadLocalAccessor;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.reflect.KProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnJava;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.system.JavaVersion;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.task.support.ContextPropagatingTaskDecorator;
import org.springframework.http.HttpHeaders;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;

@AutoConfiguration(afterName={"org.springframework.boot.autoconfigure.task.TaskSchedulingAutoConfiguration"})
@EnableConfigurationProperties(value={DgsConfigurationProperties.class, DgsDataloaderConfigurationProperties.class})
@ImportAutoConfiguration(classes={JacksonAutoConfiguration.class, DgsInputArgumentConfiguration.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 d2\u00020\u0001:\u0001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0017J\b\u0010\u0014\u001a\u00020\u0015H\u0017J>\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0012H\u0017J\u00a8\u0001\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010\r\u001a\u00020\u000e2\u000e\b\u0001\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u000e\b\u0001\u0010.\u001a\b\u0012\u0004\u0012\u00020-0,2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000,2\u0006\u00101\u001a\u00020\f2\f\u00102\u001a\b\u0012\u0004\u0012\u0002030)2\u0006\u00104\u001a\u00020\n2\f\u00105\u001a\b\u0012\u0004\u0012\u0002060)H\u0017J\b\u0010\u001b\u001a\u00020\u001cH\u0017J\u008a\u0001\u00107\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u00192\f\u00108\u001a\b\u0012\u0004\u0012\u0002090,2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020;0,2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=0,2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020?0)2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A0\u00122\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0,2\u0006\u0010B\u001a\u00020C2\u0012\b\u0002\u0010D\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030E0,2\u0006\u0010F\u001a\u00020GH\u0017J\b\u0010H\u001a\u00020IH\u0017J\b\u0010J\u001a\u00020KH\u0017J\b\u0010B\u001a\u00020CH\u0017J\b\u0010L\u001a\u00020MH\u0017J\b\u0010N\u001a\u00020OH\u0017J,\u0010P\u001a\u00020(2\u0010\u0010Q\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030R0,2\u0010\u0010S\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030T0,H\u0017J\u0016\u0010U\u001a\u00020*2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020K0)H\u0017J\b\u0010W\u001a\u00020*H\u0017J&\u0010F\u001a\u00020G2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020Y0)2\u000e\b\u0001\u0010Z\u001a\b\u0012\u0004\u0012\u00020[0,H\u0017J\b\u0010\\\u001a\u000206H\u0017J\b\u0010]\u001a\u00020^H\u0017J\u0010\u00102\u001a\u0002032\u0006\u0010\u0002\u001a\u00020\u0003H\u0017J\u001a\u0010#\u001a\u00020$2\u0006\u00107\u001a\u00020&2\b\u0010_\u001a\u0004\u0018\u00010`H\u0017J\b\u0010a\u001a\u00020bH\u0017J\b\u0010c\u001a\u00020[H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lcom/netflix/graphql/dgs/autoconfig/DgsAutoConfiguration;", "", "configProps", "Lcom/netflix/graphql/dgs/autoconfig/DgsConfigurationProperties;", "dataloaderConfigProps", "Lcom/netflix/graphql/dgs/autoconfig/DgsDataloaderConfigurationProperties;", "(Lcom/netflix/graphql/dgs/autoconfig/DgsConfigurationProperties;Lcom/netflix/graphql/dgs/autoconfig/DgsDataloaderConfigurationProperties;)V", "dataFetcherExceptionHandler", "Lgraphql/execution/DataFetcherExceptionHandler;", "defaultQueryValueCustomizer", "Lcom/netflix/graphql/dgs/internal/QueryValueCustomizer;", "defaultReloadSchemaIndicator", "Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor$ReloadSchemaIndicator;", "environment", "Lorg/springframework/core/env/Environment;", "dgsDataLoaderInstrumentationDataLoaderCustomizer", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderInstrumentationDataLoaderCustomizer;", "instrumentations", "", "Lcom/netflix/graphql/dgs/DgsDataLoaderInstrumentation;", "dgsDataLoaderOptionsProvider", "Lcom/netflix/graphql/dgs/DgsDataLoaderOptionsProvider;", "dgsDataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "dataloaderOptionProvider", "dgsScheduledExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "extensionProviders", "Lcom/netflix/graphql/dgs/DataLoaderInstrumentationExtensionProvider;", "customizers", "Lcom/netflix/graphql/dgs/DgsDataLoaderCustomizer;", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "schema", "Lgraphql/schema/GraphQLSchema;", "schemaProvider", "Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "dgsContextBuilder", "Lcom/netflix/graphql/dgs/internal/DefaultDgsGraphQLContextBuilder;", "Lorg/springframework/beans/factory/ObjectProvider;", "Lgraphql/execution/instrumentation/Instrumentation;", "providedQueryExecutionStrategy", "Ljava/util/Optional;", "Lgraphql/execution/ExecutionStrategy;", "providedMutationExecutionStrategy", "idProvider", "Lgraphql/execution/ExecutionIdProvider;", "reloadSchemaIndicator", "preparsedDocumentProvider", "Lgraphql/execution/preparsed/PreparsedDocumentProvider;", "queryValueCustomizer", "requestCustomizer", "Lcom/netflix/graphql/dgs/internal/DgsQueryExecutorRequestCustomizer;", "dgsSchemaProvider", "federationResolver", "Lcom/netflix/graphql/dgs/DgsFederationResolver;", "existingTypeDefinitionFactory", "Lgraphql/schema/idl/TypeDefinitionRegistry;", "existingCodeRegistry", "Lgraphql/schema/GraphQLCodeRegistry;", "mockProviders", "Lcom/netflix/graphql/mocking/MockProvider;", "dataFetcherResultProcessors", "Lcom/netflix/graphql/dgs/internal/DataFetcherResultProcessor;", "entityFetcherRegistry", "Lcom/netflix/graphql/dgs/internal/EntityFetcherRegistry;", "defaultDataFetcherFactory", "Lgraphql/schema/DataFetcherFactory;", "methodDataFetcherFactory", "Lcom/netflix/graphql/dgs/internal/method/MethodDataFetcherFactory;", "dgsWrapWithContextDataLoaderCustomizer", "Lcom/netflix/graphql/dgs/internal/DgsWrapWithContextDataLoaderCustomizer;", "disableIntrospectionContextContributor", "Lcom/netflix/graphql/dgs/context/GraphQLContextContributor;", "flowReactiveDataFetcherResultProcessor", "Lcom/netflix/graphql/dgs/internal/FlowDataFetcherResultProcessor;", "fluxReactiveDataFetcherResultProcessor", "Lcom/netflix/graphql/dgs/internal/FluxDataFetcherResultProcessor;", "graphQLContextBuilder", "dgsCustomContextBuilder", "Lcom/netflix/graphql/dgs/context/DgsCustomContextBuilder;", "dgsCustomContextBuilderWithRequest", "Lcom/netflix/graphql/dgs/context/DgsCustomContextBuilderWithRequest;", "graphQLContextContributionInstrumentation", "graphQLContextContributors", "graphqlJavaErrorInstrumentation", "argumentResolvers", "Lcom/netflix/graphql/dgs/internal/method/ArgumentResolver;", "taskExecutorOptional", "Lorg/springframework/core/task/AsyncTaskExecutor;", "mockRequestHeaderCustomizer", "monoReactiveDataFetcherResultProcessor", "Lcom/netflix/graphql/dgs/internal/MonoDataFetcherResultProcessor;", "fieldVisibility", "Lgraphql/schema/visibility/GraphqlFieldVisibility;", "uploadScalar", "Lcom/netflix/graphql/dgs/scalars/UploadScalar;", "virtualThreadsTaskExecutor", "Companion", "graphql-dgs-spring-boot-oss-autoconfigure"})
public class DgsAutoConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsConfigurationProperties configProps;
    @NotNull
    private final DgsDataloaderConfigurationProperties dataloaderConfigProps;
    @NotNull
    public static final String AUTO_CONF_PREFIX = "dgs.graphql";
    @NotNull
    private static final Logger LOG;

    public DgsAutoConfiguration(@NotNull DgsConfigurationProperties configProps, @NotNull DgsDataloaderConfigurationProperties dataloaderConfigProps) {
        Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
        Intrinsics.checkNotNullParameter((Object)dataloaderConfigProps, (String)"dataloaderConfigProps");
        this.configProps = configProps;
        this.dataloaderConfigProps = dataloaderConfigProps;
    }

    @Bean
    @Order(value=-2147483648)
    @NotNull
    public Instrumentation graphQLContextContributionInstrumentation(@NotNull ObjectProvider<GraphQLContextContributor> graphQLContextContributors) {
        Intrinsics.checkNotNullParameter(graphQLContextContributors, (String)"graphQLContextContributors");
        List list = graphQLContextContributors.orderedStream().toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return (Instrumentation)new GraphQLContextContributorInstrumentation(list);
    }

    @Bean
    @NotNull
    public Instrumentation graphqlJavaErrorInstrumentation() {
        return (Instrumentation)new GraphQLJavaErrorInstrumentation();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DgsQueryExecutor dgsQueryExecutor(@NotNull ApplicationContext applicationContext, @NotNull GraphQLSchema schema, @NotNull DgsSchemaProvider schemaProvider, @NotNull DgsDataLoaderProvider dgsDataLoaderProvider, @NotNull DefaultDgsGraphQLContextBuilder dgsContextBuilder, @NotNull DataFetcherExceptionHandler dataFetcherExceptionHandler, @NotNull ObjectProvider<Instrumentation> instrumentations, @NotNull Environment environment, @Qualifier(value="query") @NotNull Optional<ExecutionStrategy> providedQueryExecutionStrategy, @Qualifier(value="mutation") @NotNull Optional<ExecutionStrategy> providedMutationExecutionStrategy, @NotNull Optional<ExecutionIdProvider> idProvider, @NotNull DefaultDgsQueryExecutor.ReloadSchemaIndicator reloadSchemaIndicator, @NotNull ObjectProvider<PreparsedDocumentProvider> preparsedDocumentProvider, @NotNull QueryValueCustomizer queryValueCustomizer, @NotNull ObjectProvider<DgsQueryExecutorRequestCustomizer> requestCustomizer) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)schemaProvider, (String)"schemaProvider");
        Intrinsics.checkNotNullParameter((Object)dgsDataLoaderProvider, (String)"dgsDataLoaderProvider");
        Intrinsics.checkNotNullParameter((Object)dgsContextBuilder, (String)"dgsContextBuilder");
        Intrinsics.checkNotNullParameter((Object)dataFetcherExceptionHandler, (String)"dataFetcherExceptionHandler");
        Intrinsics.checkNotNullParameter(instrumentations, (String)"instrumentations");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(providedQueryExecutionStrategy, (String)"providedQueryExecutionStrategy");
        Intrinsics.checkNotNullParameter(providedMutationExecutionStrategy, (String)"providedMutationExecutionStrategy");
        Intrinsics.checkNotNullParameter(idProvider, (String)"idProvider");
        Intrinsics.checkNotNullParameter((Object)reloadSchemaIndicator, (String)"reloadSchemaIndicator");
        Intrinsics.checkNotNullParameter(preparsedDocumentProvider, (String)"preparsedDocumentProvider");
        Intrinsics.checkNotNullParameter((Object)queryValueCustomizer, (String)"queryValueCustomizer");
        Intrinsics.checkNotNullParameter(requestCustomizer, (String)"requestCustomizer");
        ExecutionStrategy queryExecutionStrategy = providedQueryExecutionStrategy.orElse((ExecutionStrategy)new AsyncExecutionStrategy(dataFetcherExceptionHandler));
        ExecutionStrategy mutationExecutionStrategy = providedMutationExecutionStrategy.orElse((ExecutionStrategy)new AsyncSerialExecutionStrategy(dataFetcherExceptionHandler));
        List instrumentationImpls = instrumentations.orderedStream().toList();
        if (instrumentationImpls.size() == 1) {
            Intrinsics.checkNotNull(instrumentationImpls);
            object = (Instrumentation)CollectionsKt.single(instrumentationImpls);
        } else {
            Intrinsics.checkNotNull(instrumentationImpls);
            object = !((Collection)instrumentationImpls).isEmpty() ? (Instrumentation)new ChainedInstrumentation(instrumentationImpls) : null;
        }
        Instrumentation instrumentation = object;
        Intrinsics.checkNotNull((Object)queryExecutionStrategy);
        Intrinsics.checkNotNull((Object)mutationExecutionStrategy);
        PreparsedDocumentProvider preparsedDocumentProvider2 = (PreparsedDocumentProvider)preparsedDocumentProvider.getIfAvailable();
        Object object2 = requestCustomizer.getIfAvailable(() -> DgsAutoConfiguration.dgsQueryExecutor$lambda$0((KProperty0)new PropertyReference0Impl(DgsQueryExecutorRequestCustomizer.Companion){

            @Nullable
            public Object get() {
                return ((DgsQueryExecutorRequestCustomizer.Companion)this.receiver).getDEFAULT_REQUEST_CUSTOMIZER();
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getIfAvailable(...)");
        return (DgsQueryExecutor)new DefaultDgsQueryExecutor(schema, schemaProvider, dgsDataLoaderProvider, dgsContextBuilder, instrumentation, queryExecutionStrategy, mutationExecutionStrategy, idProvider, reloadSchemaIndicator, preparsedDocumentProvider2, queryValueCustomizer, (DgsQueryExecutorRequestCustomizer)object2);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public QueryValueCustomizer defaultQueryValueCustomizer() {
        return DgsAutoConfiguration::defaultQueryValueCustomizer$lambda$1;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DgsDataLoaderOptionsProvider dgsDataLoaderOptionsProvider() {
        return (DgsDataLoaderOptionsProvider)new DefaultDataLoaderOptionsProvider();
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean(name={"dgsScheduledExecutorService"})
    @Qualifier(value="dgsScheduledExecutorService")
    @NotNull
    public ScheduledExecutorService dgsScheduledExecutorService() {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor(...)");
        return scheduledExecutorService;
    }

    @Bean
    @ConditionalOnProperty(prefix="dgs.graphql.convertAllDataLoadersToWithContext", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @Order(value=0)
    @NotNull
    public DgsWrapWithContextDataLoaderCustomizer dgsWrapWithContextDataLoaderCustomizer() {
        return new DgsWrapWithContextDataLoaderCustomizer();
    }

    @Bean
    @Order(value=100)
    @NotNull
    public DgsDataLoaderInstrumentationDataLoaderCustomizer dgsDataLoaderInstrumentationDataLoaderCustomizer(@NotNull List<? extends DgsDataLoaderInstrumentation> instrumentations) {
        Intrinsics.checkNotNullParameter(instrumentations, (String)"instrumentations");
        return new DgsDataLoaderInstrumentationDataLoaderCustomizer(instrumentations);
    }

    @Bean
    @NotNull
    public DgsDataLoaderProvider dgsDataLoaderProvider(@NotNull ApplicationContext applicationContext, @NotNull DgsDataLoaderOptionsProvider dataloaderOptionProvider, @Qualifier(value="dgsScheduledExecutorService") @NotNull ScheduledExecutorService dgsScheduledExecutorService, @NotNull List<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders, @NotNull List<? extends DgsDataLoaderCustomizer> customizers) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)dataloaderOptionProvider, (String)"dataloaderOptionProvider");
        Intrinsics.checkNotNullParameter((Object)dgsScheduledExecutorService, (String)"dgsScheduledExecutorService");
        Intrinsics.checkNotNullParameter(extensionProviders, (String)"extensionProviders");
        Intrinsics.checkNotNullParameter(customizers, (String)"customizers");
        Duration duration = this.dataloaderConfigProps.getScheduleDuration();
        boolean bl = this.dataloaderConfigProps.getTickerModeEnabled();
        return new DgsDataLoaderProvider(applicationContext, extensionProviders, customizers, dataloaderOptionProvider, dgsScheduledExecutorService, duration, bl);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DefaultDgsQueryExecutor.ReloadSchemaIndicator defaultReloadSchemaIndicator(@NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        String[] stringArray = environment.getActiveProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getActiveProfiles(...)");
        boolean isLaptopProfile = ArraysKt.contains((Object[])stringArray, (Object)"laptop");
        Boolean hotReloadSetting = (Boolean)environment.getProperty("dgs.reload", Boolean.TYPE, (Object)isLaptopProfile);
        return () -> DgsAutoConfiguration.defaultReloadSchemaIndicator$lambda$2(hotReloadSetting);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DgsSchemaProvider dgsSchemaProvider(@NotNull ApplicationContext applicationContext, @NotNull Optional<DgsFederationResolver> federationResolver, @NotNull Optional<TypeDefinitionRegistry> existingTypeDefinitionFactory, @NotNull Optional<GraphQLCodeRegistry> existingCodeRegistry, @NotNull ObjectProvider<MockProvider> mockProviders, @NotNull List<? extends DataFetcherResultProcessor> dataFetcherResultProcessors, @NotNull Optional<DataFetcherExceptionHandler> dataFetcherExceptionHandler, @NotNull EntityFetcherRegistry entityFetcherRegistry, @NotNull Optional<DataFetcherFactory<?>> defaultDataFetcherFactory, @NotNull MethodDataFetcherFactory methodDataFetcherFactory) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter(federationResolver, (String)"federationResolver");
        Intrinsics.checkNotNullParameter(existingTypeDefinitionFactory, (String)"existingTypeDefinitionFactory");
        Intrinsics.checkNotNullParameter(existingCodeRegistry, (String)"existingCodeRegistry");
        Intrinsics.checkNotNullParameter(mockProviders, (String)"mockProviders");
        Intrinsics.checkNotNullParameter(dataFetcherResultProcessors, (String)"dataFetcherResultProcessors");
        Intrinsics.checkNotNullParameter(dataFetcherExceptionHandler, (String)"dataFetcherExceptionHandler");
        Intrinsics.checkNotNullParameter((Object)entityFetcherRegistry, (String)"entityFetcherRegistry");
        Intrinsics.checkNotNullParameter(defaultDataFetcherFactory, (String)"defaultDataFetcherFactory");
        Intrinsics.checkNotNullParameter((Object)methodDataFetcherFactory, (String)"methodDataFetcherFactory");
        return new DgsSchemaProvider(applicationContext, federationResolver, existingTypeDefinitionFactory, CollectionsKt.toSet((Iterable)((Iterable)mockProviders)), this.configProps.getSchemaLocations(), dataFetcherResultProcessors, dataFetcherExceptionHandler, entityFetcherRegistry, defaultDataFetcherFactory, methodDataFetcherFactory, null, this.configProps.getSchemaWiringValidationEnabled(), this.configProps.getEnableEntityFetcherCustomScalarParsing(), 1024, null);
    }

    public static /* synthetic */ DgsSchemaProvider dgsSchemaProvider$default(DgsAutoConfiguration dgsAutoConfiguration, ApplicationContext applicationContext, Optional optional, Optional optional2, Optional optional3, ObjectProvider objectProvider, List list, Optional optional4, EntityFetcherRegistry entityFetcherRegistry, Optional optional5, MethodDataFetcherFactory methodDataFetcherFactory, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: dgsSchemaProvider");
        }
        if ((n & 0x40) != 0) {
            Optional<DataFetcherExceptionHandler> optional6 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional6, (String)"empty(...)");
            optional4 = optional6;
        }
        if ((n & 0x100) != 0) {
            Optional<DataFetcherFactory<?>> optional7 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional7, (String)"empty(...)");
            optional5 = optional7;
        }
        return dgsAutoConfiguration.dgsSchemaProvider(applicationContext, optional, optional2, optional3, (ObjectProvider<MockProvider>)objectProvider, list, optional4, entityFetcherRegistry, optional5, methodDataFetcherFactory);
    }

    @Bean
    @NotNull
    public EntityFetcherRegistry entityFetcherRegistry() {
        return new EntityFetcherRegistry();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DataFetcherExceptionHandler dataFetcherExceptionHandler() {
        return (DataFetcherExceptionHandler)new DefaultDataFetcherExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public GraphQLSchema schema(@NotNull DgsSchemaProvider dgsSchemaProvider, @Nullable GraphqlFieldVisibility fieldVisibility) {
        Intrinsics.checkNotNullParameter((Object)dgsSchemaProvider, (String)"dgsSchemaProvider");
        SchemaProviderResult result = fieldVisibility == null ? DgsSchemaProvider.schema$default((DgsSchemaProvider)dgsSchemaProvider, null, null, null, (boolean)false, (int)14, null) : DgsSchemaProvider.schema$default((DgsSchemaProvider)dgsSchemaProvider, null, (GraphqlFieldVisibility)fieldVisibility, null, (boolean)false, (int)12, null);
        return result.getGraphQLSchema();
    }

    @Bean
    @ConditionalOnProperty(prefix="dgs.graphql.preparsedDocumentProvider", name={"enabled"}, havingValue="true", matchIfMissing=false)
    @ConditionalOnMissingBean
    @NotNull
    public PreparsedDocumentProvider preparsedDocumentProvider(@NotNull DgsConfigurationProperties configProps) {
        Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
        long l = configProps.getPreparsedDocumentProvider().getMaximumCacheSize();
        Duration duration = Duration.parse(configProps.getPreparsedDocumentProvider().getCacheValidityDuration());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"parse(...)");
        return (PreparsedDocumentProvider)new DgsDefaultPreparsedDocumentProvider(l, duration);
    }

    @Bean
    @ConditionalOnProperty(prefix="dgs.graphql.introspection", name={"enabled"}, havingValue="false", matchIfMissing=false)
    @NotNull
    public GraphQLContextContributor disableIntrospectionContextContributor() {
        return DgsAutoConfiguration::disableIntrospectionContextContributor$lambda$3;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DefaultDgsGraphQLContextBuilder graphQLContextBuilder(@NotNull Optional<DgsCustomContextBuilder<?>> dgsCustomContextBuilder, @NotNull Optional<DgsCustomContextBuilderWithRequest<?>> dgsCustomContextBuilderWithRequest) {
        Intrinsics.checkNotNullParameter(dgsCustomContextBuilder, (String)"dgsCustomContextBuilder");
        Intrinsics.checkNotNullParameter(dgsCustomContextBuilderWithRequest, (String)"dgsCustomContextBuilderWithRequest");
        return new DefaultDgsGraphQLContextBuilder(dgsCustomContextBuilder, dgsCustomContextBuilderWithRequest);
    }

    @Bean
    @ConditionalOnMissingClass(value={"com.netflix.graphql.dgs.springgraphql.autoconfig.DgsSpringGraphQLAutoConfiguration"})
    @NotNull
    public UploadScalar uploadScalar() {
        return new UploadScalar();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"reactor.core.publisher.Mono"})
    @NotNull
    public MonoDataFetcherResultProcessor monoReactiveDataFetcherResultProcessor() {
        return new MonoDataFetcherResultProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"kotlinx.coroutines.flow.Flow"})
    @NotNull
    public FlowDataFetcherResultProcessor flowReactiveDataFetcherResultProcessor() {
        return new FlowDataFetcherResultProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"reactor.core.publisher.Flux"})
    @NotNull
    public FluxDataFetcherResultProcessor fluxReactiveDataFetcherResultProcessor() {
        return new FluxDataFetcherResultProcessor();
    }

    @Bean
    @Qualifier(value="dgsAsyncTaskExecutor")
    @ConditionalOnJava(value=JavaVersion.TWENTY_ONE)
    @ConditionalOnMissingBean(name={"dgsAsyncTaskExecutor"})
    @ConditionalOnProperty(name={"dgs.graphql.virtualthreads.enabled"}, havingValue="true", matchIfMissing=false)
    @NotNull
    public AsyncTaskExecutor virtualThreadsTaskExecutor() {
        LOG.info("Enabling virtual threads for DGS");
        ContextRegistry contextRegistry = new ContextRegistry().loadContextAccessors().loadThreadLocalAccessors().registerThreadLocalAccessor((ThreadLocalAccessor)new Slf4jThreadLocalAccessor(new String[0]));
        SimpleAsyncTaskExecutor executor = new SimpleAsyncTaskExecutor("dgs-virtual-thread-");
        executor.setVirtualThreads(true);
        executor.setTaskDecorator((TaskDecorator)new ContextPropagatingTaskDecorator(ContextSnapshotFactory.builder().contextRegistry(contextRegistry).build()));
        return (AsyncTaskExecutor)executor;
    }

    @Bean
    @NotNull
    public MethodDataFetcherFactory methodDataFetcherFactory(@NotNull ObjectProvider<ArgumentResolver> argumentResolvers, @Qualifier(value="dgsAsyncTaskExecutor") @NotNull Optional<AsyncTaskExecutor> taskExecutorOptional) {
        Intrinsics.checkNotNullParameter(argumentResolvers, (String)"argumentResolvers");
        Intrinsics.checkNotNullParameter(taskExecutorOptional, (String)"taskExecutorOptional");
        AsyncTaskExecutor taskExecutor = taskExecutorOptional.isPresent() ? taskExecutorOptional.get() : null;
        List list = argumentResolvers.orderedStream().toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return new MethodDataFetcherFactory(list, (ParameterNameDiscoverer)new DefaultParameterNameDiscoverer(), taskExecutor);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.mock.web.MockHttpServletRequest"})
    @NotNull
    public DgsQueryExecutorRequestCustomizer mockRequestHeaderCustomizer() {
        return new DgsQueryExecutorRequestCustomizer(){

            @Nullable
            public WebRequest apply(@Nullable WebRequest request, @Nullable HttpHeaders headers) {
                Map map = (Map)headers;
                if (map == null || map.isEmpty() || !(request instanceof NativeWebRequest)) {
                    return request;
                }
                Object object = ((NativeWebRequest)request).getNativeRequest();
                MockHttpServletRequest mockHttpServletRequest = object instanceof MockHttpServletRequest ? (MockHttpServletRequest)object : null;
                if (mockHttpServletRequest == null) {
                    return request;
                }
                MockHttpServletRequest mockRequest = mockHttpServletRequest;
                headers.forEach((arg_0, arg_1) -> mockRequestHeaderCustomizer.1.apply$lambda$0((Function2)new Function2<String, List<String>, Unit>(mockRequest){
                    final /* synthetic */ MockHttpServletRequest $mockRequest;
                    {
                        this.$mockRequest = $mockRequest;
                        super(2);
                    }

                    public final void invoke(String key, List<String> value) {
                        if (this.$mockRequest.getHeader(key) == null) {
                            this.$mockRequest.addHeader(key, value);
                        }
                    }
                }, arg_0, arg_1));
                return request;
            }

            @NotNull
            public String toString() {
                return "{MockRequestHeaderCustomizer}";
            }

            private static final void apply$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0, p1);
            }
        };
    }

    private static final DgsQueryExecutorRequestCustomizer dgsQueryExecutor$lambda$0(KProperty0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DgsQueryExecutorRequestCustomizer)((Function0)$tmp0).invoke();
    }

    private static final String defaultQueryValueCustomizer$lambda$1(String a) {
        return a;
    }

    private static final boolean defaultReloadSchemaIndicator$lambda$2(Boolean $hotReloadSetting) {
        Intrinsics.checkNotNull((Object)$hotReloadSetting);
        return $hotReloadSetting;
    }

    private static final void disableIntrospectionContextContributor$lambda$3(GraphQLContext.Builder builder, Map map, DgsRequestData dgsRequestData) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.put((Object)"INTROSPECTION_DISABLED", (Object)true);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DgsAutoConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/netflix/graphql/dgs/autoconfig/DgsAutoConfiguration$Companion;", "", "()V", "AUTO_CONF_PREFIX", "", "LOG", "Lorg/slf4j/Logger;", "graphql-dgs-spring-boot-oss-autoconfigure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

