/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.springgraphql.autoconfig;

import com.netflix.graphql.dgs.DataLoaderInstrumentationExtensionProvider;
import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsDataLoaderCustomizer;
import com.netflix.graphql.dgs.DgsDataLoaderInstrumentation;
import com.netflix.graphql.dgs.DgsDataLoaderOptionsProvider;
import com.netflix.graphql.dgs.DgsDefaultPreparsedDocumentProvider;
import com.netflix.graphql.dgs.DgsFederationResolver;
import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.DgsRuntimeWiring;
import com.netflix.graphql.dgs.DgsTypeDefinitionRegistry;
import com.netflix.graphql.dgs.ReloadSchemaIndicator;
import com.netflix.graphql.dgs.autoconfig.DgsConfigurationProperties;
import com.netflix.graphql.dgs.autoconfig.DgsDataloaderConfigurationProperties;
import com.netflix.graphql.dgs.autoconfig.DgsInputArgumentConfiguration;
import com.netflix.graphql.dgs.context.DgsCustomContextBuilder;
import com.netflix.graphql.dgs.context.DgsCustomContextBuilderWithRequest;
import com.netflix.graphql.dgs.context.GraphQLContextContributor;
import com.netflix.graphql.dgs.context.GraphQLContextContributorInstrumentation;
import com.netflix.graphql.dgs.exceptions.DefaultDataFetcherExceptionHandler;
import com.netflix.graphql.dgs.internal.DataFetcherReference;
import com.netflix.graphql.dgs.internal.DataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.DefaultDataLoaderOptionsProvider;
import com.netflix.graphql.dgs.internal.DefaultDgsGraphQLContextBuilder;
import com.netflix.graphql.dgs.internal.DgsDataLoaderInstrumentationDataLoaderCustomizer;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.DgsQueryExecutorRequestCustomizer;
import com.netflix.graphql.dgs.internal.DgsRequestData;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import com.netflix.graphql.dgs.internal.DgsWrapWithContextDataLoaderCustomizer;
import com.netflix.graphql.dgs.internal.EntityFetcherRegistry;
import com.netflix.graphql.dgs.internal.FlowDataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.FluxDataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.GraphQLJavaErrorInstrumentation;
import com.netflix.graphql.dgs.internal.MonoDataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.QueryValueCustomizer;
import com.netflix.graphql.dgs.internal.method.ArgumentResolver;
import com.netflix.graphql.dgs.internal.method.MethodDataFetcherFactory;
import com.netflix.graphql.dgs.mvc.internal.method.HandlerMethodArgumentResolverAdapter;
import com.netflix.graphql.dgs.reactive.DgsReactiveCustomContextBuilderWithRequest;
import com.netflix.graphql.dgs.reactive.DgsReactiveQueryExecutor;
import com.netflix.graphql.dgs.reactive.internal.DefaultDgsReactiveGraphQLContextBuilder;
import com.netflix.graphql.dgs.reactive.internal.method.SyncHandlerMethodArgumentResolverAdapter;
import com.netflix.graphql.dgs.springgraphql.DgsGraphQLSourceBuilder;
import com.netflix.graphql.dgs.springgraphql.ReloadableGraphQLSource;
import com.netflix.graphql.dgs.springgraphql.SpringGraphQLDgsQueryExecutor;
import com.netflix.graphql.dgs.springgraphql.SpringGraphQLDgsReactiveQueryExecutor;
import com.netflix.graphql.dgs.springgraphql.autoconfig.DgsSpringGraphQLAutoConfiguration;
import com.netflix.graphql.dgs.springgraphql.autoconfig.DgsSpringGraphQLConfigurationProperties;
import com.netflix.graphql.dgs.springgraphql.autoconfig.ExceptionHandlerResolverAdapter;
import com.netflix.graphql.dgs.springgraphql.webflux.DgsWebFluxGraphQLInterceptor;
import com.netflix.graphql.dgs.springgraphql.webmvc.DgsWebMvcGraphQLInterceptor;
import graphql.GraphQL;
import graphql.GraphQLContext;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactory;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.TypeResolver;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.micrometer.context.ContextRegistry;
import io.micrometer.context.ContextSnapshotFactory;
import io.micrometer.context.ThreadLocalAccessor;
import io.micrometer.context.integration.Slf4jThreadLocalAccessor;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnJava;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.graphql.GraphQlProperties;
import org.springframework.boot.autoconfigure.graphql.GraphQlSourceBuilderCustomizer;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.system.JavaVersion;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.task.support.ContextPropagatingTaskDecorator;
import org.springframework.graphql.ExecutionGraphQlService;
import org.springframework.graphql.execution.ConnectionTypeDefinitionConfigurer;
import org.springframework.graphql.execution.DataFetcherExceptionResolver;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;
import org.springframework.graphql.execution.SchemaReport;
import org.springframework.graphql.execution.SelfDescribingDataFetcher;
import org.springframework.graphql.execution.SubscriptionExceptionResolver;
import org.springframework.graphql.server.WebGraphQlInterceptor;
import org.springframework.graphql.server.WebGraphQlRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.filter.reactive.ServerWebExchangeContextFilter;
import org.springframework.web.method.annotation.RequestHeaderMapMethodArgumentResolver;
import org.springframework.web.method.annotation.RequestParamMapMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.CookieValueMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestHeaderMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestParamMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.ServletCookieValueMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.ServletRequestDataBinderFactory;
import reactor.core.publisher.Mono;

@AutoConfiguration(beforeName={"org.springframework.boot.autoconfigure.graphql.GraphQlAutoConfiguration"}, afterName={"org.springframework.boot.autoconfigure.task.TaskSchedulingAutoConfiguration"})
@EnableConfigurationProperties(value={DgsSpringGraphQLConfigurationProperties.class, DgsConfigurationProperties.class, DgsDataloaderConfigurationProperties.class})
@ImportAutoConfiguration(classes={JacksonAutoConfiguration.class, DgsInputArgumentConfiguration.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0017\u0018\u0000 t2\u00020\u0001:\btuvwxyz{B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0017J\b\u0010\u0014\u001a\u00020\u0015H\u0017J>\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0012H\u0017J\b\u0010!\u001a\u00020\"H\u0017J\u0016\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0012H\u0017J\b\u0010\u001b\u001a\u00020\u001cH\u0017J\u0088\u0001\u0010'\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0*2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0*2\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\u00122\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0*2\u0006\u00102\u001a\u0002032\u0012\b\u0002\u00104\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003050*2\u0006\u00106\u001a\u0002072\n\b\u0002\u00108\u001a\u0004\u0018\u000109H\u0017J\u0010\u0010:\u001a\u00020;2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\b\u0010<\u001a\u00020=H\u0017J\b\u0010>\u001a\u00020?H\u0017J\b\u00102\u001a\u000203H\u0017J\b\u0010@\u001a\u00020AH\u0017J\b\u0010B\u001a\u00020CH\u0017J,\u0010D\u001a\u00020E2\u0010\u0010F\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030G0*2\u0010\u0010H\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030I0*H\u0017J\u0016\u0010J\u001a\u00020K2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020?0MH\u0017J~\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\u0006\u0010'\u001a\u00020(2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020S0M2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020U0M2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020K0M2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020&0M2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020X0M2\u0006\u0010Y\u001a\u00020\f2\u0006\u0010Z\u001a\u00020\b2\u000e\u0010[\u001a\n\u0012\u0004\u0012\u00020]\u0018\u00010\\H\u0017J\b\u0010^\u001a\u00020KH\u0017J&\u00106\u001a\u0002072\f\u0010_\u001a\b\u0012\u0004\u0012\u00020`0M2\u000e\b\u0001\u0010a\u001a\b\u0012\u0004\u0012\u00020b0*H\u0017J\b\u0010c\u001a\u00020dH\u0017J\b\u0010e\u001a\u00020fH\u0017J\u0010\u0010g\u001a\u00020h2\u0006\u0010\u0002\u001a\u00020\u0003H\u0017JF\u0010i\u001a\u00020X2\f\u0010g\u001a\b\u0012\u0004\u0012\u00020h0*2\u000e\b\u0001\u0010j\u001a\b\u0012\u0004\u0012\u00020k0*2\u000e\b\u0001\u0010l\u001a\b\u0012\u0004\u0012\u00020k0*2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0017J<\u0010m\u001a\u00020n2\u0006\u0010o\u001a\u00020p2\u0006\u0010q\u001a\u00020E2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010r\u001a\b\u0012\u0004\u0012\u00020d0M2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020?0\u0012H\u0017J\b\u0010s\u001a\u00020bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006|"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration;", "", "configProps", "Lcom/netflix/graphql/dgs/autoconfig/DgsConfigurationProperties;", "dataloaderConfigProps", "Lcom/netflix/graphql/dgs/autoconfig/DgsDataloaderConfigurationProperties;", "(Lcom/netflix/graphql/dgs/autoconfig/DgsConfigurationProperties;Lcom/netflix/graphql/dgs/autoconfig/DgsDataloaderConfigurationProperties;)V", "dataFetcherExceptionHandler", "Lgraphql/execution/DataFetcherExceptionHandler;", "defaultQueryValueCustomizer", "Lcom/netflix/graphql/dgs/internal/QueryValueCustomizer;", "defaultReloadSchemaIndicator", "Lcom/netflix/graphql/dgs/ReloadSchemaIndicator;", "environment", "Lorg/springframework/core/env/Environment;", "dgsDataLoaderInstrumentationDataLoaderCustomizer", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderInstrumentationDataLoaderCustomizer;", "instrumentations", "", "Lcom/netflix/graphql/dgs/DgsDataLoaderInstrumentation;", "dgsDataLoaderOptionsProvider", "Lcom/netflix/graphql/dgs/DgsDataLoaderOptionsProvider;", "dgsDataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "dataloaderOptionProvider", "dgsScheduledExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "extensionProviders", "Lcom/netflix/graphql/dgs/DataLoaderInstrumentationExtensionProvider;", "customizers", "Lcom/netflix/graphql/dgs/DgsDataLoaderCustomizer;", "dgsHeadersInterceptor", "Lorg/springframework/graphql/server/WebGraphQlInterceptor;", "dgsRuntimeWiringConfigurerBridge", "Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$DgsRuntimeWiringConfigurerBridge;", "configurers", "Lorg/springframework/graphql/execution/RuntimeWiringConfigurer;", "dgsSchemaProvider", "Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "federationResolver", "Ljava/util/Optional;", "Lcom/netflix/graphql/dgs/DgsFederationResolver;", "existingTypeDefinitionFactory", "Lgraphql/schema/idl/TypeDefinitionRegistry;", "existingCodeRegistry", "Lgraphql/schema/GraphQLCodeRegistry;", "dataFetcherResultProcessors", "Lcom/netflix/graphql/dgs/internal/DataFetcherResultProcessor;", "entityFetcherRegistry", "Lcom/netflix/graphql/dgs/internal/EntityFetcherRegistry;", "defaultDataFetcherFactory", "Lgraphql/schema/DataFetcherFactory;", "methodDataFetcherFactory", "Lcom/netflix/graphql/dgs/internal/method/MethodDataFetcherFactory;", "fallbackTypeResolver", "Lgraphql/schema/TypeResolver;", "dgsTypeDefinitionConfigurerBridge", "Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$DgsTypeDefinitionConfigurerBridge;", "dgsWrapWithContextDataLoaderCustomizer", "Lcom/netflix/graphql/dgs/internal/DgsWrapWithContextDataLoaderCustomizer;", "disableIntrospectionContextContributor", "Lcom/netflix/graphql/dgs/context/GraphQLContextContributor;", "flowReactiveDataFetcherResultProcessor", "Lcom/netflix/graphql/dgs/internal/FlowDataFetcherResultProcessor;", "fluxReactiveDataFetcherResultProcessor", "Lcom/netflix/graphql/dgs/internal/FluxDataFetcherResultProcessor;", "graphQLContextBuilder", "Lcom/netflix/graphql/dgs/internal/DefaultDgsGraphQLContextBuilder;", "dgsCustomContextBuilder", "Lcom/netflix/graphql/dgs/context/DgsCustomContextBuilder;", "dgsCustomContextBuilderWithRequest", "Lcom/netflix/graphql/dgs/context/DgsCustomContextBuilderWithRequest;", "graphQLContextContributionInstrumentation", "Lgraphql/execution/instrumentation/Instrumentation;", "graphQLContextContributors", "Lorg/springframework/beans/factory/ObjectProvider;", "graphQlSource", "Lorg/springframework/graphql/execution/GraphQlSource;", "properties", "Lorg/springframework/boot/autoconfigure/graphql/GraphQlProperties;", "exceptionResolvers", "Lorg/springframework/graphql/execution/DataFetcherExceptionResolver;", "subscriptionExceptionResolvers", "Lorg/springframework/graphql/execution/SubscriptionExceptionResolver;", "wiringConfigurers", "sourceCustomizers", "Lorg/springframework/boot/autoconfigure/graphql/GraphQlSourceBuilderCustomizer;", "reloadSchemaIndicator", "defaultExceptionHandler", "reportConsumer", "Ljava/util/function/Consumer;", "Lorg/springframework/graphql/execution/SchemaReport;", "graphqlJavaErrorInstrumentation", "argumentResolvers", "Lcom/netflix/graphql/dgs/internal/method/ArgumentResolver;", "taskExecutorOptional", "Lorg/springframework/core/task/AsyncTaskExecutor;", "mockRequestHeaderCustomizer", "Lcom/netflix/graphql/dgs/internal/DgsQueryExecutorRequestCustomizer;", "monoReactiveDataFetcherResultProcessor", "Lcom/netflix/graphql/dgs/internal/MonoDataFetcherResultProcessor;", "preparsedDocumentProvider", "Lgraphql/execution/preparsed/PreparsedDocumentProvider;", "sourceBuilderCustomizer", "providedQueryExecutionStrategy", "Lgraphql/execution/ExecutionStrategy;", "providedMutationExecutionStrategy", "springGraphQLDgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "executionService", "Lorg/springframework/graphql/ExecutionGraphQlService;", "dgsContextBuilder", "requestCustomizer", "virtualThreadsTaskExecutor", "Companion", "DgsRuntimeWiringConfigurerBridge", "DgsTypeDefinitionConfigurerBridge", "ReactiveConfiguration", "WebFluxArgumentHandlerConfiguration", "WebFluxConfiguration", "WebMvcArgumentHandlerConfiguration", "WebMvcConfiguration", "graphql-dgs-spring-graphql"})
@SourceDebugExtension(value={"SMAP\nDgsSpringGraphQLAutoConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsSpringGraphQLAutoConfiguration.kt\ncom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,774:1\n125#2:775\n152#2,3:776\n*S KotlinDebug\n*F\n+ 1 DgsSpringGraphQLAutoConfiguration.kt\ncom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration\n*L\n345#1:775\n345#1:776,3\n*E\n"})
public class DgsSpringGraphQLAutoConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsConfigurationProperties configProps;
    @NotNull
    private final DgsDataloaderConfigurationProperties dataloaderConfigProps;
    @NotNull
    public static final String AUTO_CONF_PREFIX = "dgs.graphql";
    @NotNull
    private static final Logger LOG;

    public DgsSpringGraphQLAutoConfiguration(@NotNull DgsConfigurationProperties configProps, @NotNull DgsDataloaderConfigurationProperties dataloaderConfigProps) {
        Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
        Intrinsics.checkNotNullParameter((Object)dataloaderConfigProps, (String)"dataloaderConfigProps");
        this.configProps = configProps;
        this.dataloaderConfigProps = dataloaderConfigProps;
    }

    @Bean
    @Order(value=-2147483648)
    @NotNull
    public Instrumentation graphQLContextContributionInstrumentation(@NotNull ObjectProvider<GraphQLContextContributor> graphQLContextContributors) {
        Intrinsics.checkNotNullParameter(graphQLContextContributors, (String)"graphQLContextContributors");
        List list = graphQLContextContributors.orderedStream().toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return (Instrumentation)new GraphQLContextContributorInstrumentation(list);
    }

    @Bean
    @Order(value=0x7FFFFFFE)
    @ConditionalOnProperty(prefix="dgs.graphql.errors.classification", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public Instrumentation graphqlJavaErrorInstrumentation() {
        return (Instrumentation)new GraphQLJavaErrorInstrumentation();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public QueryValueCustomizer defaultQueryValueCustomizer() {
        return DgsSpringGraphQLAutoConfiguration::defaultQueryValueCustomizer$lambda$0;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DgsDataLoaderOptionsProvider dgsDataLoaderOptionsProvider() {
        return (DgsDataLoaderOptionsProvider)new DefaultDataLoaderOptionsProvider();
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean(name={"dgsScheduledExecutorService"})
    @Qualifier(value="dgsScheduledExecutorService")
    @NotNull
    public ScheduledExecutorService dgsScheduledExecutorService() {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor(...)");
        return scheduledExecutorService;
    }

    @Bean
    @ConditionalOnProperty(prefix="dgs.graphql.convertAllDataLoadersToWithContext", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @Order(value=0)
    @NotNull
    public DgsWrapWithContextDataLoaderCustomizer dgsWrapWithContextDataLoaderCustomizer() {
        return new DgsWrapWithContextDataLoaderCustomizer();
    }

    @Bean
    @Order(value=100)
    @NotNull
    public DgsDataLoaderInstrumentationDataLoaderCustomizer dgsDataLoaderInstrumentationDataLoaderCustomizer(@NotNull List<? extends DgsDataLoaderInstrumentation> instrumentations) {
        Intrinsics.checkNotNullParameter(instrumentations, (String)"instrumentations");
        return new DgsDataLoaderInstrumentationDataLoaderCustomizer(instrumentations);
    }

    @Bean
    @NotNull
    public DgsDataLoaderProvider dgsDataLoaderProvider(@NotNull ApplicationContext applicationContext, @NotNull DgsDataLoaderOptionsProvider dataloaderOptionProvider, @Qualifier(value="dgsScheduledExecutorService") @NotNull ScheduledExecutorService dgsScheduledExecutorService, @NotNull List<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders, @NotNull List<? extends DgsDataLoaderCustomizer> customizers) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)dataloaderOptionProvider, (String)"dataloaderOptionProvider");
        Intrinsics.checkNotNullParameter((Object)dgsScheduledExecutorService, (String)"dgsScheduledExecutorService");
        Intrinsics.checkNotNullParameter(extensionProviders, (String)"extensionProviders");
        Intrinsics.checkNotNullParameter(customizers, (String)"customizers");
        Duration duration = this.dataloaderConfigProps.getScheduleDuration();
        boolean bl = this.dataloaderConfigProps.getTickerModeEnabled();
        return new DgsDataLoaderProvider(applicationContext, extensionProviders, customizers, dataloaderOptionProvider, dgsScheduledExecutorService, duration, bl);
    }

    @Bean
    @NotNull
    public EntityFetcherRegistry entityFetcherRegistry() {
        return new EntityFetcherRegistry();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DataFetcherExceptionHandler dataFetcherExceptionHandler() {
        return (DataFetcherExceptionHandler)new DefaultDataFetcherExceptionHandler();
    }

    @Bean
    @ConditionalOnProperty(prefix="dgs.graphql.preparsedDocumentProvider", name={"enabled"}, havingValue="true", matchIfMissing=false)
    @ConditionalOnMissingBean
    @NotNull
    public PreparsedDocumentProvider preparsedDocumentProvider(@NotNull DgsConfigurationProperties configProps) {
        Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
        long l = configProps.getPreparsedDocumentProvider().getMaximumCacheSize();
        Duration duration = Duration.parse(configProps.getPreparsedDocumentProvider().getCacheValidityDuration());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"parse(...)");
        return (PreparsedDocumentProvider)new DgsDefaultPreparsedDocumentProvider(l, duration);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DefaultDgsGraphQLContextBuilder graphQLContextBuilder(@NotNull Optional<DgsCustomContextBuilder<?>> dgsCustomContextBuilder, @NotNull Optional<DgsCustomContextBuilderWithRequest<?>> dgsCustomContextBuilderWithRequest) {
        Intrinsics.checkNotNullParameter(dgsCustomContextBuilder, (String)"dgsCustomContextBuilder");
        Intrinsics.checkNotNullParameter(dgsCustomContextBuilderWithRequest, (String)"dgsCustomContextBuilderWithRequest");
        return new DefaultDgsGraphQLContextBuilder(dgsCustomContextBuilder, dgsCustomContextBuilderWithRequest);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public ReloadSchemaIndicator defaultReloadSchemaIndicator(@NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        String[] stringArray = environment.getActiveProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getActiveProfiles(...)");
        boolean isLaptopProfile = ArraysKt.contains((Object[])stringArray, (Object)"laptop");
        Boolean hotReloadSetting = (Boolean)environment.getProperty("dgs.reload", Boolean.TYPE, (Object)isLaptopProfile);
        return () -> DgsSpringGraphQLAutoConfiguration.defaultReloadSchemaIndicator$lambda$1(hotReloadSetting);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DgsSchemaProvider dgsSchemaProvider(@NotNull ApplicationContext applicationContext, @NotNull Optional<DgsFederationResolver> federationResolver, @NotNull Optional<TypeDefinitionRegistry> existingTypeDefinitionFactory, @NotNull Optional<GraphQLCodeRegistry> existingCodeRegistry, @NotNull List<? extends DataFetcherResultProcessor> dataFetcherResultProcessors, @NotNull Optional<DataFetcherExceptionHandler> dataFetcherExceptionHandler, @NotNull EntityFetcherRegistry entityFetcherRegistry, @NotNull Optional<DataFetcherFactory<?>> defaultDataFetcherFactory, @NotNull MethodDataFetcherFactory methodDataFetcherFactory, @Nullable TypeResolver fallbackTypeResolver) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter(federationResolver, (String)"federationResolver");
        Intrinsics.checkNotNullParameter(existingTypeDefinitionFactory, (String)"existingTypeDefinitionFactory");
        Intrinsics.checkNotNullParameter(existingCodeRegistry, (String)"existingCodeRegistry");
        Intrinsics.checkNotNullParameter(dataFetcherResultProcessors, (String)"dataFetcherResultProcessors");
        Intrinsics.checkNotNullParameter(dataFetcherExceptionHandler, (String)"dataFetcherExceptionHandler");
        Intrinsics.checkNotNullParameter((Object)entityFetcherRegistry, (String)"entityFetcherRegistry");
        Intrinsics.checkNotNullParameter(defaultDataFetcherFactory, (String)"defaultDataFetcherFactory");
        Intrinsics.checkNotNullParameter((Object)methodDataFetcherFactory, (String)"methodDataFetcherFactory");
        return new DgsSchemaProvider(applicationContext, federationResolver, existingTypeDefinitionFactory, this.configProps.getSchemaLocations(), dataFetcherResultProcessors, dataFetcherExceptionHandler, entityFetcherRegistry, defaultDataFetcherFactory, methodDataFetcherFactory, null, this.configProps.getSchemaWiringValidationEnabled(), this.configProps.getEnableEntityFetcherCustomScalarParsing(), fallbackTypeResolver, 512, null);
    }

    public static /* synthetic */ DgsSchemaProvider dgsSchemaProvider$default(DgsSpringGraphQLAutoConfiguration dgsSpringGraphQLAutoConfiguration, ApplicationContext applicationContext, Optional optional, Optional optional2, Optional optional3, List list, Optional optional4, EntityFetcherRegistry entityFetcherRegistry, Optional optional5, MethodDataFetcherFactory methodDataFetcherFactory, TypeResolver typeResolver, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: dgsSchemaProvider");
        }
        if ((n & 0x20) != 0) {
            Optional<DataFetcherExceptionHandler> optional6 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional6, (String)"empty(...)");
            optional4 = optional6;
        }
        if ((n & 0x80) != 0) {
            Optional<DataFetcherFactory<?>> optional7 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional7, (String)"empty(...)");
            optional5 = optional7;
        }
        if ((n & 0x200) != 0) {
            typeResolver = null;
        }
        return dgsSpringGraphQLAutoConfiguration.dgsSchemaProvider(applicationContext, optional, optional2, optional3, list, optional4, entityFetcherRegistry, optional5, methodDataFetcherFactory, typeResolver);
    }

    @Bean
    @NotNull
    public GraphQlSource graphQlSource(@NotNull GraphQlProperties properties, @NotNull DgsSchemaProvider dgsSchemaProvider, @NotNull ObjectProvider<DataFetcherExceptionResolver> exceptionResolvers, @NotNull ObjectProvider<SubscriptionExceptionResolver> subscriptionExceptionResolvers, @NotNull ObjectProvider<Instrumentation> instrumentations, @NotNull ObjectProvider<RuntimeWiringConfigurer> wiringConfigurers, @NotNull ObjectProvider<GraphQlSourceBuilderCustomizer> sourceCustomizers, @NotNull ReloadSchemaIndicator reloadSchemaIndicator, @NotNull DataFetcherExceptionHandler defaultExceptionHandler, @Nullable Consumer<SchemaReport> reportConsumer) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)dgsSchemaProvider, (String)"dgsSchemaProvider");
        Intrinsics.checkNotNullParameter(exceptionResolvers, (String)"exceptionResolvers");
        Intrinsics.checkNotNullParameter(subscriptionExceptionResolvers, (String)"subscriptionExceptionResolvers");
        Intrinsics.checkNotNullParameter(instrumentations, (String)"instrumentations");
        Intrinsics.checkNotNullParameter(wiringConfigurers, (String)"wiringConfigurers");
        Intrinsics.checkNotNullParameter(sourceCustomizers, (String)"sourceCustomizers");
        Intrinsics.checkNotNullParameter((Object)reloadSchemaIndicator, (String)"reloadSchemaIndicator");
        Intrinsics.checkNotNullParameter((Object)defaultExceptionHandler, (String)"defaultExceptionHandler");
        List list = exceptionResolvers.orderedStream().collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        List dataFetcherExceptionResolvers = list;
        ((Collection)dataFetcherExceptionResolvers).add(new ExceptionHandlerResolverAdapter(defaultExceptionHandler));
        GraphQlSource.SchemaResourceBuilder builder = (GraphQlSource.SchemaResourceBuilder)((GraphQlSource.SchemaResourceBuilder)((GraphQlSource.SchemaResourceBuilder)new DgsGraphQLSourceBuilder(dgsSchemaProvider, this.configProps.getIntrospection().getShowSdlComments()).exceptionResolvers(dataFetcherExceptionResolvers)).subscriptionExceptionResolvers(subscriptionExceptionResolvers.orderedStream().toList())).instrumentation(instrumentations.orderedStream().toList());
        if (properties.getSchema().getInspection().isEnabled()) {
            if (reportConsumer != null) {
                builder.inspectSchemaMappings(reportConsumer);
            } else if (LOG.isInfoEnabled()) {
                builder.inspectSchemaMappings(DgsSpringGraphQLAutoConfiguration::graphQlSource$lambda$3);
            }
        }
        wiringConfigurers.orderedStream().forEach(arg_0 -> DgsSpringGraphQLAutoConfiguration.graphQlSource$lambda$4((Function1)new Function1<RuntimeWiringConfigurer, Unit>(builder){
            final /* synthetic */ GraphQlSource.SchemaResourceBuilder $builder;
            {
                this.$builder = $builder;
                super(1);
            }

            public final void invoke(@NotNull RuntimeWiringConfigurer configurer) {
                Intrinsics.checkNotNullParameter((Object)configurer, (String)"configurer");
                this.$builder.configureRuntimeWiring(configurer);
            }
        }, arg_0));
        sourceCustomizers.orderedStream().forEach(arg_0 -> DgsSpringGraphQLAutoConfiguration.graphQlSource$lambda$5((Function1)new Function1<GraphQlSourceBuilderCustomizer, Unit>(builder){
            final /* synthetic */ GraphQlSource.SchemaResourceBuilder $builder;
            {
                this.$builder = $builder;
                super(1);
            }

            public final void invoke(@NotNull GraphQlSourceBuilderCustomizer customizer) {
                Intrinsics.checkNotNullParameter((Object)customizer, (String)"customizer");
                customizer.customize(this.$builder);
            }
        }, arg_0));
        Intrinsics.checkNotNull((Object)builder);
        return new ReloadableGraphQLSource((GraphQlSource.Builder)builder, reloadSchemaIndicator);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"reactor.core.publisher.Mono"})
    @NotNull
    public MonoDataFetcherResultProcessor monoReactiveDataFetcherResultProcessor() {
        return new MonoDataFetcherResultProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"kotlinx.coroutines.flow.Flow"})
    @NotNull
    public FlowDataFetcherResultProcessor flowReactiveDataFetcherResultProcessor() {
        return new FlowDataFetcherResultProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"reactor.core.publisher.Flux"})
    @NotNull
    public FluxDataFetcherResultProcessor fluxReactiveDataFetcherResultProcessor() {
        return new FluxDataFetcherResultProcessor();
    }

    @Bean
    @Qualifier(value="dgsAsyncTaskExecutor")
    @ConditionalOnJava(value=JavaVersion.TWENTY_ONE)
    @ConditionalOnMissingBean(name={"dgsAsyncTaskExecutor"})
    @ConditionalOnProperty(prefix="dgs.graphql.virtualthreads", name={"enabled"}, havingValue="true", matchIfMissing=false)
    @NotNull
    public AsyncTaskExecutor virtualThreadsTaskExecutor() {
        LOG.info("Enabling virtual threads for DGS");
        ContextRegistry contextRegistry = new ContextRegistry().loadContextAccessors().loadThreadLocalAccessors().registerThreadLocalAccessor((ThreadLocalAccessor)new Slf4jThreadLocalAccessor(new String[0]));
        SimpleAsyncTaskExecutor executor = new SimpleAsyncTaskExecutor("dgs-virtual-thread-");
        executor.setVirtualThreads(true);
        executor.setTaskDecorator((TaskDecorator)new ContextPropagatingTaskDecorator(ContextSnapshotFactory.builder().contextRegistry(contextRegistry).build()));
        return (AsyncTaskExecutor)executor;
    }

    @Bean
    @NotNull
    public MethodDataFetcherFactory methodDataFetcherFactory(@NotNull ObjectProvider<ArgumentResolver> argumentResolvers, @Qualifier(value="dgsAsyncTaskExecutor") @NotNull Optional<AsyncTaskExecutor> taskExecutorOptional) {
        Intrinsics.checkNotNullParameter(argumentResolvers, (String)"argumentResolvers");
        Intrinsics.checkNotNullParameter(taskExecutorOptional, (String)"taskExecutorOptional");
        AsyncTaskExecutor taskExecutor = taskExecutorOptional.isPresent() ? taskExecutorOptional.get() : null;
        List list = argumentResolvers.orderedStream().toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return new MethodDataFetcherFactory(list, (ParameterNameDiscoverer)new DefaultParameterNameDiscoverer(), taskExecutor);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.mock.web.MockHttpServletRequest"})
    @NotNull
    public DgsQueryExecutorRequestCustomizer mockRequestHeaderCustomizer() {
        return new DgsQueryExecutorRequestCustomizer(){

            @Nullable
            public WebRequest apply(@Nullable WebRequest request, @Nullable HttpHeaders headers) {
                Map map = (Map)headers;
                if (map == null || map.isEmpty() || !(request instanceof NativeWebRequest)) {
                    return request;
                }
                Object object = ((NativeWebRequest)request).getNativeRequest();
                MockHttpServletRequest mockHttpServletRequest = object instanceof MockHttpServletRequest ? (MockHttpServletRequest)object : null;
                if (mockHttpServletRequest == null) {
                    return request;
                }
                MockHttpServletRequest mockRequest = mockHttpServletRequest;
                headers.forEach((arg_0, arg_1) -> mockRequestHeaderCustomizer.1.apply$lambda$0((Function2)new Function2<String, List<String>, Unit>(mockRequest){
                    final /* synthetic */ MockHttpServletRequest $mockRequest;
                    {
                        this.$mockRequest = $mockRequest;
                        super(2);
                    }

                    public final void invoke(String key, List<String> value) {
                        if (this.$mockRequest.getHeader(key) == null) {
                            this.$mockRequest.addHeader(key, value);
                        }
                    }
                }, arg_0, arg_1));
                return request;
            }

            @NotNull
            public String toString() {
                return "{MockRequestHeaderCustomizer}";
            }

            private static final void apply$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0, p1);
            }
        };
    }

    @Bean
    @DgsComponent
    @NotNull
    public DgsRuntimeWiringConfigurerBridge dgsRuntimeWiringConfigurerBridge(@NotNull List<? extends RuntimeWiringConfigurer> configurers) {
        Intrinsics.checkNotNullParameter(configurers, (String)"configurers");
        return new DgsRuntimeWiringConfigurerBridge(configurers);
    }

    @Bean
    @ConditionalOnProperty(value={"dgs.springgraphql.pagination.enabled"}, havingValue="true", matchIfMissing=true)
    @DgsComponent
    @NotNull
    public DgsTypeDefinitionConfigurerBridge dgsTypeDefinitionConfigurerBridge(@NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        return new DgsTypeDefinitionConfigurerBridge();
    }

    @Bean
    @NotNull
    public GraphQlSourceBuilderCustomizer sourceBuilderCustomizer(@NotNull Optional<PreparsedDocumentProvider> preparsedDocumentProvider, @Qualifier(value="query") @NotNull Optional<ExecutionStrategy> providedQueryExecutionStrategy, @Qualifier(value="mutation") @NotNull Optional<ExecutionStrategy> providedMutationExecutionStrategy, @NotNull DataFetcherExceptionHandler dataFetcherExceptionHandler, @NotNull Environment environment) {
        Intrinsics.checkNotNullParameter(preparsedDocumentProvider, (String)"preparsedDocumentProvider");
        Intrinsics.checkNotNullParameter(providedQueryExecutionStrategy, (String)"providedQueryExecutionStrategy");
        Intrinsics.checkNotNullParameter(providedMutationExecutionStrategy, (String)"providedMutationExecutionStrategy");
        Intrinsics.checkNotNullParameter((Object)dataFetcherExceptionHandler, (String)"dataFetcherExceptionHandler");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        return arg_0 -> DgsSpringGraphQLAutoConfiguration.sourceBuilderCustomizer$lambda$7(environment, preparsedDocumentProvider, providedQueryExecutionStrategy, providedMutationExecutionStrategy, arg_0);
    }

    @Bean
    @ConditionalOnProperty(name={"spring.graphql.schema.introspection.enabled"}, havingValue="false", matchIfMissing=false)
    @NotNull
    public GraphQLContextContributor disableIntrospectionContextContributor() {
        return DgsSpringGraphQLAutoConfiguration::disableIntrospectionContextContributor$lambda$8;
    }

    @Bean
    @NotNull
    public DgsQueryExecutor springGraphQLDgsQueryExecutor(@NotNull ExecutionGraphQlService executionService, @NotNull DefaultDgsGraphQLContextBuilder dgsContextBuilder, @NotNull DgsDataLoaderProvider dgsDataLoaderProvider, @NotNull ObjectProvider<DgsQueryExecutorRequestCustomizer> requestCustomizer, @NotNull List<? extends GraphQLContextContributor> graphQLContextContributors) {
        Intrinsics.checkNotNullParameter((Object)executionService, (String)"executionService");
        Intrinsics.checkNotNullParameter((Object)dgsContextBuilder, (String)"dgsContextBuilder");
        Intrinsics.checkNotNullParameter((Object)dgsDataLoaderProvider, (String)"dgsDataLoaderProvider");
        Intrinsics.checkNotNullParameter(requestCustomizer, (String)"requestCustomizer");
        Intrinsics.checkNotNullParameter(graphQLContextContributors, (String)"graphQLContextContributors");
        Object object = requestCustomizer.getIfAvailable(() -> DgsSpringGraphQLAutoConfiguration.springGraphQLDgsQueryExecutor$lambda$9((KProperty0)new PropertyReference0Impl(DgsQueryExecutorRequestCustomizer.Companion){

            @Nullable
            public Object get() {
                return ((DgsQueryExecutorRequestCustomizer.Companion)this.receiver).getDEFAULT_REQUEST_CUSTOMIZER();
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getIfAvailable(...)");
        return new SpringGraphQLDgsQueryExecutor(executionService, dgsContextBuilder, dgsDataLoaderProvider, (DgsQueryExecutorRequestCustomizer)object, graphQLContextContributors);
    }

    @Bean
    @ConditionalOnProperty(prefix="dgs.graphql.dgs-response-headers", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public WebGraphQlInterceptor dgsHeadersInterceptor() {
        return DgsSpringGraphQLAutoConfiguration::dgsHeadersInterceptor$lambda$11;
    }

    private static final String defaultQueryValueCustomizer$lambda$0(String a) {
        return a;
    }

    private static final boolean defaultReloadSchemaIndicator$lambda$1(Boolean $hotReloadSetting) {
        Intrinsics.checkNotNull((Object)$hotReloadSetting);
        return $hotReloadSetting;
    }

    /*
     * WARNING - void declaration
     */
    private static final void graphQlSource$lambda$3(SchemaReport schemaReport) {
        void $this$mapTo$iv$iv;
        StringBuilder messageBuilder = new StringBuilder("***Schema Report***\n");
        MultiValueMap multiValueMap = schemaReport.unmappedArguments();
        Intrinsics.checkNotNullExpressionValue((Object)multiValueMap, (String)"unmappedArguments(...)");
        Map $this$map$iv = (Map)multiValueMap;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            void entry;
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DataFetcher key = (DataFetcher)entry.getKey();
            List value = (List)entry.getValue();
            if (key instanceof SelfDescribingDataFetcher) {
                DataFetcherReference dataFetcher = ((DgsGraphQLSourceBuilder.DgsSelfDescribingDataFetcher)key).getDataFetcher();
                object = dataFetcher.getMethod().getDeclaringClass().getName() + "." + dataFetcher.getMethod().getName() + " for arguments " + value;
            } else {
                object = entry.toString();
            }
            collection.add(object);
        }
        List arguments = (List)destination$iv$iv;
        messageBuilder.append("Unmapped fields: ").append(schemaReport.unmappedFields()).append('\n');
        messageBuilder.append("Unmapped registrations: ").append(schemaReport.unmappedRegistrations()).append('\n');
        messageBuilder.append("Unmapped arguments: ").append(arguments).append('\n');
        messageBuilder.append("Skipped types: ").append(schemaReport.skippedTypes()).append('\n');
        LOG.info("{}", (Object)messageBuilder);
    }

    private static final void graphQlSource$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void graphQlSource$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void sourceBuilderCustomizer$lambda$7$lambda$6(Environment $environment, Optional $preparsedDocumentProvider, Optional $providedQueryExecutionStrategy, Optional $providedMutationExecutionStrategy, GraphQL.Builder graphQlBuilder) {
        Intrinsics.checkNotNullParameter((Object)$environment, (String)"$environment");
        Intrinsics.checkNotNullParameter((Object)$preparsedDocumentProvider, (String)"$preparsedDocumentProvider");
        Intrinsics.checkNotNullParameter((Object)$providedQueryExecutionStrategy, (String)"$providedQueryExecutionStrategy");
        Intrinsics.checkNotNullParameter((Object)$providedMutationExecutionStrategy, (String)"$providedMutationExecutionStrategy");
        Boolean apqEnabled = (Boolean)$environment.getProperty("dgs.graphql.apq.enabled", Boolean.TYPE, (Object)false);
        if ($preparsedDocumentProvider.isPresent() && !apqEnabled.booleanValue()) {
            graphQlBuilder.preparsedDocumentProvider((PreparsedDocumentProvider)$preparsedDocumentProvider.get());
        }
        if ($providedQueryExecutionStrategy.isPresent()) {
            graphQlBuilder.queryExecutionStrategy((ExecutionStrategy)$providedQueryExecutionStrategy.get());
        }
        if ($providedMutationExecutionStrategy.isPresent()) {
            graphQlBuilder.mutationExecutionStrategy((ExecutionStrategy)$providedMutationExecutionStrategy.get());
        }
    }

    private static final void sourceBuilderCustomizer$lambda$7(Environment $environment, Optional $preparsedDocumentProvider, Optional $providedQueryExecutionStrategy, Optional $providedMutationExecutionStrategy, GraphQlSource.SchemaResourceBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)$environment, (String)"$environment");
        Intrinsics.checkNotNullParameter((Object)$preparsedDocumentProvider, (String)"$preparsedDocumentProvider");
        Intrinsics.checkNotNullParameter((Object)$providedQueryExecutionStrategy, (String)"$providedQueryExecutionStrategy");
        Intrinsics.checkNotNullParameter((Object)$providedMutationExecutionStrategy, (String)"$providedMutationExecutionStrategy");
        builder.configureGraphQl(arg_0 -> DgsSpringGraphQLAutoConfiguration.sourceBuilderCustomizer$lambda$7$lambda$6($environment, $preparsedDocumentProvider, $providedQueryExecutionStrategy, $providedMutationExecutionStrategy, arg_0));
    }

    private static final void disableIntrospectionContextContributor$lambda$8(GraphQLContext.Builder builder, Map map, DgsRequestData dgsRequestData) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.put((Object)"INTROSPECTION_DISABLED", (Object)true);
    }

    private static final DgsQueryExecutorRequestCustomizer springGraphQLDgsQueryExecutor$lambda$9(KProperty0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DgsQueryExecutorRequestCustomizer)((Function0)$tmp0).invoke();
    }

    private static final void dgsHeadersInterceptor$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Mono dgsHeadersInterceptor$lambda$11(WebGraphQlRequest request, WebGraphQlInterceptor.Chain chain) {
        return chain.next(request).doOnNext(arg_0 -> DgsSpringGraphQLAutoConfiguration.dgsHeadersInterceptor$lambda$11$lambda$10(dgsHeadersInterceptor.1.1.INSTANCE, arg_0));
    }

    static {
        Logger logger = LoggerFactory.getLogger(DgsSpringGraphQLAutoConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$Companion;", "", "()V", "AUTO_CONF_PREFIX", "", "LOG", "Lorg/slf4j/Logger;", "graphql-dgs-spring-graphql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$DgsRuntimeWiringConfigurerBridge;", "", "configurers", "", "Lorg/springframework/graphql/execution/RuntimeWiringConfigurer;", "(Ljava/util/List;)V", "runtimeWiring", "Lgraphql/schema/idl/RuntimeWiring$Builder;", "builder", "graphql-dgs-spring-graphql"})
    @SourceDebugExtension(value={"SMAP\nDgsSpringGraphQLAutoConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsSpringGraphQLAutoConfiguration.kt\ncom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$DgsRuntimeWiringConfigurerBridge\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,774:1\n1855#2,2:775\n*S KotlinDebug\n*F\n+ 1 DgsSpringGraphQLAutoConfiguration.kt\ncom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$DgsRuntimeWiringConfigurerBridge\n*L\n472#1:775,2\n*E\n"})
    public static final class DgsRuntimeWiringConfigurerBridge {
        @NotNull
        private final List<RuntimeWiringConfigurer> configurers;

        public DgsRuntimeWiringConfigurerBridge(@NotNull List<? extends RuntimeWiringConfigurer> configurers) {
            Intrinsics.checkNotNullParameter(configurers, (String)"configurers");
            this.configurers = configurers;
        }

        @DgsRuntimeWiring
        @NotNull
        public final RuntimeWiring.Builder runtimeWiring(@NotNull RuntimeWiring.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Iterable $this$forEach$iv = this.configurers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RuntimeWiringConfigurer it = (RuntimeWiringConfigurer)element$iv;
                boolean bl = false;
                it.configure(builder);
            }
            return builder;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$DgsTypeDefinitionConfigurerBridge;", "", "()V", "typeDefinitionRegistry", "Lgraphql/schema/idl/TypeDefinitionRegistry;", "graphql-dgs-spring-graphql"})
    public static final class DgsTypeDefinitionConfigurerBridge {
        @DgsTypeDefinitionRegistry
        @NotNull
        public final TypeDefinitionRegistry typeDefinitionRegistry(@NotNull TypeDefinitionRegistry typeDefinitionRegistry) {
            Intrinsics.checkNotNullParameter((Object)typeDefinitionRegistry, (String)"typeDefinitionRegistry");
            TypeDefinitionRegistry newTypeDefinitionRegistry = new TypeDefinitionRegistry();
            new ConnectionTypeDefinitionConfigurer().configure(typeDefinitionRegistry);
            return newTypeDefinitionRegistry;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Publisher.class, ServerRequest.class})
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\u001a\u0010\u0005\u001a\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bH\u0017J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0017\u00a8\u0006\u0011"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$ReactiveConfiguration;", "", "()V", "dgsServerWebExchangeContextFilter", "Lorg/springframework/web/filter/reactive/ServerWebExchangeContextFilter;", "reactiveGraphQlContextBuilder", "Lcom/netflix/graphql/dgs/reactive/internal/DefaultDgsReactiveGraphQLContextBuilder;", "dgsReactiveCustomContextBuilderWithRequest", "Ljava/util/Optional;", "Lcom/netflix/graphql/dgs/reactive/DgsReactiveCustomContextBuilderWithRequest;", "springGraphQLDgsReactiveQueryExecutor", "Lcom/netflix/graphql/dgs/reactive/DgsReactiveQueryExecutor;", "executionService", "Lorg/springframework/graphql/ExecutionGraphQlService;", "dgsContextBuilder", "dgsDataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "graphql-dgs-spring-graphql"})
    public static class ReactiveConfiguration {
        @Bean
        @NotNull
        public DgsReactiveQueryExecutor springGraphQLDgsReactiveQueryExecutor(@NotNull ExecutionGraphQlService executionService, @NotNull DefaultDgsReactiveGraphQLContextBuilder dgsContextBuilder, @NotNull DgsDataLoaderProvider dgsDataLoaderProvider) {
            Intrinsics.checkNotNullParameter((Object)executionService, (String)"executionService");
            Intrinsics.checkNotNullParameter((Object)dgsContextBuilder, (String)"dgsContextBuilder");
            Intrinsics.checkNotNullParameter((Object)dgsDataLoaderProvider, (String)"dgsDataLoaderProvider");
            return new SpringGraphQLDgsReactiveQueryExecutor(executionService, dgsContextBuilder, dgsDataLoaderProvider);
        }

        @Bean
        @ConditionalOnMissingBean
        @NotNull
        public DefaultDgsReactiveGraphQLContextBuilder reactiveGraphQlContextBuilder(@NotNull Optional<DgsReactiveCustomContextBuilderWithRequest<?>> dgsReactiveCustomContextBuilderWithRequest) {
            Intrinsics.checkNotNullParameter(dgsReactiveCustomContextBuilderWithRequest, (String)"dgsReactiveCustomContextBuilderWithRequest");
            return new DefaultDgsReactiveGraphQLContextBuilder(dgsReactiveCustomContextBuilderWithRequest);
        }

        @Bean
        @ConditionalOnMissingBean
        @NotNull
        public ServerWebExchangeContextFilter dgsServerWebExchangeContextFilter() {
            return new ServerWebExchangeContextFilter();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\u0016\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0017J\"\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\u001a\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\"\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\"\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017\u00a8\u0006\u0014"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$WebFluxArgumentHandlerConfiguration;", "", "()V", "cookieValueArgumentResolver", "Lcom/netflix/graphql/dgs/internal/method/ArgumentResolver;", "beanFactory", "Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;", "registry", "Lorg/springframework/core/ReactiveAdapterRegistry;", "bindingContext", "Lorg/springframework/web/reactive/BindingContext;", "dgsBindingContext", "adapter", "Lorg/springframework/beans/factory/ObjectProvider;", "Lorg/springframework/web/reactive/result/method/annotation/RequestMappingHandlerAdapter;", "requestHeaderArgumentResolver", "requestHeaderMapArgumentResolver", "requestParamArgumentResolver", "requestParamMapArgumentResolver", "Dgs", "graphql-dgs-spring-graphql"})
    public static class WebFluxArgumentHandlerConfiguration {
        @Dgs
        @Bean
        @NotNull
        public BindingContext dgsBindingContext(@NotNull ObjectProvider<org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerAdapter> adapter) {
            Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
            org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerAdapter requestMappingHandlerAdapter = (org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerAdapter)adapter.getIfAvailable();
            return new BindingContext((WebBindingInitializer)(requestMappingHandlerAdapter != null ? requestMappingHandlerAdapter.getWebBindingInitializer() : null));
        }

        @Bean
        @NotNull
        public ArgumentResolver cookieValueArgumentResolver(@NotNull ConfigurableBeanFactory beanFactory, @NotNull ReactiveAdapterRegistry registry, @Dgs @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            return (ArgumentResolver)new SyncHandlerMethodArgumentResolverAdapter((SyncHandlerMethodArgumentResolver)new CookieValueMethodArgumentResolver(beanFactory, registry), bindingContext);
        }

        @Bean
        @NotNull
        public ArgumentResolver requestHeaderMapArgumentResolver(@NotNull ReactiveAdapterRegistry registry, @Dgs @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            return (ArgumentResolver)new SyncHandlerMethodArgumentResolverAdapter((SyncHandlerMethodArgumentResolver)new org.springframework.web.reactive.result.method.annotation.RequestHeaderMapMethodArgumentResolver(registry), bindingContext);
        }

        @Bean
        @NotNull
        public ArgumentResolver requestHeaderArgumentResolver(@NotNull ConfigurableBeanFactory beanFactory, @NotNull ReactiveAdapterRegistry registry, @Dgs @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            return (ArgumentResolver)new SyncHandlerMethodArgumentResolverAdapter((SyncHandlerMethodArgumentResolver)new RequestHeaderMethodArgumentResolver(beanFactory, registry), bindingContext);
        }

        @Bean
        @NotNull
        public ArgumentResolver requestParamArgumentResolver(@NotNull ConfigurableBeanFactory beanFactory, @NotNull ReactiveAdapterRegistry registry, @Dgs @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            return (ArgumentResolver)new SyncHandlerMethodArgumentResolverAdapter((SyncHandlerMethodArgumentResolver)new RequestParamMethodArgumentResolver(beanFactory, registry, false), bindingContext);
        }

        @Bean
        @NotNull
        public ArgumentResolver requestParamMapArgumentResolver(@NotNull ConfigurableBeanFactory beanFactory, @NotNull ReactiveAdapterRegistry registry, @Dgs @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            return (ArgumentResolver)new SyncHandlerMethodArgumentResolverAdapter((SyncHandlerMethodArgumentResolver)new org.springframework.web.reactive.result.method.annotation.RequestParamMapMethodArgumentResolver(registry), bindingContext);
        }

        @Qualifier
        @Retention(value=RetentionPolicy.RUNTIME)
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0083\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$WebFluxArgumentHandlerConfiguration$Dgs;", "", "graphql-dgs-spring-graphql"})
        private static @interface Dgs {
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\t"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$WebFluxConfiguration;", "", "()V", "webFluxDgsGraphQLInterceptor", "Lcom/netflix/graphql/dgs/springgraphql/webflux/DgsWebFluxGraphQLInterceptor;", "dgsDataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "defaultDgsReactiveGraphQLContextBuilder", "Lcom/netflix/graphql/dgs/reactive/internal/DefaultDgsReactiveGraphQLContextBuilder;", "graphql-dgs-spring-graphql"})
    public static class WebFluxConfiguration {
        @Bean
        @NotNull
        public DgsWebFluxGraphQLInterceptor webFluxDgsGraphQLInterceptor(@NotNull DgsDataLoaderProvider dgsDataLoaderProvider, @NotNull DefaultDgsReactiveGraphQLContextBuilder defaultDgsReactiveGraphQLContextBuilder) {
            Intrinsics.checkNotNullParameter((Object)dgsDataLoaderProvider, (String)"dgsDataLoaderProvider");
            Intrinsics.checkNotNullParameter((Object)defaultDgsReactiveGraphQLContextBuilder, (String)"defaultDgsReactiveGraphQLContextBuilder");
            return new DgsWebFluxGraphQLInterceptor(dgsDataLoaderProvider, defaultDgsReactiveGraphQLContextBuilder);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017J\u0018\u0010\t\u001a\u00020\b2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0017J\u0012\u0010\r\u001a\u00020\u00042\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017J\u001a\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017J\u0012\u0010\u000f\u001a\u00020\u00042\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017J\u0012\u0010\u0010\u001a\u00020\u00042\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\u0012"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$WebMvcArgumentHandlerConfiguration;", "", "()V", "cookieValueResolver", "Lcom/netflix/graphql/dgs/internal/method/ArgumentResolver;", "beanFactory", "Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;", "dataBinderFactory", "Lorg/springframework/web/bind/support/WebDataBinderFactory;", "dgsWebDataBinderFactory", "adapter", "Lorg/springframework/beans/factory/ObjectProvider;", "Lorg/springframework/web/servlet/mvc/method/annotation/RequestMappingHandlerAdapter;", "requestHeaderMapResolver", "requestHeaderResolver", "requestParamMapResolver", "requestParamResolver", "Dgs", "graphql-dgs-spring-graphql"})
    public static class WebMvcArgumentHandlerConfiguration {
        @Bean
        @Dgs
        @NotNull
        public WebDataBinderFactory dgsWebDataBinderFactory(@Qualifier(value="requestMappingHandlerAdapter") @NotNull ObjectProvider<RequestMappingHandlerAdapter> adapter) {
            Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
            RequestMappingHandlerAdapter requestMappingHandlerAdapter = (RequestMappingHandlerAdapter)adapter.getIfAvailable();
            return (WebDataBinderFactory)new ServletRequestDataBinderFactory(CollectionsKt.emptyList(), (WebBindingInitializer)(requestMappingHandlerAdapter != null ? requestMappingHandlerAdapter.getWebBindingInitializer() : null));
        }

        @Bean
        @NotNull
        public ArgumentResolver requestHeaderMapResolver(@Dgs @NotNull WebDataBinderFactory dataBinderFactory) {
            Intrinsics.checkNotNullParameter((Object)dataBinderFactory, (String)"dataBinderFactory");
            return new HandlerMethodArgumentResolverAdapter((HandlerMethodArgumentResolver)new RequestHeaderMapMethodArgumentResolver(), dataBinderFactory);
        }

        @Bean
        @NotNull
        public ArgumentResolver requestHeaderResolver(@NotNull ConfigurableBeanFactory beanFactory, @Dgs @NotNull WebDataBinderFactory dataBinderFactory) {
            Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
            Intrinsics.checkNotNullParameter((Object)dataBinderFactory, (String)"dataBinderFactory");
            return new HandlerMethodArgumentResolverAdapter((HandlerMethodArgumentResolver)new org.springframework.web.method.annotation.RequestHeaderMethodArgumentResolver(beanFactory), dataBinderFactory);
        }

        @Bean
        @NotNull
        public ArgumentResolver requestParamResolver(@Dgs @NotNull WebDataBinderFactory dataBinderFactory) {
            Intrinsics.checkNotNullParameter((Object)dataBinderFactory, (String)"dataBinderFactory");
            return new HandlerMethodArgumentResolverAdapter((HandlerMethodArgumentResolver)new org.springframework.web.method.annotation.RequestParamMethodArgumentResolver(false), dataBinderFactory);
        }

        @Bean
        @NotNull
        public ArgumentResolver requestParamMapResolver(@Dgs @NotNull WebDataBinderFactory dataBinderFactory) {
            Intrinsics.checkNotNullParameter((Object)dataBinderFactory, (String)"dataBinderFactory");
            return new HandlerMethodArgumentResolverAdapter((HandlerMethodArgumentResolver)new RequestParamMapMethodArgumentResolver(), dataBinderFactory);
        }

        @Bean
        @NotNull
        public ArgumentResolver cookieValueResolver(@NotNull ConfigurableBeanFactory beanFactory, @Dgs @NotNull WebDataBinderFactory dataBinderFactory) {
            Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
            Intrinsics.checkNotNullParameter((Object)dataBinderFactory, (String)"dataBinderFactory");
            return new HandlerMethodArgumentResolverAdapter((HandlerMethodArgumentResolver)new ServletCookieValueMethodArgumentResolver(beanFactory), dataBinderFactory);
        }

        @Qualifier
        @Retention(value=RetentionPolicy.RUNTIME)
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0083\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$WebMvcArgumentHandlerConfiguration$Dgs;", "", "graphql-dgs-spring-graphql"})
        private static @interface Dgs {
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$WebMvcConfiguration;", "", "dgsSpringGraphQLConfigurationProperties", "Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLConfigurationProperties;", "(Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLConfigurationProperties;)V", "dgsGraphQlInterceptor", "Lcom/netflix/graphql/dgs/springgraphql/webmvc/DgsWebMvcGraphQLInterceptor;", "dgsDataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "dgsDefaultContextBuilder", "Lcom/netflix/graphql/dgs/internal/DefaultDgsGraphQLContextBuilder;", "graphQLContextContributors", "", "Lcom/netflix/graphql/dgs/context/GraphQLContextContributor;", "graphql-dgs-spring-graphql"})
    public static class WebMvcConfiguration {
        @NotNull
        private final DgsSpringGraphQLConfigurationProperties dgsSpringGraphQLConfigurationProperties;

        public WebMvcConfiguration(@NotNull DgsSpringGraphQLConfigurationProperties dgsSpringGraphQLConfigurationProperties) {
            Intrinsics.checkNotNullParameter((Object)dgsSpringGraphQLConfigurationProperties, (String)"dgsSpringGraphQLConfigurationProperties");
            this.dgsSpringGraphQLConfigurationProperties = dgsSpringGraphQLConfigurationProperties;
        }

        @Bean
        @NotNull
        public DgsWebMvcGraphQLInterceptor dgsGraphQlInterceptor(@NotNull DgsDataLoaderProvider dgsDataLoaderProvider, @NotNull DefaultDgsGraphQLContextBuilder dgsDefaultContextBuilder, @NotNull List<? extends GraphQLContextContributor> graphQLContextContributors) {
            Intrinsics.checkNotNullParameter((Object)dgsDataLoaderProvider, (String)"dgsDataLoaderProvider");
            Intrinsics.checkNotNullParameter((Object)dgsDefaultContextBuilder, (String)"dgsDefaultContextBuilder");
            Intrinsics.checkNotNullParameter(graphQLContextContributors, (String)"graphQLContextContributors");
            return new DgsWebMvcGraphQLInterceptor(dgsDataLoaderProvider, dgsDefaultContextBuilder, this.dgsSpringGraphQLConfigurationProperties, graphQLContextContributors);
        }
    }
}

