/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.springgraphql.conditions;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/conditions/OnDgsReloadCondition;", "Lorg/springframework/boot/autoconfigure/condition/SpringBootCondition;", "()V", "getMatchOutcome", "Lorg/springframework/boot/autoconfigure/condition/ConditionOutcome;", "context", "Lorg/springframework/context/annotation/ConditionContext;", "metadata", "Lorg/springframework/core/type/AnnotatedTypeMetadata;", "Companion", "graphql-dgs-spring-graphql"})
public final class OnDgsReloadCondition
extends SpringBootCondition {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public ConditionOutcome getMatchOutcome(@Nullable ConditionContext context, @Nullable AnnotatedTypeMetadata metadata) {
        ConditionContext conditionContext = context;
        Intrinsics.checkNotNull((Object)conditionContext);
        Environment environment = conditionContext.getEnvironment();
        Intrinsics.checkNotNull((Object)environment);
        boolean reloadEnabled = Companion.evaluate(environment);
        return reloadEnabled ? ConditionOutcome.match((String)"DgsReload enabled.") : ConditionOutcome.noMatch((String)"DgsReload disabled");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/conditions/OnDgsReloadCondition$Companion;", "", "()V", "evaluate", "", "environment", "Lorg/springframework/core/env/Environment;", "graphql-dgs-spring-graphql"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean evaluate(@NotNull Environment environment) {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            String[] stringArray = environment.getActiveProfiles();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getActiveProfiles(...)");
            boolean isLaptopProfile = ArraysKt.contains((Object[])stringArray, (Object)"laptop");
            Boolean reloadEnabled = (Boolean)environment.getProperty("dgs.reload", Boolean.TYPE, (Object)isLaptopProfile);
            Intrinsics.checkNotNull((Object)reloadEnabled);
            return reloadEnabled;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

