/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.springgraphql.autoconfig;

import com.netflix.graphql.dgs.internal.DefaultDgsQueryExecutor;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import com.netflix.graphql.dgs.springgraphql.DgsGraphQLSourceBuilder;
import com.netflix.graphql.dgs.springgraphql.ReloadableGraphQLSource;
import com.netflix.graphql.dgs.springgraphql.autoconfig.DgsSpringGraphQLAutoConfiguration;
import com.netflix.graphql.dgs.springgraphql.autoconfig.ExceptionHandlerResolverAdapter;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.instrumentation.Instrumentation;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.graphql.GraphQlProperties;
import org.springframework.boot.autoconfigure.graphql.GraphQlSourceBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.graphql.execution.DataFetcherExceptionResolver;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;
import org.springframework.graphql.execution.SchemaReport;
import org.springframework.graphql.execution.SubscriptionExceptionResolver;

@AutoConfiguration
@AutoConfigureBefore(name={"org.springframework.boot.autoconfigure.graphql.GraphQlAutoConfiguration"})
@AutoConfigureAfter(name={"com.netflix.graphql.dgs.autoconfig.DgsAutoConfiguration"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Jp\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLSourceAutoConfiguration;", "", "()V", "logger", "Lorg/apache/commons/logging/Log;", "kotlin.jvm.PlatformType", "graphQlSource", "Lorg/springframework/graphql/execution/GraphQlSource;", "properties", "Lorg/springframework/boot/autoconfigure/graphql/GraphQlProperties;", "dgsSchemaProvider", "Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "exceptionResolvers", "Lorg/springframework/beans/factory/ObjectProvider;", "Lorg/springframework/graphql/execution/DataFetcherExceptionResolver;", "subscriptionExceptionResolvers", "Lorg/springframework/graphql/execution/SubscriptionExceptionResolver;", "instrumentations", "Lgraphql/execution/instrumentation/Instrumentation;", "wiringConfigurers", "Lorg/springframework/graphql/execution/RuntimeWiringConfigurer;", "sourceCustomizers", "Lorg/springframework/boot/autoconfigure/graphql/GraphQlSourceBuilderCustomizer;", "reloadSchemaIndicator", "Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor$ReloadSchemaIndicator;", "defaultExceptionHandler", "Lgraphql/execution/DataFetcherExceptionHandler;", "graphql-dgs-spring-graphql"})
public class DgsSpringGraphQLSourceAutoConfiguration {
    private final Log logger = LogFactory.getLog(DgsSpringGraphQLAutoConfiguration.class);

    @Bean
    @NotNull
    public GraphQlSource graphQlSource(@NotNull GraphQlProperties properties, @NotNull DgsSchemaProvider dgsSchemaProvider, @NotNull ObjectProvider<DataFetcherExceptionResolver> exceptionResolvers, @NotNull ObjectProvider<SubscriptionExceptionResolver> subscriptionExceptionResolvers, @NotNull ObjectProvider<Instrumentation> instrumentations, @NotNull ObjectProvider<RuntimeWiringConfigurer> wiringConfigurers, @NotNull ObjectProvider<GraphQlSourceBuilderCustomizer> sourceCustomizers, @NotNull DefaultDgsQueryExecutor.ReloadSchemaIndicator reloadSchemaIndicator, @NotNull DataFetcherExceptionHandler defaultExceptionHandler) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)dgsSchemaProvider, (String)"dgsSchemaProvider");
        Intrinsics.checkNotNullParameter(exceptionResolvers, (String)"exceptionResolvers");
        Intrinsics.checkNotNullParameter(subscriptionExceptionResolvers, (String)"subscriptionExceptionResolvers");
        Intrinsics.checkNotNullParameter(instrumentations, (String)"instrumentations");
        Intrinsics.checkNotNullParameter(wiringConfigurers, (String)"wiringConfigurers");
        Intrinsics.checkNotNullParameter(sourceCustomizers, (String)"sourceCustomizers");
        Intrinsics.checkNotNullParameter((Object)reloadSchemaIndicator, (String)"reloadSchemaIndicator");
        Intrinsics.checkNotNullParameter((Object)defaultExceptionHandler, (String)"defaultExceptionHandler");
        List list = exceptionResolvers.orderedStream().toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        List dataFetcherExceptionResolvers = CollectionsKt.toMutableList((Collection)list);
        dataFetcherExceptionResolvers.add(new ExceptionHandlerResolverAdapter(defaultExceptionHandler));
        GraphQlSource.SchemaResourceBuilder builder = (GraphQlSource.SchemaResourceBuilder)((GraphQlSource.SchemaResourceBuilder)((GraphQlSource.SchemaResourceBuilder)new DgsGraphQLSourceBuilder(dgsSchemaProvider).exceptionResolvers(dataFetcherExceptionResolvers)).subscriptionExceptionResolvers(subscriptionExceptionResolvers.orderedStream().toList())).instrumentation(instrumentations.orderedStream().toList());
        if (properties.getSchema().getInspection().isEnabled()) {
            builder.inspectSchemaMappings(arg_0 -> DgsSpringGraphQLSourceAutoConfiguration.graphQlSource$lambda$0(this, arg_0));
        }
        wiringConfigurers.orderedStream().forEach(arg_0 -> DgsSpringGraphQLSourceAutoConfiguration.graphQlSource$lambda$1((Function1)new Function1<RuntimeWiringConfigurer, Unit>(builder){
            final /* synthetic */ GraphQlSource.SchemaResourceBuilder $builder;
            {
                this.$builder = $builder;
                super(1);
            }

            public final void invoke(@NotNull RuntimeWiringConfigurer configurer) {
                Intrinsics.checkNotNullParameter((Object)configurer, (String)"configurer");
                this.$builder.configureRuntimeWiring(configurer);
            }
        }, arg_0));
        sourceCustomizers.orderedStream().forEach(arg_0 -> DgsSpringGraphQLSourceAutoConfiguration.graphQlSource$lambda$2((Function1)new Function1<GraphQlSourceBuilderCustomizer, Unit>(builder){
            final /* synthetic */ GraphQlSource.SchemaResourceBuilder $builder;
            {
                this.$builder = $builder;
                super(1);
            }

            public final void invoke(@NotNull GraphQlSourceBuilderCustomizer customizer) {
                Intrinsics.checkNotNullParameter((Object)customizer, (String)"customizer");
                customizer.customize(this.$builder);
            }
        }, arg_0));
        Intrinsics.checkNotNull((Object)builder);
        return new ReloadableGraphQLSource((GraphQlSource.Builder)builder, reloadSchemaIndicator);
    }

    private static final void graphQlSource$lambda$0(DgsSpringGraphQLSourceAutoConfiguration this$0, SchemaReport message) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.logger.info((Object)message);
    }

    private static final void graphQlSource$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void graphQlSource$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

