/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.springgraphql.webmvc;

import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.internal.DefaultDgsGraphQLContextBuilder;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.DgsWebMvcRequestData;
import com.netflix.graphql.dgs.springgraphql.autoconfig.DgsSpringGraphQLConfigurationProperties;
import graphql.ExecutionInput;
import graphql.GraphQLContext;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoaderRegistry;
import org.jetbrains.annotations.NotNull;
import org.springframework.graphql.server.WebGraphQlInterceptor;
import org.springframework.graphql.server.WebGraphQlRequest;
import org.springframework.graphql.server.WebGraphQlResponse;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/webmvc/DgsWebMvcGraphQLInterceptor;", "Lorg/springframework/graphql/server/WebGraphQlInterceptor;", "dgsDataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "dgsContextBuilder", "Lcom/netflix/graphql/dgs/internal/DefaultDgsGraphQLContextBuilder;", "dgsSpringConfigurationProperties", "Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLConfigurationProperties;", "(Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;Lcom/netflix/graphql/dgs/internal/DefaultDgsGraphQLContextBuilder;Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLConfigurationProperties;)V", "intercept", "Lreactor/core/publisher/Mono;", "Lorg/springframework/graphql/server/WebGraphQlResponse;", "request", "Lorg/springframework/graphql/server/WebGraphQlRequest;", "chain", "Lorg/springframework/graphql/server/WebGraphQlInterceptor$Chain;", "graphql-dgs-spring-graphql"})
public final class DgsWebMvcGraphQLInterceptor
implements WebGraphQlInterceptor {
    @NotNull
    private final DgsDataLoaderProvider dgsDataLoaderProvider;
    @NotNull
    private final DefaultDgsGraphQLContextBuilder dgsContextBuilder;
    @NotNull
    private final DgsSpringGraphQLConfigurationProperties dgsSpringConfigurationProperties;

    public DgsWebMvcGraphQLInterceptor(@NotNull DgsDataLoaderProvider dgsDataLoaderProvider, @NotNull DefaultDgsGraphQLContextBuilder dgsContextBuilder, @NotNull DgsSpringGraphQLConfigurationProperties dgsSpringConfigurationProperties) {
        Intrinsics.checkNotNullParameter((Object)dgsDataLoaderProvider, (String)"dgsDataLoaderProvider");
        Intrinsics.checkNotNullParameter((Object)dgsContextBuilder, (String)"dgsContextBuilder");
        Intrinsics.checkNotNullParameter((Object)dgsSpringConfigurationProperties, (String)"dgsSpringConfigurationProperties");
        this.dgsDataLoaderProvider = dgsDataLoaderProvider;
        this.dgsContextBuilder = dgsContextBuilder;
        this.dgsSpringConfigurationProperties = dgsSpringConfigurationProperties;
    }

    @NotNull
    public Mono<WebGraphQlResponse> intercept(@NotNull WebGraphQlRequest request, @NotNull WebGraphQlInterceptor.Chain chain) {
        DgsContext dgsContext;
        ServletRequestAttributes servletRequestAttributes;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        if (RequestContextHolder.getRequestAttributes() instanceof ServletRequestAttributes) {
            RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
            Intrinsics.checkNotNull((Object)requestAttributes, (String)"null cannot be cast to non-null type org.springframework.web.context.request.ServletRequestAttributes");
            v1 = (ServletRequestAttributes)requestAttributes;
        } else {
            v1 = servletRequestAttributes = null;
        }
        if (servletRequestAttributes != null) {
            WebRequest webRequest = (WebRequest)new ServletWebRequest(servletRequestAttributes.getRequest(), servletRequestAttributes.getResponse());
            dgsContext = this.dgsContextBuilder.build(new DgsWebMvcRequestData(request.getExtensions(), request.getHeaders(), webRequest));
        } else {
            dgsContext = this.dgsContextBuilder.build(new DgsWebMvcRequestData(request.getExtensions(), request.getHeaders(), null, 4, null));
        }
        DgsContext dgsContext2 = dgsContext;
        CompletableFuture<GraphQLContext> graphQLContextFuture = new CompletableFuture<GraphQLContext>();
        DataLoaderRegistry dataLoaderRegistry = this.dgsDataLoaderProvider.buildRegistryWithContextSupplier(() -> DgsWebMvcGraphQLInterceptor.intercept$lambda$0(graphQLContextFuture));
        request.configureExecutionInput((arg_0, arg_1) -> DgsWebMvcGraphQLInterceptor.intercept$lambda$1(dgsContext2, dataLoaderRegistry, arg_0, arg_1));
        graphQLContextFuture.complete(request.toExecutionInput().getGraphQLContext());
        if (!this.dgsSpringConfigurationProperties.getWebmvc().getAsyncdispatch().getEnabled()) {
            Object object = chain.next(request).block();
            Intrinsics.checkNotNull((Object)object);
            WebGraphQlResponse response = (WebGraphQlResponse)object;
            if (dataLoaderRegistry instanceof AutoCloseable) {
                ((AutoCloseable)dataLoaderRegistry).close();
            }
            Mono mono = Mono.just((Object)response);
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"just(...)");
            return mono;
        }
        Mono mono = chain.next(request).doFinally(arg_0 -> DgsWebMvcGraphQLInterceptor.intercept$lambda$2(dataLoaderRegistry, arg_0));
        Intrinsics.checkNotNull((Object)mono);
        return mono;
    }

    private static final GraphQLContext intercept$lambda$0(CompletableFuture $graphQLContextFuture) {
        Intrinsics.checkNotNullParameter((Object)$graphQLContextFuture, (String)"$graphQLContextFuture");
        return (GraphQLContext)$graphQLContextFuture.get();
    }

    private static final ExecutionInput intercept$lambda$1(DgsContext $dgsContext, DataLoaderRegistry $dataLoaderRegistry, ExecutionInput executionInput, ExecutionInput.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)$dgsContext, (String)"$dgsContext");
        Intrinsics.checkNotNullParameter((Object)$dataLoaderRegistry, (String)"$dataLoaderRegistry");
        return builder.context((Object)$dgsContext).graphQLContext((Consumer)$dgsContext).dataLoaderRegistry($dataLoaderRegistry).build();
    }

    private static final void intercept$lambda$2(DataLoaderRegistry $dataLoaderRegistry, SignalType it) {
        Intrinsics.checkNotNullParameter((Object)$dataLoaderRegistry, (String)"$dataLoaderRegistry");
        if ($dataLoaderRegistry instanceof AutoCloseable) {
            ((AutoCloseable)$dataLoaderRegistry).close();
        }
    }
}

