/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.webflux.autoconfiguration;

import com.netflix.graphql.dgs.internal.CookieValueResolver;
import com.netflix.graphql.dgs.internal.DefaultDgsQueryExecutor;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import com.netflix.graphql.dgs.reactive.DgsReactiveCustomContextBuilderWithRequest;
import com.netflix.graphql.dgs.reactive.DgsReactiveQueryExecutor;
import com.netflix.graphql.dgs.reactive.internal.DefaultDgsReactiveGraphQLContextBuilder;
import com.netflix.graphql.dgs.reactive.internal.DefaultDgsReactiveQueryExecutor;
import com.netflix.graphql.dgs.reactive.internal.FluxDataFetcherResultProcessor;
import com.netflix.graphql.dgs.reactive.internal.MonoDataFetcherResultProcessor;
import com.netflix.graphql.dgs.webflux.autoconfiguration.DgsWebfluxConfigurationProperties;
import com.netflix.graphql.dgs.webflux.autoconfiguration.GraphiQlConfigurer;
import com.netflix.graphql.dgs.webflux.handlers.DgsReactiveWebsocketHandler;
import com.netflix.graphql.dgs.webflux.handlers.DgsWebfluxHttpHandler;
import com.netflix.graphql.dgs.webflux.handlers.WebFluxCookieValueResolver;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.AsyncSerialExecutionStrategy;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.schema.GraphQLSchema;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.function.server.ServerResponseExtensionsKt;
import org.springframework.web.reactive.handler.SimpleUrlHandlerMapping;
import org.springframework.web.reactive.socket.server.support.WebSocketHandlerAdapter;
import reactor.core.publisher.Mono;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Configuration
@EnableConfigurationProperties(value={DgsWebfluxConfigurationProperties.class})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0017J~\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\b\u0001\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u000e\b\u0001\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001c2\u0006\u0010!\u001a\u00020\"H\u0017J\b\u0010#\u001a\u00020$H\u0017J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0002\u001a\u00020\u0003H\u0017J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0017J\n\u0010(\u001a\u0004\u0018\u00010)H\u0017J\b\u0010*\u001a\u00020+H\u0017J\u001a\u0010,\u001a\u00020\u00142\u0010\u0010-\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030.0\u001cH\u0017J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u00100\u001a\u000201H\u0017J\u0010\u00102\u001a\u0002032\u0006\u0010\n\u001a\u00020\tH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebFluxAutoConfiguration;", "", "configProps", "Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties;", "(Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties;)V", "dgsGraphQlRouter", "Lorg/springframework/web/reactive/function/server/RouterFunction;", "Lorg/springframework/web/reactive/function/server/ServerResponse;", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/reactive/DgsReactiveQueryExecutor;", "dgsReactiveQueryExecutor", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "schema", "Lgraphql/schema/GraphQLSchema;", "schemaProvider", "Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "dgsDataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "dgsContextBuilder", "Lcom/netflix/graphql/dgs/reactive/internal/DefaultDgsReactiveGraphQLContextBuilder;", "dataFetcherExceptionHandler", "Lgraphql/execution/DataFetcherExceptionHandler;", "chainedInstrumentation", "Lgraphql/execution/instrumentation/ChainedInstrumentation;", "environment", "Lorg/springframework/core/env/Environment;", "providedQueryExecutionStrategy", "Ljava/util/Optional;", "Lgraphql/execution/ExecutionStrategy;", "providedMutationExecutionStrategy", "idProvider", "Lgraphql/execution/ExecutionIdProvider;", "reloadSchemaIndicator", "Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor$ReloadSchemaIndicator;", "fluxReactiveDataFetcherResultProcessor", "Lcom/netflix/graphql/dgs/reactive/internal/FluxDataFetcherResultProcessor;", "graphiQlConfigurer", "Lcom/netflix/graphql/dgs/webflux/autoconfiguration/GraphiQlConfigurer;", "graphiQlIndexRedirect", "handlerAdapter", "Lorg/springframework/web/reactive/socket/server/support/WebSocketHandlerAdapter;", "monoReactiveDataFetcherResultProcessor", "Lcom/netflix/graphql/dgs/reactive/internal/MonoDataFetcherResultProcessor;", "reactiveGraphQlContextBuilder", "dgsReactiveCustomContextBuilderWithRequest", "Lcom/netflix/graphql/dgs/reactive/DgsReactiveCustomContextBuilderWithRequest;", "schemaRouter", "webfluxCookieResolver", "Lcom/netflix/graphql/dgs/internal/CookieValueResolver;", "websocketSubscriptionHandler", "Lorg/springframework/web/reactive/handler/SimpleUrlHandlerMapping;", "graphql-dgs-spring-webflux-autoconfigure"})
public class DgsWebFluxAutoConfiguration {
    @NotNull
    private final DgsWebfluxConfigurationProperties configProps;

    public DgsWebFluxAutoConfiguration(@NotNull DgsWebfluxConfigurationProperties configProps) {
        Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
        this.configProps = configProps;
    }

    @Bean
    @NotNull
    public DgsReactiveQueryExecutor dgsReactiveQueryExecutor(@NotNull ApplicationContext applicationContext, @NotNull GraphQLSchema schema, @NotNull DgsSchemaProvider schemaProvider, @NotNull DgsDataLoaderProvider dgsDataLoaderProvider, @NotNull DefaultDgsReactiveGraphQLContextBuilder dgsContextBuilder, @NotNull DataFetcherExceptionHandler dataFetcherExceptionHandler, @NotNull ChainedInstrumentation chainedInstrumentation, @NotNull Environment environment, @Qualifier(value="query") @NotNull Optional<ExecutionStrategy> providedQueryExecutionStrategy, @Qualifier(value="mutation") @NotNull Optional<ExecutionStrategy> providedMutationExecutionStrategy, @NotNull Optional<ExecutionIdProvider> idProvider, @NotNull DefaultDgsQueryExecutor.ReloadSchemaIndicator reloadSchemaIndicator) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)schemaProvider, (String)"schemaProvider");
        Intrinsics.checkNotNullParameter((Object)dgsDataLoaderProvider, (String)"dgsDataLoaderProvider");
        Intrinsics.checkNotNullParameter((Object)dgsContextBuilder, (String)"dgsContextBuilder");
        Intrinsics.checkNotNullParameter((Object)dataFetcherExceptionHandler, (String)"dataFetcherExceptionHandler");
        Intrinsics.checkNotNullParameter((Object)chainedInstrumentation, (String)"chainedInstrumentation");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(providedQueryExecutionStrategy, (String)"providedQueryExecutionStrategy");
        Intrinsics.checkNotNullParameter(providedMutationExecutionStrategy, (String)"providedMutationExecutionStrategy");
        Intrinsics.checkNotNullParameter(idProvider, (String)"idProvider");
        Intrinsics.checkNotNullParameter((Object)reloadSchemaIndicator, (String)"reloadSchemaIndicator");
        ExecutionStrategy queryExecutionStrategy = providedQueryExecutionStrategy.orElse((ExecutionStrategy)new AsyncExecutionStrategy(dataFetcherExceptionHandler));
        ExecutionStrategy mutationExecutionStrategy = providedMutationExecutionStrategy.orElse((ExecutionStrategy)new AsyncSerialExecutionStrategy(dataFetcherExceptionHandler));
        Intrinsics.checkNotNullExpressionValue((Object)queryExecutionStrategy, (String)"queryExecutionStrategy");
        Intrinsics.checkNotNullExpressionValue((Object)mutationExecutionStrategy, (String)"mutationExecutionStrategy");
        return (DgsReactiveQueryExecutor)new DefaultDgsReactiveQueryExecutor(schema, schemaProvider, dgsDataLoaderProvider, dgsContextBuilder, chainedInstrumentation, queryExecutionStrategy, mutationExecutionStrategy, idProvider, reloadSchemaIndicator, null, 512, null);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DefaultDgsReactiveGraphQLContextBuilder reactiveGraphQlContextBuilder(@NotNull Optional<DgsReactiveCustomContextBuilderWithRequest<?>> dgsReactiveCustomContextBuilderWithRequest) {
        Intrinsics.checkNotNullParameter(dgsReactiveCustomContextBuilderWithRequest, (String)"dgsReactiveCustomContextBuilderWithRequest");
        return new DefaultDgsReactiveGraphQLContextBuilder(dgsReactiveCustomContextBuilderWithRequest);
    }

    @Bean
    @ConditionalOnProperty(name={"dgs.graphql.graphiql.enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public GraphiQlConfigurer graphiQlConfigurer(@NotNull DgsWebfluxConfigurationProperties configProps) {
        Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
        return new GraphiQlConfigurer(configProps);
    }

    @Bean
    @ConditionalOnProperty(name={"dgs.graphql.graphiql.enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public RouterFunction<ServerResponse> graphiQlIndexRedirect() {
        RouterFunction routerFunction = RouterFunctions.route().GET("/graphiql", DgsWebFluxAutoConfiguration::graphiQlIndexRedirect$lambda-0).build();
        Intrinsics.checkNotNullExpressionValue((Object)routerFunction, (String)"route().GET(\"/graphiql\") {\n            permanentRedirect(URI.create(\"/graphiql/index.html\")).build()\n        }.build()");
        return routerFunction;
    }

    @Bean
    @NotNull
    public RouterFunction<ServerResponse> dgsGraphQlRouter(@NotNull DgsReactiveQueryExecutor dgsQueryExecutor) {
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        DgsWebfluxHttpHandler graphQlHandler = new DgsWebfluxHttpHandler(dgsQueryExecutor);
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON, MediaType.valueOf((String)"application/graphql")};
        RouterFunction routerFunction = RouterFunctions.route().POST(this.configProps.getPath(), RequestPredicates.accept((MediaType[])mediaTypeArray), graphQlHandler::graphql).build();
        Intrinsics.checkNotNullExpressionValue((Object)routerFunction, (String)"route()\n            .POST(\n                configProps.path, accept(MediaType.APPLICATION_JSON, MediaType.valueOf(\"application/graphql\")),\n                graphQlHandler::graphql\n            ).build()");
        return routerFunction;
    }

    @Bean
    @ConditionalOnProperty(name={"dgs.graphql.schema-json.enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public RouterFunction<ServerResponse> schemaRouter(@NotNull DgsSchemaProvider schemaProvider) {
        Intrinsics.checkNotNullParameter((Object)schemaProvider, (String)"schemaProvider");
        RouterFunction routerFunction = RouterFunctions.route().GET(this.configProps.getSchemaJson().getPath(), arg_0 -> DgsWebFluxAutoConfiguration.schemaRouter$lambda-3(schemaProvider, arg_0)).build();
        Intrinsics.checkNotNullExpressionValue((Object)routerFunction, (String)"route()\n            .GET(\n                configProps.schemaJson.path\n            ) {\n                val graphQLSchema: GraphQLSchema = schemaProvider.schema()\n                val graphQL = GraphQL.newGraphQL(graphQLSchema).build()\n\n                val executionInput: ExecutionInput =\n                    ExecutionInput.newExecutionInput().query(IntrospectionQuery.INTROSPECTION_QUERY)\n                        .build()\n                val execute = graphQL.executeAsync(executionInput)\n\n                return@GET Mono.fromCompletionStage(execute)\n                    .map { it.toSpecification() }\n                    .flatMap { ok().json().bodyValue(it) }\n            }.build()");
        return routerFunction;
    }

    @Bean
    @NotNull
    public SimpleUrlHandlerMapping websocketSubscriptionHandler(@NotNull DgsReactiveQueryExecutor dgsReactiveQueryExecutor) {
        Intrinsics.checkNotNullParameter((Object)dgsReactiveQueryExecutor, (String)"dgsReactiveQueryExecutor");
        SimpleUrlHandlerMapping simpleUrlHandlerMapping = new SimpleUrlHandlerMapping(MapsKt.mapOf((Pair)TuplesKt.to((Object)"/subscriptions", (Object)new DgsReactiveWebsocketHandler(dgsReactiveQueryExecutor))));
        simpleUrlHandlerMapping.setOrder(1);
        return simpleUrlHandlerMapping;
    }

    @Bean
    @Nullable
    public WebSocketHandlerAdapter handlerAdapter() {
        return new WebSocketHandlerAdapter();
    }

    @Bean
    @NotNull
    public MonoDataFetcherResultProcessor monoReactiveDataFetcherResultProcessor() {
        return new MonoDataFetcherResultProcessor();
    }

    @Bean
    @NotNull
    public FluxDataFetcherResultProcessor fluxReactiveDataFetcherResultProcessor() {
        return new FluxDataFetcherResultProcessor();
    }

    @Bean
    @NotNull
    public CookieValueResolver webfluxCookieResolver() {
        return new WebFluxCookieValueResolver();
    }

    private static final Mono graphiQlIndexRedirect$lambda-0(ServerRequest it) {
        return ServerResponse.permanentRedirect((URI)URI.create("/graphiql/index.html")).build();
    }

    private static final Map schemaRouter$lambda-3$lambda-1(ExecutionResult it) {
        return it.toSpecification();
    }

    private static final Mono schemaRouter$lambda-3$lambda-2(Map it) {
        ServerResponse.BodyBuilder bodyBuilder = ServerResponse.ok();
        Intrinsics.checkNotNullExpressionValue((Object)bodyBuilder, (String)"ok()");
        return ServerResponseExtensionsKt.json((ServerResponse.BodyBuilder)bodyBuilder).bodyValue((Object)it);
    }

    private static final Mono schemaRouter$lambda-3(DgsSchemaProvider $schemaProvider, ServerRequest it) {
        Intrinsics.checkNotNullParameter((Object)$schemaProvider, (String)"$schemaProvider");
        GraphQLSchema graphQLSchema = DgsSchemaProvider.schema$default((DgsSchemaProvider)$schemaProvider, null, null, (int)3, null);
        GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).build();
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query("\n  query IntrospectionQuery {\n    __schema {\n      queryType { name }\n      mutationType { name }\n      subscriptionType { name }\n      types {\n        ...FullType\n      }\n      directives {\n        name\n        description\n        locations\n        args {\n          ...InputValue\n        }\n        isRepeatable\n      }\n    }\n  }\n\n  fragment FullType on __Type {\n    kind\n    name\n    description\n    fields(includeDeprecated: true) {\n      name\n      description\n      args {\n        ...InputValue\n      }\n      type {\n        ...TypeRef\n      }\n      isDeprecated\n      deprecationReason\n    }\n    inputFields(includeDeprecated: true) {\n      ...InputValue\n    }\n    interfaces {\n      ...TypeRef\n    }\n    enumValues(includeDeprecated: true) {\n      name\n      description\n      isDeprecated\n      deprecationReason\n    }\n    possibleTypes {\n      ...TypeRef\n    }\n  }\n\n  fragment InputValue on __InputValue {\n    name\n    description\n    type { ...TypeRef }\n    defaultValue\n    isDeprecated\n    deprecationReason\n  }\n\nfragment TypeRef on __Type {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n          ofType {\n            kind\n            name\n            ofType {\n              kind\n              name\n              ofType {\n                kind\n                name\n                ofType {\n                  kind\n                  name\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n\n").build();
        Intrinsics.checkNotNullExpressionValue((Object)executionInput, (String)"newExecutionInput().query(IntrospectionQuery.INTROSPECTION_QUERY)\n                        .build()");
        ExecutionInput executionInput2 = executionInput;
        CompletableFuture execute = graphQL.executeAsync(executionInput2);
        return Mono.fromCompletionStage((CompletionStage)execute).map(DgsWebFluxAutoConfiguration::schemaRouter$lambda-3$lambda-1).flatMap(DgsWebFluxAutoConfiguration::schemaRouter$lambda-3$lambda-2);
    }
}

