/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.webflux.autoconfiguration;

import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.context.properties.bind.DefaultValue;

@ConstructorBinding
@ConfigurationProperties(prefix="dgs.graphql")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0013B\u0019\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties;", "", "path", "", "schemaJson", "Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties$DgsSchemaJsonConfigurationProperties;", "(Ljava/lang/String;Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties$DgsSchemaJsonConfigurationProperties;)V", "getPath", "()Ljava/lang/String;", "setPath", "(Ljava/lang/String;)V", "getSchemaJson", "()Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties$DgsSchemaJsonConfigurationProperties;", "setSchemaJson", "(Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties$DgsSchemaJsonConfigurationProperties;)V", "validatePath", "", "pathProperty", "validatePaths", "DgsSchemaJsonConfigurationProperties", "graphql-dgs-spring-webflux-autoconfigure"})
public final class DgsWebfluxConfigurationProperties {
    @NotNull
    private String path;
    @NestedConfigurationProperty
    @NotNull
    private DgsSchemaJsonConfigurationProperties schemaJson;

    public DgsWebfluxConfigurationProperties(@DefaultValue(value={"/graphql"}) @NotNull String path, @NotNull DgsSchemaJsonConfigurationProperties schemaJson) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)schemaJson, (String)"schemaJson");
        this.path = path;
        this.schemaJson = schemaJson;
    }

    public /* synthetic */ DgsWebfluxConfigurationProperties(String string, DgsSchemaJsonConfigurationProperties dgsSchemaJsonConfigurationProperties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "/graphql";
        }
        if ((n & 2) != 0) {
            dgsSchemaJsonConfigurationProperties = new DgsSchemaJsonConfigurationProperties(null, 1, null);
        }
        this(string, dgsSchemaJsonConfigurationProperties);
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final void setPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.path = string;
    }

    @NotNull
    public final DgsSchemaJsonConfigurationProperties getSchemaJson() {
        return this.schemaJson;
    }

    public final void setSchemaJson(@NotNull DgsSchemaJsonConfigurationProperties dgsSchemaJsonConfigurationProperties) {
        Intrinsics.checkNotNullParameter((Object)dgsSchemaJsonConfigurationProperties, (String)"<set-?>");
        this.schemaJson = dgsSchemaJsonConfigurationProperties;
    }

    @PostConstruct
    public final void validatePaths() {
        this.validatePath(this.path, "dgs.graphql.path");
        this.validatePath(this.schemaJson.getPath(), "dgs.graphql.schema-json.path");
    }

    private final void validatePath(String path, String pathProperty) {
        if (!(Intrinsics.areEqual((Object)path, (Object)"/") || StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null))) {
            throw new IllegalArgumentException(pathProperty + " must start with '/' and not end with '/' but was '" + path + '\'');
        }
    }

    public DgsWebfluxConfigurationProperties() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0010"}, d2={"Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties$DgsSchemaJsonConfigurationProperties;", "", "path", "", "(Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "setPath", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-dgs-spring-webflux-autoconfigure"})
    public static final class DgsSchemaJsonConfigurationProperties {
        @NotNull
        private String path;

        public DgsSchemaJsonConfigurationProperties(@DefaultValue(value={"/schema.json"}) @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.path = path;
        }

        public /* synthetic */ DgsSchemaJsonConfigurationProperties(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "/schema.json";
            }
            this(string);
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        public final void setPath(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.path = string;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final DgsSchemaJsonConfigurationProperties copy(@DefaultValue(value={"/schema.json"}) @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new DgsSchemaJsonConfigurationProperties(path);
        }

        public static /* synthetic */ DgsSchemaJsonConfigurationProperties copy$default(DgsSchemaJsonConfigurationProperties dgsSchemaJsonConfigurationProperties, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = dgsSchemaJsonConfigurationProperties.path;
            }
            return dgsSchemaJsonConfigurationProperties.copy(string);
        }

        @NotNull
        public String toString() {
            return "DgsSchemaJsonConfigurationProperties(path=" + this.path + ')';
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DgsSchemaJsonConfigurationProperties)) {
                return false;
            }
            DgsSchemaJsonConfigurationProperties dgsSchemaJsonConfigurationProperties = (DgsSchemaJsonConfigurationProperties)other;
            return Intrinsics.areEqual((Object)this.path, (Object)dgsSchemaJsonConfigurationProperties.path);
        }

        public DgsSchemaJsonConfigurationProperties() {
            this(null, 1, null);
        }
    }
}

