/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.webflux.handlers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.reactive.DgsReactiveQueryExecutor;
import com.netflix.graphql.dgs.webflux.handlers.QueryInput;
import graphql.ExecutionResult;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/netflix/graphql/dgs/webflux/handlers/DgsWebfluxHttpHandler;", "", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/reactive/DgsReactiveQueryExecutor;", "(Lcom/netflix/graphql/dgs/reactive/DgsReactiveQueryExecutor;)V", "graphql", "Lreactor/core/publisher/Mono;", "Lorg/springframework/web/reactive/function/server/ServerResponse;", "request", "Lorg/springframework/web/reactive/function/server/ServerRequest;", "Companion", "graphql-dgs-spring-webflux-autoconfigure"})
public final class DgsWebfluxHttpHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsReactiveQueryExecutor dgsQueryExecutor;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final ObjectMapper mapper;

    public DgsWebfluxHttpHandler(@NotNull DgsReactiveQueryExecutor dgsQueryExecutor) {
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        this.dgsQueryExecutor = dgsQueryExecutor;
    }

    @NotNull
    public final Mono<ServerResponse> graphql(@NotNull ServerRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Mono mono = request.bodyToMono(String.class).map(arg_0 -> DgsWebfluxHttpHandler.graphql$lambda-0(request, arg_0)).flatMap(arg_0 -> DgsWebfluxHttpHandler.graphql$lambda-1(this, request, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"request.bodyToMono(String::class.java)\n                .map {\n                    if (\"application/graphql\" == request.headers().firstHeader(\"Content-Type\")) {\n                        QueryInput(it)\n                    } else {\n                        val readValue = mapper.readValue<Map<String, Any>>(it)\n                        QueryInput(\n                            readValue[\"query\"] as String,\n\n                            (readValue[\"variables\"] ?: emptyMap<String, Any>()) as Map<String, Any>,\n                            (readValue[\"extensions\"] ?: emptyMap<String, Any>()) as Map<String, Any>,\n                        )\n                    }\n                }\n                .flatMap { queryInput ->\n                    logger.debug(\"Parsed variables: {}\", queryInput.queryVariables)\n\n                    dgsQueryExecutor.execute(\n                        queryInput.query,\n                        queryInput.queryVariables,\n                        queryInput.extensions,\n                        request.headers().asHttpHeaders(),\n                        \"\",\n                        request\n                    )\n                }");
        Mono executionResult = mono;
        mono = executionResult.flatMap(DgsWebfluxHttpHandler::graphql$lambda-2);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"executionResult.flatMap { result ->\n            val graphQlOutput = result.toSpecification()\n            ServerResponse.ok().bodyValue(graphQlOutput)\n        }");
        return mono;
    }

    /*
     * WARNING - void declaration
     */
    private static final QueryInput graphql$lambda-0(ServerRequest $request, String it) {
        QueryInput queryInput;
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        if (Intrinsics.areEqual((Object)"application/graphql", (Object)$request.headers().firstHeader("Content-Type"))) {
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            queryInput = new QueryInput(it, null, null, 6, null);
        } else {
            void $this$readValue$iv;
            Object object = mapper;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            String content$iv = it;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            Map readValue2 = (Map)$this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<Map<String, ? extends Object>>(){});
            object = readValue2.get("query");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String string = (String)object;
            object = readValue2.get("variables");
            Map map = object == null ? MapsKt.emptyMap() : object;
            object = readValue2.get("extensions");
            queryInput = new QueryInput(string, map, object == null ? MapsKt.emptyMap() : object);
        }
        return queryInput;
    }

    private static final Mono graphql$lambda-1(DgsWebfluxHttpHandler this$0, ServerRequest $request, QueryInput queryInput) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        logger.debug("Parsed variables: {}", queryInput.getQueryVariables());
        return this$0.dgsQueryExecutor.execute(queryInput.getQuery(), queryInput.getQueryVariables(), queryInput.getExtensions(), $request.headers().asHttpHeaders(), "", $request);
    }

    private static final Mono graphql$lambda-2(ExecutionResult result) {
        Map graphQlOutput = result.toSpecification();
        return ServerResponse.ok().bodyValue((Object)graphQlOutput);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DgsWebfluxHttpHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DgsWebfluxHttpHandler::class.java)");
        DgsWebfluxHttpHandler.logger = logger;
        mapper = ExtensionsKt.jacksonObjectMapper();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/netflix/graphql/dgs/webflux/handlers/DgsWebfluxHttpHandler$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "graphql-dgs-spring-webflux-autoconfigure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

