/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.webflux.autoconfiguration;

import com.netflix.graphql.dgs.webflux.autoconfiguration.DgsWebfluxConfigurationProperties;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.io.Resource;
import org.springframework.web.reactive.config.ResourceHandlerRegistration;
import org.springframework.web.reactive.config.ResourceHandlerRegistry;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.resource.PathResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolver;
import org.springframework.web.reactive.resource.ResourceTransformer;
import org.springframework.web.reactive.resource.ResourceTransformerChain;
import org.springframework.web.reactive.resource.TransformedResource;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/netflix/graphql/dgs/webflux/autoconfiguration/GraphiQlConfigurer;", "Lorg/springframework/web/reactive/config/WebFluxConfigurer;", "configProps", "Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties;", "(Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties;)V", "addResourceHandlers", "", "registry", "Lorg/springframework/web/reactive/config/ResourceHandlerRegistry;", "TokenReplacingTransformer", "graphql-dgs-spring-webflux-autoconfigure"})
public final class GraphiQlConfigurer
implements WebFluxConfigurer {
    @NotNull
    private final DgsWebfluxConfigurationProperties configProps;

    public GraphiQlConfigurer(@NotNull DgsWebfluxConfigurationProperties configProps) {
        Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
        this.configProps = configProps;
    }

    public void addResourceHandlers(@NotNull ResourceHandlerRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        String graphqlPath = this.configProps.getPath();
        String[] stringArray = new String[]{Intrinsics.stringPlus((String)this.configProps.getGraphiql().getPath(), (Object)"/**")};
        ResourceHandlerRegistration resourceHandlerRegistration = registry.addResourceHandler(stringArray);
        stringArray = new String[]{"classpath:/static/graphiql/"};
        resourceHandlerRegistration.addResourceLocations(stringArray).resourceChain(true).addResolver((ResourceResolver)new PathResourceResolver()).addTransformer((ResourceTransformer)new TokenReplacingTransformer("<DGS_GRAPHQL_PATH>", graphqlPath, this.configProps));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J&\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/netflix/graphql/dgs/webflux/autoconfiguration/GraphiQlConfigurer$TokenReplacingTransformer;", "Lorg/springframework/web/reactive/resource/ResourceTransformer;", "replaceToken", "", "replaceValue", "configProps", "Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties;", "(Ljava/lang/String;Ljava/lang/String;Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties;)V", "transform", "Lreactor/core/publisher/Mono;", "Lorg/springframework/core/io/Resource;", "exchange", "Lorg/springframework/web/server/ServerWebExchange;", "resource", "transformerChain", "Lorg/springframework/web/reactive/resource/ResourceTransformerChain;", "graphql-dgs-spring-webflux-autoconfigure"})
    public static final class TokenReplacingTransformer
    implements ResourceTransformer {
        @NotNull
        private final String replaceToken;
        @NotNull
        private final String replaceValue;
        @NotNull
        private final DgsWebfluxConfigurationProperties configProps;

        public TokenReplacingTransformer(@NotNull String replaceToken, @NotNull String replaceValue, @NotNull DgsWebfluxConfigurationProperties configProps) {
            Intrinsics.checkNotNullParameter((Object)replaceToken, (String)"replaceToken");
            Intrinsics.checkNotNullParameter((Object)replaceValue, (String)"replaceValue");
            Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
            this.replaceToken = replaceToken;
            this.replaceValue = replaceValue;
            this.configProps = configProps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Mono<Resource> transform(@NotNull ServerWebExchange exchange, @NotNull Resource resource, @NotNull ResourceTransformerChain transformerChain) throws IOException {
            Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Intrinsics.checkNotNullParameter((Object)transformerChain, (String)"transformerChain");
            String string = exchange.getRequest().getURI().toASCIIString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"exchange.request.uri.toASCIIString()");
            if (StringsKt.endsWith$default((String)string, (String)Intrinsics.stringPlus((String)this.configProps.getGraphiql().getPath(), (Object)"/index.html"), (boolean)false, (int)2, null)) {
                Closeable closeable = resource.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)closeable, (String)"resource.inputStream");
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                Object object = closeable;
                int n = 0;
                object = new InputStreamReader((InputStream)object, charset);
                n = 8192;
                boolean bl2 = false;
                closeable = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
                boolean bl3 = false;
                bl = false;
                Object object2 = null;
                try {
                    BufferedReader p0 = (BufferedReader)closeable;
                    boolean bl4 = false;
                    object = TextStreamsKt.readText((Reader)p0);
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
                }
                Object content = object;
                String string2 = StringsKt.replace$default((String)content, (String)this.replaceToken, (String)this.replaceValue, (boolean)false, (int)4, null);
                object2 = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"UTF_8");
                boolean bl5 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string3.getBytes((Charset)object2);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                closeable = Mono.just((Object)new TransformedResource(resource, byArray));
                Intrinsics.checkNotNullExpressionValue((Object)closeable, (String)"just(\n                    TransformedResource(\n                        resource,\n                        content.replace(replaceToken, replaceValue).toByteArray(\n                            StandardCharsets.UTF_8\n                        )\n                    )\n                )");
                return closeable;
            }
            string = Mono.just((Object)resource);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"just(resource)");
            return string;
        }
    }
}

