/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.webflux.autoconfiguration;

import com.netflix.graphql.dgs.internal.CookieValueResolver;
import com.netflix.graphql.dgs.internal.DefaultDgsQueryExecutor;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import com.netflix.graphql.dgs.internal.FluxDataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.MonoDataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.QueryValueCustomizer;
import com.netflix.graphql.dgs.reactive.DgsReactiveCustomContextBuilderWithRequest;
import com.netflix.graphql.dgs.reactive.DgsReactiveQueryExecutor;
import com.netflix.graphql.dgs.reactive.internal.DefaultDgsReactiveGraphQLContextBuilder;
import com.netflix.graphql.dgs.reactive.internal.DefaultDgsReactiveQueryExecutor;
import com.netflix.graphql.dgs.webflux.autoconfiguration.DgsWebfluxConfigurationProperties;
import com.netflix.graphql.dgs.webflux.autoconfiguration.GraphiQlConfigurer;
import com.netflix.graphql.dgs.webflux.handlers.DefaultDgsWebfluxHttpHandler;
import com.netflix.graphql.dgs.webflux.handlers.DgsHandshakeWebSocketService;
import com.netflix.graphql.dgs.webflux.handlers.DgsReactiveWebsocketHandler;
import com.netflix.graphql.dgs.webflux.handlers.DgsWebfluxHttpHandler;
import com.netflix.graphql.dgs.webflux.handlers.WebFluxCookieValueResolver;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.AsyncSerialExecutionStrategy;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.GraphQLSchema;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.function.server.ServerResponseExtensionsKt;
import org.springframework.web.reactive.handler.SimpleUrlHandlerMapping;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.reactive.socket.server.WebSocketService;
import org.springframework.web.reactive.socket.server.support.WebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.server.upgrade.ReactorNettyRequestUpgradeStrategy;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.WebsocketServerSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Configuration
@EnableConfigurationProperties(value={DgsWebfluxConfigurationProperties.class})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0017J\u008e\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u000e\b\u0001\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u000e\b\u0001\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0017J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u000bH\u0017J\b\u0010)\u001a\u00020*H\u0017J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u0002\u001a\u00020\u0003H\u0017J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0017J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u000201H\u0017J\b\u00102\u001a\u000203H\u0017J\u001a\u00104\u001a\u00020\u00152\u0010\u00105\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003060\u001dH\u0017J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\b\u00100\u001a\u000201H\u0017J\b\u00108\u001a\u000209H\u0017J\u0010\u0010:\u001a\u00020;2\u0006\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebFluxAutoConfiguration;", "", "configProps", "Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties;", "(Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties;)V", "dgsGraphQlRouter", "Lorg/springframework/web/reactive/function/server/RouterFunction;", "Lorg/springframework/web/reactive/function/server/ServerResponse;", "dgsWebfluxHttpHandler", "Lcom/netflix/graphql/dgs/webflux/handlers/DgsWebfluxHttpHandler;", "dgsReactiveQueryExecutor", "Lcom/netflix/graphql/dgs/reactive/DgsReactiveQueryExecutor;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "schema", "Lgraphql/schema/GraphQLSchema;", "schemaProvider", "Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "dgsDataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "dgsContextBuilder", "Lcom/netflix/graphql/dgs/reactive/internal/DefaultDgsReactiveGraphQLContextBuilder;", "dataFetcherExceptionHandler", "Lgraphql/execution/DataFetcherExceptionHandler;", "chainedInstrumentation", "Lgraphql/execution/instrumentation/ChainedInstrumentation;", "environment", "Lorg/springframework/core/env/Environment;", "providedQueryExecutionStrategy", "Ljava/util/Optional;", "Lgraphql/execution/ExecutionStrategy;", "providedMutationExecutionStrategy", "idProvider", "Lgraphql/execution/ExecutionIdProvider;", "reloadSchemaIndicator", "Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor$ReloadSchemaIndicator;", "preparsedDocumentProvider", "Lgraphql/execution/preparsed/PreparsedDocumentProvider;", "queryValueCustomizer", "Lcom/netflix/graphql/dgs/internal/QueryValueCustomizer;", "dgsQueryExecutor", "fluxReactiveDataFetcherResultProcessor", "Lcom/netflix/graphql/dgs/internal/FluxDataFetcherResultProcessor;", "graphiQlConfigurer", "Lcom/netflix/graphql/dgs/webflux/autoconfiguration/GraphiQlConfigurer;", "graphiQlIndexRedirect", "handlerAdapter", "Lorg/springframework/web/reactive/socket/server/support/WebSocketHandlerAdapter;", "webSocketService", "Lorg/springframework/web/reactive/socket/server/WebSocketService;", "monoReactiveDataFetcherResultProcessor", "Lcom/netflix/graphql/dgs/internal/MonoDataFetcherResultProcessor;", "reactiveGraphQlContextBuilder", "dgsReactiveCustomContextBuilderWithRequest", "Lcom/netflix/graphql/dgs/reactive/DgsReactiveCustomContextBuilderWithRequest;", "schemaRouter", "webfluxCookieResolver", "Lcom/netflix/graphql/dgs/internal/CookieValueResolver;", "websocketSubscriptionHandler", "Lorg/springframework/web/reactive/handler/SimpleUrlHandlerMapping;", "graphql-dgs-spring-webflux-autoconfigure"})
public class DgsWebFluxAutoConfiguration {
    @NotNull
    private final DgsWebfluxConfigurationProperties configProps;

    public DgsWebFluxAutoConfiguration(@NotNull DgsWebfluxConfigurationProperties configProps) {
        Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
        this.configProps = configProps;
    }

    @Bean
    @NotNull
    public DgsReactiveQueryExecutor dgsReactiveQueryExecutor(@NotNull ApplicationContext applicationContext, @NotNull GraphQLSchema schema, @NotNull DgsSchemaProvider schemaProvider, @NotNull DgsDataLoaderProvider dgsDataLoaderProvider, @NotNull DefaultDgsReactiveGraphQLContextBuilder dgsContextBuilder, @NotNull DataFetcherExceptionHandler dataFetcherExceptionHandler, @NotNull ChainedInstrumentation chainedInstrumentation, @NotNull Environment environment, @Qualifier(value="query") @NotNull Optional<ExecutionStrategy> providedQueryExecutionStrategy, @Qualifier(value="mutation") @NotNull Optional<ExecutionStrategy> providedMutationExecutionStrategy, @NotNull Optional<ExecutionIdProvider> idProvider, @NotNull DefaultDgsQueryExecutor.ReloadSchemaIndicator reloadSchemaIndicator, @NotNull PreparsedDocumentProvider preparsedDocumentProvider, @NotNull QueryValueCustomizer queryValueCustomizer) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)schemaProvider, (String)"schemaProvider");
        Intrinsics.checkNotNullParameter((Object)dgsDataLoaderProvider, (String)"dgsDataLoaderProvider");
        Intrinsics.checkNotNullParameter((Object)dgsContextBuilder, (String)"dgsContextBuilder");
        Intrinsics.checkNotNullParameter((Object)dataFetcherExceptionHandler, (String)"dataFetcherExceptionHandler");
        Intrinsics.checkNotNullParameter((Object)chainedInstrumentation, (String)"chainedInstrumentation");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(providedQueryExecutionStrategy, (String)"providedQueryExecutionStrategy");
        Intrinsics.checkNotNullParameter(providedMutationExecutionStrategy, (String)"providedMutationExecutionStrategy");
        Intrinsics.checkNotNullParameter(idProvider, (String)"idProvider");
        Intrinsics.checkNotNullParameter((Object)reloadSchemaIndicator, (String)"reloadSchemaIndicator");
        Intrinsics.checkNotNullParameter((Object)preparsedDocumentProvider, (String)"preparsedDocumentProvider");
        Intrinsics.checkNotNullParameter((Object)queryValueCustomizer, (String)"queryValueCustomizer");
        ExecutionStrategy queryExecutionStrategy = providedQueryExecutionStrategy.orElse((ExecutionStrategy)new AsyncExecutionStrategy(dataFetcherExceptionHandler));
        ExecutionStrategy mutationExecutionStrategy = providedMutationExecutionStrategy.orElse((ExecutionStrategy)new AsyncSerialExecutionStrategy(dataFetcherExceptionHandler));
        Intrinsics.checkNotNullExpressionValue((Object)queryExecutionStrategy, (String)"queryExecutionStrategy");
        Intrinsics.checkNotNullExpressionValue((Object)mutationExecutionStrategy, (String)"mutationExecutionStrategy");
        return (DgsReactiveQueryExecutor)new DefaultDgsReactiveQueryExecutor(schema, schemaProvider, dgsDataLoaderProvider, dgsContextBuilder, chainedInstrumentation, queryExecutionStrategy, mutationExecutionStrategy, idProvider, reloadSchemaIndicator, preparsedDocumentProvider, queryValueCustomizer);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DefaultDgsReactiveGraphQLContextBuilder reactiveGraphQlContextBuilder(@NotNull Optional<DgsReactiveCustomContextBuilderWithRequest<?>> dgsReactiveCustomContextBuilderWithRequest) {
        Intrinsics.checkNotNullParameter(dgsReactiveCustomContextBuilderWithRequest, (String)"dgsReactiveCustomContextBuilderWithRequest");
        return new DefaultDgsReactiveGraphQLContextBuilder(dgsReactiveCustomContextBuilderWithRequest);
    }

    @Bean
    @ConditionalOnProperty(name={"dgs.graphql.graphiql.enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public GraphiQlConfigurer graphiQlConfigurer(@NotNull DgsWebfluxConfigurationProperties configProps) {
        Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
        return new GraphiQlConfigurer(configProps);
    }

    @Bean
    @ConditionalOnProperty(name={"dgs.graphql.graphiql.enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public RouterFunction<ServerResponse> graphiQlIndexRedirect() {
        RouterFunction routerFunction = RouterFunctions.route().GET(this.configProps.getGraphiql().getPath(), arg_0 -> DgsWebFluxAutoConfiguration.graphiQlIndexRedirect$lambda-0(this, arg_0)).build();
        Intrinsics.checkNotNullExpressionValue((Object)routerFunction, (String)"route()\n            .GET\u2026   }\n            .build()");
        return routerFunction;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DgsWebfluxHttpHandler dgsWebfluxHttpHandler(@NotNull DgsReactiveQueryExecutor dgsQueryExecutor) {
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        return new DefaultDgsWebfluxHttpHandler(dgsQueryExecutor);
    }

    @Bean
    @NotNull
    public RouterFunction<ServerResponse> dgsGraphQlRouter(@NotNull DgsWebfluxHttpHandler dgsWebfluxHttpHandler) {
        Intrinsics.checkNotNullParameter((Object)dgsWebfluxHttpHandler, (String)"dgsWebfluxHttpHandler");
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON, MediaType.valueOf((String)"application/graphql")};
        RouterFunction routerFunction = RouterFunctions.route().POST(this.configProps.getPath(), RequestPredicates.accept((MediaType[])mediaTypeArray), dgsWebfluxHttpHandler::graphql).build();
        Intrinsics.checkNotNullExpressionValue((Object)routerFunction, (String)"route()\n            .POS\u2026hql\n            ).build()");
        return routerFunction;
    }

    @Bean
    @ConditionalOnProperty(name={"dgs.graphql.schema-json.enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public RouterFunction<ServerResponse> schemaRouter(@NotNull DgsSchemaProvider schemaProvider) {
        Intrinsics.checkNotNullParameter((Object)schemaProvider, (String)"schemaProvider");
        RouterFunction routerFunction = RouterFunctions.route().GET(this.configProps.getSchemaJson().getPath(), arg_0 -> DgsWebFluxAutoConfiguration.schemaRouter$lambda-3(schemaProvider, arg_0)).build();
        Intrinsics.checkNotNullExpressionValue((Object)routerFunction, (String)"route()\n            .GET\u2026) }\n            }.build()");
        return routerFunction;
    }

    @Bean
    @NotNull
    public SimpleUrlHandlerMapping websocketSubscriptionHandler(@NotNull DgsReactiveQueryExecutor dgsReactiveQueryExecutor) {
        Intrinsics.checkNotNullParameter((Object)dgsReactiveQueryExecutor, (String)"dgsReactiveQueryExecutor");
        SimpleUrlHandlerMapping simpleUrlHandlerMapping = new SimpleUrlHandlerMapping(MapsKt.mapOf((Pair)TuplesKt.to((Object)"/subscriptions", (Object)new DgsReactiveWebsocketHandler(dgsReactiveQueryExecutor))));
        simpleUrlHandlerMapping.setOrder(1);
        return simpleUrlHandlerMapping;
    }

    @Bean
    @NotNull
    public WebSocketService webSocketService() {
        ReactorNettyRequestUpgradeStrategy strategy = new ReactorNettyRequestUpgradeStrategy(DgsWebFluxAutoConfiguration::webSocketService$lambda-4);
        return (WebSocketService)new DgsHandshakeWebSocketService((RequestUpgradeStrategy)strategy);
    }

    @Bean
    @Nullable
    public WebSocketHandlerAdapter handlerAdapter(@NotNull WebSocketService webSocketService) {
        Intrinsics.checkNotNullParameter((Object)webSocketService, (String)"webSocketService");
        return new WebSocketHandlerAdapter(webSocketService);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public MonoDataFetcherResultProcessor monoReactiveDataFetcherResultProcessor() {
        return new MonoDataFetcherResultProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public FluxDataFetcherResultProcessor fluxReactiveDataFetcherResultProcessor() {
        return new FluxDataFetcherResultProcessor();
    }

    @Bean
    @NotNull
    public CookieValueResolver webfluxCookieResolver() {
        return new WebFluxCookieValueResolver();
    }

    private static final Mono graphiQlIndexRedirect$lambda-0(DgsWebFluxAutoConfiguration this$0, ServerRequest it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return ServerResponse.permanentRedirect((URI)URI.create(Intrinsics.stringPlus((String)this$0.configProps.getGraphiql().getPath(), (Object)"/index.html"))).build();
    }

    private static final Map schemaRouter$lambda-3$lambda-1(ExecutionResult it) {
        return it.toSpecification();
    }

    private static final Mono schemaRouter$lambda-3$lambda-2(Map it) {
        ServerResponse.BodyBuilder bodyBuilder = ServerResponse.ok();
        Intrinsics.checkNotNullExpressionValue((Object)bodyBuilder, (String)"ok()");
        return ServerResponseExtensionsKt.json((ServerResponse.BodyBuilder)bodyBuilder).bodyValue((Object)it);
    }

    private static final Mono schemaRouter$lambda-3(DgsSchemaProvider $schemaProvider, ServerRequest it) {
        Intrinsics.checkNotNullParameter((Object)$schemaProvider, (String)"$schemaProvider");
        GraphQLSchema graphQLSchema = DgsSchemaProvider.schema$default((DgsSchemaProvider)$schemaProvider, null, null, (int)3, null);
        GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).build();
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query("\n  query IntrospectionQuery {\n    __schema {\n      queryType { name }\n      mutationType { name }\n      subscriptionType { name }\n      types {\n        ...FullType\n      }\n      directives {\n        name\n        description\n        locations\n        args {\n          ...InputValue\n        }\n        isRepeatable\n      }\n    }\n  }\n\n  fragment FullType on __Type {\n    kind\n    name\n    description\n    fields(includeDeprecated: true) {\n      name\n      description\n      args {\n        ...InputValue\n      }\n      type {\n        ...TypeRef\n      }\n      isDeprecated\n      deprecationReason\n    }\n    inputFields(includeDeprecated: true) {\n      ...InputValue\n    }\n    interfaces {\n      ...TypeRef\n    }\n    enumValues(includeDeprecated: true) {\n      name\n      description\n      isDeprecated\n      deprecationReason\n    }\n    possibleTypes {\n      ...TypeRef\n    }\n  }\n\n  fragment InputValue on __InputValue {\n    name\n    description\n    type { ...TypeRef }\n    defaultValue\n    isDeprecated\n    deprecationReason\n  }\n\nfragment TypeRef on __Type {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n          ofType {\n            kind\n            name\n            ofType {\n              kind\n              name\n              ofType {\n                kind\n                name\n                ofType {\n                  kind\n                  name\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n\n").build();
        Intrinsics.checkNotNullExpressionValue((Object)executionInput, (String)"newExecutionInput().quer\u2026                 .build()");
        ExecutionInput executionInput2 = executionInput;
        CompletableFuture execute = graphQL.executeAsync(executionInput2);
        return Mono.fromCompletionStage((CompletionStage)execute).map(DgsWebFluxAutoConfiguration::schemaRouter$lambda-3$lambda-1).flatMap(DgsWebFluxAutoConfiguration::schemaRouter$lambda-3$lambda-2);
    }

    private static final WebsocketServerSpec.Builder webSocketService$lambda-4() {
        return (WebsocketServerSpec.Builder)WebsocketServerSpec.builder().protocols("graphql-ws");
    }
}

