/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.webflux.autoconfiguration;

import java.time.Duration;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.context.properties.bind.DefaultValue;

@ConstructorBinding
@ConfigurationProperties(prefix="dgs.graphql")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0004\u001f !\"B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\b\u0010\u001e\u001a\u00020\u001cH\u0007R\u001e\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006#"}, d2={"Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties;", "", "websocket", "Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties$DgsWebsocketConfigurationProperties;", "path", "", "graphiql", "Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties$DgsGraphiQLConfigurationProperties;", "schemaJson", "Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties$DgsSchemaJsonConfigurationProperties;", "(Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties$DgsWebsocketConfigurationProperties;Ljava/lang/String;Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties$DgsGraphiQLConfigurationProperties;Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties$DgsSchemaJsonConfigurationProperties;)V", "getGraphiql", "()Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties$DgsGraphiQLConfigurationProperties;", "setGraphiql", "(Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties$DgsGraphiQLConfigurationProperties;)V", "getPath", "()Ljava/lang/String;", "setPath", "(Ljava/lang/String;)V", "getSchemaJson", "()Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties$DgsSchemaJsonConfigurationProperties;", "setSchemaJson", "(Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties$DgsSchemaJsonConfigurationProperties;)V", "getWebsocket", "()Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties$DgsWebsocketConfigurationProperties;", "setWebsocket", "(Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties$DgsWebsocketConfigurationProperties;)V", "validatePath", "", "pathProperty", "validatePaths", "Companion", "DgsGraphiQLConfigurationProperties", "DgsSchemaJsonConfigurationProperties", "DgsWebsocketConfigurationProperties", "graphql-dgs-spring-webflux-autoconfigure"})
public final class DgsWebfluxConfigurationProperties {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NestedConfigurationProperty
    @NotNull
    private DgsWebsocketConfigurationProperties websocket;
    @NotNull
    private String path;
    @NestedConfigurationProperty
    @NotNull
    private DgsGraphiQLConfigurationProperties graphiql;
    @NestedConfigurationProperty
    @NotNull
    private DgsSchemaJsonConfigurationProperties schemaJson;
    @NotNull
    public static final String DEFAULT_CONNECTION_INIT_TIMEOUT = "10s";
    @NotNull
    private static final Duration DEFAULT_CONNECTION_INIT_TIMEOUT_DURATION;

    public DgsWebfluxConfigurationProperties(@NotNull DgsWebsocketConfigurationProperties websocket, @DefaultValue(value={"/graphql"}) @NotNull String path, @NotNull DgsGraphiQLConfigurationProperties graphiql, @NotNull DgsSchemaJsonConfigurationProperties schemaJson) {
        Intrinsics.checkNotNullParameter((Object)websocket, (String)"websocket");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)graphiql, (String)"graphiql");
        Intrinsics.checkNotNullParameter((Object)schemaJson, (String)"schemaJson");
        this.websocket = websocket;
        this.path = path;
        this.graphiql = graphiql;
        this.schemaJson = schemaJson;
    }

    public /* synthetic */ DgsWebfluxConfigurationProperties(DgsWebsocketConfigurationProperties dgsWebsocketConfigurationProperties, String string, DgsGraphiQLConfigurationProperties dgsGraphiQLConfigurationProperties, DgsSchemaJsonConfigurationProperties dgsSchemaJsonConfigurationProperties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dgsWebsocketConfigurationProperties = new DgsWebsocketConfigurationProperties(DEFAULT_CONNECTION_INIT_TIMEOUT_DURATION);
        }
        if ((n & 2) != 0) {
            string = "/graphql";
        }
        if ((n & 4) != 0) {
            dgsGraphiQLConfigurationProperties = new DgsGraphiQLConfigurationProperties(null, null, 3, null);
        }
        if ((n & 8) != 0) {
            dgsSchemaJsonConfigurationProperties = new DgsSchemaJsonConfigurationProperties(null, 1, null);
        }
        this(dgsWebsocketConfigurationProperties, string, dgsGraphiQLConfigurationProperties, dgsSchemaJsonConfigurationProperties);
    }

    @NotNull
    public final DgsWebsocketConfigurationProperties getWebsocket() {
        return this.websocket;
    }

    public final void setWebsocket(@NotNull DgsWebsocketConfigurationProperties dgsWebsocketConfigurationProperties) {
        Intrinsics.checkNotNullParameter((Object)dgsWebsocketConfigurationProperties, (String)"<set-?>");
        this.websocket = dgsWebsocketConfigurationProperties;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final void setPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.path = string;
    }

    @NotNull
    public final DgsGraphiQLConfigurationProperties getGraphiql() {
        return this.graphiql;
    }

    public final void setGraphiql(@NotNull DgsGraphiQLConfigurationProperties dgsGraphiQLConfigurationProperties) {
        Intrinsics.checkNotNullParameter((Object)dgsGraphiQLConfigurationProperties, (String)"<set-?>");
        this.graphiql = dgsGraphiQLConfigurationProperties;
    }

    @NotNull
    public final DgsSchemaJsonConfigurationProperties getSchemaJson() {
        return this.schemaJson;
    }

    public final void setSchemaJson(@NotNull DgsSchemaJsonConfigurationProperties dgsSchemaJsonConfigurationProperties) {
        Intrinsics.checkNotNullParameter((Object)dgsSchemaJsonConfigurationProperties, (String)"<set-?>");
        this.schemaJson = dgsSchemaJsonConfigurationProperties;
    }

    @PostConstruct
    public final void validatePaths() {
        this.validatePath(this.path, "dgs.graphql.path");
        this.validatePath(this.graphiql.getPath(), "dgs.graphql.graphiql.path");
        this.validatePath(this.schemaJson.getPath(), "dgs.graphql.schema-json.path");
    }

    private final void validatePath(String path, String pathProperty) {
        if (!(Intrinsics.areEqual((Object)path, (Object)"/") || StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null))) {
            throw new IllegalArgumentException(pathProperty + " must start with '/' and not end with '/' but was '" + path + '\'');
        }
    }

    public DgsWebfluxConfigurationProperties() {
        this(null, null, null, null, 15, null);
    }

    static {
        Duration duration = Duration.ofSeconds(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(10)");
        DEFAULT_CONNECTION_INIT_TIMEOUT_DURATION = duration;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0011"}, d2={"Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties$DgsWebsocketConfigurationProperties;", "", "connectionInitTimeout", "Ljava/time/Duration;", "(Ljava/time/Duration;)V", "getConnectionInitTimeout", "()Ljava/time/Duration;", "setConnectionInitTimeout", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "graphql-dgs-spring-webflux-autoconfigure"})
    public static final class DgsWebsocketConfigurationProperties {
        @NotNull
        private Duration connectionInitTimeout;

        public DgsWebsocketConfigurationProperties(@DefaultValue(value={"10s"}) @NotNull Duration connectionInitTimeout) {
            Intrinsics.checkNotNullParameter((Object)connectionInitTimeout, (String)"connectionInitTimeout");
            this.connectionInitTimeout = connectionInitTimeout;
        }

        @NotNull
        public final Duration getConnectionInitTimeout() {
            return this.connectionInitTimeout;
        }

        public final void setConnectionInitTimeout(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.connectionInitTimeout = duration;
        }

        @NotNull
        public final Duration component1() {
            return this.connectionInitTimeout;
        }

        @NotNull
        public final DgsWebsocketConfigurationProperties copy(@DefaultValue(value={"10s"}) @NotNull Duration connectionInitTimeout) {
            Intrinsics.checkNotNullParameter((Object)connectionInitTimeout, (String)"connectionInitTimeout");
            return new DgsWebsocketConfigurationProperties(connectionInitTimeout);
        }

        public static /* synthetic */ DgsWebsocketConfigurationProperties copy$default(DgsWebsocketConfigurationProperties dgsWebsocketConfigurationProperties, Duration duration, int n, Object object) {
            if ((n & 1) != 0) {
                duration = dgsWebsocketConfigurationProperties.connectionInitTimeout;
            }
            return dgsWebsocketConfigurationProperties.copy(duration);
        }

        @NotNull
        public String toString() {
            return "DgsWebsocketConfigurationProperties(connectionInitTimeout=" + this.connectionInitTimeout + ')';
        }

        public int hashCode() {
            return this.connectionInitTimeout.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DgsWebsocketConfigurationProperties)) {
                return false;
            }
            DgsWebsocketConfigurationProperties dgsWebsocketConfigurationProperties = (DgsWebsocketConfigurationProperties)other;
            return Intrinsics.areEqual((Object)this.connectionInitTimeout, (Object)dgsWebsocketConfigurationProperties.connectionInitTimeout);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties$DgsGraphiQLConfigurationProperties;", "", "path", "", "title", "(Ljava/lang/String;Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "setPath", "(Ljava/lang/String;)V", "getTitle", "setTitle", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-dgs-spring-webflux-autoconfigure"})
    public static final class DgsGraphiQLConfigurationProperties {
        @NotNull
        private String path;
        @NotNull
        private String title;

        public DgsGraphiQLConfigurationProperties(@DefaultValue(value={"/graphiql"}) @NotNull String path, @DefaultValue(value={"Simple GraphiQL Example"}) @NotNull String title) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            this.path = path;
            this.title = title;
        }

        public /* synthetic */ DgsGraphiQLConfigurationProperties(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "/graphiql";
            }
            if ((n & 2) != 0) {
                string2 = "Simple GraphiQL Example";
            }
            this(string, string2);
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        public final void setPath(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.path = string;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.title = string;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final String component2() {
            return this.title;
        }

        @NotNull
        public final DgsGraphiQLConfigurationProperties copy(@DefaultValue(value={"/graphiql"}) @NotNull String path, @DefaultValue(value={"Simple GraphiQL Example"}) @NotNull String title) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            return new DgsGraphiQLConfigurationProperties(path, title);
        }

        public static /* synthetic */ DgsGraphiQLConfigurationProperties copy$default(DgsGraphiQLConfigurationProperties dgsGraphiQLConfigurationProperties, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = dgsGraphiQLConfigurationProperties.path;
            }
            if ((n & 2) != 0) {
                string2 = dgsGraphiQLConfigurationProperties.title;
            }
            return dgsGraphiQLConfigurationProperties.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "DgsGraphiQLConfigurationProperties(path=" + this.path + ", title=" + this.title + ')';
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = result * 31 + this.title.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DgsGraphiQLConfigurationProperties)) {
                return false;
            }
            DgsGraphiQLConfigurationProperties dgsGraphiQLConfigurationProperties = (DgsGraphiQLConfigurationProperties)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)dgsGraphiQLConfigurationProperties.path)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.title, (Object)dgsGraphiQLConfigurationProperties.title);
        }

        public DgsGraphiQLConfigurationProperties() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0010"}, d2={"Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties$DgsSchemaJsonConfigurationProperties;", "", "path", "", "(Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "setPath", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-dgs-spring-webflux-autoconfigure"})
    public static final class DgsSchemaJsonConfigurationProperties {
        @NotNull
        private String path;

        public DgsSchemaJsonConfigurationProperties(@DefaultValue(value={"/schema.json"}) @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.path = path;
        }

        public /* synthetic */ DgsSchemaJsonConfigurationProperties(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "/schema.json";
            }
            this(string);
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        public final void setPath(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.path = string;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final DgsSchemaJsonConfigurationProperties copy(@DefaultValue(value={"/schema.json"}) @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new DgsSchemaJsonConfigurationProperties(path);
        }

        public static /* synthetic */ DgsSchemaJsonConfigurationProperties copy$default(DgsSchemaJsonConfigurationProperties dgsSchemaJsonConfigurationProperties, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = dgsSchemaJsonConfigurationProperties.path;
            }
            return dgsSchemaJsonConfigurationProperties.copy(string);
        }

        @NotNull
        public String toString() {
            return "DgsSchemaJsonConfigurationProperties(path=" + this.path + ')';
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DgsSchemaJsonConfigurationProperties)) {
                return false;
            }
            DgsSchemaJsonConfigurationProperties dgsSchemaJsonConfigurationProperties = (DgsSchemaJsonConfigurationProperties)other;
            return Intrinsics.areEqual((Object)this.path, (Object)dgsSchemaJsonConfigurationProperties.path);
        }

        public DgsSchemaJsonConfigurationProperties() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties$Companion;", "", "()V", "DEFAULT_CONNECTION_INIT_TIMEOUT", "", "DEFAULT_CONNECTION_INIT_TIMEOUT_DURATION", "Ljava/time/Duration;", "getDEFAULT_CONNECTION_INIT_TIMEOUT_DURATION", "()Ljava/time/Duration;", "graphql-dgs-spring-webflux-autoconfigure"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getDEFAULT_CONNECTION_INIT_TIMEOUT_DURATION() {
            return DEFAULT_CONNECTION_INIT_TIMEOUT_DURATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

