/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.webflux.handlers;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.netflix.graphql.dgs.reactive.DgsReactiveQueryExecutor;
import com.netflix.graphql.dgs.webflux.handlers.DgsWebfluxHttpHandler;
import com.netflix.graphql.dgs.webflux.handlers.GraphQLMediaTypes;
import com.netflix.graphql.dgs.webflux.handlers.QueryInput;
import graphql.ExecutionResult;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/netflix/graphql/dgs/webflux/handlers/DefaultDgsWebfluxHttpHandler;", "Lcom/netflix/graphql/dgs/webflux/handlers/DgsWebfluxHttpHandler;", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/reactive/DgsReactiveQueryExecutor;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/netflix/graphql/dgs/reactive/DgsReactiveQueryExecutor;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "graphql", "Lreactor/core/publisher/Mono;", "Lorg/springframework/web/reactive/function/server/ServerResponse;", "request", "Lorg/springframework/web/reactive/function/server/ServerRequest;", "Companion", "graphql-dgs-spring-webflux-autoconfigure"})
public final class DefaultDgsWebfluxHttpHandler
implements DgsWebfluxHttpHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsReactiveQueryExecutor dgsQueryExecutor;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private static final Logger logger;

    public DefaultDgsWebfluxHttpHandler(@NotNull DgsReactiveQueryExecutor dgsQueryExecutor, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.dgsQueryExecutor = dgsQueryExecutor;
        this.objectMapper = objectMapper;
    }

    @Override
    @NotNull
    public Mono<ServerResponse> graphql(@NotNull ServerRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Mono mono = request.bodyToMono(String.class).flatMap(arg_0 -> DefaultDgsWebfluxHttpHandler.graphql$lambda-1(request, this, arg_0)).flatMap(arg_0 -> DefaultDgsWebfluxHttpHandler.graphql$lambda-2(this, request, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"request.bodyToMono(Strin\u2026      )\n                }");
        Mono executionResult = mono;
        Mono mono2 = executionResult.flatMap(DefaultDgsWebfluxHttpHandler::graphql$lambda-3).onErrorResume(DefaultDgsWebfluxHttpHandler::graphql$lambda-4);
        Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"executionResult.flatMap \u2026)\n            }\n        }");
        return mono2;
    }

    /*
     * WARNING - void declaration
     */
    private static final QueryInput graphql$lambda-1$lambda-0(DefaultDgsWebfluxHttpHandler this$0, String $body) {
        void $this$readValue$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ObjectMapper objectMapper = this$0.objectMapper;
        Intrinsics.checkNotNullExpressionValue((Object)$body, (String)"body");
        String content$iv = $body;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        Map readValue2 = (Map)$this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<Map<String, ? extends Object>>(){});
        Object iq = readValue2.get("query");
        String query = iq instanceof String ? (String)iq : null;
        Object iq2 = readValue2.get("operationName");
        String operationName = iq2 instanceof String ? (String)iq2 : "";
        Object object = readValue2.get("variables");
        if (object == null) {
            object = MapsKt.emptyMap();
        }
        Map map = (Map)object;
        Object object2 = readValue2.get("extensions");
        if (object2 == null) {
            object2 = MapsKt.emptyMap();
        }
        return new QueryInput(query, map, (Map)object2, operationName);
    }

    private static final Mono graphql$lambda-1(ServerRequest $request, DefaultDgsWebfluxHttpHandler this$0, String body) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return GraphQLMediaTypes.INSTANCE.isApplicationGraphQL($request) ? Mono.just((Object)new QueryInput(body, null, null, null, 14, null)) : Mono.fromCallable(() -> DefaultDgsWebfluxHttpHandler.graphql$lambda-1$lambda-0(this$0, body));
    }

    private static final Mono graphql$lambda-2(DefaultDgsWebfluxHttpHandler this$0, ServerRequest $request, QueryInput queryInput) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        logger.debug("Parsed variables: {}", queryInput.getQueryVariables());
        return this$0.dgsQueryExecutor.execute(queryInput.getQuery(), queryInput.getQueryVariables(), queryInput.getExtensions(), $request.headers().asHttpHeaders(), queryInput.getOperationName(), $request);
    }

    private static final Mono graphql$lambda-3(ExecutionResult result) {
        return ServerResponse.ok().bodyValue((Object)result.toSpecification());
    }

    private static final Mono graphql$lambda-4(Throwable ex) {
        Mono mono;
        Throwable throwable = ex;
        if (throwable instanceof JsonParseException) {
            ServerResponse.BodyBuilder bodyBuilder = ServerResponse.badRequest();
            StringBuilder stringBuilder = new StringBuilder().append("Invalid query - ");
            String string = ex.getMessage();
            if (string == null) {
                string = "no details found in the error message";
            }
            mono = bodyBuilder.bodyValue((Object)stringBuilder.append(string).append('.').toString());
        } else if (throwable instanceof MismatchedInputException) {
            mono = ServerResponse.badRequest().bodyValue((Object)"Invalid query - No content to map to input.");
        } else {
            ServerResponse.BodyBuilder bodyBuilder = ServerResponse.badRequest();
            StringBuilder stringBuilder = new StringBuilder().append("Invalid query - ");
            String string = ex.getMessage();
            if (string == null) {
                string = "no additional details found";
            }
            mono = bodyBuilder.bodyValue((Object)stringBuilder.append(string).append('.').toString());
        }
        return mono;
    }

    static {
        Logger logger = LoggerFactory.getLogger(DefaultDgsWebfluxHttpHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DefaultDgsWebf\u2026xHttpHandler::class.java)");
        DefaultDgsWebfluxHttpHandler.logger = logger;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/webflux/handlers/DefaultDgsWebfluxHttpHandler$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs-spring-webflux-autoconfigure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

