/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.webflux.handlers;

import com.netflix.graphql.dgs.reactive.DgsReactiveQueryExecutor;
import com.netflix.graphql.dgs.webflux.handlers.WebsocketGraphQLTransportWSProtocolHandler;
import com.netflix.graphql.dgs.webflux.handlers.WebsocketGraphQLWSProtocolHandler;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/netflix/graphql/dgs/webflux/handlers/DgsReactiveWebsocketHandler;", "Lorg/springframework/web/reactive/socket/WebSocketHandler;", "dgsReactiveQueryExecutor", "Lcom/netflix/graphql/dgs/reactive/DgsReactiveQueryExecutor;", "connectionInitTimeout", "Ljava/time/Duration;", "(Lcom/netflix/graphql/dgs/reactive/DgsReactiveQueryExecutor;Ljava/time/Duration;)V", "graphqlTransportWSHandler", "Lcom/netflix/graphql/dgs/webflux/handlers/WebsocketGraphQLTransportWSProtocolHandler;", "graphqlWSHandler", "Lcom/netflix/graphql/dgs/webflux/handlers/WebsocketGraphQLWSProtocolHandler;", "getSubProtocols", "", "", "handle", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "webSocketSession", "Lorg/springframework/web/reactive/socket/WebSocketSession;", "graphql-dgs-spring-webflux-autoconfigure"})
public final class DgsReactiveWebsocketHandler
implements WebSocketHandler {
    @NotNull
    private final WebsocketGraphQLWSProtocolHandler graphqlWSHandler;
    @NotNull
    private final WebsocketGraphQLTransportWSProtocolHandler graphqlTransportWSHandler;

    public DgsReactiveWebsocketHandler(@NotNull DgsReactiveQueryExecutor dgsReactiveQueryExecutor, @NotNull Duration connectionInitTimeout) {
        Intrinsics.checkNotNullParameter((Object)dgsReactiveQueryExecutor, (String)"dgsReactiveQueryExecutor");
        Intrinsics.checkNotNullParameter((Object)connectionInitTimeout, (String)"connectionInitTimeout");
        this.graphqlWSHandler = new WebsocketGraphQLWSProtocolHandler(dgsReactiveQueryExecutor);
        this.graphqlTransportWSHandler = new WebsocketGraphQLTransportWSProtocolHandler(dgsReactiveQueryExecutor, connectionInitTimeout);
    }

    @NotNull
    public List<String> getSubProtocols() {
        Object[] objectArray = new String[]{"graphql-ws", "graphql-transport-ws"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public Mono<Void> handle(@NotNull WebSocketSession webSocketSession) {
        Intrinsics.checkNotNullParameter((Object)webSocketSession, (String)"webSocketSession");
        if (StringsKt.equals((String)webSocketSession.getHandshakeInfo().getSubProtocol(), (String)"graphql-ws", (boolean)true)) {
            return this.graphqlWSHandler.handle(webSocketSession);
        }
        if (StringsKt.equals((String)webSocketSession.getHandshakeInfo().getSubProtocol(), (String)"graphql-transport-ws", (boolean)true)) {
            return this.graphqlTransportWSHandler.handle(webSocketSession);
        }
        Mono mono = Mono.empty();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"empty()");
        return mono;
    }
}

