/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.webflux.handlers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.graphql.dgs.reactive.DgsReactiveQueryExecutor;
import com.netflix.graphql.dgs.webflux.handlers.WebsocketReactiveProtocolHandler;
import com.netflix.graphql.types.subscription.websockets.CloseCode;
import com.netflix.graphql.types.subscription.websockets.Message;
import graphql.ExecutionResult;
import graphql.GraphqlErrorBuilder;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00140\u00130\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/netflix/graphql/dgs/webflux/handlers/WebsocketGraphQLTransportWSProtocolHandler;", "Lcom/netflix/graphql/dgs/webflux/handlers/WebsocketReactiveProtocolHandler;", "dgsReactiveQueryExecutor", "Lcom/netflix/graphql/dgs/reactive/DgsReactiveQueryExecutor;", "connectionInitTimeout", "Ljava/time/Duration;", "(Lcom/netflix/graphql/dgs/reactive/DgsReactiveQueryExecutor;Ljava/time/Duration;)V", "connections", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "decoder", "Lorg/springframework/http/codec/json/Jackson2JsonDecoder;", "encoder", "Lorg/springframework/http/codec/json/Jackson2JsonEncoder;", "resolvableType", "Lorg/springframework/core/ResolvableType;", "kotlin.jvm.PlatformType", "sessions", "", "Lorg/reactivestreams/Subscription;", "handle", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "webSocketSession", "Lorg/springframework/web/reactive/socket/WebSocketSession;", "toWebsocketMessage", "Lorg/springframework/web/reactive/socket/WebSocketMessage;", "operationMessage", "Lcom/netflix/graphql/types/subscription/websockets/Message;", "session", "Companion", "graphql-dgs-spring-webflux-autoconfigure"})
public final class WebsocketGraphQLTransportWSProtocolHandler
implements WebsocketReactiveProtocolHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsReactiveQueryExecutor dgsReactiveQueryExecutor;
    @NotNull
    private final Duration connectionInitTimeout;
    private final ResolvableType resolvableType;
    @NotNull
    private final ConcurrentHashMap<String, Map<String, Subscription>> sessions;
    @NotNull
    private final ConcurrentHashMap<String, Boolean> connections;
    @NotNull
    private final Jackson2JsonDecoder decoder;
    @NotNull
    private final Jackson2JsonEncoder encoder;
    private static final Logger logger = LoggerFactory.getLogger(DgsReactiveQueryExecutor.class);

    public WebsocketGraphQLTransportWSProtocolHandler(@NotNull DgsReactiveQueryExecutor dgsReactiveQueryExecutor, @NotNull Duration connectionInitTimeout) {
        Intrinsics.checkNotNullParameter((Object)dgsReactiveQueryExecutor, (String)"dgsReactiveQueryExecutor");
        Intrinsics.checkNotNullParameter((Object)connectionInitTimeout, (String)"connectionInitTimeout");
        this.dgsReactiveQueryExecutor = dgsReactiveQueryExecutor;
        this.connectionInitTimeout = connectionInitTimeout;
        this.resolvableType = ResolvableType.forType((Type)((Type)((Object)Message.class)));
        this.sessions = new ConcurrentHashMap();
        this.connections = new ConcurrentHashMap();
        this.decoder = new Jackson2JsonDecoder();
        this.encoder = new Jackson2JsonEncoder(this.decoder.getObjectMapper(), new MimeType[0]);
    }

    @Override
    @NotNull
    public Mono<Void> handle(@NotNull WebSocketSession webSocketSession) {
        Intrinsics.checkNotNullParameter((Object)webSocketSession, (String)"webSocketSession");
        Map map = this.connections;
        String string = webSocketSession.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"webSocketSession.id");
        String string2 = string;
        Boolean bl = false;
        map.put(string2, bl);
        Mono.delay((Duration)this.connectionInitTimeout).then(Mono.defer(() -> WebsocketGraphQLTransportWSProtocolHandler.handle$lambda-0(this, webSocketSession))).subscribe();
        Mono mono = webSocketSession.send((Publisher)webSocketSession.receive().flatMap(arg_0 -> WebsocketGraphQLTransportWSProtocolHandler.handle$lambda-6(this, webSocketSession, arg_0)).log().doFinally(arg_0 -> WebsocketGraphQLTransportWSProtocolHandler.handle$lambda-8(webSocketSession, this, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"webSocketSession.send(\n \u2026              }\n        )");
        return mono;
    }

    private final WebSocketMessage toWebsocketMessage(Message operationMessage, WebSocketSession session) {
        return new WebSocketMessage(WebSocketMessage.Type.TEXT, this.encoder.encodeValue((Object)operationMessage, session.bufferFactory(), this.resolvableType, MimeTypeUtils.APPLICATION_JSON, null));
    }

    private static final Mono handle$lambda-0(WebsocketGraphQLTransportWSProtocolHandler this$0, WebSocketSession $webSocketSession) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$webSocketSession, (String)"$webSocketSession");
        return Intrinsics.areEqual((Object)this$0.connections.get($webSocketSession.getId()), (Object)false) ? $webSocketSession.close(new CloseStatus(CloseCode.ConnectionInitialisationTimeout.getCode(), "Did not receive a ConnectionInitMessage")) : Mono.empty();
    }

    private static final WebSocketMessage handle$lambda-6$lambda-5$lambda-1(WebsocketGraphQLTransportWSProtocolHandler this$0, Message $operationMessage, WebSocketSession $webSocketSession, ExecutionResult er) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$operationMessage, (String)"$operationMessage");
        Intrinsics.checkNotNullParameter((Object)$webSocketSession, (String)"$webSocketSession");
        Object object = er.getData();
        List list = er.getErrors();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"er.errors");
        com.netflix.graphql.types.subscription.websockets.ExecutionResult executionResult = new com.netflix.graphql.types.subscription.websockets.ExecutionResult(object, list);
        String string = ((Message.SubscribeMessage)$operationMessage).getId();
        return this$0.toWebsocketMessage((Message)new Message.NextMessage(string, executionResult), $webSocketSession);
    }

    private static final void handle$lambda-6$lambda-5$lambda-2(Message $operationMessage, WebsocketGraphQLTransportWSProtocolHandler this$0, WebSocketSession $webSocketSession, Subscription it) {
        Intrinsics.checkNotNullParameter((Object)$operationMessage, (String)"$operationMessage");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$webSocketSession, (String)"$webSocketSession");
        if (((Message.SubscribeMessage)$operationMessage).getId() != null) {
            Map map = this$0.sessions;
            String string = $webSocketSession.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"webSocketSession.id");
            String string2 = string;
            Object object = new Pair[]{TuplesKt.to((Object)((Message.SubscribeMessage)$operationMessage).getId(), (Object)it)};
            object = MapsKt.mutableMapOf((Pair[])object);
            map.put(string2, object);
        }
    }

    private static final void handle$lambda-6$lambda-5$lambda-3(WebSocketSession $webSocketSession, WebsocketGraphQLTransportWSProtocolHandler this$0, Message $operationMessage) {
        Intrinsics.checkNotNullParameter((Object)$webSocketSession, (String)"$webSocketSession");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$operationMessage, (String)"$operationMessage");
        $webSocketSession.send((Publisher)Flux.just((Object)this$0.toWebsocketMessage((Message)new Message.CompleteMessage(((Message.SubscribeMessage)$operationMessage).getId()), $webSocketSession))).subscribe();
        Map<String, Subscription> map = this$0.sessions.get($webSocketSession.getId());
        if (map != null) {
            map.remove(((Message.SubscribeMessage)$operationMessage).getId());
        }
        logger.debug("Completing subscription {} for connection {}", (Object)((Message.SubscribeMessage)$operationMessage).getId(), (Object)$webSocketSession.getId());
    }

    private static final void handle$lambda-6$lambda-5$lambda-4(WebSocketSession $webSocketSession, WebsocketGraphQLTransportWSProtocolHandler this$0, Message $operationMessage, Message.SubscribeMessage.Payload $queryPayload, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$webSocketSession, (String)"$webSocketSession");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$operationMessage, (String)"$operationMessage");
        Intrinsics.checkNotNullParameter((Object)$queryPayload, (String)"$queryPayload");
        Object[] objectArray = CollectionsKt.listOf((Object)GraphqlErrorBuilder.newError().message(it.getMessage(), new Object[0]).build());
        String string = ((Message.SubscribeMessage)$operationMessage).getId();
        $webSocketSession.send((Publisher)Flux.just((Object)this$0.toWebsocketMessage((Message)new Message.ErrorMessage(string, (List)objectArray), $webSocketSession))).subscribe();
        Map<String, Subscription> map = this$0.sessions.get($webSocketSession.getId());
        if (map != null) {
            map.remove(((Message.SubscribeMessage)$operationMessage).getId());
        }
        objectArray = new Object[]{$queryPayload, ((Message.SubscribeMessage)$operationMessage).getId(), $webSocketSession.getId(), it};
        logger.debug("Subscription publisher error for input {} for subscription {} for connection {}", objectArray);
    }

    private static final Publisher handle$lambda-6$lambda-5(WebsocketGraphQLTransportWSProtocolHandler this$0, Message $operationMessage, WebSocketSession $webSocketSession, Message.SubscribeMessage.Payload $queryPayload, ExecutionResult executionResult) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$operationMessage, (String)"$operationMessage");
        Intrinsics.checkNotNullParameter((Object)$webSocketSession, (String)"$webSocketSession");
        Intrinsics.checkNotNullParameter((Object)$queryPayload, (String)"$queryPayload");
        Object object = executionResult.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executionResult.getData()");
        Publisher publisher = (Publisher)object;
        return (Publisher)Flux.from((Publisher)publisher).map(arg_0 -> WebsocketGraphQLTransportWSProtocolHandler.handle$lambda-6$lambda-5$lambda-1(this$0, $operationMessage, $webSocketSession, arg_0)).doOnSubscribe(arg_0 -> WebsocketGraphQLTransportWSProtocolHandler.handle$lambda-6$lambda-5$lambda-2($operationMessage, this$0, $webSocketSession, arg_0)).doOnComplete(() -> WebsocketGraphQLTransportWSProtocolHandler.handle$lambda-6$lambda-5$lambda-3($webSocketSession, this$0, $operationMessage)).doOnError(arg_0 -> WebsocketGraphQLTransportWSProtocolHandler.handle$lambda-6$lambda-5$lambda-4($webSocketSession, this$0, $operationMessage, $queryPayload, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final Publisher handle$lambda-6(WebsocketGraphQLTransportWSProtocolHandler this$0, WebSocketSession $webSocketSession, WebSocketMessage message) {
        Flux flux;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$webSocketSession, (String)"$webSocketSession");
        DataBuffer dataBuffer = DataBufferUtils.retain((DataBuffer)message.getPayload());
        Intrinsics.checkNotNullExpressionValue((Object)dataBuffer, (String)"retain(message.payload)");
        DataBuffer buffer = dataBuffer;
        Object object = this$0.decoder.decode(buffer, this$0.resolvableType, MimeTypeUtils.APPLICATION_JSON, null);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.netflix.graphql.types.subscription.websockets.Message");
        }
        Message operationMessage = (Message)object;
        Message message2 = operationMessage;
        if (message2 instanceof Message.ConnectionInitMessage) {
            Boolean bl = this$0.connections.get($webSocketSession.getId());
            Intrinsics.checkNotNull((Object)bl);
            if (bl.booleanValue()) {
                return (Publisher)$webSocketSession.close(new CloseStatus(CloseCode.TooManyInitialisationRequests.getCode(), "Too many connection initialisation requests")).thenMany((Publisher)Mono.empty());
            }
            Map map = this$0.connections;
            String string = $webSocketSession.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"webSocketSession.id");
            String string2 = string;
            Boolean bl2 = true;
            map.put(string2, bl2);
            flux = Flux.just((Object)this$0.toWebsocketMessage((Message)new Message.ConnectionAckMessage(null, 1, null), $webSocketSession));
        } else if (message2 instanceof Message.SubscribeMessage) {
            void from$iv;
            void $this$convertValue$iv;
            ObjectMapper objectMapper = this$0.decoder.getObjectMapper();
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"decoder.objectMapper");
            ObjectMapper objectMapper2 = objectMapper;
            Message.SubscribeMessage.Payload payload = ((Message.SubscribeMessage)operationMessage).getPayload();
            boolean $i$f$convertValue = false;
            boolean $i$f$jacksonTypeRef = false;
            Message.SubscribeMessage.Payload queryPayload = (Message.SubscribeMessage.Payload)$this$convertValue$iv.convertValue((Object)from$iv, (TypeReference)new TypeReference<Message.SubscribeMessage.Payload>(){});
            if (this$0.sessions.containsKey($webSocketSession.getId())) {
                return (Publisher)$webSocketSession.close(new CloseStatus(CloseCode.SubscriberAlreadyExists.getCode(), "Subscriber for " + $webSocketSession.getId() + " already exists")).thenMany((Publisher)Mono.empty());
            }
            logger.debug("Starting subscription {} for session {}", (Object)queryPayload, (Object)$webSocketSession.getId());
            flux = this$0.dgsReactiveQueryExecutor.execute(queryPayload.getQuery(), queryPayload.getVariables()).flatMapMany(arg_0 -> WebsocketGraphQLTransportWSProtocolHandler.handle$lambda-6$lambda-5(this$0, operationMessage, $webSocketSession, queryPayload, arg_0));
        } else if (message2 instanceof Message.PingMessage) {
            flux = Flux.just((Object)this$0.toWebsocketMessage((Message)new Message.PongMessage(null, 1, null), $webSocketSession));
        } else if (message2 instanceof Message.PongMessage) {
            flux = Flux.empty();
        } else if (message2 instanceof Message.CompleteMessage) {
            Subscription subscription = this$0.sessions.get($webSocketSession.getId());
            if (subscription != null && (subscription = subscription.remove(((Message.CompleteMessage)operationMessage).getId())) != null) {
                subscription.cancel();
            }
            logger.debug("Client stopped subscription {} for connection {}", (Object)((Message.CompleteMessage)operationMessage).getId(), (Object)$webSocketSession.getId());
            flux = Flux.empty();
        } else {
            return (Publisher)$webSocketSession.close(new CloseStatus(CloseCode.BadRequest.getCode(), "Unrecognized message")).thenMany((Publisher)Mono.empty());
        }
        return (Publisher)flux;
    }

    private static final void handle$lambda-8(WebSocketSession $webSocketSession, WebsocketGraphQLTransportWSProtocolHandler this$0, SignalType it) {
        Intrinsics.checkNotNullParameter((Object)$webSocketSession, (String)"$webSocketSession");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        logger.debug("Cleaning up subscriptions for session " + $webSocketSession.getId());
        Map<String, Subscription> map = this$0.sessions.get($webSocketSession.getId());
        if (map != null) {
            Map<String, Subscription> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Subscription>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Subscription> element$iv;
                Map.Entry<String, Subscription> it2 = element$iv = iterator.next();
                boolean bl = false;
                it2.getValue().cancel();
            }
        }
        this$0.sessions.remove($webSocketSession.getId());
        this$0.connections.remove($webSocketSession.getId());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/graphql/dgs/webflux/handlers/WebsocketGraphQLTransportWSProtocolHandler$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "graphql-dgs-spring-webflux-autoconfigure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

