/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.webflux.handlers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.graphql.dgs.reactive.DgsReactiveQueryExecutor;
import com.netflix.graphql.dgs.webflux.handlers.WebsocketReactiveProtocolHandler;
import com.netflix.graphql.types.subscription.DataPayload;
import com.netflix.graphql.types.subscription.OperationMessage;
import com.netflix.graphql.types.subscription.QueryPayload;
import graphql.ExecutionResult;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00100\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/netflix/graphql/dgs/webflux/handlers/WebsocketGraphQLWSProtocolHandler;", "Lcom/netflix/graphql/dgs/webflux/handlers/WebsocketReactiveProtocolHandler;", "dgsReactiveQueryExecutor", "Lcom/netflix/graphql/dgs/reactive/DgsReactiveQueryExecutor;", "(Lcom/netflix/graphql/dgs/reactive/DgsReactiveQueryExecutor;)V", "decoder", "Lorg/springframework/http/codec/json/Jackson2JsonDecoder;", "encoder", "Lorg/springframework/http/codec/json/Jackson2JsonEncoder;", "resolvableType", "Lorg/springframework/core/ResolvableType;", "kotlin.jvm.PlatformType", "sessions", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lorg/reactivestreams/Subscription;", "handle", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "webSocketSession", "Lorg/springframework/web/reactive/socket/WebSocketSession;", "toWebsocketMessage", "Lorg/springframework/web/reactive/socket/WebSocketMessage;", "operationMessage", "Lcom/netflix/graphql/types/subscription/OperationMessage;", "session", "Companion", "graphql-dgs-spring-webflux-autoconfigure"})
public final class WebsocketGraphQLWSProtocolHandler
implements WebsocketReactiveProtocolHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsReactiveQueryExecutor dgsReactiveQueryExecutor;
    private final ResolvableType resolvableType;
    @NotNull
    private final ConcurrentHashMap<String, Map<String, Subscription>> sessions;
    @NotNull
    private final Jackson2JsonDecoder decoder;
    @NotNull
    private final Jackson2JsonEncoder encoder;
    private static final Logger logger = LoggerFactory.getLogger(DgsReactiveQueryExecutor.class);

    public WebsocketGraphQLWSProtocolHandler(@NotNull DgsReactiveQueryExecutor dgsReactiveQueryExecutor) {
        Intrinsics.checkNotNullParameter((Object)dgsReactiveQueryExecutor, (String)"dgsReactiveQueryExecutor");
        this.dgsReactiveQueryExecutor = dgsReactiveQueryExecutor;
        this.resolvableType = ResolvableType.forType((Type)((Type)((Object)OperationMessage.class)));
        this.sessions = new ConcurrentHashMap();
        this.decoder = new Jackson2JsonDecoder();
        this.encoder = new Jackson2JsonEncoder(this.decoder.getObjectMapper(), new MimeType[0]);
    }

    @Override
    @NotNull
    public Mono<Void> handle(@NotNull WebSocketSession webSocketSession) {
        Intrinsics.checkNotNullParameter((Object)webSocketSession, (String)"webSocketSession");
        Mono mono = webSocketSession.send((Publisher)webSocketSession.receive().flatMap(arg_0 -> WebsocketGraphQLWSProtocolHandler.handle$lambda-6(this, webSocketSession, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"webSocketSession.send(\n \u2026              }\n        )");
        return mono;
    }

    private final WebSocketMessage toWebsocketMessage(OperationMessage operationMessage, WebSocketSession session) {
        return new WebSocketMessage(WebSocketMessage.Type.TEXT, this.encoder.encodeValue((Object)operationMessage, session.bufferFactory(), this.resolvableType, MimeTypeUtils.APPLICATION_JSON, null));
    }

    private static final WebSocketMessage handle$lambda-6$lambda-4$lambda-0(WebsocketGraphQLWSProtocolHandler this$0, OperationMessage $operationMessage, WebSocketSession $webSocketSession, ExecutionResult er) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$operationMessage, (String)"$operationMessage");
        Intrinsics.checkNotNullParameter((Object)$webSocketSession, (String)"$webSocketSession");
        return this$0.toWebsocketMessage(new OperationMessage("data", (Object)new DataPayload(er.getData(), er.getErrors()), $operationMessage.getId()), $webSocketSession);
    }

    private static final void handle$lambda-6$lambda-4$lambda-1(OperationMessage $operationMessage, WebsocketGraphQLWSProtocolHandler this$0, WebSocketSession $webSocketSession, Subscription it) {
        Intrinsics.checkNotNullParameter((Object)$operationMessage, (String)"$operationMessage");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$webSocketSession, (String)"$webSocketSession");
        if ($operationMessage.getId() != null) {
            Map map = this$0.sessions;
            String string = $webSocketSession.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"webSocketSession.id");
            String string2 = string;
            Object object = new Pair[1];
            String string3 = $operationMessage.getId();
            Intrinsics.checkNotNull((Object)string3);
            object[0] = TuplesKt.to((Object)string3, (Object)it);
            object = MapsKt.mutableMapOf((Pair[])object);
            map.put(string2, object);
        }
    }

    private static final void handle$lambda-6$lambda-4$lambda-2(WebSocketSession $webSocketSession, WebsocketGraphQLWSProtocolHandler this$0, OperationMessage $operationMessage) {
        Intrinsics.checkNotNullParameter((Object)$webSocketSession, (String)"$webSocketSession");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$operationMessage, (String)"$operationMessage");
        $webSocketSession.send((Publisher)Flux.just((Object)this$0.toWebsocketMessage(new OperationMessage("complete", null, $operationMessage.getId()), $webSocketSession))).subscribe();
        Map<String, Subscription> map = this$0.sessions.get($webSocketSession.getId());
        if (map != null) {
            Map<String, Subscription> map2 = map;
            String string = $operationMessage.getId();
            Subscription cfr_ignored_0 = (Subscription)TypeIntrinsics.asMutableMap(map2).remove(string);
        }
        logger.debug("Completing subscription {} for connection {}", (Object)$operationMessage.getId(), (Object)$webSocketSession.getId());
    }

    private static final void handle$lambda-6$lambda-4$lambda-3(WebSocketSession $webSocketSession, WebsocketGraphQLWSProtocolHandler this$0, OperationMessage $operationMessage, QueryPayload $queryPayload, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$webSocketSession, (String)"$webSocketSession");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$operationMessage, (String)"$operationMessage");
        Intrinsics.checkNotNullParameter((Object)$queryPayload, (String)"$queryPayload");
        String string = it.getMessage();
        Intrinsics.checkNotNull((Object)string);
        $webSocketSession.send((Publisher)Flux.just((Object)this$0.toWebsocketMessage(new OperationMessage("error", (Object)new DataPayload(null, CollectionsKt.listOf((Object)string)), $operationMessage.getId()), $webSocketSession))).subscribe();
        Map<String, Subscription> map = this$0.sessions.get($webSocketSession.getId());
        if (map != null) {
            Map<String, Subscription> map2 = map;
            String string2 = $operationMessage.getId();
            Subscription cfr_ignored_0 = (Subscription)TypeIntrinsics.asMutableMap(map2).remove(string2);
        }
        Object[] objectArray = new Object[]{$queryPayload, $operationMessage.getId(), $webSocketSession.getId(), it};
        logger.debug("Subscription publisher error for input {} for subscription {} for connection {}", objectArray);
    }

    private static final Publisher handle$lambda-6$lambda-4(WebsocketGraphQLWSProtocolHandler this$0, OperationMessage $operationMessage, WebSocketSession $webSocketSession, QueryPayload $queryPayload, ExecutionResult executionResult) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$operationMessage, (String)"$operationMessage");
        Intrinsics.checkNotNullParameter((Object)$webSocketSession, (String)"$webSocketSession");
        Intrinsics.checkNotNullParameter((Object)$queryPayload, (String)"$queryPayload");
        Object object = executionResult.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executionResult.getData()");
        Publisher publisher = (Publisher)object;
        return (Publisher)Flux.from((Publisher)publisher).map(arg_0 -> WebsocketGraphQLWSProtocolHandler.handle$lambda-6$lambda-4$lambda-0(this$0, $operationMessage, $webSocketSession, arg_0)).doOnSubscribe(arg_0 -> WebsocketGraphQLWSProtocolHandler.handle$lambda-6$lambda-4$lambda-1($operationMessage, this$0, $webSocketSession, arg_0)).doOnComplete(() -> WebsocketGraphQLWSProtocolHandler.handle$lambda-6$lambda-4$lambda-2($webSocketSession, this$0, $operationMessage)).doOnError(arg_0 -> WebsocketGraphQLWSProtocolHandler.handle$lambda-6$lambda-4$lambda-3($webSocketSession, this$0, $operationMessage, $queryPayload, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final Publisher handle$lambda-6(WebsocketGraphQLWSProtocolHandler this$0, WebSocketSession $webSocketSession, WebSocketMessage message) {
        Flux flux;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$webSocketSession, (String)"$webSocketSession");
        DataBuffer dataBuffer = DataBufferUtils.retain((DataBuffer)message.getPayload());
        Intrinsics.checkNotNullExpressionValue((Object)dataBuffer, (String)"retain(message.payload)");
        DataBuffer buffer = dataBuffer;
        Object object = this$0.decoder.decode(buffer, this$0.resolvableType, MimeTypeUtils.APPLICATION_JSON, null);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.netflix.graphql.types.subscription.OperationMessage");
        }
        OperationMessage operationMessage = (OperationMessage)object;
        switch (operationMessage.getType()) {
            case "connection_init": {
                flux = Flux.just((Object)this$0.toWebsocketMessage(new OperationMessage("connection_ack", null, null, 6, null), $webSocketSession));
                break;
            }
            case "start": {
                void from$iv;
                void $this$convertValue$iv;
                ObjectMapper objectMapper = this$0.decoder.getObjectMapper();
                Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"decoder.objectMapper");
                ObjectMapper objectMapper2 = objectMapper;
                Object object2 = operationMessage.getPayload();
                if (object2 == null) {
                    throw new IllegalStateException("payload == null".toString());
                }
                Object object3 = object2;
                boolean $i$f$convertValue = false;
                boolean $i$f$jacksonTypeRef = false;
                QueryPayload queryPayload = (QueryPayload)$this$convertValue$iv.convertValue((Object)from$iv, (TypeReference)new TypeReference<QueryPayload>(){});
                logger.debug("Starting subscription {} for session {}", (Object)queryPayload, (Object)$webSocketSession.getId());
                flux = this$0.dgsReactiveQueryExecutor.execute(queryPayload.getQuery(), queryPayload.getVariables()).flatMapMany(arg_0 -> WebsocketGraphQLWSProtocolHandler.handle$lambda-6$lambda-4(this$0, operationMessage, $webSocketSession, queryPayload, arg_0));
                break;
            }
            case "stop": {
                Subscription subscription = this$0.sessions.get($webSocketSession.getId());
                if (subscription != null) {
                    Subscription from$iv = subscription;
                    String $i$f$convertValue = operationMessage.getId();
                    subscription = (Subscription)TypeIntrinsics.asMutableMap(from$iv).remove($i$f$convertValue);
                    if (subscription != null) {
                        subscription.cancel();
                    }
                }
                logger.debug("Client stopped subscription {} for connection {}", (Object)operationMessage.getId(), (Object)$webSocketSession.getId());
                flux = Flux.empty();
                break;
            }
            case "connection_terminate": {
                Map<String, Subscription> map = this$0.sessions.get($webSocketSession.getId());
                if (map != null && (map = map.values()) != null) {
                    Iterable $this$forEach$iv = (Iterable)((Object)map);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Subscription it = (Subscription)element$iv;
                        boolean bl = false;
                        it.cancel();
                    }
                }
                this$0.sessions.remove($webSocketSession.getId());
                $webSocketSession.close();
                logger.debug("Connection {} terminated", (Object)$webSocketSession.getId());
                flux = Flux.empty();
                break;
            }
            default: {
                flux = Flux.empty();
            }
        }
        return (Publisher)flux;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/graphql/dgs/webflux/handlers/WebsocketGraphQLWSProtocolHandler$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "graphql-dgs-spring-webflux-autoconfigure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

