/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.webflux.handlers;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.reactive.socket.server.support.HandshakeWebSocketService;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/netflix/graphql/dgs/webflux/handlers/DgsHandshakeWebSocketService;", "Lorg/springframework/web/reactive/socket/server/support/HandshakeWebSocketService;", "()V", "upgradeStrategy", "Lorg/springframework/web/reactive/socket/server/RequestUpgradeStrategy;", "(Lorg/springframework/web/reactive/socket/server/RequestUpgradeStrategy;)V", "handleRequest", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "exchange", "Lorg/springframework/web/server/ServerWebExchange;", "handler", "Lorg/springframework/web/reactive/socket/WebSocketHandler;", "Companion", "graphql-dgs-spring-webflux-autoconfigure"})
public final class DgsHandshakeWebSocketService
extends HandshakeWebSocketService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
    private static final Logger logger = LoggerFactory.getLogger(DgsHandshakeWebSocketService.class);

    public DgsHandshakeWebSocketService() {
    }

    public DgsHandshakeWebSocketService(@NotNull RequestUpgradeStrategy upgradeStrategy) {
        Intrinsics.checkNotNullParameter((Object)upgradeStrategy, (String)"upgradeStrategy");
        super(upgradeStrategy);
    }

    @NotNull
    public Mono<Void> handleRequest(@NotNull ServerWebExchange exchange, @NotNull WebSocketHandler handler) {
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        ServerWebExchange newExchange = exchange;
        ServerHttpRequest request = exchange.getRequest();
        HttpHeaders headers = request.getHeaders();
        List protocols = (List)headers.get((Object)SEC_WEBSOCKET_PROTOCOL);
        String[] stringArray = (String[])protocols;
        if (stringArray == null || stringArray.isEmpty()) {
            stringArray = new String[]{"graphql-ws"};
            request = request.mutate().header(SEC_WEBSOCKET_PROTOCOL, stringArray).build();
            ServerWebExchange serverWebExchange = newExchange.mutate().request(request).build();
            Intrinsics.checkNotNullExpressionValue((Object)serverWebExchange, (String)"newExchange.mutate().request(request).build()");
            newExchange = serverWebExchange;
        }
        Mono mono = super.handleRequest(newExchange, handler);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"super.handleRequest(newExchange, handler)");
        return mono;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/netflix/graphql/dgs/webflux/handlers/DgsHandshakeWebSocketService$Companion;", "", "()V", "SEC_WEBSOCKET_PROTOCOL", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "graphql-dgs-spring-webflux-autoconfigure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

