/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.webflux.handlers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.graphql.dgs.reactive.DgsReactiveQueryExecutor;
import com.netflix.graphql.dgs.webflux.handlers.WebsocketGraphQLWSProtocolHandler;
import com.netflix.graphql.dgs.webflux.handlers.WebsocketReactiveProtocolHandler;
import com.netflix.graphql.types.subscription.DataPayload;
import com.netflix.graphql.types.subscription.OperationMessage;
import com.netflix.graphql.types.subscription.QueryPayload;
import graphql.ExecutionResult;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00100\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/netflix/graphql/dgs/webflux/handlers/WebsocketGraphQLWSProtocolHandler;", "Lcom/netflix/graphql/dgs/webflux/handlers/WebsocketReactiveProtocolHandler;", "dgsReactiveQueryExecutor", "Lcom/netflix/graphql/dgs/reactive/DgsReactiveQueryExecutor;", "(Lcom/netflix/graphql/dgs/reactive/DgsReactiveQueryExecutor;)V", "decoder", "Lorg/springframework/http/codec/json/Jackson2JsonDecoder;", "encoder", "Lorg/springframework/http/codec/json/Jackson2JsonEncoder;", "resolvableType", "Lorg/springframework/core/ResolvableType;", "kotlin.jvm.PlatformType", "sessions", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lorg/reactivestreams/Subscription;", "handle", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "webSocketSession", "Lorg/springframework/web/reactive/socket/WebSocketSession;", "toWebsocketMessage", "Lorg/springframework/web/reactive/socket/WebSocketMessage;", "operationMessage", "Lcom/netflix/graphql/types/subscription/OperationMessage;", "session", "Companion", "graphql-dgs-spring-webflux-autoconfigure"})
public final class WebsocketGraphQLWSProtocolHandler
implements WebsocketReactiveProtocolHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsReactiveQueryExecutor dgsReactiveQueryExecutor;
    private final ResolvableType resolvableType;
    @NotNull
    private final ConcurrentHashMap<String, Map<String, Subscription>> sessions;
    @NotNull
    private final Jackson2JsonDecoder decoder;
    @NotNull
    private final Jackson2JsonEncoder encoder;
    private static final Logger logger = LoggerFactory.getLogger(DgsReactiveQueryExecutor.class);

    public WebsocketGraphQLWSProtocolHandler(@NotNull DgsReactiveQueryExecutor dgsReactiveQueryExecutor) {
        Intrinsics.checkNotNullParameter((Object)dgsReactiveQueryExecutor, (String)"dgsReactiveQueryExecutor");
        this.dgsReactiveQueryExecutor = dgsReactiveQueryExecutor;
        this.resolvableType = ResolvableType.forType((Type)((Type)((Object)OperationMessage.class)));
        this.sessions = new ConcurrentHashMap();
        this.decoder = new Jackson2JsonDecoder();
        this.encoder = new Jackson2JsonEncoder(this.decoder.getObjectMapper(), new MimeType[0]);
    }

    @Override
    @NotNull
    public Mono<Void> handle(@NotNull WebSocketSession webSocketSession) {
        Intrinsics.checkNotNullParameter((Object)webSocketSession, (String)"webSocketSession");
        Mono mono = webSocketSession.send((Publisher)webSocketSession.receive().flatMap(arg_0 -> WebsocketGraphQLWSProtocolHandler.handle$lambda$0((Function1)new Function1<WebSocketMessage, Publisher<? extends WebSocketMessage>>(this, webSocketSession){
            final /* synthetic */ WebsocketGraphQLWSProtocolHandler this$0;
            final /* synthetic */ WebSocketSession $webSocketSession;
            {
                this.this$0 = $receiver;
                this.$webSocketSession = $webSocketSession;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Publisher<? extends WebSocketMessage> invoke(WebSocketMessage message) {
                Flux flux;
                DataBuffer dataBuffer = DataBufferUtils.retain((DataBuffer)message.getPayload());
                Intrinsics.checkNotNullExpressionValue((Object)dataBuffer, (String)"retain(message.payload)");
                DataBuffer buffer = dataBuffer;
                Object object = WebsocketGraphQLWSProtocolHandler.access$getDecoder$p(this.this$0).decode(buffer, WebsocketGraphQLWSProtocolHandler.access$getResolvableType$p(this.this$0), MimeTypeUtils.APPLICATION_JSON, null);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.netflix.graphql.types.subscription.OperationMessage");
                OperationMessage operationMessage = (OperationMessage)object;
                switch (operationMessage.getType()) {
                    case "connection_init": {
                        flux = Flux.just((Object)WebsocketGraphQLWSProtocolHandler.access$toWebsocketMessage(this.this$0, new OperationMessage("connection_ack", null, null, 6, null), this.$webSocketSession));
                        break;
                    }
                    case "start": {
                        void from$iv;
                        void $this$convertValue$iv;
                        ObjectMapper objectMapper = WebsocketGraphQLWSProtocolHandler.access$getDecoder$p(this.this$0).getObjectMapper();
                        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"decoder.objectMapper");
                        ObjectMapper objectMapper2 = objectMapper;
                        Object object2 = operationMessage.getPayload();
                        if (object2 == null) {
                            throw new IllegalStateException("payload == null".toString());
                        }
                        Object object3 = object2;
                        boolean $i$f$convertValue = false;
                        boolean $i$f$jacksonTypeRef = false;
                        QueryPayload queryPayload = (QueryPayload)$this$convertValue$iv.convertValue((Object)from$iv, (TypeReference)new TypeReference<QueryPayload>(){});
                        WebsocketGraphQLWSProtocolHandler.access$getLogger$cp().debug("Starting subscription {} for session {}", (Object)queryPayload, (Object)this.$webSocketSession.getId());
                        flux = WebsocketGraphQLWSProtocolHandler.access$getDgsReactiveQueryExecutor$p(this.this$0).execute(queryPayload.getQuery(), queryPayload.getVariables()).flatMapMany(arg_0 -> handle.1.invoke$lambda$0((Function1)new Function1<ExecutionResult, Publisher<? extends WebSocketMessage>>(this.this$0, operationMessage, this.$webSocketSession, queryPayload){
                            final /* synthetic */ WebsocketGraphQLWSProtocolHandler this$0;
                            final /* synthetic */ OperationMessage $operationMessage;
                            final /* synthetic */ WebSocketSession $webSocketSession;
                            final /* synthetic */ QueryPayload $queryPayload;
                            {
                                this.this$0 = $receiver;
                                this.$operationMessage = $operationMessage;
                                this.$webSocketSession = $webSocketSession;
                                this.$queryPayload = $queryPayload;
                                super(1);
                            }

                            public final Publisher<? extends WebSocketMessage> invoke(ExecutionResult executionResult2) {
                                Object object = executionResult2.getData();
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executionResult.getData()");
                                Publisher publisher = (Publisher)object;
                                return (Publisher)Flux.from((Publisher)publisher).map(arg_0 -> handle.1.invoke$lambda$0((Function1)new Function1<ExecutionResult, WebSocketMessage>(this.this$0, this.$operationMessage, this.$webSocketSession){
                                    final /* synthetic */ WebsocketGraphQLWSProtocolHandler this$0;
                                    final /* synthetic */ OperationMessage $operationMessage;
                                    final /* synthetic */ WebSocketSession $webSocketSession;
                                    {
                                        this.this$0 = $receiver;
                                        this.$operationMessage = $operationMessage;
                                        this.$webSocketSession = $webSocketSession;
                                        super(1);
                                    }

                                    public final WebSocketMessage invoke(ExecutionResult er) {
                                        return WebsocketGraphQLWSProtocolHandler.access$toWebsocketMessage(this.this$0, new OperationMessage("data", (Object)new DataPayload(er.getData(), er.getErrors()), this.$operationMessage.getId()), this.$webSocketSession);
                                    }
                                }, arg_0)).doOnSubscribe(arg_0 -> handle.1.invoke$lambda$1((Function1)new Function1<Subscription, Unit>(this.$operationMessage, this.this$0, this.$webSocketSession){
                                    final /* synthetic */ OperationMessage $operationMessage;
                                    final /* synthetic */ WebsocketGraphQLWSProtocolHandler this$0;
                                    final /* synthetic */ WebSocketSession $webSocketSession;
                                    {
                                        this.$operationMessage = $operationMessage;
                                        this.this$0 = $receiver;
                                        this.$webSocketSession = $webSocketSession;
                                        super(1);
                                    }

                                    public final void invoke(Subscription it) {
                                        if (this.$operationMessage.getId() != null) {
                                            Map map = WebsocketGraphQLWSProtocolHandler.access$getSessions$p(this.this$0);
                                            String string = this.$webSocketSession.getId();
                                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"webSocketSession.id");
                                            String string2 = string;
                                            Object object = new Pair[1];
                                            String string3 = this.$operationMessage.getId();
                                            Intrinsics.checkNotNull((Object)string3);
                                            object[0] = TuplesKt.to((Object)string3, (Object)it);
                                            object = MapsKt.mutableMapOf((Pair[])object);
                                            map.put(string2, object);
                                        }
                                    }
                                }, arg_0)).doOnComplete(() -> handle.1.invoke$lambda$2(this.$webSocketSession, this.this$0, this.$operationMessage)).doOnError(arg_0 -> handle.1.invoke$lambda$3((Function1)new Function1<Throwable, Unit>(this.$webSocketSession, this.this$0, this.$operationMessage, this.$queryPayload){
                                    final /* synthetic */ WebSocketSession $webSocketSession;
                                    final /* synthetic */ WebsocketGraphQLWSProtocolHandler this$0;
                                    final /* synthetic */ OperationMessage $operationMessage;
                                    final /* synthetic */ QueryPayload $queryPayload;
                                    {
                                        this.$webSocketSession = $webSocketSession;
                                        this.this$0 = $receiver;
                                        this.$operationMessage = $operationMessage;
                                        this.$queryPayload = $queryPayload;
                                        super(1);
                                    }

                                    public final void invoke(Throwable it) {
                                        String string = it.getMessage();
                                        Intrinsics.checkNotNull((Object)string);
                                        this.$webSocketSession.send((Publisher)Flux.just((Object)WebsocketGraphQLWSProtocolHandler.access$toWebsocketMessage(this.this$0, new OperationMessage("error", (Object)new DataPayload(null, CollectionsKt.listOf((Object)string)), this.$operationMessage.getId()), this.$webSocketSession))).subscribe();
                                        Map map = (Map)WebsocketGraphQLWSProtocolHandler.access$getSessions$p(this.this$0).get(this.$webSocketSession.getId());
                                        if (map != null) {
                                            Map map2 = map;
                                            String string2 = this.$operationMessage.getId();
                                            Subscription cfr_ignored_0 = (Subscription)TypeIntrinsics.asMutableMap((Object)map2).remove(string2);
                                        }
                                        Object[] objectArray = new Object[]{this.$queryPayload, this.$operationMessage.getId(), this.$webSocketSession.getId(), it};
                                        WebsocketGraphQLWSProtocolHandler.access$getLogger$cp().debug("Subscription publisher error for input {} for subscription {} for connection {}", objectArray);
                                    }
                                }, arg_0));
                            }

                            private static final WebSocketMessage invoke$lambda$0(Function1 $tmp0, Object p0) {
                                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                                return (WebSocketMessage)$tmp0.invoke(p0);
                            }

                            private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                                $tmp0.invoke(p0);
                            }

                            private static final void invoke$lambda$2(WebSocketSession $webSocketSession, WebsocketGraphQLWSProtocolHandler this$0, OperationMessage $operationMessage) {
                                Intrinsics.checkNotNullParameter((Object)$webSocketSession, (String)"$webSocketSession");
                                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                                Intrinsics.checkNotNullParameter((Object)$operationMessage, (String)"$operationMessage");
                                $webSocketSession.send((Publisher)Flux.just((Object)WebsocketGraphQLWSProtocolHandler.access$toWebsocketMessage(this$0, new OperationMessage("complete", null, $operationMessage.getId()), $webSocketSession))).subscribe();
                                Map map = (Map)WebsocketGraphQLWSProtocolHandler.access$getSessions$p(this$0).get($webSocketSession.getId());
                                if (map != null) {
                                    Map map2 = map;
                                    String string = $operationMessage.getId();
                                    Subscription cfr_ignored_0 = (Subscription)TypeIntrinsics.asMutableMap((Object)map2).remove(string);
                                }
                                WebsocketGraphQLWSProtocolHandler.access$getLogger$cp().debug("Completing subscription {} for connection {}", (Object)$operationMessage.getId(), (Object)$webSocketSession.getId());
                            }

                            private static final void invoke$lambda$3(Function1 $tmp0, Object p0) {
                                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                                $tmp0.invoke(p0);
                            }
                        }, arg_0));
                        break;
                    }
                    case "stop": {
                        Map map = (Map)WebsocketGraphQLWSProtocolHandler.access$getSessions$p(this.this$0).get(this.$webSocketSession.getId());
                        if (map != null) {
                            Map from$iv = map;
                            String $i$f$convertValue = operationMessage.getId();
                            map = (Subscription)TypeIntrinsics.asMutableMap((Object)from$iv).remove($i$f$convertValue);
                            if (map != null) {
                                map.cancel();
                            }
                        }
                        WebsocketGraphQLWSProtocolHandler.access$getLogger$cp().debug("Client stopped subscription {} for connection {}", (Object)operationMessage.getId(), (Object)this.$webSocketSession.getId());
                        flux = Flux.empty();
                        break;
                    }
                    case "connection_terminate": {
                        Object object4 = (Map)WebsocketGraphQLWSProtocolHandler.access$getSessions$p(this.this$0).get(this.$webSocketSession.getId());
                        if (object4 != null && (object4 = object4.values()) != null) {
                            Iterable $this$forEach$iv = (Iterable)object4;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                Subscription it = (Subscription)element$iv;
                                boolean bl = false;
                                it.cancel();
                            }
                        }
                        WebsocketGraphQLWSProtocolHandler.access$getSessions$p(this.this$0).remove(this.$webSocketSession.getId());
                        this.$webSocketSession.close();
                        WebsocketGraphQLWSProtocolHandler.access$getLogger$cp().debug("Connection {} terminated", (Object)this.$webSocketSession.getId());
                        flux = Flux.empty();
                        break;
                    }
                    default: {
                        flux = Flux.empty();
                    }
                }
                return (Publisher)flux;
            }

            private static final Publisher invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Publisher)$tmp0.invoke(p0);
            }
        }, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"override fun handle(webS\u2026        }\n        )\n    }");
        return mono;
    }

    private final WebSocketMessage toWebsocketMessage(OperationMessage operationMessage, WebSocketSession session) {
        return new WebSocketMessage(WebSocketMessage.Type.TEXT, this.encoder.encodeValue((Object)operationMessage, session.bufferFactory(), this.resolvableType, MimeTypeUtils.APPLICATION_JSON, null));
    }

    private static final Publisher handle$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Jackson2JsonDecoder access$getDecoder$p(WebsocketGraphQLWSProtocolHandler $this) {
        return $this.decoder;
    }

    public static final /* synthetic */ ResolvableType access$getResolvableType$p(WebsocketGraphQLWSProtocolHandler $this) {
        return $this.resolvableType;
    }

    public static final /* synthetic */ WebSocketMessage access$toWebsocketMessage(WebsocketGraphQLWSProtocolHandler $this, OperationMessage operationMessage, WebSocketSession session) {
        return $this.toWebsocketMessage(operationMessage, session);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ DgsReactiveQueryExecutor access$getDgsReactiveQueryExecutor$p(WebsocketGraphQLWSProtocolHandler $this) {
        return $this.dgsReactiveQueryExecutor;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getSessions$p(WebsocketGraphQLWSProtocolHandler $this) {
        return $this.sessions;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/graphql/dgs/webflux/handlers/WebsocketGraphQLWSProtocolHandler$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "graphql-dgs-spring-webflux-autoconfigure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

