/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.webflux.autoconfiguration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.internal.DefaultDgsQueryExecutor;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import com.netflix.graphql.dgs.internal.FluxDataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.MonoDataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.QueryValueCustomizer;
import com.netflix.graphql.dgs.internal.method.ArgumentResolver;
import com.netflix.graphql.dgs.reactive.DgsReactiveCustomContextBuilderWithRequest;
import com.netflix.graphql.dgs.reactive.DgsReactiveQueryExecutor;
import com.netflix.graphql.dgs.reactive.internal.DefaultDgsReactiveGraphQLContextBuilder;
import com.netflix.graphql.dgs.reactive.internal.DefaultDgsReactiveQueryExecutor;
import com.netflix.graphql.dgs.reactive.internal.method.SyncHandlerMethodArgumentResolverAdapter;
import com.netflix.graphql.dgs.webflux.autoconfiguration.DgsWebFluxAutoConfiguration;
import com.netflix.graphql.dgs.webflux.autoconfiguration.DgsWebfluxConfigurationProperties;
import com.netflix.graphql.dgs.webflux.autoconfiguration.GraphiQlConfigurer;
import com.netflix.graphql.dgs.webflux.handlers.DefaultDgsWebfluxHttpHandler;
import com.netflix.graphql.dgs.webflux.handlers.DgsHandshakeWebSocketService;
import com.netflix.graphql.dgs.webflux.handlers.DgsReactiveWebsocketHandler;
import com.netflix.graphql.dgs.webflux.handlers.DgsWebfluxHttpHandler;
import com.netflix.graphql.dgs.webflux.handlers.GraphQLMediaTypes;
import graphql.ExecutionInput;
import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.AsyncSerialExecutionStrategy;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.introspection.IntrospectionQuery;
import graphql.schema.GraphQLSchema;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.handler.SimpleUrlHandlerMapping;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.CookieValueMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestHeaderMapMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestHeaderMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.reactive.result.method.annotation.RequestParamMapMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestParamMethodArgumentResolver;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.reactive.socket.server.WebSocketService;
import org.springframework.web.reactive.socket.server.support.WebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.server.upgrade.ReactorNettyRequestUpgradeStrategy;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.WebsocketServerSpec;

@AutoConfiguration
@EnableConfigurationProperties(value={DgsWebfluxConfigurationProperties.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0001>B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0017J\b\u0010\n\u001a\u00020\u000bH\u0017J\u009a\u0001\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u000e\b\u0001\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u000e\b\u0001\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0 2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u001b2\u0006\u0010)\u001a\u00020*H\u0017J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010+\u001a\u00020\r2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0017J\b\u0010,\u001a\u00020-H\u0017J\u0010\u0010.\u001a\u00020/2\u0006\u0010\u0002\u001a\u00020\u0003H\u0017J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0017J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u000204H\u0017J\b\u00105\u001a\u000206H\u0017J\u001a\u00107\u001a\u00020\u00172\u0010\u00108\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003090 H\u0017J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u00103\u001a\u000204H\u0017J\u0018\u0010;\u001a\u00020<2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010=\u001a\u00020\u0003H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebFluxAutoConfiguration;", "", "configProps", "Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties;", "(Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties;)V", "dgsGraphQlRouter", "Lorg/springframework/web/reactive/function/server/RouterFunction;", "Lorg/springframework/web/reactive/function/server/ServerResponse;", "dgsWebfluxHttpHandler", "Lcom/netflix/graphql/dgs/webflux/handlers/DgsWebfluxHttpHandler;", "dgsObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "dgsReactiveQueryExecutor", "Lcom/netflix/graphql/dgs/reactive/DgsReactiveQueryExecutor;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "schema", "Lgraphql/schema/GraphQLSchema;", "schemaProvider", "Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "dgsDataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "dgsContextBuilder", "Lcom/netflix/graphql/dgs/reactive/internal/DefaultDgsReactiveGraphQLContextBuilder;", "dataFetcherExceptionHandler", "Lgraphql/execution/DataFetcherExceptionHandler;", "instrumentations", "Lorg/springframework/beans/factory/ObjectProvider;", "Lgraphql/execution/instrumentation/Instrumentation;", "environment", "Lorg/springframework/core/env/Environment;", "providedQueryExecutionStrategy", "Ljava/util/Optional;", "Lgraphql/execution/ExecutionStrategy;", "providedMutationExecutionStrategy", "idProvider", "Lgraphql/execution/ExecutionIdProvider;", "reloadSchemaIndicator", "Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor$ReloadSchemaIndicator;", "preparsedDocumentProvider", "Lgraphql/execution/preparsed/PreparsedDocumentProvider;", "queryValueCustomizer", "Lcom/netflix/graphql/dgs/internal/QueryValueCustomizer;", "dgsQueryExecutor", "fluxReactiveDataFetcherResultProcessor", "Lcom/netflix/graphql/dgs/internal/FluxDataFetcherResultProcessor;", "graphiQlConfigurer", "Lcom/netflix/graphql/dgs/webflux/autoconfiguration/GraphiQlConfigurer;", "graphiQlIndexRedirect", "handlerAdapter", "Lorg/springframework/web/reactive/socket/server/support/WebSocketHandlerAdapter;", "webSocketService", "Lorg/springframework/web/reactive/socket/server/WebSocketService;", "monoReactiveDataFetcherResultProcessor", "Lcom/netflix/graphql/dgs/internal/MonoDataFetcherResultProcessor;", "reactiveGraphQlContextBuilder", "dgsReactiveCustomContextBuilderWithRequest", "Lcom/netflix/graphql/dgs/reactive/DgsReactiveCustomContextBuilderWithRequest;", "schemaRouter", "websocketSubscriptionHandler", "Lorg/springframework/web/reactive/handler/SimpleUrlHandlerMapping;", "webfluxConfigurationProperties", "WebFluxArgumentHandlerConfiguration", "graphql-dgs-spring-webflux-autoconfigure"})
@SourceDebugExtension(value={"SMAP\nDgsWebFluxAutoConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsWebFluxAutoConfiguration.kt\ncom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebFluxAutoConfiguration\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,314:1\n37#2,2:315\n*S KotlinDebug\n*F\n+ 1 DgsWebFluxAutoConfiguration.kt\ncom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebFluxAutoConfiguration\n*L\n179#1:315,2\n*E\n"})
public class DgsWebFluxAutoConfiguration {
    @NotNull
    private final DgsWebfluxConfigurationProperties configProps;

    public DgsWebFluxAutoConfiguration(@NotNull DgsWebfluxConfigurationProperties configProps) {
        Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
        this.configProps = configProps;
    }

    @Bean
    @NotNull
    public DgsReactiveQueryExecutor dgsReactiveQueryExecutor(@NotNull ApplicationContext applicationContext, @NotNull GraphQLSchema schema, @NotNull DgsSchemaProvider schemaProvider, @NotNull DgsDataLoaderProvider dgsDataLoaderProvider, @NotNull DefaultDgsReactiveGraphQLContextBuilder dgsContextBuilder, @NotNull DataFetcherExceptionHandler dataFetcherExceptionHandler, @NotNull ObjectProvider<Instrumentation> instrumentations, @NotNull Environment environment, @Qualifier(value="query") @NotNull Optional<ExecutionStrategy> providedQueryExecutionStrategy, @Qualifier(value="mutation") @NotNull Optional<ExecutionStrategy> providedMutationExecutionStrategy, @NotNull Optional<ExecutionIdProvider> idProvider, @NotNull DefaultDgsQueryExecutor.ReloadSchemaIndicator reloadSchemaIndicator, @NotNull ObjectProvider<PreparsedDocumentProvider> preparsedDocumentProvider, @NotNull QueryValueCustomizer queryValueCustomizer) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)schemaProvider, (String)"schemaProvider");
        Intrinsics.checkNotNullParameter((Object)dgsDataLoaderProvider, (String)"dgsDataLoaderProvider");
        Intrinsics.checkNotNullParameter((Object)dgsContextBuilder, (String)"dgsContextBuilder");
        Intrinsics.checkNotNullParameter((Object)dataFetcherExceptionHandler, (String)"dataFetcherExceptionHandler");
        Intrinsics.checkNotNullParameter(instrumentations, (String)"instrumentations");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(providedQueryExecutionStrategy, (String)"providedQueryExecutionStrategy");
        Intrinsics.checkNotNullParameter(providedMutationExecutionStrategy, (String)"providedMutationExecutionStrategy");
        Intrinsics.checkNotNullParameter(idProvider, (String)"idProvider");
        Intrinsics.checkNotNullParameter((Object)reloadSchemaIndicator, (String)"reloadSchemaIndicator");
        Intrinsics.checkNotNullParameter(preparsedDocumentProvider, (String)"preparsedDocumentProvider");
        Intrinsics.checkNotNullParameter((Object)queryValueCustomizer, (String)"queryValueCustomizer");
        ExecutionStrategy queryExecutionStrategy = providedQueryExecutionStrategy.orElse((ExecutionStrategy)new AsyncExecutionStrategy(dataFetcherExceptionHandler));
        ExecutionStrategy mutationExecutionStrategy = providedMutationExecutionStrategy.orElse((ExecutionStrategy)new AsyncSerialExecutionStrategy(dataFetcherExceptionHandler));
        List instrumentationImpls = instrumentations.orderedStream().toList();
        if (instrumentationImpls.size() == 1) {
            Intrinsics.checkNotNull(instrumentationImpls);
            object = (Instrumentation)CollectionsKt.single(instrumentationImpls);
        } else {
            Intrinsics.checkNotNull(instrumentationImpls);
            object = !((Collection)instrumentationImpls).isEmpty() ? (Instrumentation)new ChainedInstrumentation(instrumentationImpls) : null;
        }
        Instrumentation instrumentation = object;
        Intrinsics.checkNotNull((Object)queryExecutionStrategy);
        Intrinsics.checkNotNull((Object)mutationExecutionStrategy);
        return (DgsReactiveQueryExecutor)new DefaultDgsReactiveQueryExecutor(schema, schemaProvider, dgsDataLoaderProvider, dgsContextBuilder, instrumentation, queryExecutionStrategy, mutationExecutionStrategy, idProvider, reloadSchemaIndicator, (PreparsedDocumentProvider)preparsedDocumentProvider.getIfAvailable(), queryValueCustomizer);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DefaultDgsReactiveGraphQLContextBuilder reactiveGraphQlContextBuilder(@NotNull Optional<DgsReactiveCustomContextBuilderWithRequest<?>> dgsReactiveCustomContextBuilderWithRequest) {
        Intrinsics.checkNotNullParameter(dgsReactiveCustomContextBuilderWithRequest, (String)"dgsReactiveCustomContextBuilderWithRequest");
        return new DefaultDgsReactiveGraphQLContextBuilder(dgsReactiveCustomContextBuilderWithRequest);
    }

    @Bean
    @ConditionalOnProperty(name={"dgs.graphql.graphiql.enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public GraphiQlConfigurer graphiQlConfigurer(@NotNull DgsWebfluxConfigurationProperties configProps) {
        Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
        return new GraphiQlConfigurer(configProps);
    }

    @Bean
    @ConditionalOnProperty(name={"dgs.graphql.graphiql.enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public RouterFunction<ServerResponse> graphiQlIndexRedirect() {
        RouterFunction routerFunction = RouterFunctions.route().GET(this.configProps.getGraphiql().getPath(), arg_0 -> DgsWebFluxAutoConfiguration.graphiQlIndexRedirect$lambda$0(this, arg_0)).build();
        Intrinsics.checkNotNullExpressionValue((Object)routerFunction, (String)"build(...)");
        return routerFunction;
    }

    @Bean
    @Qualifier(value="dgsObjectMapper")
    @ConditionalOnMissingBean(name={"dgsObjectMapper"})
    @NotNull
    public ObjectMapper dgsObjectMapper() {
        return ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DgsWebfluxHttpHandler dgsWebfluxHttpHandler(@NotNull DgsReactiveQueryExecutor dgsQueryExecutor, @Qualifier(value="dgsObjectMapper") @NotNull ObjectMapper dgsObjectMapper) {
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        Intrinsics.checkNotNullParameter((Object)dgsObjectMapper, (String)"dgsObjectMapper");
        return new DefaultDgsWebfluxHttpHandler(dgsQueryExecutor, dgsObjectMapper);
    }

    @Bean
    @NotNull
    public RouterFunction<ServerResponse> dgsGraphQlRouter(@NotNull DgsWebfluxHttpHandler dgsWebfluxHttpHandler) {
        Intrinsics.checkNotNullParameter((Object)dgsWebfluxHttpHandler, (String)"dgsWebfluxHttpHandler");
        Collection $this$toTypedArray$iv = GraphQLMediaTypes.INSTANCE.getACCEPTABLE_MEDIA_TYPES();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        MediaType[] mediaTypeArray = thisCollection$iv.toArray(new MediaType[0]);
        RouterFunction routerFunction = RouterFunctions.route().POST(this.configProps.getPath(), RequestPredicates.accept((MediaType[])Arrays.copyOf(mediaTypeArray, mediaTypeArray.length)), dgsWebfluxHttpHandler::graphql).build();
        Intrinsics.checkNotNullExpressionValue((Object)routerFunction, (String)"build(...)");
        return routerFunction;
    }

    @Bean
    @ConditionalOnProperty(name={"dgs.graphql.schema-json.enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public RouterFunction<ServerResponse> schemaRouter(@NotNull DgsSchemaProvider schemaProvider) {
        Intrinsics.checkNotNullParameter((Object)schemaProvider, (String)"schemaProvider");
        RouterFunction routerFunction = RouterFunctions.route().GET(this.configProps.getSchemaJson().getPath(), arg_0 -> DgsWebFluxAutoConfiguration.schemaRouter$lambda$3(schemaProvider, arg_0)).build();
        Intrinsics.checkNotNullExpressionValue((Object)routerFunction, (String)"build(...)");
        return routerFunction;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SimpleUrlHandlerMapping websocketSubscriptionHandler(@NotNull DgsReactiveQueryExecutor dgsReactiveQueryExecutor, @NotNull DgsWebfluxConfigurationProperties webfluxConfigurationProperties) {
        Intrinsics.checkNotNullParameter((Object)dgsReactiveQueryExecutor, (String)"dgsReactiveQueryExecutor");
        Intrinsics.checkNotNullParameter((Object)webfluxConfigurationProperties, (String)"webfluxConfigurationProperties");
        SimpleUrlHandlerMapping simpleUrlHandlerMapping = new SimpleUrlHandlerMapping(MapsKt.mapOf((Pair)TuplesKt.to((Object)webfluxConfigurationProperties.getWebsocket().getPath(), (Object)new DgsReactiveWebsocketHandler(dgsReactiveQueryExecutor, webfluxConfigurationProperties.getWebsocket().getConnectionInitTimeout()))));
        simpleUrlHandlerMapping.setOrder(1);
        return simpleUrlHandlerMapping;
    }

    @Bean
    @NotNull
    public WebSocketService webSocketService() {
        ReactorNettyRequestUpgradeStrategy strategy = new ReactorNettyRequestUpgradeStrategy(DgsWebFluxAutoConfiguration::webSocketService$lambda$4);
        return (WebSocketService)new DgsHandshakeWebSocketService((RequestUpgradeStrategy)strategy);
    }

    @Bean
    @Nullable
    public WebSocketHandlerAdapter handlerAdapter(@NotNull WebSocketService webSocketService) {
        Intrinsics.checkNotNullParameter((Object)webSocketService, (String)"webSocketService");
        return new WebSocketHandlerAdapter(webSocketService);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public MonoDataFetcherResultProcessor monoReactiveDataFetcherResultProcessor() {
        return new MonoDataFetcherResultProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public FluxDataFetcherResultProcessor fluxReactiveDataFetcherResultProcessor() {
        return new FluxDataFetcherResultProcessor();
    }

    private static final Mono graphiQlIndexRedirect$lambda$0(DgsWebFluxAutoConfiguration this$0, ServerRequest it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return ServerResponse.permanentRedirect((URI)URI.create(this$0.configProps.getGraphiql().getPath() + "/index.html")).build();
    }

    private static final Map schemaRouter$lambda$3$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    private static final Mono schemaRouter$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Mono schemaRouter$lambda$3(DgsSchemaProvider $schemaProvider, ServerRequest it) {
        Intrinsics.checkNotNullParameter((Object)$schemaProvider, (String)"$schemaProvider");
        GraphQLSchema graphQLSchema = DgsSchemaProvider.schema$default((DgsSchemaProvider)$schemaProvider, null, null, null, (boolean)false, (int)15, null).getGraphQLSchema();
        GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).build();
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(IntrospectionQuery.INTROSPECTION_QUERY).build();
        Intrinsics.checkNotNullExpressionValue((Object)executionInput, (String)"build(...)");
        ExecutionInput executionInput2 = executionInput;
        CompletableFuture execute = graphQL.executeAsync(executionInput2);
        return Mono.fromCompletionStage((CompletionStage)execute).map(arg_0 -> DgsWebFluxAutoConfiguration.schemaRouter$lambda$3$lambda$1(schemaRouter.1.1.INSTANCE, arg_0)).flatMap(arg_0 -> DgsWebFluxAutoConfiguration.schemaRouter$lambda$3$lambda$2(schemaRouter.1.2.INSTANCE, arg_0));
    }

    private static final WebsocketServerSpec.Builder webSocketService$lambda$4() {
        return (WebsocketServerSpec.Builder)WebsocketServerSpec.builder().protocols("graphql-ws");
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\u0016\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0017J\"\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\u001a\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\"\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\"\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017\u00a8\u0006\u0014"}, d2={"Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebFluxAutoConfiguration$WebFluxArgumentHandlerConfiguration;", "", "()V", "cookieValueArgumentResolver", "Lcom/netflix/graphql/dgs/internal/method/ArgumentResolver;", "beanFactory", "Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;", "registry", "Lorg/springframework/core/ReactiveAdapterRegistry;", "bindingContext", "Lorg/springframework/web/reactive/BindingContext;", "dgsBindingContext", "adapter", "Lorg/springframework/beans/factory/ObjectProvider;", "Lorg/springframework/web/reactive/result/method/annotation/RequestMappingHandlerAdapter;", "requestHeaderArgumentResolver", "requestHeaderMapArgumentResolver", "requestParamArgumentResolver", "requestParamMapArgumentResolver", "Dgs", "graphql-dgs-spring-webflux-autoconfigure"})
    public static class WebFluxArgumentHandlerConfiguration {
        @Dgs
        @Bean
        @NotNull
        public BindingContext dgsBindingContext(@NotNull ObjectProvider<RequestMappingHandlerAdapter> adapter) {
            Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
            RequestMappingHandlerAdapter requestMappingHandlerAdapter = (RequestMappingHandlerAdapter)adapter.getIfAvailable();
            return new BindingContext((WebBindingInitializer)(requestMappingHandlerAdapter != null ? requestMappingHandlerAdapter.getWebBindingInitializer() : null));
        }

        @Bean
        @NotNull
        public ArgumentResolver cookieValueArgumentResolver(@NotNull ConfigurableBeanFactory beanFactory, @NotNull ReactiveAdapterRegistry registry, @Dgs @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            return (ArgumentResolver)new SyncHandlerMethodArgumentResolverAdapter((SyncHandlerMethodArgumentResolver)new CookieValueMethodArgumentResolver(beanFactory, registry), bindingContext);
        }

        @Bean
        @NotNull
        public ArgumentResolver requestHeaderMapArgumentResolver(@NotNull ReactiveAdapterRegistry registry, @Dgs @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            return (ArgumentResolver)new SyncHandlerMethodArgumentResolverAdapter((SyncHandlerMethodArgumentResolver)new RequestHeaderMapMethodArgumentResolver(registry), bindingContext);
        }

        @Bean
        @NotNull
        public ArgumentResolver requestHeaderArgumentResolver(@NotNull ConfigurableBeanFactory beanFactory, @NotNull ReactiveAdapterRegistry registry, @Dgs @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            return (ArgumentResolver)new SyncHandlerMethodArgumentResolverAdapter((SyncHandlerMethodArgumentResolver)new RequestHeaderMethodArgumentResolver(beanFactory, registry), bindingContext);
        }

        @Bean
        @NotNull
        public ArgumentResolver requestParamArgumentResolver(@NotNull ConfigurableBeanFactory beanFactory, @NotNull ReactiveAdapterRegistry registry, @Dgs @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            return (ArgumentResolver)new SyncHandlerMethodArgumentResolverAdapter((SyncHandlerMethodArgumentResolver)new RequestParamMethodArgumentResolver(beanFactory, registry, false), bindingContext);
        }

        @Bean
        @NotNull
        public ArgumentResolver requestParamMapArgumentResolver(@NotNull ConfigurableBeanFactory beanFactory, @NotNull ReactiveAdapterRegistry registry, @Dgs @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            return (ArgumentResolver)new SyncHandlerMethodArgumentResolverAdapter((SyncHandlerMethodArgumentResolver)new RequestParamMapMethodArgumentResolver(registry), bindingContext);
        }

        @Qualifier
        @Retention(value=RetentionPolicy.RUNTIME)
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0083\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebFluxAutoConfiguration$WebFluxArgumentHandlerConfiguration$Dgs;", "", "graphql-dgs-spring-webflux-autoconfigure"})
        private static @interface Dgs {
        }
    }
}

