/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.webmvc.autoconfigure;

import com.netflix.graphql.dgs.webmvc.autoconfigure.DgsWebMvcConfigurationProperties;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.PathResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.ResourceTransformerChain;
import org.springframework.web.servlet.resource.TransformedResource;

@Configuration
@EnableConfigurationProperties(value={DgsWebMvcConfigurationProperties.class})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \r2\u00020\u0001:\u0003\r\u000e\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/netflix/graphql/dgs/webmvc/autoconfigure/GraphiQLConfigurer;", "Lorg/springframework/web/servlet/config/annotation/WebMvcConfigurer;", "configProps", "Lcom/netflix/graphql/dgs/webmvc/autoconfigure/DgsWebMvcConfigurationProperties;", "servletContext", "Ljavax/servlet/ServletContext;", "(Lcom/netflix/graphql/dgs/webmvc/autoconfigure/DgsWebMvcConfigurationProperties;Ljavax/servlet/ServletContext;)V", "addResourceHandlers", "", "registry", "Lorg/springframework/web/servlet/config/annotation/ResourceHandlerRegistry;", "addViewControllers", "Lorg/springframework/web/servlet/config/annotation/ViewControllerRegistry;", "Companion", "Constants", "TokenReplacingTransformer", "graphql-dgs-spring-webmvc-autoconfigure"})
public class GraphiQLConfigurer
implements WebMvcConfigurer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsWebMvcConfigurationProperties configProps;
    @NotNull
    private final ServletContext servletContext;
    @NotNull
    private static final Logger logger;

    public GraphiQLConfigurer(@NotNull DgsWebMvcConfigurationProperties configProps, @NotNull ServletContext servletContext) {
        Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
        Intrinsics.checkNotNullParameter((Object)servletContext, (String)"servletContext");
        this.configProps = configProps;
        this.servletContext = servletContext;
    }

    public void addViewControllers(@NotNull ViewControllerRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        registry.addViewController(this.configProps.getGraphiql().getPath()).setViewName("forward:/graphiql/index.html");
        registry.addViewController(Intrinsics.stringPlus((String)this.configProps.getGraphiql().getPath(), (Object)"/")).setViewName("forward:/graphiql/index.html");
    }

    public void addResourceHandlers(@NotNull ResourceHandlerRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        String graphqlPath = Intrinsics.stringPlus((String)this.servletContext.getContextPath(), (Object)this.configProps.getPath());
        logger.info("Configuring GraphiQL to use GraphQL endpoint at '{}'", (Object)graphqlPath);
        String[] stringArray = new String[]{"/graphiql/**"};
        ResourceHandlerRegistration resourceHandlerRegistration = registry.addResourceHandler(stringArray);
        stringArray = new String[]{"classpath:/static/graphiql/"};
        resourceHandlerRegistration.addResourceLocations(stringArray).setCachePeriod(Integer.valueOf(3600)).resourceChain(true).addResolver((ResourceResolver)new PathResourceResolver()).addTransformer((ResourceTransformer)new TokenReplacingTransformer("<DGS_GRAPHQL_PATH>", graphqlPath));
    }

    static {
        Logger logger = LoggerFactory.getLogger(GraphiQLConfigurer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(GraphiQLConfigurer::class.java)");
        GraphiQLConfigurer.logger = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/netflix/graphql/dgs/webmvc/autoconfigure/GraphiQLConfigurer$TokenReplacingTransformer;", "Lorg/springframework/web/servlet/resource/ResourceTransformer;", "replaceToken", "", "replaceValue", "(Ljava/lang/String;Ljava/lang/String;)V", "transform", "Lorg/springframework/core/io/Resource;", "request", "Ljavax/servlet/http/HttpServletRequest;", "resource", "transformerChain", "Lorg/springframework/web/servlet/resource/ResourceTransformerChain;", "graphql-dgs-spring-webmvc-autoconfigure"})
    public static final class TokenReplacingTransformer
    implements ResourceTransformer {
        @NotNull
        private final String replaceToken;
        @NotNull
        private final String replaceValue;

        public TokenReplacingTransformer(@NotNull String replaceToken, @NotNull String replaceValue) {
            Intrinsics.checkNotNullParameter((Object)replaceToken, (String)"replaceToken");
            Intrinsics.checkNotNullParameter((Object)replaceValue, (String)"replaceValue");
            this.replaceToken = replaceToken;
            this.replaceValue = replaceValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Resource transform(@Nullable HttpServletRequest request, @NotNull Resource resource, @Nullable ResourceTransformerChain transformerChain) throws IOException {
            Object object;
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            HttpServletRequest httpServletRequest = request;
            if (httpServletRequest == null ? false : ((object = httpServletRequest.getRequestURI()) == null ? false : StringsKt.endsWith$default((String)object, (String)"/graphiql/index.html", (boolean)false, (int)2, null))) {
                object = resource.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resource.inputStream");
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                Object object2 = object;
                int n = 0;
                object2 = new InputStreamReader((InputStream)object2, charset);
                n = 8192;
                boolean bl2 = false;
                object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                boolean bl3 = false;
                bl = false;
                Throwable throwable = null;
                try {
                    BufferedReader p0 = (BufferedReader)object;
                    boolean bl4 = false;
                    object2 = TextStreamsKt.readText((Reader)p0);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                Object content = object2;
                object = StringsKt.replace$default((String)content, (String)this.replaceToken, (String)this.replaceValue, (boolean)false, (int)4, null);
                Charset charset2 = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
                boolean bl5 = false;
                Object object3 = object;
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = ((String)object3).getBytes(charset2);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                return (Resource)new TransformedResource(resource, byArray);
            }
            return resource;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/webmvc/autoconfigure/GraphiQLConfigurer$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs-spring-webmvc-autoconfigure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/webmvc/autoconfigure/GraphiQLConfigurer$Constants;", "", "()V", "PATH_TO_GRAPHIQL_INDEX_HTML", "", "graphql-dgs-spring-webmvc-autoconfigure"})
    public static final class Constants {
        @NotNull
        public static final Constants INSTANCE = new Constants();
        @NotNull
        public static final String PATH_TO_GRAPHIQL_INDEX_HTML = "/graphiql/index.html";

        private Constants() {
        }
    }
}

