/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.webmvc.autoconfigure;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import com.netflix.graphql.dgs.internal.method.ArgumentResolver;
import com.netflix.graphql.dgs.mvc.DefaultDgsGraphQLRequestHeaderValidator;
import com.netflix.graphql.dgs.mvc.DgsGraphQLRequestHeaderValidator;
import com.netflix.graphql.dgs.mvc.DgsRestController;
import com.netflix.graphql.dgs.mvc.DgsRestSchemaJsonController;
import com.netflix.graphql.dgs.mvc.GraphQLRequestContentTypePredicate;
import com.netflix.graphql.dgs.mvc.GraphQLRequestHeaderValidationRule;
import com.netflix.graphql.dgs.mvc.internal.method.HandlerMethodArgumentResolverAdapter;
import com.netflix.graphql.dgs.webmvc.autoconfigure.DgsWebMvcConfigurationProperties;
import com.netflix.graphql.dgs.webmvc.autoconfigure.GraphiQLConfigurer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.method.annotation.RequestHeaderMapMethodArgumentResolver;
import org.springframework.web.method.annotation.RequestHeaderMethodArgumentResolver;
import org.springframework.web.method.annotation.RequestParamMapMethodArgumentResolver;
import org.springframework.web.method.annotation.RequestParamMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.ServletCookieValueMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.ServletRequestDataBinderFactory;

@AutoConfiguration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={DgsWebMvcConfigurationProperties.class})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001:\u0004\n\u000b\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u0004H\u0017\u00a8\u0006\u000e"}, d2={"Lcom/netflix/graphql/dgs/webmvc/autoconfigure/DgsWebMvcAutoConfiguration;", "", "()V", "dgsObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "dgsRestController", "Lcom/netflix/graphql/dgs/mvc/DgsRestController;", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "objectMapper", "DgsGraphiQLConfiguration", "DgsWebMvcSchemaJsonConfiguration", "WebMvcArgumentHandlerConfiguration", "WebMvcHeaderValidationConfiguration", "graphql-dgs-spring-webmvc-autoconfigure"})
public class DgsWebMvcAutoConfiguration {
    @Bean
    @Qualifier(value="dgsObjectMapper")
    @ConditionalOnMissingBean(name={"dgsObjectMapper"})
    @NotNull
    public ObjectMapper dgsObjectMapper() {
        ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper().registerModule((Module)new JavaTimeModule());
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"jacksonObjectMapper().re\u2026rModule(JavaTimeModule())");
        return objectMapper;
    }

    @Bean
    @NotNull
    public DgsRestController dgsRestController(@NotNull DgsQueryExecutor dgsQueryExecutor, @Qualifier(value="dgsObjectMapper") @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        return new DgsRestController(dgsQueryExecutor, objectMapper, null, 4, null);
    }

    @Configuration
    @ConditionalOnClass(value={DispatcherServlet.class})
    @ConditionalOnProperty(name={"dgs.graphql.graphiql.enabled"}, havingValue="true", matchIfMissing=true)
    @Import(value={GraphiQLConfigurer.class})
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/netflix/graphql/dgs/webmvc/autoconfigure/DgsWebMvcAutoConfiguration$DgsGraphiQLConfiguration;", "", "()V", "graphql-dgs-spring-webmvc-autoconfigure"})
    public static class DgsGraphiQLConfiguration {
    }

    @Configuration
    @ConditionalOnProperty(name={"dgs.graphql.schema-json.enabled"}, havingValue="true", matchIfMissing=true)
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\u0007"}, d2={"Lcom/netflix/graphql/dgs/webmvc/autoconfigure/DgsWebMvcAutoConfiguration$DgsWebMvcSchemaJsonConfiguration;", "", "()V", "dgsRestSchemaJsonController", "Lcom/netflix/graphql/dgs/mvc/DgsRestSchemaJsonController;", "dgsSchemaProvider", "Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "graphql-dgs-spring-webmvc-autoconfigure"})
    public static class DgsWebMvcSchemaJsonConfiguration {
        @Bean
        @NotNull
        public DgsRestSchemaJsonController dgsRestSchemaJsonController(@NotNull DgsSchemaProvider dgsSchemaProvider) {
            Intrinsics.checkNotNullParameter((Object)dgsSchemaProvider, (String)"dgsSchemaProvider");
            return new DgsRestSchemaJsonController(dgsSchemaProvider);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017J\u0016\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0017J\u0012\u0010\r\u001a\u00020\u00042\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017J\u001a\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017J\u0012\u0010\u000f\u001a\u00020\u00042\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017J\u0012\u0010\u0010\u001a\u00020\u00042\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\u0012"}, d2={"Lcom/netflix/graphql/dgs/webmvc/autoconfigure/DgsWebMvcAutoConfiguration$WebMvcArgumentHandlerConfiguration;", "", "()V", "cookieValueResolver", "Lcom/netflix/graphql/dgs/internal/method/ArgumentResolver;", "beanFactory", "Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;", "dataBinderFactory", "Lorg/springframework/web/bind/support/WebDataBinderFactory;", "dgsWebDataBinderFactory", "adapter", "Lorg/springframework/beans/factory/ObjectProvider;", "Lorg/springframework/web/servlet/mvc/method/annotation/RequestMappingHandlerAdapter;", "requestHeaderMapResolver", "requestHeaderResolver", "requestParamMapResolver", "requestParamResolver", "Dgs", "graphql-dgs-spring-webmvc-autoconfigure"})
    public static class WebMvcArgumentHandlerConfiguration {
        @Bean
        @Dgs
        @NotNull
        public WebDataBinderFactory dgsWebDataBinderFactory(@NotNull ObjectProvider<RequestMappingHandlerAdapter> adapter) {
            Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
            RequestMappingHandlerAdapter requestMappingHandlerAdapter = (RequestMappingHandlerAdapter)adapter.getIfAvailable();
            return (WebDataBinderFactory)new ServletRequestDataBinderFactory(CollectionsKt.emptyList(), (WebBindingInitializer)(requestMappingHandlerAdapter != null ? requestMappingHandlerAdapter.getWebBindingInitializer() : null));
        }

        @Bean
        @NotNull
        public ArgumentResolver requestHeaderMapResolver(@Dgs @NotNull WebDataBinderFactory dataBinderFactory) {
            Intrinsics.checkNotNullParameter((Object)dataBinderFactory, (String)"dataBinderFactory");
            return (ArgumentResolver)new HandlerMethodArgumentResolverAdapter((HandlerMethodArgumentResolver)new RequestHeaderMapMethodArgumentResolver(), dataBinderFactory);
        }

        @Bean
        @NotNull
        public ArgumentResolver requestHeaderResolver(@NotNull ConfigurableBeanFactory beanFactory, @Dgs @NotNull WebDataBinderFactory dataBinderFactory) {
            Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
            Intrinsics.checkNotNullParameter((Object)dataBinderFactory, (String)"dataBinderFactory");
            return (ArgumentResolver)new HandlerMethodArgumentResolverAdapter((HandlerMethodArgumentResolver)new RequestHeaderMethodArgumentResolver(beanFactory), dataBinderFactory);
        }

        @Bean
        @NotNull
        public ArgumentResolver requestParamResolver(@Dgs @NotNull WebDataBinderFactory dataBinderFactory) {
            Intrinsics.checkNotNullParameter((Object)dataBinderFactory, (String)"dataBinderFactory");
            return (ArgumentResolver)new HandlerMethodArgumentResolverAdapter((HandlerMethodArgumentResolver)new RequestParamMethodArgumentResolver(false), dataBinderFactory);
        }

        @Bean
        @NotNull
        public ArgumentResolver requestParamMapResolver(@Dgs @NotNull WebDataBinderFactory dataBinderFactory) {
            Intrinsics.checkNotNullParameter((Object)dataBinderFactory, (String)"dataBinderFactory");
            return (ArgumentResolver)new HandlerMethodArgumentResolverAdapter((HandlerMethodArgumentResolver)new RequestParamMapMethodArgumentResolver(), dataBinderFactory);
        }

        @Bean
        @NotNull
        public ArgumentResolver cookieValueResolver(@NotNull ConfigurableBeanFactory beanFactory, @Dgs @NotNull WebDataBinderFactory dataBinderFactory) {
            Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
            Intrinsics.checkNotNullParameter((Object)dataBinderFactory, (String)"dataBinderFactory");
            return (ArgumentResolver)new HandlerMethodArgumentResolverAdapter((HandlerMethodArgumentResolver)new ServletCookieValueMethodArgumentResolver(beanFactory), dataBinderFactory);
        }

        @Qualifier
        @Retention(value=RetentionPolicy.RUNTIME)
        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0083\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/netflix/graphql/dgs/webmvc/autoconfigure/DgsWebMvcAutoConfiguration$WebMvcArgumentHandlerConfiguration$Dgs;", "", "graphql-dgs-spring-webmvc-autoconfigure"})
        private static @interface Dgs {
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006H\u0017J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0017J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0017\u00a8\u0006\r"}, d2={"Lcom/netflix/graphql/dgs/webmvc/autoconfigure/DgsWebMvcAutoConfiguration$WebMvcHeaderValidationConfiguration;", "", "()V", "defaultOSSDgsGraphQLRequestHeadersValidator", "Lcom/netflix/graphql/dgs/mvc/DgsGraphQLRequestHeaderValidator;", "validationRulesProvider", "Lorg/springframework/beans/factory/ObjectProvider;", "Lcom/netflix/graphql/dgs/mvc/GraphQLRequestHeaderValidationRule;", "contentTypePredicatesProviders", "Lcom/netflix/graphql/dgs/mvc/GraphQLRequestContentTypePredicate;", "graphQLRequestContentTypePredicates", "", "graphqlRequestHeaderValidationRules", "graphql-dgs-spring-webmvc-autoconfigure"})
    public static class WebMvcHeaderValidationConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @NotNull
        public DgsGraphQLRequestHeaderValidator defaultOSSDgsGraphQLRequestHeadersValidator(@NotNull ObjectProvider<GraphQLRequestHeaderValidationRule> validationRulesProvider, @NotNull ObjectProvider<GraphQLRequestContentTypePredicate> contentTypePredicatesProviders) {
            Intrinsics.checkNotNullParameter(validationRulesProvider, (String)"validationRulesProvider");
            Intrinsics.checkNotNullParameter(contentTypePredicatesProviders, (String)"contentTypePredicatesProviders");
            List list = validationRulesProvider.orderedStream().toList();
            List list2 = contentTypePredicatesProviders.orderedStream().toList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"toList()");
            Intrinsics.checkNotNullExpressionValue(list, (String)"toList()");
            return (DgsGraphQLRequestHeaderValidator)new DefaultDgsGraphQLRequestHeaderValidator(list2, list);
        }

        @Bean
        @NotNull
        public List<GraphQLRequestContentTypePredicate> graphQLRequestContentTypePredicates() {
            return GraphQLRequestContentTypePredicate.Companion.getRECOMMENDED_GRAPHQL_CONTENT_TYPE_PREDICATES();
        }

        @Bean
        @ConditionalOnProperty(value={"dgs.graphql.header.validation.enabled"}, havingValue="true", matchIfMissing=true)
        @NotNull
        public List<GraphQLRequestHeaderValidationRule> graphqlRequestHeaderValidationRules() {
            return DgsGraphQLRequestHeaderValidator.Companion.getRECOMMENDED_GRAPHQL_REQUEST_HEADERS_VALIDATOR();
        }
    }
}

