/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.webmvc.autoconfigure;

import com.netflix.graphql.dgs.webmvc.autoconfigure.DgsWebMvcConfigurationProperties;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.config.annotation.ResourceChainRegistration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.PathResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.ResourceTransformerChain;
import org.springframework.web.servlet.resource.TransformedResource;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={DgsWebMvcConfigurationProperties.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \r2\u00020\u0001:\u0003\r\u000e\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/netflix/graphql/dgs/webmvc/autoconfigure/GraphiQLConfigurer;", "Lorg/springframework/web/servlet/config/annotation/WebMvcConfigurer;", "configProps", "Lcom/netflix/graphql/dgs/webmvc/autoconfigure/DgsWebMvcConfigurationProperties;", "servletContext", "Ljakarta/servlet/ServletContext;", "(Lcom/netflix/graphql/dgs/webmvc/autoconfigure/DgsWebMvcConfigurationProperties;Ljakarta/servlet/ServletContext;)V", "addResourceHandlers", "", "registry", "Lorg/springframework/web/servlet/config/annotation/ResourceHandlerRegistry;", "addViewControllers", "Lorg/springframework/web/servlet/config/annotation/ViewControllerRegistry;", "Companion", "Constants", "TokenReplacingTransformer", "graphql-dgs-spring-webmvc-autoconfigure"})
public class GraphiQLConfigurer
implements WebMvcConfigurer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsWebMvcConfigurationProperties configProps;
    @NotNull
    private final ServletContext servletContext;
    @NotNull
    private static final Logger logger;

    public GraphiQLConfigurer(@NotNull DgsWebMvcConfigurationProperties configProps, @NotNull ServletContext servletContext) {
        Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
        Intrinsics.checkNotNullParameter((Object)servletContext, (String)"servletContext");
        this.configProps = configProps;
        this.servletContext = servletContext;
    }

    public void addViewControllers(@NotNull ViewControllerRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        registry.addViewController(this.configProps.getGraphiql().getPath()).setViewName("forward:/graphiql/index.html");
        registry.addViewController(this.configProps.getGraphiql().getPath() + "/").setViewName("forward:/graphiql/index.html");
    }

    public void addResourceHandlers(@NotNull ResourceHandlerRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        String graphqlPath = this.servletContext.getContextPath() + this.configProps.getPath();
        logger.info("Configuring GraphiQL to use GraphQL endpoint at '{}'", (Object)graphqlPath);
        String[] stringArray = new String[]{"/graphiql/**"};
        ResourceHandlerRegistration resourceHandlerRegistration = registry.addResourceHandler(stringArray);
        stringArray = new String[]{"classpath:/graphiql/"};
        ResourceChainRegistration resourceChainRegistration = resourceHandlerRegistration.addResourceLocations(stringArray).setCachePeriod(Integer.valueOf(3600)).resourceChain(true).addResolver((ResourceResolver)new PathResourceResolver());
        stringArray = new Pair[]{TuplesKt.to((Object)"<DGS_GRAPHQL_PATH>", (Object)graphqlPath), TuplesKt.to((Object)"<DGS_GRAPHIQL_TITLE>", (Object)this.configProps.getGraphiql().getTitle())};
        resourceChainRegistration.addTransformer((ResourceTransformer)new TokenReplacingTransformer(MapsKt.mapOf((Pair[])stringArray)));
    }

    static {
        Logger logger = LoggerFactory.getLogger(GraphiQLConfigurer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        GraphiQLConfigurer.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/webmvc/autoconfigure/GraphiQLConfigurer$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs-spring-webmvc-autoconfigure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/webmvc/autoconfigure/GraphiQLConfigurer$Constants;", "", "()V", "PATH_TO_GRAPHIQL_INDEX_HTML", "", "graphql-dgs-spring-webmvc-autoconfigure"})
    public static final class Constants {
        @NotNull
        public static final Constants INSTANCE = new Constants();
        @NotNull
        public static final String PATH_TO_GRAPHIQL_INDEX_HTML = "/graphiql/index.html";

        private Constants() {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/netflix/graphql/dgs/webmvc/autoconfigure/GraphiQLConfigurer$TokenReplacingTransformer;", "Lorg/springframework/web/servlet/resource/ResourceTransformer;", "replaceMap", "", "", "(Ljava/util/Map;)V", "transform", "Lorg/springframework/core/io/Resource;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "resource", "transformerChain", "Lorg/springframework/web/servlet/resource/ResourceTransformerChain;", "graphql-dgs-spring-webmvc-autoconfigure"})
    @SourceDebugExtension(value={"SMAP\nGraphiQLConfigurer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphiQLConfigurer.kt\ncom/netflix/graphql/dgs/webmvc/autoconfigure/GraphiQLConfigurer$TokenReplacingTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,95:1\n1#2:96\n215#3,2:97\n*S KotlinDebug\n*F\n+ 1 GraphiQLConfigurer.kt\ncom/netflix/graphql/dgs/webmvc/autoconfigure/GraphiQLConfigurer$TokenReplacingTransformer\n*L\n80#1:97,2\n*E\n"})
    public static final class TokenReplacingTransformer
    implements ResourceTransformer {
        @NotNull
        private final Map<String, String> replaceMap;

        public TokenReplacingTransformer(@NotNull Map<String, String> replaceMap) {
            Intrinsics.checkNotNullParameter(replaceMap, (String)"replaceMap");
            this.replaceMap = replaceMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Resource transform(@NotNull HttpServletRequest request, @NotNull Resource resource, @NotNull ResourceTransformerChain transformerChain) throws IOException {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Intrinsics.checkNotNullParameter((Object)transformerChain, (String)"transformerChain");
            String string = request.getRequestURI();
            if (string == null) {
                string = "";
            }
            if (StringsKt.endsWith$default((String)string, (String)"/graphiql/index.html", (boolean)false, (int)2, null)) {
                Object content = null;
                InputStream inputStream = resource.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                Object object = inputStream;
                Object object2 = Charsets.UTF_8;
                Iterator<Map.Entry<String, String>> iterator = new InputStreamReader((InputStream)object, (Charset)object2);
                int n = 8192;
                object = iterator instanceof BufferedReader ? (BufferedReader)((Object)iterator) : new BufferedReader((Reader)((Object)iterator), n);
                object2 = null;
                try {
                    BufferedReader p0 = (BufferedReader)object;
                    boolean bl = false;
                    iterator = TextStreamsKt.readText((Reader)p0);
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
                content = iterator;
                Map<String, String> $this$forEach$iv = this.replaceMap;
                boolean $i$f$forEach = false;
                iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> element$iv;
                    Map.Entry<String, String> it = element$iv = iterator.next();
                    boolean bl = false;
                    content = StringsKt.replace$default(content, (String)it.getKey(), (String)it.getValue(), (boolean)false, (int)4, null);
                }
                object = content;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                byte[] byArray = ((String)object).getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                return (Resource)new TransformedResource(resource, byArray);
            }
            return resource;
        }
    }
}

