/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.mvc;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.internal.utils.MultipartVariableMapper;
import com.netflix.graphql.dgs.internal.utils.TimeTracer;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphqlErrorBuilder;
import graphql.execution.reactive.SubscriptionPublisher;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\\\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0016\b\u0001\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\r2\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\r2\b\b\u0001\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/netflix/graphql/dgs/mvc/DgsRestController;", "", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/netflix/graphql/dgs/DgsQueryExecutor;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getDgsQueryExecutor", "()Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "graphql", "Lorg/springframework/http/ResponseEntity;", "", "body", "fileParams", "", "Lorg/springframework/web/multipart/MultipartFile;", "operation", "mapParam", "headers", "Lorg/springframework/http/HttpHeaders;", "webRequest", "Lorg/springframework/web/context/request/WebRequest;", "Companion", "graphql-dgs-spring-webmvc"})
public class DgsRestController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsQueryExecutor dgsQueryExecutor;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final MediaType GRAPHQL_MEDIA_TYPE;

    public DgsRestController(@NotNull DgsQueryExecutor dgsQueryExecutor, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.dgsQueryExecutor = dgsQueryExecutor;
        this.mapper = mapper;
    }

    public /* synthetic */ DgsRestController(DgsQueryExecutor dgsQueryExecutor, ObjectMapper objectMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            objectMapper = ExtensionsKt.jacksonObjectMapper();
        }
        this(dgsQueryExecutor, objectMapper);
    }

    @NotNull
    public DgsQueryExecutor getDgsQueryExecutor() {
        return this.dgsQueryExecutor;
    }

    @NotNull
    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @RequestMapping(value={"#{@'dgs.graphql-com.netflix.graphql.dgs.webmvc.autoconfigure.DgsWebMvcConfigurationProperties'.path}"}, produces={"application/json"})
    @NotNull
    public final ResponseEntity<String> graphql(@RequestBody @Nullable String body, @RequestParam @Nullable Map<String, ? extends MultipartFile> fileParams, @RequestParam(name="operations") @Nullable String operation, @RequestParam(name="map") @Nullable String mapParam, @RequestHeader @NotNull HttpHeaders headers, @NotNull WebRequest webRequest) {
        Object opName;
        Object object;
        boolean $i$f$jacksonTypeRef;
        ObjectMapper $this$readValue$iv;
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)webRequest, (String)"webRequest");
        logger.debug("Starting /graphql handling");
        Map inputQuery = null;
        Map queryVariables = null;
        Map extensions = null;
        if (body != null) {
            logger.debug("Reading input value: '{}'", (Object)body);
            if (GRAPHQL_MEDIA_TYPE.includes(headers.getContentType())) {
                inputQuery = MapsKt.mapOf((Pair)TuplesKt.to((Object)"query", (Object)body));
                queryVariables = MapsKt.emptyMap();
                extensions = MapsKt.emptyMap();
            } else {
                Map map;
                Map map2;
                try {
                    $this$readValue$iv = this.getMapper();
                    boolean $i$f$readValue = false;
                    $i$f$jacksonTypeRef = false;
                    inputQuery = (Map)$this$readValue$iv.readValue(body, (TypeReference)new TypeReference<Map<String, ? extends Object>>(){});
                }
                catch (Exception ex) {
                    ResponseEntity responseEntity;
                    Exception $i$f$readValue = ex;
                    if ($i$f$readValue instanceof JsonParseException) {
                        ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.badRequest();
                        StringBuilder stringBuilder = new StringBuilder().append("Invalid query - ");
                        String string = ex.getMessage();
                        if (string == null) {
                            string = "no details found in the error message";
                        }
                        ResponseEntity responseEntity2 = bodyBuilder.body((Object)stringBuilder.append(string).append('.').toString());
                        responseEntity = responseEntity2;
                        Intrinsics.checkNotNullExpressionValue((Object)responseEntity2, (String)"badRequest()\n           \u2026in the error message\"}.\")");
                    } else if ($i$f$readValue instanceof MismatchedInputException) {
                        ResponseEntity responseEntity3 = ResponseEntity.badRequest().body((Object)"Invalid query - No content to map to input.");
                        responseEntity = responseEntity3;
                        Intrinsics.checkNotNullExpressionValue((Object)responseEntity3, (String)"badRequest()\n           \u2026ontent to map to input.\")");
                    } else {
                        ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.badRequest();
                        StringBuilder stringBuilder = new StringBuilder().append("Invalid query - ");
                        String string = ex.getMessage();
                        if (string == null) {
                            string = "no additional details found";
                        }
                        ResponseEntity responseEntity4 = bodyBuilder.body((Object)stringBuilder.append(string).append('.').toString());
                        responseEntity = responseEntity4;
                        Intrinsics.checkNotNullExpressionValue((Object)responseEntity4, (String)"badRequest()\n           \u2026tional details found\"}.\")");
                    }
                    return responseEntity;
                }
                if (inputQuery.get("variables") != null) {
                    Object v = inputQuery.get("variables");
                    if (v == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                    }
                    map2 = (Map)v;
                } else {
                    map2 = queryVariables = MapsKt.emptyMap();
                }
                if (inputQuery.get("extensions") != null) {
                    Object v = inputQuery.get("extensions");
                    if (v == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                    }
                    map = (Map)v;
                } else {
                    map = MapsKt.emptyMap();
                }
                extensions = map;
                logger.debug("Parsed variables: {}", (Object)queryVariables);
            }
        } else if (fileParams != null && mapParam != null && operation != null) {
            Map fileMapInput;
            Map map;
            Map map3;
            $this$readValue$iv = this.getMapper();
            boolean $i$f$readValue = false;
            $i$f$jacksonTypeRef = false;
            inputQuery = (Map)$this$readValue$iv.readValue(operation, (TypeReference)new TypeReference<Map<String, ? extends Object>>(){});
            if (inputQuery.get("variables") != null) {
                Object v = inputQuery.get("variables");
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                }
                map3 = (Map)v;
            } else {
                map3 = queryVariables = MapsKt.emptyMap();
            }
            if (inputQuery.get("extensions") != null) {
                Object v = inputQuery.get("extensions");
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                }
                map = (Map)v;
            } else {
                map = MapsKt.emptyMap();
            }
            extensions = map;
            ObjectMapper $this$readValue$iv2 = this.getMapper();
            boolean $i$f$readValue2 = false;
            boolean $i$f$jacksonTypeRef2 = false;
            Map $this$forEach$iv = fileMapInput = (Map)$this$readValue$iv2.readValue(mapParam, (TypeReference)new TypeReference<Map<String, ? extends List<? extends String>>>(){});
            boolean $i$f$forEach = false;
            for (Map.Entry entry : $this$forEach$iv.entrySet()) {
                object = entry;
                boolean bl = false;
                String fileKey = (String)object.getKey();
                List objectPaths = (List)object.getValue();
                MultipartFile file = fileParams.get(fileKey);
                if (file == null) continue;
                Iterable $this$forEach$iv2 = objectPaths;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String objectPath = (String)element$iv2;
                    boolean bl2 = false;
                    MultipartVariableMapper.INSTANCE.mapVariable(objectPath, queryVariables, file);
                }
            }
        } else {
            ResponseEntity responseEntity = ResponseEntity.badRequest().body((Object)"Invalid GraphQL request - no request body was provided");
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"badRequest().body(\"Inval\u2026quest body was provided\")");
            return responseEntity;
        }
        Object v = opName = inputQuery.get("operationName");
        if (!(v == null ? true : v instanceof String)) {
            ResponseEntity responseEntity = ResponseEntity.badRequest().body((Object)"Invalid GraphQL request - operationName must be a String");
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"badRequest().body(\"Inval\u2026onName must be a String\")");
            return responseEntity;
        }
        String gqlOperationName = (String)opName;
        Object $i$f$jacksonTypeRef2 = inputQuery.get("query");
        String query = $i$f$jacksonTypeRef2 instanceof String ? (String)$i$f$jacksonTypeRef2 : null;
        ExecutionResult executionResult2 = (ExecutionResult)TimeTracer.INSTANCE.logTime((Function0)new Function0<ExecutionResult>(this, query, (Map<String, ? extends Object>)queryVariables, (Map<String, ? extends Object>)extensions, headers, gqlOperationName, webRequest){
            final /* synthetic */ DgsRestController this$0;
            final /* synthetic */ String $query;
            final /* synthetic */ Map<String, Object> $queryVariables;
            final /* synthetic */ Map<String, Object> $extensions;
            final /* synthetic */ HttpHeaders $headers;
            final /* synthetic */ String $gqlOperationName;
            final /* synthetic */ WebRequest $webRequest;
            {
                this.this$0 = $receiver;
                this.$query = $query;
                this.$queryVariables = $queryVariables;
                this.$extensions = $extensions;
                this.$headers = $headers;
                this.$gqlOperationName = $gqlOperationName;
                this.$webRequest = $webRequest;
                super(0);
            }

            public final ExecutionResult invoke() {
                return this.this$0.getDgsQueryExecutor().execute(this.$query, this.$queryVariables, this.$extensions, this.$headers, this.$gqlOperationName, this.$webRequest);
            }
        }, logger, "Executed query in {}ms");
        logger.debug("Execution result - Contains data: '{}' - Number of errors: {}", (Object)executionResult2.isDataPresent(), (Object)executionResult2.getErrors().size());
        if (executionResult2.isDataPresent() && executionResult2.getData() instanceof SubscriptionPublisher) {
            ResponseEntity responseEntity = ResponseEntity.badRequest().body((Object)"Trying to execute subscription on /graphql. Use /subscriptions instead!");
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"badRequest()\n           \u2026/subscriptions instead!\")");
            return responseEntity;
        }
        try {
            object = (String)TimeTracer.INSTANCE.logTime((Function0)new Function0<String>(this, executionResult2){
                final /* synthetic */ DgsRestController this$0;
                final /* synthetic */ ExecutionResult $executionResult;
                {
                    this.this$0 = $receiver;
                    this.$executionResult = $executionResult;
                    super(0);
                }

                public final String invoke() {
                    return this.this$0.getMapper().writeValueAsString((Object)this.$executionResult.toSpecification());
                }
            }, logger, "Serialized JSON result in {}ms");
        }
        catch (InvalidDefinitionException ex) {
            String errorMessage = "Error serializing response: " + ex.getMessage();
            ExecutionResultImpl errorResponse = new ExecutionResultImpl(GraphqlErrorBuilder.newError().message(errorMessage, new Object[0]).build());
            logger.error(errorMessage, (Throwable)ex);
            object = this.getMapper().writeValueAsString((Object)errorResponse.toSpecification());
        }
        Object object2 = object;
        ResponseEntity responseEntity = ResponseEntity.ok((Object)object2);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(result)");
        return responseEntity;
    }

    static {
        Logger logger = LoggerFactory.getLogger(DgsRestController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DgsRestController::class.java)");
        DgsRestController.logger = logger;
        GRAPHQL_MEDIA_TYPE = new MediaType("application", "graphql");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/netflix/graphql/dgs/mvc/DgsRestController$Companion;", "", "()V", "GRAPHQL_MEDIA_TYPE", "Lorg/springframework/http/MediaType;", "logger", "Lorg/slf4j/Logger;", "graphql-dgs-spring-webmvc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

