/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.mvc;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.internal.utils.MultipartVariableMapper;
import com.netflix.graphql.dgs.internal.utils.TimeTracer;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphqlErrorBuilder;
import graphql.execution.reactive.CompletionStageMappingPublisher;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\\\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\t2\u0016\b\u0001\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\t2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/netflix/graphql/dgs/mvc/DgsRestController;", "", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "(Lcom/netflix/graphql/dgs/DgsQueryExecutor;)V", "getDgsQueryExecutor", "()Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "graphql", "Lorg/springframework/http/ResponseEntity;", "", "body", "fileParams", "", "Lorg/springframework/web/multipart/MultipartFile;", "operation", "mapParam", "headers", "Lorg/springframework/http/HttpHeaders;", "webRequest", "Lorg/springframework/web/context/request/WebRequest;", "Companion", "graphql-dgs-spring-webmvc"})
public class DgsRestController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsQueryExecutor dgsQueryExecutor;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final ObjectMapper mapper;

    public DgsRestController(@NotNull DgsQueryExecutor dgsQueryExecutor) {
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        this.dgsQueryExecutor = dgsQueryExecutor;
    }

    @NotNull
    public DgsQueryExecutor getDgsQueryExecutor() {
        return this.dgsQueryExecutor;
    }

    @RequestMapping(value={"#{@'dgs.graphql-com.netflix.graphql.dgs.webmvc.autoconfigure.DgsWebMvcConfigurationProperties'.path}"}, produces={"application/json"})
    @NotNull
    public final ResponseEntity<String> graphql(@RequestBody @Nullable String body, @RequestParam @Nullable Map<String, ? extends MultipartFile> fileParams, @RequestParam(name="operations") @Nullable String operation, @RequestParam(name="map") @Nullable String mapParam, @RequestHeader @NotNull HttpHeaders headers, @NotNull WebRequest webRequest) {
        String string;
        String ex2;
        Object it;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)webRequest, (String)"webRequest");
        logger.debug("Starting /graphql handling");
        Map inputQuery = null;
        Map queryVariables = null;
        Map extensions = null;
        if (body != null) {
            logger.debug("Reading input value: '{}'", (Object)body);
            String string2 = headers.getFirst("Content-Type");
            if (string2 == null ? false : StringsKt.contains$default((CharSequence)string2, (CharSequence)"application/graphql", (boolean)false, (int)2, null)) {
                inputQuery = MapsKt.mapOf((Pair)new Pair((Object)"query", (Object)body));
                queryVariables = MapsKt.emptyMap();
                extensions = MapsKt.emptyMap();
            } else {
                Map map;
                Map map2;
                try {
                    string2 = body;
                    boolean bl2 = false;
                    bl = false;
                    it = string2;
                    boolean bl3 = false;
                    ObjectMapper $this$readValue$iv = mapper;
                    boolean $i$f$readValue = false;
                    boolean $i$f$jacksonTypeRef = false;
                    inputQuery = (Map)$this$readValue$iv.readValue((String)it, (TypeReference)new TypeReference<Map<String, ? extends Object>>(){});
                }
                catch (JsonParseException ex2) {
                    String string3 = ex2.getMessage();
                    ResponseEntity responseEntity = ResponseEntity.badRequest().body((Object)(string3 == null ? "Error parsing query - no details found in the error message" : string3));
                    Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"badRequest()\n           \u2026nd in the error message\")");
                    return responseEntity;
                }
                if (inputQuery.get("variables") != null) {
                    ex2 = inputQuery.get("variables");
                    if (ex2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                    }
                    map2 = (Map)((Object)ex2);
                } else {
                    map2 = queryVariables = MapsKt.emptyMap();
                }
                if (inputQuery.get("extensions") != null) {
                    ex2 = inputQuery.get("extensions");
                    if (ex2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                    }
                    map = (Map)((Object)ex2);
                } else {
                    map = MapsKt.emptyMap();
                }
                extensions = map;
                logger.debug("Parsed variables: {}", (Object)queryVariables);
            }
        } else if (fileParams != null && mapParam != null && operation != null) {
            Map fileMapInput;
            Map map;
            Map map3;
            ex2 = operation;
            boolean bl4 = false;
            bl = false;
            String it22 = ex2;
            boolean bl5 = false;
            ObjectMapper $this$readValue$iv = mapper;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            inputQuery = (Map)$this$readValue$iv.readValue(it22, (TypeReference)new TypeReference<Map<String, ? extends Object>>(){});
            if (inputQuery.get("variables") != null) {
                ex2 = inputQuery.get("variables");
                if (ex2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                }
                map3 = (Map)((Object)ex2);
            } else {
                map3 = queryVariables = MapsKt.emptyMap();
            }
            if (inputQuery.get("extensions") != null) {
                ex2 = inputQuery.get("extensions");
                if (ex2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                }
                map = (Map)((Object)ex2);
            } else {
                map = MapsKt.emptyMap();
            }
            extensions = map;
            String string4 = mapParam;
            bl = false;
            boolean it22 = false;
            String it3 = string4;
            boolean $i$a$-let-DgsRestController$graphql$fileMapInput$22 = false;
            ObjectMapper $this$readValue$iv2 = mapper;
            boolean $i$f$readValue2 = false;
            boolean $i$f$jacksonTypeRef2 = false;
            Map $this$forEach$iv = fileMapInput = (Map)$this$readValue$iv2.readValue(it3, (TypeReference)new TypeReference<Map<String, ? extends List<? extends String>>>(){});
            boolean $i$f$forEach = false;
            it = $this$forEach$iv;
            boolean bl6 = false;
            Iterator $i$a$-let-DgsRestController$graphql$fileMapInput$22 = it.entrySet().iterator();
            while ($i$a$-let-DgsRestController$graphql$fileMapInput$22.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$fileKey$objectPaths = element$iv = $i$a$-let-DgsRestController$graphql$fileMapInput$22.next();
                boolean bl7 = false;
                Map.Entry entry = $dstr$fileKey$objectPaths;
                boolean bl8 = false;
                String fileKey = (String)entry.getKey();
                Map.Entry entry2 = $dstr$fileKey$objectPaths;
                boolean bl9 = false;
                List objectPaths = (List)entry2.getValue();
                MultipartFile file = fileParams.get(fileKey);
                if (file == null) continue;
                Iterable $this$forEach$iv2 = objectPaths;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String objectPath = (String)element$iv2;
                    boolean bl10 = false;
                    MultipartVariableMapper.INSTANCE.mapVariable(objectPath, queryVariables, file);
                }
            }
        } else {
            ResponseEntity fileMapInput = ResponseEntity.badRequest().body((Object)"Invalid GraphQL request - no request body was provided");
            Intrinsics.checkNotNullExpressionValue((Object)fileMapInput, (String)"badRequest().body(\"Inval\u2026quest body was provided\")");
            return fileMapInput;
        }
        Object opName = inputQuery.get("operationName");
        if (!(opName == null ? true : opName instanceof String)) {
            ResponseEntity $i$f$forEach = ResponseEntity.badRequest().body((Object)"Invalid GraphQL request - operationName must be a String");
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEach, (String)"badRequest().body(\"Inval\u2026onName must be a String\")");
            return $i$f$forEach;
        }
        String gqlOperationName = (String)opName;
        ExecutionResult executionResult2 = (ExecutionResult)TimeTracer.INSTANCE.logTime((Function0)new Function0<ExecutionResult>(this, (Map<String, ? extends Object>)inputQuery, (Map<String, ? extends Object>)queryVariables, (Map<String, ? extends Object>)extensions, headers, gqlOperationName, webRequest){
            final /* synthetic */ DgsRestController this$0;
            final /* synthetic */ Map<String, Object> $inputQuery;
            final /* synthetic */ Map<String, Object> $queryVariables;
            final /* synthetic */ Map<String, Object> $extensions;
            final /* synthetic */ HttpHeaders $headers;
            final /* synthetic */ String $gqlOperationName;
            final /* synthetic */ WebRequest $webRequest;
            {
                this.this$0 = $receiver;
                this.$inputQuery = $inputQuery;
                this.$queryVariables = $queryVariables;
                this.$extensions = $extensions;
                this.$headers = $headers;
                this.$gqlOperationName = $gqlOperationName;
                this.$webRequest = $webRequest;
                super(0);
            }

            public final ExecutionResult invoke() {
                Object object = this.$inputQuery.get("query");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                return this.this$0.getDgsQueryExecutor().execute((String)object, this.$queryVariables, this.$extensions, this.$headers, this.$gqlOperationName, this.$webRequest);
            }
        }, logger, "Executed query in {}ms");
        logger.debug("Execution result - Contains data: '{}' - Number of errors: {}", (Object)executionResult2.isDataPresent(), (Object)executionResult2.getErrors().size());
        if (executionResult2.isDataPresent() && executionResult2.getData() instanceof CompletionStageMappingPublisher) {
            it = ResponseEntity.badRequest().body((Object)"Trying to execute subscription on /graphql. Use /subscriptions instead!");
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"badRequest()\n           \u2026/subscriptions instead!\")");
            return it;
        }
        try {
            string = (String)TimeTracer.INSTANCE.logTime((Function0)new Function0<String>(executionResult2){
                final /* synthetic */ ExecutionResult $executionResult;
                {
                    this.$executionResult = $executionResult;
                    super(0);
                }

                public final String invoke() {
                    return DgsRestController.access$getMapper$cp().writeValueAsString((Object)this.$executionResult.toSpecification());
                }
            }, logger, "Serialized JSON result in {}ms");
        }
        catch (InvalidDefinitionException ex3) {
            String errorMessage = Intrinsics.stringPlus((String)"Error serializing response: ", (Object)ex3.getMessage());
            ExecutionResultImpl errorResponse = new ExecutionResultImpl(GraphqlErrorBuilder.newError().message(errorMessage, new Object[0]).build());
            logger.error(errorMessage, (Throwable)ex3);
            string = mapper.writeValueAsString((Object)errorResponse.toSpecification());
        }
        String result2 = string;
        string = ResponseEntity.ok((Object)result2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ok(result)");
        return string;
    }

    public static final /* synthetic */ ObjectMapper access$getMapper$cp() {
        return mapper;
    }

    static {
        Logger logger = LoggerFactory.getLogger(DgsRestController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DgsRestController::class.java)");
        DgsRestController.logger = logger;
        mapper = ExtensionsKt.jacksonObjectMapper();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/netflix/graphql/dgs/mvc/DgsRestController$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "graphql-dgs-spring-webmvc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

