/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.mvc;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.DgsExecutionResult;
import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.internal.utils.MultipartVariableMapper;
import com.netflix.graphql.dgs.internal.utils.TimeTracer;
import com.netflix.graphql.dgs.mvc.DefaultDgsGraphQLRequestHeaderValidator;
import com.netflix.graphql.dgs.mvc.DgsGraphQLRequestHeaderValidator;
import com.netflix.graphql.dgs.mvc.GraphQLMediaTypes;
import graphql.ExecutionResult;
import graphql.execution.reactive.SubscriptionPublisher;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\\\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u00102\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0016\b\u0001\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00142\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u00152\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u00152\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/netflix/graphql/dgs/mvc/DgsRestController;", "", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "dgsGraphQLRequestHeaderValidator", "Lcom/netflix/graphql/dgs/mvc/DgsGraphQLRequestHeaderValidator;", "(Lcom/netflix/graphql/dgs/DgsQueryExecutor;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/netflix/graphql/dgs/mvc/DgsGraphQLRequestHeaderValidator;)V", "getDgsGraphQLRequestHeaderValidator", "()Lcom/netflix/graphql/dgs/mvc/DgsGraphQLRequestHeaderValidator;", "getDgsQueryExecutor", "()Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "graphql", "Lorg/springframework/http/ResponseEntity;", "body", "", "fileParams", "", "", "Lorg/springframework/web/multipart/MultipartFile;", "operation", "mapParam", "headers", "Lorg/springframework/http/HttpHeaders;", "webRequest", "Lorg/springframework/web/context/request/WebRequest;", "Companion", "graphql-dgs-spring-webmvc"})
public class DgsRestController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsQueryExecutor dgsQueryExecutor;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final DgsGraphQLRequestHeaderValidator dgsGraphQLRequestHeaderValidator;
    @NotNull
    public static final String DGS_RESPONSE_HEADERS_KEY = "dgs-response-headers";
    @NotNull
    private static final Logger logger;

    public DgsRestController(@NotNull DgsQueryExecutor dgsQueryExecutor, @NotNull ObjectMapper mapper, @NotNull DgsGraphQLRequestHeaderValidator dgsGraphQLRequestHeaderValidator) {
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)dgsGraphQLRequestHeaderValidator, (String)"dgsGraphQLRequestHeaderValidator");
        this.dgsQueryExecutor = dgsQueryExecutor;
        this.mapper = mapper;
        this.dgsGraphQLRequestHeaderValidator = dgsGraphQLRequestHeaderValidator;
    }

    public /* synthetic */ DgsRestController(DgsQueryExecutor dgsQueryExecutor, ObjectMapper objectMapper, DgsGraphQLRequestHeaderValidator dgsGraphQLRequestHeaderValidator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            objectMapper = ExtensionsKt.jacksonObjectMapper();
        }
        if ((n & 4) != 0) {
            dgsGraphQLRequestHeaderValidator = new DefaultDgsGraphQLRequestHeaderValidator(null, null, 3, null);
        }
        this(dgsQueryExecutor, objectMapper, dgsGraphQLRequestHeaderValidator);
    }

    @NotNull
    public DgsQueryExecutor getDgsQueryExecutor() {
        return this.dgsQueryExecutor;
    }

    @NotNull
    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @NotNull
    public DgsGraphQLRequestHeaderValidator getDgsGraphQLRequestHeaderValidator() {
        return this.dgsGraphQLRequestHeaderValidator;
    }

    @RequestMapping(value={"#{@'dgs.graphql-com.netflix.graphql.dgs.webmvc.autoconfigure.DgsWebMvcConfigurationProperties'.path}"}, produces={"application/json"})
    @NotNull
    public final ResponseEntity<Object> graphql(@RequestBody @Nullable byte[] body, @RequestParam @Nullable Map<String, ? extends MultipartFile> fileParams, @RequestParam(name="operations") @Nullable String operation, @RequestParam(name="map") @Nullable String mapParam, @RequestHeader @NotNull HttpHeaders headers, @NotNull WebRequest webRequest) {
        ResponseEntity responseEntity;
        Object opName;
        Object $i$f$jacksonTypeRef22;
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)webRequest, (String)"webRequest");
        logger.debug("Validate HTTP Headers for the GraphQL endpoint...");
        try {
            this.getDgsGraphQLRequestHeaderValidator().assert(headers);
        }
        catch (DgsGraphQLRequestHeaderValidator.GraphqlRequestContentTypePredicateException e) {
            logger.debug("Unsupported Media-Type {}.", (Object)headers.getContentType(), (Object)e);
            ResponseEntity responseEntity2 = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE)).body((Object)"Unsupported media type.");
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity2, (String)"status(HttpStatus.UNSUPP\u2026Unsupported media type.\")");
            return responseEntity2;
        }
        catch (DgsGraphQLRequestHeaderValidator.GraphQLRequestHeaderRuleException e) {
            logger.debug("The Request Headers failed a DGS Header validation rule.", (Throwable)e);
            ResponseEntity responseEntity3 = ResponseEntity.badRequest().body((Object)e.getMessage());
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity3, (String)"badRequest().body(e.message)");
            return responseEntity3;
        }
        catch (DgsGraphQLRequestHeaderValidator.GraphqlRequestHeaderValidationException e) {
            logger.debug("The DGS Request Header Validator deemed the request headers as invalid.", (Throwable)e);
            ResponseEntity responseEntity4 = ResponseEntity.badRequest().body((Object)e.getMessage());
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity4, (String)"badRequest().body(e.message)");
            return responseEntity4;
        }
        catch (Exception e) {
            logger.error("The DGS Request Header Validator failed with exception!", (Throwable)e);
            ResponseEntity responseEntity5 = ResponseEntity.internalServerError().body((Object)"Unable to validate the HTTP Request Headers.");
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity5, (String)"internalServerError().bo\u2026e HTTP Request Headers.\")");
            return responseEntity5;
        }
        logger.debug("Starting HTTP GraphQL handling...");
        Map inputQuery = null;
        Map queryVariables = null;
        Map extensions = null;
        if (body != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Reading input value: '{}'", (Object)StringsKt.decodeToString((byte[])body));
            }
            if (GraphQLMediaTypes.INSTANCE.includesApplicationGraphQL(headers)) {
                inputQuery = MapsKt.mapOf((Pair)TuplesKt.to((Object)"query", (Object)StringsKt.decodeToString((byte[])body)));
                queryVariables = MapsKt.emptyMap();
                extensions = MapsKt.emptyMap();
            } else {
                Map map;
                try {
                    $this$readValue$iv = this.getMapper();
                    boolean $i$f$readValue = false;
                    $i$f$jacksonTypeRef = false;
                    inputQuery = (Map)$this$readValue$iv.readValue(body, (TypeReference)new TypeReference<Map<String, ? extends Object>>(){});
                }
                catch (Exception ex) {
                    ResponseEntity responseEntity6;
                    Exception $i$f$readValue = ex;
                    if ($i$f$readValue instanceof JsonParseException) {
                        ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.badRequest();
                        String string = ex.getMessage();
                        if (string == null) {
                            string = "no details found in the error message";
                        }
                        ResponseEntity responseEntity7 = bodyBuilder.body((Object)("Invalid query - " + string + "."));
                        responseEntity6 = responseEntity7;
                        Intrinsics.checkNotNullExpressionValue((Object)responseEntity7, (String)"badRequest()\n           \u2026in the error message\"}.\")");
                    } else if ($i$f$readValue instanceof MismatchedInputException) {
                        ResponseEntity responseEntity8 = ResponseEntity.badRequest().body((Object)"Invalid query - No content to map to input.");
                        responseEntity6 = responseEntity8;
                        Intrinsics.checkNotNullExpressionValue((Object)responseEntity8, (String)"badRequest()\n           \u2026ontent to map to input.\")");
                    } else {
                        ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.badRequest();
                        String string = ex.getMessage();
                        if (string == null) {
                            string = "no additional details found";
                        }
                        ResponseEntity responseEntity9 = bodyBuilder.body((Object)("Invalid query - " + string + "."));
                        responseEntity6 = responseEntity9;
                        Intrinsics.checkNotNullExpressionValue((Object)responseEntity9, (String)"badRequest()\n           \u2026tional details found\"}.\")");
                    }
                    return responseEntity6;
                }
                if (inputQuery.get("variables") != null) {
                    Object v = inputQuery.get("variables");
                    Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                    v13 = (Map)v;
                } else {
                    v13 = queryVariables = MapsKt.emptyMap();
                }
                if (inputQuery.get("extensions") != null) {
                    Object v = inputQuery.get("extensions");
                    Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                    map = (Map)v;
                } else {
                    map = MapsKt.emptyMap();
                }
                extensions = map;
                logger.debug("Parsed variables: {}", (Object)queryVariables);
            }
        } else if (fileParams != null && mapParam != null && operation != null) {
            Map fileMapInput;
            Map map;
            $this$readValue$iv = this.getMapper();
            boolean $i$f$readValue = false;
            $i$f$jacksonTypeRef = false;
            inputQuery = (Map)$this$readValue$iv.readValue(operation, (TypeReference)new TypeReference<Map<String, ? extends Object>>(){});
            if (inputQuery.get("variables") != null) {
                Object v = inputQuery.get("variables");
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                v17 = (Map)v;
            } else {
                v17 = queryVariables = MapsKt.emptyMap();
            }
            if (inputQuery.get("extensions") != null) {
                Object v = inputQuery.get("extensions");
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                map = (Map)v;
            } else {
                map = MapsKt.emptyMap();
            }
            extensions = map;
            ObjectMapper $this$readValue$iv = this.getMapper();
            boolean $i$f$readValue2 = false;
            boolean $i$f$jacksonTypeRef22 = false;
            Map $this$forEach$iv = fileMapInput = (Map)$this$readValue$iv.readValue(mapParam, (TypeReference)new TypeReference<Map<String, ? extends List<? extends String>>>(){});
            boolean $i$f$forEach = false;
            $i$f$jacksonTypeRef22 = $this$forEach$iv.entrySet().iterator();
            while ($i$f$jacksonTypeRef22.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = (Map.Entry)$i$f$jacksonTypeRef22.next();
                boolean bl = false;
                String fileKey = (String)entry.getKey();
                List objectPaths = (List)entry.getValue();
                MultipartFile file = fileParams.get(fileKey);
                if (file == null) continue;
                Iterable $this$forEach$iv2 = objectPaths;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String objectPath = (String)element$iv2;
                    boolean bl2 = false;
                    MultipartVariableMapper.INSTANCE.mapVariable(objectPath, queryVariables, file);
                }
            }
        } else {
            ResponseEntity responseEntity10 = ResponseEntity.badRequest().body((Object)"Invalid GraphQL request - no request body was provided");
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity10, (String)"badRequest().body(\"Inval\u2026quest body was provided\")");
            return responseEntity10;
        }
        Object v = opName = inputQuery.get("operationName");
        if (!(v == null ? true : v instanceof String)) {
            ResponseEntity responseEntity11 = ResponseEntity.badRequest().body((Object)"Invalid GraphQL request - operationName must be a String");
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity11, (String)"badRequest().body(\"Inval\u2026onName must be a String\")");
            return responseEntity11;
        }
        String gqlOperationName = (String)opName;
        $i$f$jacksonTypeRef22 = inputQuery.get("query");
        String query = $i$f$jacksonTypeRef22 instanceof String ? (String)$i$f$jacksonTypeRef22 : null;
        ExecutionResult executionResult2 = (ExecutionResult)TimeTracer.INSTANCE.logTime((Function0)new Function0<ExecutionResult>(this, query, (Map<String, ? extends Object>)queryVariables, (Map<String, ? extends Object>)extensions, headers, gqlOperationName, webRequest){
            final /* synthetic */ DgsRestController this$0;
            final /* synthetic */ String $query;
            final /* synthetic */ Map<String, Object> $queryVariables;
            final /* synthetic */ Map<String, Object> $extensions;
            final /* synthetic */ HttpHeaders $headers;
            final /* synthetic */ String $gqlOperationName;
            final /* synthetic */ WebRequest $webRequest;
            {
                this.this$0 = $receiver;
                this.$query = $query;
                this.$queryVariables = $queryVariables;
                this.$extensions = $extensions;
                this.$headers = $headers;
                this.$gqlOperationName = $gqlOperationName;
                this.$webRequest = $webRequest;
                super(0);
            }

            public final ExecutionResult invoke() {
                return this.this$0.getDgsQueryExecutor().execute(this.$query, this.$queryVariables, this.$extensions, this.$headers, this.$gqlOperationName, this.$webRequest);
            }
        }, logger, "Executed query in {}ms");
        logger.debug("Execution result - Contains data: '{}' - Number of errors: {}", (Object)executionResult2.isDataPresent(), (Object)executionResult2.getErrors().size());
        if (executionResult2.isDataPresent() && executionResult2.getData() instanceof SubscriptionPublisher) {
            ResponseEntity responseEntity12 = ResponseEntity.badRequest().body((Object)"Trying to execute subscription on /graphql. Use /subscriptions instead!");
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity12, (String)"badRequest()\n           \u2026/subscriptions instead!\")");
            return responseEntity12;
        }
        if (executionResult2 instanceof DgsExecutionResult) {
            responseEntity = ((DgsExecutionResult)executionResult2).toSpringResponse(this.getMapper());
        } else {
            DgsExecutionResult.Builder builder = DgsExecutionResult.Companion.builder();
            Intrinsics.checkNotNullExpressionValue((Object)executionResult2, (String)"executionResult");
            responseEntity = builder.executionResult(executionResult2).build().toSpringResponse(this.getMapper());
        }
        return responseEntity;
    }

    static {
        Logger logger = LoggerFactory.getLogger(DgsRestController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DgsRestController::class.java)");
        DgsRestController.logger = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/netflix/graphql/dgs/mvc/DgsRestController$Companion;", "", "()V", "DGS_RESPONSE_HEADERS_KEY", "", "logger", "Lorg/slf4j/Logger;", "graphql-dgs-spring-webmvc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

