/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.mvc;

import com.netflix.graphql.dgs.mvc.DgsGraphQLRequestHeaderValidator;
import com.netflix.graphql.dgs.mvc.GraphQLRequestHeaderValidationRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/netflix/graphql/dgs/mvc/GraphQLCSRFRequestHeaderValidationRule;", "Lcom/netflix/graphql/dgs/mvc/GraphQLRequestHeaderValidationRule;", "()V", "assert", "", "headers", "Lorg/springframework/http/HttpHeaders;", "Companion", "graphql-dgs-spring-webmvc"})
@SourceDebugExtension(value={"SMAP\nGraphQLCSRFRequestHeaderValidationRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphQLCSRFRequestHeaderValidationRule.kt\ncom/netflix/graphql/dgs/mvc/GraphQLCSRFRequestHeaderValidationRule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1549#2:136\n1620#2,3:137\n*S KotlinDebug\n*F\n+ 1 GraphQLCSRFRequestHeaderValidationRule.kt\ncom/netflix/graphql/dgs/mvc/GraphQLCSRFRequestHeaderValidationRule\n*L\n73#1:136\n73#1:137,3\n*E\n"})
public final class GraphQLCSRFRequestHeaderValidationRule
implements GraphQLRequestHeaderValidationRule {
    @NotNull
    public static final Companion Companion;
    @NotNull
    public static final String HEADER_X_APOLLO_OPERATION_NAME = "x-apollo-operation-name";
    @NotNull
    public static final String HEADER_APOLLO_REQUIRE_PREFLIGHT = "apollo-require-preflight";
    @NotNull
    public static final String HEADER_GRAPHQL_REQUIRE_PREFLIGHT = "graphql-require-preflight";
    @NotNull
    private static final Set<MediaType> NON_PREFLIGHTED_CONTENT_TYPES;
    @NotNull
    private static final Set<String> GRAPHQL_PREFLIGHT_REQUESTS_HEADERS;

    @Override
    public void assert(@NotNull HttpHeaders headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Companion.assertGraphQLCsrf(headers);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Object[] objectArray = new MediaType[]{MediaType.APPLICATION_FORM_URLENCODED, MediaType.MULTIPART_FORM_DATA, MediaType.TEXT_PLAIN};
        NON_PREFLIGHTED_CONTENT_TYPES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{HEADER_APOLLO_REQUIRE_PREFLIGHT, HEADER_X_APOLLO_OPERATION_NAME, HEADER_GRAPHQL_REQUIRE_PREFLIGHT};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            collection.add(string2);
        }
        GRAPHQL_PREFLIGHT_REQUESTS_HEADERS = CollectionsKt.toSet((Iterable)((List)var3_3));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000fH\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002R\u0014\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0002R\u0014\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0002R\u001f\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/netflix/graphql/dgs/mvc/GraphQLCSRFRequestHeaderValidationRule$Companion;", "", "()V", "GRAPHQL_PREFLIGHT_REQUESTS_HEADERS", "", "", "getGRAPHQL_PREFLIGHT_REQUESTS_HEADERS", "()Ljava/util/Set;", "HEADER_APOLLO_REQUIRE_PREFLIGHT", "getHEADER_APOLLO_REQUIRE_PREFLIGHT$annotations", "HEADER_GRAPHQL_REQUIRE_PREFLIGHT", "getHEADER_GRAPHQL_REQUIRE_PREFLIGHT$annotations", "HEADER_X_APOLLO_OPERATION_NAME", "getHEADER_X_APOLLO_OPERATION_NAME$annotations", "NON_PREFLIGHTED_CONTENT_TYPES", "Lorg/springframework/http/MediaType;", "kotlin.jvm.PlatformType", "getNON_PREFLIGHTED_CONTENT_TYPES", "assertGraphQLCsrf", "", "headers", "Lorg/springframework/http/HttpHeaders;", "containsCSRFinFlightHeader", "", "isPreflightedContentType", "mediaType", "graphql-dgs-spring-webmvc"})
    @SourceDebugExtension(value={"SMAP\nGraphQLCSRFRequestHeaderValidationRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphQLCSRFRequestHeaderValidationRule.kt\ncom/netflix/graphql/dgs/mvc/GraphQLCSRFRequestHeaderValidationRule$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public static /* synthetic */ void getHEADER_X_APOLLO_OPERATION_NAME$annotations() {
        }

        public static /* synthetic */ void getHEADER_APOLLO_REQUIRE_PREFLIGHT$annotations() {
        }

        public static /* synthetic */ void getHEADER_GRAPHQL_REQUIRE_PREFLIGHT$annotations() {
        }

        @NotNull
        public final Set<MediaType> getNON_PREFLIGHTED_CONTENT_TYPES() {
            return NON_PREFLIGHTED_CONTENT_TYPES;
        }

        @NotNull
        public final Set<String> getGRAPHQL_PREFLIGHT_REQUESTS_HEADERS() {
            return GRAPHQL_PREFLIGHT_REQUESTS_HEADERS;
        }

        public final void assertGraphQLCsrf(@NotNull HttpHeaders headers) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            MediaType contentType = headers.getContentType();
            if (contentType != null && this.isPreflightedContentType(contentType)) {
                return;
            }
            if (this.containsCSRFinFlightHeader(headers)) {
                return;
            }
            throw new DgsGraphQLRequestHeaderValidator.GraphQLRequestHeaderRuleException("Expecting a CSRF Prevention Header but none was found, supported headers are " + this.getGRAPHQL_PREFLIGHT_REQUESTS_HEADERS() + ".");
        }

        private final boolean isPreflightedContentType(MediaType mediaType) {
            Object v0;
            block1: {
                Iterable iterable = this.getNON_PREFLIGHTED_CONTENT_TYPES();
                for (Object t : iterable) {
                    MediaType it = (MediaType)t;
                    boolean bl = false;
                    if (!it.isCompatibleWith(mediaType)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0 == null;
        }

        private final boolean containsCSRFinFlightHeader(HttpHeaders headers) {
            Object v3;
            block1: {
                Set set = headers.keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
                Iterable iterable = set;
                for (Object t : iterable) {
                    String it = (String)t;
                    boolean bl = false;
                    Set<String> set2 = Companion.getGRAPHQL_PREFLIGHT_REQUESTS_HEADERS();
                    Intrinsics.checkNotNull((Object)it);
                    String string = it.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    if (!set2.contains(string)) continue;
                    v3 = t;
                    break block1;
                }
                v3 = null;
            }
            String csrfInFlightHeader = v3;
            return StringUtils.hasText((String)csrfInFlightHeader);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

