/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.subscriptions.sse;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.subscriptions.sse.DgsSSESubscriptionHandler;
import com.netflix.graphql.dgs.subscriptions.sse.DgsSSESubscriptionHandler$subscriptionWithId$;
import com.netflix.graphql.types.subscription.QueryPayload;
import com.netflix.graphql.types.subscription.SSEDataPayload;
import graphql.ExecutionResult;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@RestController
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/netflix/graphql/dgs/subscriptions/sse/DgsSSESubscriptionHandler;", "", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "(Lcom/netflix/graphql/dgs/DgsQueryExecutor;)V", "getDgsQueryExecutor", "()Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "subscriptionWithId", "Lorg/springframework/http/ResponseEntity;", "Lorg/springframework/web/servlet/mvc/method/annotation/SseEmitter;", "queryBase64", "", "Companion", "graphql-dgs-subscriptions-sse"})
public class DgsSSESubscriptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsQueryExecutor dgsQueryExecutor;
    @NotNull
    private static final ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();
    @NotNull
    private static final Logger logger;

    public DgsSSESubscriptionHandler(@NotNull DgsQueryExecutor dgsQueryExecutor) {
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        this.dgsQueryExecutor = dgsQueryExecutor;
    }

    @NotNull
    public DgsQueryExecutor getDgsQueryExecutor() {
        return this.dgsQueryExecutor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/subscriptions"}, produces={"text/event-stream"})
    @NotNull
    public final ResponseEntity<SseEmitter> subscriptionWithId(@RequestParam(value="query") @NotNull String queryBase64) {
        Publisher publisher;
        QueryPayload ex2;
        String string;
        Intrinsics.checkNotNullParameter((Object)queryBase64, (String)"queryBase64");
        SseEmitter emitter = new SseEmitter(Long.valueOf(-1L));
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
        String sessionId = string2;
        try {
            byte[] byArray = Base64.getDecoder().decode(queryBase64);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getDecoder().decode(queryBase64)");
            byte[] byArray2 = byArray;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            boolean bl = false;
            string = new String(byArray2, charset);
        }
        catch (IllegalArgumentException ex2) {
            emitter.send((Object)"Error decoding base64 encoded query");
            emitter.complete();
            ResponseEntity responseEntity = ResponseEntity.badRequest().body((Object)emitter);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"badRequest().body(emitter)");
            return responseEntity;
        }
        String string3 = string;
        try {
            ex2 = (QueryPayload)mapper.readValue(string3, QueryPayload.class);
        }
        catch (Exception exception) {
            emitter.send((Object)Intrinsics.stringPlus((String)"Error parsing query: ", (Object)exception.getMessage()));
            emitter.complete();
            ResponseEntity responseEntity = ResponseEntity.badRequest().body((Object)emitter);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"badRequest().body(emitter)");
            return responseEntity;
        }
        QueryPayload queryPayload = ex2;
        ExecutionResult executionResult = this.getDgsQueryExecutor().execute(queryPayload.getQuery(), queryPayload.getVariables());
        Intrinsics.checkNotNullExpressionValue((Object)executionResult, (String)"dgsQueryExecutor.execute\u2026, queryPayload.variables)");
        ExecutionResult executionResult2 = executionResult;
        List list = executionResult2.getErrors();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"executionResult.errors");
        Collection collection = list;
        boolean bl = false;
        if (!collection.isEmpty()) {
            ResponseEntity responseEntity;
            List list2 = executionResult2.getErrors();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"executionResult.errors");
            Sequence sequence = CollectionsKt.asSequence((Iterable)list2);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)sequence, (Function1)subscriptionWithId$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            if (!SequencesKt.any((Sequence)sequence2)) {
                List list3 = executionResult2.getErrors();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"executionResult.errors");
                Sequence sequence3 = CollectionsKt.asSequence((Iterable)list3);
                $i$f$filterIsInstance = false;
                Sequence sequence4 = SequencesKt.filter((Sequence)sequence3, (Function1)subscriptionWithId$$inlined$filterIsInstance$2.INSTANCE);
                if (sequence4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                }
                if (!SequencesKt.any((Sequence)sequence4)) {
                    List list4 = executionResult2.getErrors();
                    Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"executionResult.errors");
                    String errorMessage = Intrinsics.stringPlus((String)"Error executing subscription query: ", (Object)CollectionsKt.joinToString$default((Iterable)list4, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
                    logger.error(errorMessage);
                    emitter.send((Object)errorMessage);
                    emitter.complete();
                    ResponseEntity responseEntity2 = ResponseEntity.status((int)500).body((Object)emitter);
                    Intrinsics.checkNotNullExpressionValue((Object)responseEntity2, (String)"{\n                val er\u2026dy(emitter)\n            }");
                    responseEntity = responseEntity2;
                    return responseEntity;
                }
            }
            List list5 = executionResult2.getErrors();
            Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"executionResult.errors");
            String errorMessage = Intrinsics.stringPlus((String)"Subscription query failed to validate: ", (Object)CollectionsKt.joinToString$default((Iterable)list5, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            emitter.send((Object)errorMessage);
            emitter.complete();
            ResponseEntity responseEntity3 = ResponseEntity.badRequest().body((Object)emitter);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity3, (String)"{\n                val er\u2026dy(emitter)\n            }");
            responseEntity = responseEntity3;
            return responseEntity;
        }
        Subscriber<ExecutionResult> subscriber2 = new Subscriber<ExecutionResult>(sessionId, queryPayload, emitter){
            public Subscription subscription;
            final /* synthetic */ String $sessionId;
            final /* synthetic */ QueryPayload $queryPayload;
            final /* synthetic */ SseEmitter $emitter;
            {
                this.$sessionId = $sessionId;
                this.$queryPayload = $queryPayload;
                this.$emitter = $emitter;
            }

            @NotNull
            public final Subscription getSubscription() {
                Subscription subscription = this.subscription;
                if (subscription != null) {
                    return subscription;
                }
                Intrinsics.throwUninitializedPropertyAccessException((String)"subscription");
                return null;
            }

            public final void setSubscription(@NotNull Subscription subscription) {
                Intrinsics.checkNotNullParameter((Object)subscription, (String)"<set-?>");
                this.subscription = subscription;
            }

            public void onSubscribe(@NotNull Subscription s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                DgsSSESubscriptionHandler.access$getLogger$cp().info("Started subscription with id {} for request {}", (Object)this.$sessionId, (Object)this.$queryPayload);
                this.setSubscription(s);
                s.request(1L);
            }

            public void onNext(@NotNull ExecutionResult t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                SseEmitter.SseEventBuilder event = SseEmitter.event().data((Object)DgsSSESubscriptionHandler.access$getMapper$cp().writeValueAsString((Object)new SSEDataPayload(t.getData(), t.getErrors(), this.$sessionId, null, 8, null)), MediaType.APPLICATION_JSON).id(UUID.randomUUID().toString());
                this.$emitter.send(event);
                this.getSubscription().request(1L);
            }

            public void onError(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                DgsSSESubscriptionHandler.access$getLogger$cp().error("Error on subscription {}", (Object)this.$sessionId, (Object)t);
                SseEmitter.SseEventBuilder event = SseEmitter.event().data((Object)DgsSSESubscriptionHandler.access$getMapper$cp().writeValueAsString((Object)new SSEDataPayload(null, CollectionsKt.listOf((Object)new Error(t.getMessage())), this.$sessionId, null, 8, null)), MediaType.APPLICATION_JSON);
                this.$emitter.send(event);
                this.$emitter.completeWithError(t);
            }

            public void onComplete() {
                this.$emitter.complete();
            }
        };
        emitter.onError(arg_0 -> DgsSSESubscriptionHandler.subscriptionWithId$lambda-0(sessionId, subscriber2, arg_0));
        emitter.onTimeout(() -> DgsSSESubscriptionHandler.subscriptionWithId$lambda-1(sessionId, subscriber2));
        try {
            publisher = (Publisher)executionResult2.getData();
        }
        catch (ClassCastException ex3) {
            ResponseEntity responseEntity;
            if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"subscription", (boolean)false, (int)2, null)) {
                logger.error(Intrinsics.stringPlus((String)"Invalid return type for subscription datafetcher. A subscription datafetcher must return a Publisher<ExecutionResult>. The query was ", (Object)string3), (Throwable)ex3);
                emitter.send((Object)"Invalid return type for subscription datafetcher. Was a non-subscription query send to the subscription endpoint?");
                emitter.complete();
                ResponseEntity responseEntity4 = ResponseEntity.status((int)500).body((Object)emitter);
                Intrinsics.checkNotNullExpressionValue((Object)responseEntity4, (String)"{\n                logger\u2026dy(emitter)\n            }");
                responseEntity = responseEntity4;
                return responseEntity;
            }
            logger.warn(Intrinsics.stringPlus((String)"Invalid return type for subscription datafetcher. The query sent doesn't appear to be a subscription query: ", (Object)string3), (Throwable)ex3);
            emitter.send((Object)"Invalid return type for subscription datafetcher. Was a non-subscription query send to the subscription endpoint?");
            emitter.complete();
            ResponseEntity responseEntity5 = ResponseEntity.badRequest().body((Object)emitter);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity5, (String)"{\n                logger\u2026dy(emitter)\n            }");
            responseEntity = responseEntity5;
            return responseEntity;
        }
        Publisher publisher2 = publisher;
        publisher2.subscribe((Subscriber)subscriber2);
        publisher = ResponseEntity.ok((Object)emitter);
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"ok(emitter)");
        return publisher;
    }

    private static final void subscriptionWithId$lambda-0(String $sessionId, subscriptionWithId.subscriber.1 $subscriber, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$sessionId, (String)"$sessionId");
        Intrinsics.checkNotNullParameter((Object)$subscriber, (String)"$subscriber");
        logger.warn("Subscription {} had a connection error", (Object)$sessionId);
        $subscriber.getSubscription().cancel();
    }

    private static final void subscriptionWithId$lambda-1(String $sessionId, subscriptionWithId.subscriber.1 $subscriber) {
        Intrinsics.checkNotNullParameter((Object)$sessionId, (String)"$sessionId");
        Intrinsics.checkNotNullParameter((Object)$subscriber, (String)"$subscriber");
        logger.warn("Subscription {} timed out", (Object)$sessionId);
        $subscriber.getSubscription().cancel();
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ ObjectMapper access$getMapper$cp() {
        return mapper;
    }

    static {
        Logger logger = LoggerFactory.getLogger(DgsSSESubscriptionHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DgsSSESubscriptionHandler::class.java)");
        DgsSSESubscriptionHandler.logger = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/netflix/graphql/dgs/subscriptions/sse/DgsSSESubscriptionHandler$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "graphql-dgs-subscriptions-sse"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

