/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.subscriptions.sse;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.types.subscription.Error;
import com.netflix.graphql.types.subscription.QueryPayload;
import com.netflix.graphql.types.subscription.SSEDataPayload;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import graphql.InvalidSyntaxError;
import graphql.language.Document;
import graphql.language.OperationDefinition;
import graphql.parser.InvalidSyntaxException;
import graphql.parser.Parser;
import graphql.validation.ValidationError;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerErrorException;
import org.springframework.web.server.ServerWebInputException;
import reactor.core.publisher.Flux;

@RestController
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0017\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\b\b\u0001\u0010\u000b\u001a\u00020\nH\u0002J\u0012\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000b\u001a\u00020\nH\u0002J\u001e\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\b\b\u0001\u0010\u000f\u001a\u00020\nH\u0007J\u001e\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\b\b\u0001\u0010\u0011\u001a\u00020\nH\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/netflix/graphql/dgs/subscriptions/sse/DgsSSESubscriptionHandler;", "", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "(Lcom/netflix/graphql/dgs/DgsQueryExecutor;)V", "getDgsQueryExecutor", "()Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "handleSubscription", "Lreactor/core/publisher/Flux;", "Lorg/springframework/http/codec/ServerSentEvent;", "", "query", "isSubscriptionQuery", "", "subscriptionFromPost", "body", "subscriptionWithId", "queryBase64", "Companion", "graphql-dgs-subscriptions-sse"})
@SourceDebugExtension(value={"SMAP\nDgsSSESubscriptionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsSSESubscriptionHandler.kt\ncom/netflix/graphql/dgs/subscriptions/sse/DgsSSESubscriptionHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1747#2,3:148\n1726#2,3:151\n*S KotlinDebug\n*F\n+ 1 DgsSSESubscriptionHandler.kt\ncom/netflix/graphql/dgs/subscriptions/sse/DgsSSESubscriptionHandler\n*L\n86#1:148,3\n139#1:151,3\n*E\n"})
public class DgsSSESubscriptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsQueryExecutor dgsQueryExecutor;
    @NotNull
    private static final ObjectMapper mapper;
    @NotNull
    private static final Logger logger;

    public DgsSSESubscriptionHandler(@NotNull DgsQueryExecutor dgsQueryExecutor) {
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        this.dgsQueryExecutor = dgsQueryExecutor;
    }

    @NotNull
    public DgsQueryExecutor getDgsQueryExecutor() {
        return this.dgsQueryExecutor;
    }

    @GetMapping(value={"${dgs.graphql.sse.path:/subscriptions}"}, produces={"text/event-stream"})
    @NotNull
    public final Flux<ServerSentEvent<String>> subscriptionWithId(@RequestParam(value="query") @NotNull String queryBase64) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)queryBase64, (String)"queryBase64");
        try {
            byte[] byArray = Base64.getDecoder().decode(queryBase64);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
            object = byArray;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            object = new String((byte[])object, charset2);
        }
        catch (IllegalArgumentException ex) {
            throw new ServerWebInputException("Error decoding base64-encoded query");
        }
        Object query = object;
        return this.handleSubscription((String)query);
    }

    @PostMapping(value={"${dgs.graphql.sse.path:/subscriptions}"}, produces={"text/event-stream"})
    @NotNull
    public final Flux<ServerSentEvent<String>> subscriptionFromPost(@RequestBody @NotNull String body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return this.handleSubscription(body);
    }

    private final Flux<ServerSentEvent<String>> handleSubscription(@Language(value="graphql") String query) {
        Publisher $this$any$iv2;
        QueryPayload queryPayload;
        try {
            queryPayload = (QueryPayload)mapper.readValue(query, QueryPayload.class);
        }
        catch (Exception ex) {
            throw new ServerWebInputException("Error parsing query: " + ex.getMessage());
        }
        QueryPayload queryPayload2 = queryPayload;
        if (!this.isSubscriptionQuery(queryPayload2.getQuery())) {
            throw new ServerWebInputException("Invalid query. operation type is not a subscription");
        }
        DgsQueryExecutor dgsQueryExecutor = this.getDgsQueryExecutor();
        String string = queryPayload2.getQuery();
        Map map = queryPayload2.getVariables();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        ExecutionResult executionResult = dgsQueryExecutor.execute(string, map);
        Intrinsics.checkNotNullExpressionValue((Object)executionResult, (String)"execute(...)");
        ExecutionResult executionResult2 = executionResult;
        List list = executionResult2.getErrors();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getErrors(...)");
        if (!((Collection)list).isEmpty()) {
            String string2;
            boolean bl;
            block12: {
                List list2 = executionResult2.getErrors();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getErrors(...)");
                Iterable $this$any$iv2 = list2;
                boolean $i$f$any = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv2) {
                        GraphQLError error = (GraphQLError)element$iv;
                        boolean bl2 = false;
                        if (!(error instanceof ValidationError || error instanceof InvalidSyntaxError)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (bl) {
                List list3 = executionResult2.getErrors();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getErrors(...)");
                string2 = "Subscription query failed to validate: " + CollectionsKt.joinToString$default((Iterable)list3, null, null, null, (int)0, null, null, (int)63, null);
            } else {
                List list4 = executionResult2.getErrors();
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getErrors(...)");
                string2 = "Error executing subscription query: " + CollectionsKt.joinToString$default((Iterable)list4, null, null, null, (int)0, null, null, (int)63, null);
            }
            String errorMessage = string2;
            logger.error(errorMessage);
            throw new ServerWebInputException(errorMessage);
        }
        try {
            $this$any$iv2 = (Publisher)executionResult2.getData();
        }
        catch (ClassCastException exc) {
            logger.error("Invalid return type for subscription datafetcher. A subscription datafetcher must return a Publisher<ExecutionResult>. The query was {}", (Object)query, (Object)exc);
            throw new ServerErrorException("Invalid return type for subscription datafetcher. Was a non-subscription query send to the subscription endpoint?", (Throwable)exc);
        }
        Publisher publisher = $this$any$iv2;
        String string3 = Intrinsics.areEqual((Object)queryPayload2.getKey(), (Object)"") ? UUID.randomUUID().toString() : queryPayload2.getKey();
        Intrinsics.checkNotNull((Object)string3);
        String subscriptionId = string3;
        Flux flux = Flux.from((Publisher)publisher).map(arg_0 -> DgsSSESubscriptionHandler.handleSubscription$lambda$1((Function1)new Function1<ExecutionResult, ServerSentEvent<String>>(subscriptionId){
            final /* synthetic */ String $subscriptionId;
            {
                this.$subscriptionId = $subscriptionId;
                super(1);
            }

            public final ServerSentEvent<String> invoke(ExecutionResult it) {
                SSEDataPayload payload = new SSEDataPayload(it.getData(), it.getErrors(), this.$subscriptionId, null, 8, null);
                return ServerSentEvent.builder((Object)DgsSSESubscriptionHandler.access$getMapper$cp().writeValueAsString((Object)payload)).id(UUID.randomUUID().toString()).event("next").build();
            }
        }, arg_0)).onErrorResume(arg_0 -> DgsSSESubscriptionHandler.handleSubscription$lambda$2((Function1)new Function1<Throwable, Publisher<? extends ServerSentEvent<String>>>(subscriptionId){
            final /* synthetic */ String $subscriptionId;
            {
                this.$subscriptionId = $subscriptionId;
                super(1);
            }

            public final Publisher<? extends ServerSentEvent<String>> invoke(Throwable exc) {
                DgsSSESubscriptionHandler.access$getLogger$cp().warn("An exception occurred on subscription {}", (Object)this.$subscriptionId, (Object)exc);
                String string = exc.getMessage();
                if (string == null) {
                    string = "An exception occurred";
                }
                String errorMessage = string;
                SSEDataPayload payload = new SSEDataPayload(null, CollectionsKt.listOf((Object)new Error(errorMessage)), this.$subscriptionId, null, 8, null);
                return (Publisher)Flux.just((Object)ServerSentEvent.builder((Object)DgsSSESubscriptionHandler.access$getMapper$cp().writeValueAsString((Object)payload)).id(UUID.randomUUID().toString()).event("error").build());
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"onErrorResume(...)");
        return flux;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSubscriptionQuery(@Language(value="graphql") String query) {
        boolean bl;
        Document document;
        try {
            document = new Parser().parseDocument(query);
        }
        catch (InvalidSyntaxException exc) {
            return false;
        }
        Document document2 = document;
        List definitions = document2.getDefinitionsOfType(OperationDefinition.class);
        Intrinsics.checkNotNull((Object)definitions);
        if (((Collection)definitions).isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Iterable $this$all$iv = definitions;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            OperationDefinition def = (OperationDefinition)element$iv;
            boolean bl3 = false;
            if (def.getOperation() != OperationDefinition.Operation.SUBSCRIPTION) return false;
            bl = true;
        } while (bl);
        return false;
    }

    private static final ServerSentEvent handleSubscription$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ServerSentEvent)$tmp0.invoke(p0);
    }

    private static final Publisher handleSubscription$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ObjectMapper access$getMapper$cp() {
        return mapper;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        ObjectMapper objectMapper = Jackson2ObjectMapperBuilder.json().build();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"build(...)");
        mapper = objectMapper;
        Logger logger = LoggerFactory.getLogger(DgsSSESubscriptionHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        DgsSSESubscriptionHandler.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/netflix/graphql/dgs/subscriptions/sse/DgsSSESubscriptionHandler$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "graphql-dgs-subscriptions-sse"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

