/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.subscriptions.websockets;

import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.subscriptions.websockets.DgsHandshakeInterceptor;
import com.netflix.graphql.dgs.subscriptions.websockets.DgsWebSocketHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistration;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;

@Configuration
@ConditionalOnWebApplication
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\n"}, d2={"Lcom/netflix/graphql/dgs/subscriptions/websockets/DgsWebSocketAutoConfig;", "", "()V", "handshakeInterceptor", "Lorg/springframework/web/socket/server/HandshakeInterceptor;", "webSocketHandler", "Lorg/springframework/web/socket/WebSocketHandler;", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "WebSocketConfig", "graphql-dgs-subscriptions-websockets-autoconfigure"})
public class DgsWebSocketAutoConfig {
    @Bean
    @NotNull
    public WebSocketHandler webSocketHandler(@NotNull DgsQueryExecutor dgsQueryExecutor) {
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        return (WebSocketHandler)new DgsWebSocketHandler(dgsQueryExecutor);
    }

    @Bean
    @NotNull
    public HandshakeInterceptor handshakeInterceptor() {
        return (HandshakeInterceptor)new DgsHandshakeInterceptor();
    }

    @Configuration
    @EnableWebSocket
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0011\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/netflix/graphql/dgs/subscriptions/websockets/DgsWebSocketAutoConfig$WebSocketConfig;", "Lorg/springframework/web/socket/config/annotation/WebSocketConfigurer;", "webSocketHandler", "Lorg/springframework/web/socket/WebSocketHandler;", "handshakeInterceptor", "Lorg/springframework/web/socket/server/HandshakeInterceptor;", "(Lorg/springframework/web/socket/WebSocketHandler;Lorg/springframework/web/socket/server/HandshakeInterceptor;)V", "registerWebSocketHandlers", "", "registry", "Lorg/springframework/web/socket/config/annotation/WebSocketHandlerRegistry;", "graphql-dgs-subscriptions-websockets-autoconfigure"})
    public static class WebSocketConfig
    implements WebSocketConfigurer {
        @NotNull
        private final WebSocketHandler webSocketHandler;
        @NotNull
        private final HandshakeInterceptor handshakeInterceptor;

        public WebSocketConfig(@NotNull WebSocketHandler webSocketHandler, @NotNull HandshakeInterceptor handshakeInterceptor) {
            Intrinsics.checkNotNullParameter((Object)webSocketHandler, (String)"webSocketHandler");
            Intrinsics.checkNotNullParameter((Object)handshakeInterceptor, (String)"handshakeInterceptor");
            this.webSocketHandler = webSocketHandler;
            this.handshakeInterceptor = handshakeInterceptor;
        }

        public void registerWebSocketHandlers(@NotNull WebSocketHandlerRegistry registry) {
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            DefaultHandshakeHandler handshakeHandler = new DefaultHandshakeHandler();
            String[] stringArray = new String[]{"/subscriptions"};
            WebSocketHandlerRegistration webSocketHandlerRegistration = registry.addHandler(this.webSocketHandler, stringArray).setHandshakeHandler((HandshakeHandler)handshakeHandler);
            stringArray = new HandshakeInterceptor[]{this.handshakeInterceptor};
            WebSocketHandlerRegistration webSocketHandlerRegistration2 = webSocketHandlerRegistration.addInterceptors((HandshakeInterceptor[])stringArray);
            stringArray = new String[]{"*"};
            webSocketHandlerRegistration2.setAllowedOrigins(stringArray);
        }
    }
}

