/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.subscriptions.websockets;

import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.subscriptions.websockets.DgsHandshakeInterceptor;
import com.netflix.graphql.dgs.subscriptions.websockets.DgsWebSocketConfigurationProperties;
import com.netflix.graphql.dgs.subscriptions.websockets.DgsWebSocketHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistration;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;

@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={DgsWebSocketConfigurationProperties.class})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\n"}, d2={"Lcom/netflix/graphql/dgs/subscriptions/websockets/DgsWebSocketAutoConfig;", "", "()V", "handshakeInterceptor", "Lorg/springframework/web/socket/server/HandshakeInterceptor;", "webSocketHandler", "Lorg/springframework/web/socket/WebSocketHandler;", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "WebSocketConfig", "graphql-dgs-subscriptions-websockets-autoconfigure"})
public class DgsWebSocketAutoConfig {
    @Bean
    @NotNull
    public WebSocketHandler webSocketHandler(@NotNull DgsQueryExecutor dgsQueryExecutor) {
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        return (WebSocketHandler)new DgsWebSocketHandler(dgsQueryExecutor);
    }

    @Bean
    @NotNull
    public HandshakeInterceptor handshakeInterceptor() {
        return (HandshakeInterceptor)new DgsHandshakeInterceptor();
    }

    @Configuration
    @EnableWebSocket
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0011\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/netflix/graphql/dgs/subscriptions/websockets/DgsWebSocketAutoConfig$WebSocketConfig;", "Lorg/springframework/web/socket/config/annotation/WebSocketConfigurer;", "webSocketHandler", "Lorg/springframework/web/socket/WebSocketHandler;", "handshakeInterceptor", "Lorg/springframework/web/socket/server/HandshakeInterceptor;", "configProps", "Lcom/netflix/graphql/dgs/subscriptions/websockets/DgsWebSocketConfigurationProperties;", "(Lorg/springframework/web/socket/WebSocketHandler;Lorg/springframework/web/socket/server/HandshakeInterceptor;Lcom/netflix/graphql/dgs/subscriptions/websockets/DgsWebSocketConfigurationProperties;)V", "registerWebSocketHandlers", "", "registry", "Lorg/springframework/web/socket/config/annotation/WebSocketHandlerRegistry;", "graphql-dgs-subscriptions-websockets-autoconfigure"})
    public static class WebSocketConfig
    implements WebSocketConfigurer {
        @NotNull
        private final WebSocketHandler webSocketHandler;
        @NotNull
        private final HandshakeInterceptor handshakeInterceptor;
        @NotNull
        private final DgsWebSocketConfigurationProperties configProps;

        public WebSocketConfig(@NotNull WebSocketHandler webSocketHandler, @NotNull HandshakeInterceptor handshakeInterceptor, @NotNull DgsWebSocketConfigurationProperties configProps) {
            Intrinsics.checkNotNullParameter((Object)webSocketHandler, (String)"webSocketHandler");
            Intrinsics.checkNotNullParameter((Object)handshakeInterceptor, (String)"handshakeInterceptor");
            Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
            this.webSocketHandler = webSocketHandler;
            this.handshakeInterceptor = handshakeInterceptor;
            this.configProps = configProps;
        }

        public void registerWebSocketHandlers(@NotNull WebSocketHandlerRegistry registry) {
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            DefaultHandshakeHandler handshakeHandler = new DefaultHandshakeHandler();
            String[] stringArray = new String[]{this.configProps.getPath()};
            WebSocketHandlerRegistration webSocketHandlerRegistration = registry.addHandler(this.webSocketHandler, stringArray).setHandshakeHandler((HandshakeHandler)handshakeHandler);
            stringArray = new HandshakeInterceptor[]{this.handshakeInterceptor};
            WebSocketHandlerRegistration webSocketHandlerRegistration2 = webSocketHandlerRegistration.addInterceptors((HandshakeInterceptor[])stringArray);
            stringArray = new String[]{"*"};
            webSocketHandlerRegistration2.setAllowedOrigins(stringArray);
        }
    }
}

