/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.subscriptions.websockets;

import jakarta.annotation.PostConstruct;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.event.Level;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.DefaultValue;

@ConfigurationProperties(prefix="dgs.graphql.websocket")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 #2\u00020\u0001:\u0001#B#\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0018\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00052\b\b\u0003\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003H\u0002J\b\u0010\"\u001a\u00020 H\u0007R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"Lcom/netflix/graphql/dgs/subscriptions/websockets/DgsWebSocketConfigurationProperties;", "", "path", "", "connectionInitTimeout", "Ljava/time/Duration;", "subscriptionErrorLogLevel", "Lorg/slf4j/event/Level;", "(Ljava/lang/String;Ljava/time/Duration;Lorg/slf4j/event/Level;)V", "getConnectionInitTimeout", "()Ljava/time/Duration;", "setConnectionInitTimeout", "(Ljava/time/Duration;)V", "getPath", "()Ljava/lang/String;", "setPath", "(Ljava/lang/String;)V", "getSubscriptionErrorLogLevel", "()Lorg/slf4j/event/Level;", "setSubscriptionErrorLogLevel", "(Lorg/slf4j/event/Level;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "validatePath", "", "pathProperty", "validatePaths", "Companion", "graphql-dgs-subscriptions-websockets-autoconfigure"})
public final class DgsWebSocketConfigurationProperties {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String path;
    @NotNull
    private Duration connectionInitTimeout;
    @NotNull
    private Level subscriptionErrorLogLevel;
    @NotNull
    public static final String CONNECTION_INIT_TIMEOUT = "10s";

    public DgsWebSocketConfigurationProperties(@DefaultValue(value={"/subscriptions"}) @NotNull String path, @DefaultValue(value={"10s"}) @NotNull Duration connectionInitTimeout, @DefaultValue(value={"ERROR"}) @NotNull Level subscriptionErrorLogLevel) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)connectionInitTimeout, (String)"connectionInitTimeout");
        Intrinsics.checkNotNullParameter((Object)subscriptionErrorLogLevel, (String)"subscriptionErrorLogLevel");
        this.path = path;
        this.connectionInitTimeout = connectionInitTimeout;
        this.subscriptionErrorLogLevel = subscriptionErrorLogLevel;
    }

    public /* synthetic */ DgsWebSocketConfigurationProperties(String string, Duration duration, Level level, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "/subscriptions";
        }
        if ((n & 4) != 0) {
            level = Level.ERROR;
        }
        this(string, duration, level);
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final void setPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.path = string;
    }

    @NotNull
    public final Duration getConnectionInitTimeout() {
        return this.connectionInitTimeout;
    }

    public final void setConnectionInitTimeout(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.connectionInitTimeout = duration;
    }

    @NotNull
    public final Level getSubscriptionErrorLogLevel() {
        return this.subscriptionErrorLogLevel;
    }

    public final void setSubscriptionErrorLogLevel(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"<set-?>");
        this.subscriptionErrorLogLevel = level;
    }

    @PostConstruct
    public final void validatePaths() {
        this.validatePath(this.path, "dgs.graphql.websocket.path");
    }

    private final void validatePath(String path, String pathProperty) {
        if (!(Intrinsics.areEqual((Object)path, (Object)"/") || StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null))) {
            throw new IllegalArgumentException(pathProperty + " must start with '/' and not end with '/' but was '" + path + "'");
        }
    }

    @NotNull
    public final String component1() {
        return this.path;
    }

    @NotNull
    public final Duration component2() {
        return this.connectionInitTimeout;
    }

    @NotNull
    public final Level component3() {
        return this.subscriptionErrorLogLevel;
    }

    @NotNull
    public final DgsWebSocketConfigurationProperties copy(@DefaultValue(value={"/subscriptions"}) @NotNull String path, @DefaultValue(value={"10s"}) @NotNull Duration connectionInitTimeout, @DefaultValue(value={"ERROR"}) @NotNull Level subscriptionErrorLogLevel) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)connectionInitTimeout, (String)"connectionInitTimeout");
        Intrinsics.checkNotNullParameter((Object)subscriptionErrorLogLevel, (String)"subscriptionErrorLogLevel");
        return new DgsWebSocketConfigurationProperties(path, connectionInitTimeout, subscriptionErrorLogLevel);
    }

    public static /* synthetic */ DgsWebSocketConfigurationProperties copy$default(DgsWebSocketConfigurationProperties dgsWebSocketConfigurationProperties, String string, Duration duration, Level level, int n, Object object) {
        if ((n & 1) != 0) {
            string = dgsWebSocketConfigurationProperties.path;
        }
        if ((n & 2) != 0) {
            duration = dgsWebSocketConfigurationProperties.connectionInitTimeout;
        }
        if ((n & 4) != 0) {
            level = dgsWebSocketConfigurationProperties.subscriptionErrorLogLevel;
        }
        return dgsWebSocketConfigurationProperties.copy(string, duration, level);
    }

    @NotNull
    public String toString() {
        return "DgsWebSocketConfigurationProperties(path=" + this.path + ", connectionInitTimeout=" + this.connectionInitTimeout + ", subscriptionErrorLogLevel=" + this.subscriptionErrorLogLevel + ")";
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = result * 31 + this.connectionInitTimeout.hashCode();
        result = result * 31 + this.subscriptionErrorLogLevel.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DgsWebSocketConfigurationProperties)) {
            return false;
        }
        DgsWebSocketConfigurationProperties dgsWebSocketConfigurationProperties = (DgsWebSocketConfigurationProperties)other;
        if (!Intrinsics.areEqual((Object)this.path, (Object)dgsWebSocketConfigurationProperties.path)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.connectionInitTimeout, (Object)dgsWebSocketConfigurationProperties.connectionInitTimeout)) {
            return false;
        }
        return this.subscriptionErrorLogLevel == dgsWebSocketConfigurationProperties.subscriptionErrorLogLevel;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/subscriptions/websockets/DgsWebSocketConfigurationProperties$Companion;", "", "()V", "CONNECTION_INIT_TIMEOUT", "", "graphql-dgs-subscriptions-websockets-autoconfigure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

